/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.table;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;

public class ErInfo
implements Serializable {
    private static final long serialVersionUID = -4283572017789730037L;
    public static final int ERD_TABLE_OFFSET_X = 50;
    public static final int ERD_TABLE_OFFSET_Y = 40;
    public static final int SIZE_TABLE_HEADER_HEIGHT = 47;
    public static final int SIZE_COLUMN_HEIGHT = 21;
    public static final int SIZE_MAX_ROW = 10;
    public static final int SIZE_COLUMN_MARGIN_RIGHT = 5;
    public static final int SIZE_MIN_WIDTH = 60;
    public static final double SIZE_BORDER_BOTTOM = 1.5;
    public static final int SIZE_COLUMN_OPTION_AI = 15;
    public static final int SIZE_COLUMN_OPTION_UQ = 22;
    public static final int SIZE_COLUMN_OPTION_NN = 34;
    public static final int SIZE_COLUMN_CLOSE = 9;
    public static final int SIZE_COLUMN_KEY = 12;
    public static final int TEXT_PADDING = 2;
    public static final boolean SHOW_tableComment = true;
    public static final boolean SHOW_columnComment = true;
    public static final boolean SHOW_columnDataType = true;
    public static final boolean SHOW_columnDefault = true;
    public static final boolean SHOW_columnAutoIncrement = false;
    public static final boolean SHOW_columnPrimaryKey = true;
    public static final boolean SHOW_columnUnique = false;
    public static final boolean SHOW_columnNotNull = true;
    public static final boolean SHOW_relationship = true;
    private Control control = new Control();
    private Canvas canvas = new Canvas();
    private TableRoot table = new TableRoot();
    private RelationshipRoot relationship = new RelationshipRoot();

    public Control getControl() {
        return this.control;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public TableRoot getTable() {
        return this.table;
    }

    public RelationshipRoot getRelationship() {
        return this.relationship;
    }

    public static int getTextWidth(String value) {
        if (value == null) {
            return 0;
        }
        int r = value.length() * 10 + 2;
        if (r < 60) {
            return 60;
        }
        return r;
    }

    static class Relationship
    implements Serializable {
        private String id;
        private boolean identification;
        private String relationshipType = "OneN";
        private String startRelationshipType = "Dash";
        private String constraintName;
        private RelaNode start = new RelaNode();
        private RelaNode end = new RelaNode();

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public boolean isIdentification() {
            return this.identification;
        }

        public void setIdentification(boolean identification) {
            this.identification = identification;
        }

        public String getRelationshipType() {
            return this.relationshipType;
        }

        public void setRelationshipType(String relationshipType) {
            this.relationshipType = relationshipType;
        }

        public String getConstraintName() {
            return this.constraintName;
        }

        public void setConstraintName(String constraintName) {
            this.constraintName = constraintName;
        }

        public String getStartRelationshipType() {
            return this.startRelationshipType;
        }

        public void setStartRelationshipType(String startRelationshipType) {
            this.startRelationshipType = startRelationshipType;
        }

        public RelaNode getStart() {
            return this.start;
        }

        public RelaNode getEnd() {
            return this.end;
        }

        static class RelaNode
        implements Serializable {
            private String tableId;
            private List<String> columnIds = new ArrayList<String>();
            private double x;
            private double y;
            private String direction;

            public String getTableId() {
                return this.tableId;
            }

            public void setTableId(String tableId) {
                this.tableId = tableId;
            }

            public List<String> getColumnIds() {
                return this.columnIds;
            }

            public double getX() {
                return this.x;
            }

            public void setX(double x) {
                this.x = x;
            }

            public double getY() {
                return this.y;
            }

            public void setY(double y) {
                this.y = y;
            }

            public String getDirection() {
                return this.direction;
            }

            public void setDirection(String direction) {
                this.direction = direction;
            }
        }
    }

    static class RelationshipRoot
    implements Serializable {
        private List<Relationship> relationships = new ArrayList<Relationship>();

        public List<Relationship> getRelationships() {
            return this.relationships;
        }

        public Relationship addRelationship() {
            Relationship r = new Relationship();
            this.relationships.add(r);
            return r;
        }
    }

    static class Index
    implements Serializable {
        Index() {
        }
    }

    static class Column
    implements Serializable {
        private static final String key_Default = "default";
        private String id;
        private String name;
        private String comment;
        private String dataType;
        @JsonProperty(value="default")
        private String Default;
        private Option option = new Option();
        private Ui ui = new Ui();

        public Option getOption() {
            return this.option;
        }

        public Ui getUi() {
            return this.ui;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
            this.getUi().setWidthComment(ErInfo.getTextWidth(comment));
        }

        public String getDataType() {
            return this.dataType;
        }

        public void setDataType(String dataType) {
            this.dataType = dataType;
            this.getUi().setWidthDataType(ErInfo.getTextWidth(dataType));
        }

        public String getDefault() {
            return this.Default;
        }

        public void setDefault(String aDefault) {
            this.Default = aDefault;
            this.getUi().setWidthDefault(ErInfo.getTextWidth(aDefault));
        }

        public void setName(String name) {
            this.name = name;
            this.getUi().setWidthName(ErInfo.getTextWidth(name));
        }

        static class Ui
        implements Serializable {
            private boolean active;
            private boolean pk;
            private boolean fk;
            private boolean pfk;
            private int widthName = 60;
            private int widthComment = 60;
            private int widthDataType = 60;
            private int widthDefault = 60;

            public boolean isActive() {
                return this.active;
            }

            public void setActive(boolean active) {
                this.active = active;
            }

            public int getWidthName() {
                return this.widthName;
            }

            public void setWidthName(int widthName) {
                this.widthName = widthName;
            }

            public int getWidthComment() {
                return this.widthComment;
            }

            public void setWidthComment(int widthComment) {
                this.widthComment = widthComment;
            }

            public boolean isPk() {
                return this.pk;
            }

            public void setPk(boolean pk) {
                this.pk = pk;
            }

            public boolean isFk() {
                return this.fk;
            }

            public void setFk(boolean fk) {
                this.fk = fk;
            }

            public boolean isPfk() {
                return this.pfk;
            }

            public void setPfk(boolean pfk) {
                this.pfk = pfk;
            }

            public int getWidthDataType() {
                return this.widthDataType;
            }

            public void setWidthDataType(int widthDataType) {
                this.widthDataType = widthDataType;
            }

            public int getWidthDefault() {
                return this.widthDefault;
            }

            public void setWidthDefault(int widthDefault) {
                this.widthDefault = widthDefault;
            }
        }

        static class Option
        implements Serializable {
            private boolean autoIncrement;
            private boolean primaryKey = false;
            private boolean unique;
            private boolean notNull = true;

            Option() {
            }

            public boolean isAutoIncrement() {
                return this.autoIncrement;
            }

            public void setAutoIncrement(boolean autoIncrement) {
                this.autoIncrement = autoIncrement;
            }

            public boolean isPrimaryKey() {
                return this.primaryKey;
            }

            public void setPrimaryKey(boolean primaryKey) {
                this.primaryKey = primaryKey;
            }

            public boolean isUnique() {
                return this.unique;
            }

            public void setUnique(boolean unique) {
                this.unique = unique;
            }

            public boolean isNotNull() {
                return this.notNull;
            }

            public void setNotNull(boolean notNull) {
                this.notNull = notNull;
            }
        }
    }

    static class Table
    implements Serializable {
        private String id;
        private String name;
        private String comment;
        private List<Column> columns = new ArrayList<Column>();
        private Ui ui = new Ui();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.getUi().setWidthName(ErInfo.getTextWidth(name));
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
            this.getUi().setWidthComment(ErInfo.getTextWidth(comment));
        }

        public List<Column> getColumns() {
            return this.columns;
        }

        public Column addColumn() {
            Column col = new Column();
            this.columns.add(col);
            return col;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Ui getUi() {
            return this.ui;
        }

        @JsonIgnore
        public List<String> getPKColumnIds() {
            ArrayList<String> r = new ArrayList<String>(16);
            for (Column column : this.getColumns()) {
                if (!column.getOption().isPrimaryKey()) continue;
                r.add(column.getId());
            }
            return r;
        }

        @JsonIgnore
        public List<String> getPKColumnNames() {
            ArrayList<String> r = new ArrayList<String>(16);
            for (Column column : this.getColumns()) {
                if (!column.getOption().isPrimaryKey()) continue;
                r.add(column.name);
            }
            return r;
        }

        @JsonIgnore
        public List<String> getFKColumnIds(List<String> name) {
            ArrayList<String> r = new ArrayList<String>(16);
            for (Column column : this.getColumns()) {
                if (!name.contains(column.getName())) continue;
                r.add(column.getId());
            }
            return r;
        }

        @JsonIgnore
        public double getTableWidth() {
            double width = 0.0;
            width = this.ui.widthName + 5;
            width += (double)(this.ui.widthComment + 5);
            double defaultWidthColumn = 65.0;
            defaultWidthColumn += 65.0;
            defaultWidthColumn += 65.0;
            defaultWidthColumn += 65.0;
            defaultWidthColumn += 39.0;
            if (width < (defaultWidthColumn += 26.0)) {
                width = defaultWidthColumn;
            }
            double maxWidthColumn = 0.0;
            double widthName = 0.0;
            double widthComment = 0.0;
            double widthDataType = 0.0;
            double widthDefault = 0.0;
            double widthNotNull = 0.0;
            double widthUnique = 0.0;
            double widthAutoIncrement = 0.0;
            for (Column column : this.getColumns()) {
                if (widthName < (double)column.ui.widthName) {
                    widthName = column.ui.widthName;
                }
                if (widthComment < (double)column.ui.widthComment) {
                    widthComment = column.ui.widthComment;
                }
                if (widthDataType < (double)column.ui.widthDataType) {
                    widthDataType = column.ui.widthDataType;
                }
                if (!(widthDefault < (double)column.ui.widthDefault)) continue;
                widthDefault = column.ui.widthDefault;
            }
            widthNotNull = 34.0;
            maxWidthColumn += widthName + 5.0 + widthComment + 5.0 + widthDataType + 5.0 + widthDefault + 5.0 + widthNotNull + 5.0 + widthUnique + 5.0 + widthAutoIncrement + 5.0;
            if (width < (maxWidthColumn += 26.0)) {
                width = maxWidthColumn;
            }
            return width;
        }

        @JsonIgnore
        public double getTableHeight() {
            return 47 + Math.min(10, this.columns.size() + 1) * 21;
        }

        static class Ui
        implements Serializable {
            private boolean active;
            private double left;
            private double top;
            private int zIndex = 1;
            private int widthName = 60;
            private int widthComment = 60;

            public boolean isActive() {
                return this.active;
            }

            public void setActive(boolean active) {
                this.active = active;
            }

            public double getLeft() {
                return this.left;
            }

            public void setLeft(double left) {
                this.left = left;
            }

            public double getTop() {
                return this.top;
            }

            public void setTop(double top) {
                this.top = top;
            }

            public int getzIndex() {
                return this.zIndex;
            }

            public void setzIndex(int zIndex) {
                this.zIndex = zIndex;
            }

            public int getWidthName() {
                return this.widthName;
            }

            public void setWidthName(int widthName) {
                this.widthName = widthName;
            }

            public int getWidthComment() {
                return this.widthComment;
            }

            public void setWidthComment(int widthComment) {
                this.widthComment = widthComment;
            }
        }
    }

    static class TableRoot
    implements Serializable {
        private List<Table> tables = new ArrayList<Table>();
        private List<Index> indexes = new ArrayList<Index>();

        public List<Table> getTables() {
            return this.tables;
        }

        public Table addTable() {
            Table tbl = new Table();
            this.tables.add(tbl);
            return tbl;
        }

        public Table findTable(String tableName) {
            for (Table table : this.tables) {
                if (!table.getName().equalsIgnoreCase(tableName)) continue;
                return table;
            }
            return null;
        }

        public List<Index> getIndexes() {
            return this.indexes;
        }
    }

    static class Canvas
    implements Serializable {
        private String version = "2.0.0";
        private int width = 2000;
        private int height = 2000;
        private double scrollTop;
        private double scrollLeft;
        private int zoomLevel = 1;
        private Show show;
        private I18n i18n;
        private String database = "KSQL";
        private String databaseName = ResManager.loadKDString((String)"\u7cfb\u7edf\u5e93", (String)"ErInfo_0", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
        private String canvasType = "ERD";
        private String language = "GraphQL";
        private String tableCase = "pascalCase";
        private String columnCase = "camelCase";
        private String highlightTheme = "AtomOneLight";
        private String bracketType = "bracketType";
        private Setting setting;

        public Canvas() {
            this.show = new Show();
            this.setting = new Setting();
            this.i18n = new I18n();
        }

        public Show getShow() {
            return this.show;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public double getScrollTop() {
            return this.scrollTop;
        }

        public void setScrollTop(int scrollTop) {
            this.scrollTop = scrollTop;
        }

        public double getScrollLeft() {
            return this.scrollLeft;
        }

        public void setScrollLeft(int scrollLeft) {
            this.scrollLeft = scrollLeft;
        }

        public int getZoomLevel() {
            return this.zoomLevel;
        }

        public void setZoomLevel(int zoomLevel) {
            this.zoomLevel = zoomLevel;
        }

        public String getDatabase() {
            return this.database;
        }

        public void setDatabase(String database) {
            this.database = database;
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public String getCanvasType() {
            return this.canvasType;
        }

        public void setCanvasType(String canvasType) {
            this.canvasType = canvasType;
        }

        public String getLanguage() {
            return this.language;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        public String getTableCase() {
            return this.tableCase;
        }

        public void setTableCase(String tableCase) {
            this.tableCase = tableCase;
        }

        public String getColumnCase() {
            return this.columnCase;
        }

        public void setColumnCase(String columnCase) {
            this.columnCase = columnCase;
        }

        public String getHighlightTheme() {
            return this.highlightTheme;
        }

        public void setHighlightTheme(String highlightTheme) {
            this.highlightTheme = highlightTheme;
        }

        public String getBracketType() {
            return this.bracketType;
        }

        public void setBracketType(String bracketType) {
            this.bracketType = bracketType;
        }

        public Setting getSetting() {
            return this.setting;
        }

        public I18n getI18n() {
            return this.i18n;
        }

        static class Setting
        implements Serializable {
            private boolean relationshipDataTypeSync;
            private String[] columnOrder = new String[]{"columnName", "columnDataType", "columnNotNull", "columnUnique", "columnAutoIncrement", "columnDefault", "columnComment"};

            public boolean isRelationshipDataTypeSync() {
                return this.relationshipDataTypeSync;
            }

            public void setRelationshipDataTypeSync(boolean relationshipDataTypeSync) {
                this.relationshipDataTypeSync = relationshipDataTypeSync;
            }

            public String[] getColumnOrder() {
                return this.columnOrder;
            }

            public void setColumnOrder(String[] columnOrder) {
                this.columnOrder = columnOrder;
            }
        }

        static class I18n
        implements Serializable {
            private String columnName = ResManager.loadKDString((String)"\u5217\u540d\u79f0", (String)"ERD_columnName", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
            private String columnDefault = ResManager.loadKDString((String)"\u9ed8\u8ba4\u503c", (String)"ERD_columnDefault", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
            private String columnComment = ResManager.loadKDString((String)"\u5217\u6807\u9898", (String)"ERD_columnComment", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
            private String columnDataType = ResManager.loadKDString((String)"\u7c7b\u578b", (String)"ERD_columnDataType", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
            private String columnNotNull = ResManager.loadKDString((String)"\u975e\u7a7a", (String)"ERD_columnNotNull", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
            private String columnUnique;
            private String columnAutoIncrement = ResManager.loadKDString((String)"\u81ea\u589e\u957f", (String)"ERD_columnAutoIncrement", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
            private String showOption = ResManager.loadKDString((String)"\u67e5\u770b\u9009\u9879", (String)"ERD_showOption", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
            private String tableName = ResManager.loadKDString((String)"\u8868\u540d\u79f0", (String)"ERD_tableName", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
            private String relationship = ResManager.loadKDString((String)"\u5173\u8054", (String)"ERD_relationship", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
            private String export = ResManager.loadKDString((String)"\u5bfc\u51fa", (String)"ERD_export", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
            private String findTips = ResManager.loadKDString((String)"\u67e5\u627e", (String)"ERD_findTips", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
            private String zoomTips = ResManager.loadKDString((String)"\u7f29\u653e", (String)"ERD_zoomTips", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
            private String findTableHint = ResManager.loadKDString((String)"<\u8f93\u5165\u8868\u540d>", (String)"ERD_findTableHint", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);

            public String getColumnName() {
                return this.columnName;
            }

            public void setColumnName(String columnName) {
                this.columnName = columnName;
            }

            public String getColumnDefault() {
                return this.columnDefault;
            }

            public void setColumnDefault(String columnDefault) {
                this.columnDefault = columnDefault;
            }

            public String getColumnComment() {
                return this.columnComment;
            }

            public void setColumnComment(String columnComment) {
                this.columnComment = columnComment;
            }

            public String getColumnDataType() {
                return this.columnDataType;
            }

            public void setColumnDataType(String columnDataType) {
                this.columnDataType = columnDataType;
            }

            public String getColumnNotNull() {
                return this.columnNotNull;
            }

            public void setColumnNotNull(String columnNotNull) {
                this.columnNotNull = columnNotNull;
            }

            public String getColumnUnique() {
                return this.columnUnique;
            }

            public void setColumnUnique(String columnUnique) {
                this.columnUnique = columnUnique;
            }

            public String getColumnAutoIncrement() {
                return this.columnAutoIncrement;
            }

            public void setColumnAutoIncrement(String columnAutoIncrement) {
                this.columnAutoIncrement = columnAutoIncrement;
            }

            public String getShowOption() {
                return this.showOption;
            }

            public void setShowOption(String showOption) {
                this.showOption = showOption;
            }

            public String getTableName() {
                return this.tableName;
            }

            public void setTableName(String tableName) {
                this.tableName = tableName;
            }

            public String getRelationship() {
                return this.relationship;
            }

            public void setRelationship(String relationship) {
                this.relationship = relationship;
            }

            public String getExport() {
                return this.export;
            }

            public void setExport(String export) {
                this.export = export;
            }

            public String getFindTips() {
                return this.findTips;
            }

            public void setFindTips(String findTips) {
                this.findTips = findTips;
            }

            public String getZoomTips() {
                return this.zoomTips;
            }

            public void setZoomTips(String zoomTips) {
                this.zoomTips = zoomTips;
            }

            public String getFindTableHint() {
                return this.findTableHint;
            }

            public void setFindTableHint(String findTableHint) {
                this.findTableHint = findTableHint;
            }
        }

        static class Show
        implements Serializable {
            private boolean tableComment = true;
            private boolean columnComment = true;
            private boolean columnDataType = true;
            private boolean columnDefault = true;
            private boolean columnAutoIncrement = false;
            private boolean columnPrimaryKey = true;
            private boolean columnUnique = false;
            private boolean columnNotNull = true;
            private boolean relationship = true;

            Show() {
            }

            public boolean isTableComment() {
                return this.tableComment;
            }

            public void setTableComment(boolean tableComment) {
                this.tableComment = tableComment;
            }

            public boolean isColumnComment() {
                return this.columnComment;
            }

            public void setColumnComment(boolean columnComment) {
                this.columnComment = columnComment;
            }

            public boolean isColumnDataType() {
                return this.columnDataType;
            }

            public void setColumnDataType(boolean columnDataType) {
                this.columnDataType = columnDataType;
            }

            public boolean isColumnDefault() {
                return this.columnDefault;
            }

            public void setColumnDefault(boolean columnDefault) {
                this.columnDefault = columnDefault;
            }

            public boolean isColumnAutoIncrement() {
                return this.columnAutoIncrement;
            }

            public void setColumnAutoIncrement(boolean columnAutoIncrement) {
                this.columnAutoIncrement = columnAutoIncrement;
            }

            public boolean isColumnPrimaryKey() {
                return this.columnPrimaryKey;
            }

            public void setColumnPrimaryKey(boolean columnPrimaryKey) {
                this.columnPrimaryKey = columnPrimaryKey;
            }

            public boolean isColumnUnique() {
                return this.columnUnique;
            }

            public void setColumnUnique(boolean columnUnique) {
                this.columnUnique = columnUnique;
            }

            public boolean isColumnNotNull() {
                return this.columnNotNull;
            }

            public void setColumnNotNull(boolean columnNotNull) {
                this.columnNotNull = columnNotNull;
            }

            public boolean isRelationship() {
                return this.relationship;
            }

            public void setRelationship(boolean relationship) {
                this.relationship = relationship;
            }
        }
    }

    static class Control
    implements Serializable {
        private boolean allowEdit;
        private boolean allowZoom = true;
        private boolean allowMoveTable = true;

        public boolean isAllowEdit() {
            return this.allowEdit;
        }

        public void setAllowEdit(boolean allowEdit) {
            this.allowEdit = allowEdit;
        }

        public boolean isAllowZoom() {
            return this.allowZoom;
        }

        public void setAllowZoom(boolean allowZoom) {
            this.allowZoom = allowZoom;
        }

        public boolean isAllowMoveTable() {
            return this.allowMoveTable;
        }

        public void setAllowMoveTable(boolean allowMoveTable) {
            this.allowMoveTable = allowMoveTable;
        }
    }
}

