/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.table;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.newdevportal.table.ConstaintType;
import kd.bos.newdevportal.table.DesignerColumn;
import kd.bos.newdevportal.table.DesignerConstaint;
import kd.bos.newdevportal.table.DesignerIndex;
import kd.bos.newdevportal.table.DesignerTable;
import kd.bos.newdevportal.table.IndexType;
import kd.bos.newdevportal.table.TableInfoProvider;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class TableDetailPlugin
extends AbstractFormPlugin
implements TabSelectListener,
HyperLinkClickListener {
    protected static final Log LOG = LogFactory.getLog(TableDetailPlugin.class);
    private static final String KEY_CT_ERD = "tb_er";
    private static final String ENTITY_ID_KEY = "entityId";
    private static final String ACTIVE_TABLE_NAME = "activeTableName";
    private static final String DB_ROUTE = "dbroute";
    private static final String ENTRY_KEY = "field_entry";
    private DesignerTable table;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_KEY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void initialize() {
        super.initialize();
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_KEY);
        grid.addPackageDataListener(this::packageData);
    }

    private void packageData(PackageDataEvent event) {
        boolean isBase = (Boolean)event.getRowData().get("f_isbase");
        if (!isBase) {
            event.getNoLinkKey().add("f_comment");
        }
    }

    public void afterCreateNewData(EventObject e) {
        DesignerTable designerTable = this.getDesignerTable();
        if (designerTable == null) {
            return;
        }
        this.bindFieleTab();
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_ID_KEY);
        if (StringUtils.isNotBlank((CharSequence)entityId)) {
            String entityNum = MetadataDao.getNumberById((String)entityId);
            this.getModel().setValue("refentity", (Object)MetadataDao.getNumberById((String)entityId));
            String appId = BizAppServiceHelp.getAppIdByFormNum((String)entityNum);
            this.getModel().setValue("bizapp", (Object)appId);
        }
        this.getModel().setValue("tablename", (Object)designerTable.getCode());
        this.getModel().setValue("tabledesc", (Object)designerTable.getName());
        ILocaleString comment = designerTable.getComment();
        if (comment != null) {
            this.getModel().setValue("description", (Object)comment.toString());
        }
    }

    private String getRefEntityNum() {
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_ID_KEY);
        if (StringUtils.isNotBlank((CharSequence)entityId)) {
            return MetadataDao.getNumberById((String)entityId);
        }
        return null;
    }

    private void initTab(String key) {
        String cacheKey = String.format("tab_%s_initialized", key);
        boolean initialized = Boolean.parseBoolean(String.valueOf(this.getPageCache().get(cacheKey)));
        if (initialized) {
            return;
        }
        switch (key) {
            case "tb_field": {
                this.bindFieleTab();
                break;
            }
            case "tb_constraint": {
                this.bindConstraintTab();
                break;
            }
            case "tb_index": {
                this.bindIndexTab();
                break;
            }
            case "tb_sqlpreview": {
                this.bindDDLtab();
                break;
            }
            case "tb_er": {
                this.bindERTab();
                break;
            }
        }
        this.getPageCache().put(cacheKey, "true");
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String key = tabSelectEvent.getTabKey();
        this.initTab(key);
        this.getView().updateView(key);
    }

    private DesignerTable getDesignerTable() {
        if (this.table == null) {
            try {
                String routkey = (String)this.getView().getFormShowParameter().getCustomParam(DB_ROUTE);
                TableInfoProvider provider = TableInfoProvider.create(DBRoute.of((String)(routkey == null ? "sys" : routkey)));
                String tableName = (String)this.getView().getFormShowParameter().getCustomParam("tablename");
                this.table = provider.getTableInfo(tableName == null ? "t_bd_attachment" : tableName, this.getRefEntityNum());
            }
            catch (RuntimeException runExcep) {
                String exceptionMessage = runExcep.getMessage();
                if (exceptionMessage.contains("db type not supported")) {
                    this.getView().showTipNotification("db type not supported");
                }
                throw runExcep;
            }
        }
        return this.table;
    }

    private void bindFieleTab() {
        DesignerTable info = this.getDesignerTable();
        this.getModel().deleteEntryData(ENTRY_KEY);
        if (info == null) {
            return;
        }
        if (info.getCols().isEmpty()) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRY_KEY, info.getCols().size());
        int i = 0;
        ArrayList<String> pkColumns = new ArrayList<String>();
        for (DesignerConstaint constaint : info.getConstaints()) {
            if (!ConstaintType.Primary.equal(constaint.getConstaintType())) continue;
            pkColumns.addAll(constaint.getRefCols());
        }
        for (DesignerColumn col : info.getCols()) {
            this.getModel().setValue("f_fieldkey", (Object)col.getCode(), i);
            this.getModel().setValue("f_fieldname", (Object)col.getName(), i);
            this.getModel().setValue("f_fieldtype", (Object)col.getType(), i);
            if (col.getLength() > 0L) {
                this.getModel().setValue("f_fieldlenght", (Object)col.getLength(), i);
            }
            if (col.getScale() > 0) {
                this.getModel().setValue("f_scale", (Object)col.getScale(), i);
            }
            if (pkColumns.contains(col.getName())) {
                this.getModel().setValue("f_isprimary", (Object)true, i);
            }
            this.getModel().setValue("f_foreign", (Object)false, i);
            this.getModel().setValue("f_forbidnullvalue", (Object)col.isNotnull(), i);
            this.getModel().setValue("f_defvalue", (Object)col.getDefValue(), i);
            this.getModel().setValue("f_comment", (Object)col.getComment().getLocaleValue(), i);
            this.getModel().setValue("f_isbase", (Object)col.isBase(), i);
            ++i;
        }
    }

    private void bindConstraintTab() {
        DesignerTable info = this.getDesignerTable();
        this.getModel().deleteEntryData("key_entry");
        if (info == null) {
            return;
        }
        if (info.getConstaints().isEmpty()) {
            return;
        }
        int size = 0;
        for (DesignerConstaint constaint : info.getConstaints()) {
            if (!ConstaintType.Primary.equal(constaint.getConstaintType())) continue;
            ++size;
        }
        if (size == 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("key_entry", info.getConstaints().size());
        int i = 0;
        for (DesignerConstaint cols : info.getConstaints()) {
            this.getModel().setValue("k_name", (Object)cols.getName(), i);
            this.getModel().setValue("k_number", (Object)cols.getCode(), i);
            this.getModel().setValue("k_desc", (Object)cols.getConstaintType(), i);
            this.getModel().setValue("k_unique", (Object)true, i);
            this.getModel().setValue("k_focus", (Object)String.join((CharSequence)",", cols.getRefCols()), i);
            ++i;
        }
    }

    private void bindIndexTab() {
        DesignerTable info = this.getDesignerTable();
        this.getModel().deleteEntryData("idx_entry");
        if (info == null) {
            return;
        }
        if (info.getIdxs().isEmpty()) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("idx_entry", info.getIdxs().size());
        int i = 0;
        for (DesignerIndex cols : info.getIdxs()) {
            this.getModel().setValue("idx_name", (Object)cols.getCode(), i);
            this.getModel().setValue("idx_number", (Object)cols.getName(), i);
            this.getModel().setValue("idx_desc", (Object)cols.getIndexdef(), i);
            this.getModel().setValue("idx_unique", (Object)IndexType.Unique.equal(cols.getIndexType()), i);
            this.getModel().setValue("idx_focus", (Object)String.join((CharSequence)",", cols.getRefCols()), i);
            ++i;
        }
    }

    private void bindDDLtab() {
        CodeEdit codeEdit = (CodeEdit)this.getView().getControl("codeeditap");
        DesignerTable designerTable = this.getDesignerTable();
        if (designerTable == null) {
            return;
        }
        codeEdit.setText(designerTable.tranToDDL());
    }

    private void bindERTab() {
        FormShowParameter parentFormShowParameter = this.getView().getFormShowParameter();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_devpn_datamodel");
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_ID_KEY);
        showParameter.setCustomParam(ENTITY_ID_KEY, (Object)entityId);
        String routKey = (String)this.getView().getFormShowParameter().getCustomParam(DB_ROUTE);
        showParameter.setCustomParam(DB_ROUTE, (Object)routKey);
        String tableName = (String)this.getView().getFormShowParameter().getCustomParam("tablename");
        showParameter.setCustomParam(ACTIVE_TABLE_NAME, (Object)tableName);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(KEY_CT_ERD);
        this.getView().showForm(showParameter);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRY_KEY);
        if (dynamicObjects == null || dynamicObjects.isEmpty()) {
            return;
        }
        String entityNumber = ((DynamicObject)dynamicObjects.get(rowIndex)).getString("f_comment").split(" ")[1];
        String entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity);
        EntityMetadata metadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        String tableName = metadata.getRootEntity().getTableName();
        FormShowParameter show = new FormShowParameter();
        show.setFormId("devn_tablesheetdetail");
        show.setCustomParam("tablename", (Object)tableName);
        show.setCustomParam(ENTITY_ID_KEY, (Object)entityId);
        String dbroute = EntityMetadataCache.getDataEntityType((String)MetadataDao.getEntityNumberById((String)entityId)).getDBRouteKey();
        show.setCustomParam(DB_ROUTE, (Object)dbroute);
        ShowType showType = this.getView().getFormShowParameter().getOpenStyle().getShowType();
        if (showType == ShowType.NewTabPage) {
            IFormView mainView = this.getView().getMainView();
            String mainFormId = "";
            if (mainView != null) {
                mainFormId = this.getView().getMainView().getFormShowParameter().getFormId();
            }
            if (this.getView().getMainView() == null || "pc_main_console".equals(mainFormId)) {
                show.getOpenStyle().setShowType(ShowType.NewTabPage);
                show.getOpenStyle().setTargetKey("_submaintab_");
                IFormView parentView = this.getView().getParentView();
                parentView.showForm(show);
                this.getView().sendFormAction(parentView);
            } else if ("home_page".equals(mainFormId)) {
                show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(show);
            }
        } else {
            show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(show);
        }
    }
}

