/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.table;

import java.util.EventObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.newdevportal.table.ErDataGenerator;

public class TableErdViewerPlugin
extends AbstractFormPlugin {
    protected static final Log LOG = LogFactory.getLog(TableErdViewerPlugin.class);
    private static final String KEY_CT_ERD = "cterd";
    private static final String KEY_LBL_NO_DATA = "lblnodata";
    private static final String ENTITY_ID_KEY = "entityId";
    private static final String ACTIVE_TABLE_NAME = "activeTableName";
    private static final String DB_ROUTE = "dbroute";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.bindErdData();
    }

    private void bindErdData() {
        try {
            String data;
            String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_ID_KEY);
            if (StringUtils.isBlank((CharSequence)entityId)) {
                LOG.error("entityId need");
            }
            String entityNum = MetadataDao.getNumberById((String)entityId);
            String routKey = (String)this.getView().getFormShowParameter().getCustomParam(DB_ROUTE);
            if (StringUtils.isBlank((CharSequence)routKey)) {
                EntityMetadata oldEntityMeta = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
                routKey = oldEntityMeta.getDBRouteKey();
            }
            String activeTableName = (String)this.getView().getFormShowParameter().getCustomParam(ACTIVE_TABLE_NAME);
            String parentPageId = this.getView().getFormShowParameter().getParentPageId();
            IPageCache pageCache = null;
            if (StringUtils.isNotBlank((CharSequence)parentPageId)) {
                IFormView pView = this.getView().getViewNoPlugin(parentPageId);
                pageCache = (IPageCache)pView.getService(IPageCache.class);
            }
            if (StringUtils.isNotBlank((CharSequence)(data = ErDataGenerator.getErdData(entityId, entityNum, routKey, activeTableName, pageCache)))) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_CT_ERD});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_LBL_NO_DATA});
                CustomControl customControl = (CustomControl)this.getView().getControl(KEY_CT_ERD);
                customControl.setData((Object)data);
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_CT_ERD});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_LBL_NO_DATA});
            }
        }
        catch (RuntimeException runEx) {
            String exceptionMessage = runEx.getMessage();
            if (exceptionMessage.contains("db type not supported")) {
                this.getView().showTipNotification("db type not supported");
            }
            throw runEx;
        }
    }
}

