/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.table;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.devportal.api.BizAppService;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityObjectReader;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.ListHyperLinkClickEvent;
import kd.bos.list.events.ListHyperLinkClickListener;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.newdevportal.table.EntityTableUtil;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPools;

public class TableManagerListPlugin
extends StandardTreeListPlugin
implements ListHyperLinkClickListener,
HyperLinkClickListener,
IConfirmCallBack {
    private static final String Key_BillListCtl = "billlistap";
    private static final String KEY_TABLENAME = "tablename";
    private static final String CLOSE_CALLBACK_EXPORT = "CloseCallBack_Export";
    private static final String CLOSE_CALLBACK_EXPORTPAGE = "CloseCallBack_ExportPage";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private Map<String, String> providerContext = new HashMap<String, String>();
    private static final Log log = LogFactory.getLog(TableManagerListPlugin.class);

    private Map<String, String> getProviderContext() {
        return this.providerContext;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new EntityTableListProvider(this.getProviderContext(), this.getView()));
    }

    public void initializeTree(EventObject e) {
        BizAppService appService = (BizAppService)ServiceFactory.getService(BizAppService.class);
        TreeNode root = (TreeNode)appService.getSubsysTree(null, null, null, "app", true, false, false);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"TableManagerListPlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        treeView.addNode(root);
        this.getTreeListView().getTreeModel().setRoot(root);
        this.getTreeListView().getTreeView().focusNode(root);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        TreeNode root = this.getTreeListView().getTreeModel().getRoot();
        TreeNode node = root.getTreeNode(nodeId, 10);
        Object type = node.getData();
        if (StringUtils.equalsIgnoreCase((CharSequence)"cloud", (CharSequence)String.valueOf(type))) {
            if (node.getChildren() == null) {
                super.treeNodeClick(e);
                return;
            }
            for (TreeNode app : node.getChildren()) {
                if (app.getChildren() != null && !app.getChildren().isEmpty()) continue;
                this.fillEntityNode(app.getId(), app);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"app", (CharSequence)String.valueOf(type)) && (node.getChildren() == null || node.getChildren().isEmpty())) {
            this.fillEntityNode(node.getId(), node);
        }
        this.getTreeListView().getTreeModel().setRoot(root);
    }

    private void fillEntityNode(String appId, TreeNode node) {
        QFilter[] qf = new QFilter[2];
        ArrayList<String> modelTypes = new ArrayList<String>();
        modelTypes.add("BillFormModel");
        modelTypes.add("BaseFormModel");
        qf[0] = new QFilter("modeltype", "in", modelTypes);
        qf[1] = new QFilter("istemplate", "=", (Object)Boolean.FALSE);
        List billNode = EntityObjectReader.buildBillNodesInApp((String)appId, (QFilter[])qf);
        this.getTreeListView().getTreeView().addNodes(billNode);
        node.setChildren(billNode);
    }

    public void afterBindData(EventObject e) {
        TreeNode currNode = null;
        Map currNodeMap = this.getTreeListView().getTreeView().getTreeState().getFocusNode();
        currNode = currNodeMap == null ? this.getTreeModel().getRoot() : (TreeNode)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)currNodeMap), TreeNode.class);
        this.getTreeListView().getTreeView().focusNode(currNode);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        super.buildTreeListFilter(e);
        String nodeId = e.getNodeId() == null ? "rootNode" : e.getNodeId().toString();
        TreeNode node = this.getTreeListView().getTreeModel().getRoot().getTreeNode(nodeId, 10);
        Object type = node.getData();
        if (StringUtils.equalsIgnoreCase((CharSequence)"cloud", (CharSequence)String.valueOf(type))) {
            e.addQFilter(new QFilter("entity.bizapp.bizcloud.id", "=", (Object)nodeId));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"app", (CharSequence)String.valueOf(type))) {
            e.addQFilter(new QFilter("entity.bizapp.id", "in", this.getAppIdsBy(nodeId)));
        } else {
            if (StringUtils.equalsIgnoreCase((CharSequence)"root", (CharSequence)String.valueOf(type))) {
                return;
            }
            e.addQFilter(new QFilter("entity.number", "=", (Object)node.getId()));
        }
    }

    private List<String> getAppIdsBy(String appId) {
        DynamicObjectCollection allApps = BizAppServiceHelp.getAllBizApps();
        String masterId = allApps.stream().filter(obj -> StringUtils.equals((CharSequence)appId, (CharSequence)obj.getString("id"))).findFirst().map(app -> {
            String tType = app.getString("type");
            if (StringUtils.equals((CharSequence)"0", (CharSequence)tType)) {
                return app.getString("id");
            }
            return app.getString("masterid");
        }).orElse("");
        if (StringUtils.isBlank((CharSequence)masterId)) {
            return new ArrayList<String>();
        }
        return allApps.stream().filter(obj -> {
            String tId = obj.getString("id");
            String tMasterId = obj.getString("masterid");
            return StringUtils.equals((CharSequence)masterId, (CharSequence)tId) || StringUtils.equals((CharSequence)masterId, (CharSequence)tMasterId);
        }).map(obj -> obj.getString("id")).collect(Collectors.toList());
    }

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl(Key_BillListCtl);
        billList.addPackageDataListener(t -> {
            Object src = t.getSource();
            if (!(src instanceof DynamicTextColumnDesc)) {
                return;
            }
            AbstractColumnDesc dytextcol = (AbstractColumnDesc)src;
            Object fmtValue = "";
            Object tableName = t.getRowData().get(KEY_TABLENAME);
            switch (dytextcol.getKey()) {
                case "tablename": {
                    fmtValue = tableName;
                    break;
                }
                case "reftablename": {
                    Object refTable = t.getRowData().get("reftablename");
                    fmtValue = StringUtils.equalsIgnoreCase((CharSequence)String.valueOf(tableName), (CharSequence)String.valueOf(refTable)) ? "" : refTable;
                    break;
                }
                case "tabledesc": {
                    fmtValue = t.getRowData().get("tabledesc");
                    break;
                }
                case "bizapp": {
                    fmtValue = t.getRowData().get("bizapp");
                    break;
                }
                case "bizcloud": {
                    fmtValue = t.getRowData().get("bizcloud");
                    break;
                }
                case "refentity": {
                    fmtValue = t.getRowData().get("refentity");
                    break;
                }
                case "modifier": {
                    fmtValue = t.getRowData().get("modifier");
                    break;
                }
                case "modifytime": {
                    fmtValue = t.getRowData().get("modifytime");
                    break;
                }
            }
            t.setFormatValue(fmtValue);
        });
        billList.addBeforeBindDataListener(e -> {
            int maxsize;
            int curPageRows;
            BillList billListCtl = (BillList)this.getView().getControl(Key_BillListCtl);
            if (billListCtl != null && (curPageRows = billListCtl.getPageRow()) > (maxsize = Integer.getInteger("devp.tabledictlist.maxrowsize", 50).intValue())) {
                billListCtl.getEntryState().setPageRows(maxsize);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6bcf\u9875\u6570\u636e\u6700\u5927\u503c\u4e3a\uff1a%s\u3002", (String)"TableManagerListPlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), maxsize));
            }
        });
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl(Key_BillListCtl);
        billList.addListHyperLinkClickListener((ListHyperLinkClickListener)this);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("btnexport".equals(itemKey)) {
            this.startExportTask(this.getExportAppIds());
        } else if ("sync".equals(itemKey)) {
            EntityTableUtil.syncAll();
        } else if ("clearall".equals(itemKey)) {
            DB.execute((DBRoute)DBRoute.meta, (String)"TRUNCATE TABLE T_META_TABLEDICTION");
        } else if ("clearduplicate".equals(itemKey)) {
            EntityTableUtil.clearDuplicateData();
        } else if ("btnexportpage".equals(itemKey)) {
            long userId = RequestContext.get().getCurrUserId();
            String appId = this.getView().getFormShowParameter().getAppId();
            int flag = PermissionServiceHelper.checkPermission((Long)userId, (Long)0L, (String)appId, (String)"bos_devp_tablediction", (String)"4730fc9f000004ae");
            if (flag != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6570\u636e\u5b57\u5178\u7684\u5bfc\u51fa\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u64cd\u4f5c\u3002", (String)"TableManagerListPlugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                return;
            }
            FormShowParameter show = new FormShowParameter();
            show.setFormId("bos_devp_tableexportnode");
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CLOSE_CALLBACK_EXPORTPAGE);
            show.setCloseCallBack(closeCallBack);
            show.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(show);
            long entitySize = (Long)DB.query((DBRoute)DBRoute.meta, (String)"SELECT COUNT(1) FROM T_META_ENTITYINFO", rs -> {
                long size = 0L;
                while (rs.next()) {
                    size = rs.getLong(1);
                }
                return size;
            });
            long tableSize = (Long)DB.query((DBRoute)DBRoute.meta, (String)"SELECT COUNT(1) FROM T_META_TABLEDICTION", rs -> {
                long size = 0L;
                while (rs.next()) {
                    size = rs.getLong(1);
                }
                return size;
            });
            if (entitySize > tableSize) {
                ThreadPools.executeOnceIncludeRequestContext((String)("entitytabledictsync+" + System.currentTimeMillis()), () -> EntityTableUtil.syncAll());
            }
        }
    }

    private void startExportTask(List<String> appIds) {
        if (appIds.isEmpty()) {
            return;
        }
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("bos");
        jobInfo.setRunByLang(RequestContext.get().getLang());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setlName(ResManager.getLocaleString((String)"\u6570\u636e\u5b57\u5178Html\u5bfc\u51fa", (String)"TableManagerListPlugin_3", (String)BOS_DEVPORTAL_NEW_PLUGIN));
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.bos.newdevportal.table.DataDictExportTask");
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("appIds", appIds);
        jobInfo.setParams(params);
        jobInfo.setRunByLang(Lang.get());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CLOSE_CALLBACK_EXPORT);
        JobForm.dispatch((JobInfo)jobInfo, (IFormView)this.getView(), (CloseCallBack)closeCallBack);
    }

    private void startExportTask(List<String> appIds, String exportFormat) {
        if (appIds.isEmpty()) {
            return;
        }
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("bos");
        jobInfo.setRunByLang(RequestContext.get().getLang());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setlName(ResManager.getLocaleString((String)"\u6570\u636e\u5b57\u5178Html\u5bfc\u51fa", (String)"TableManagerListPlugin_3", (String)BOS_DEVPORTAL_NEW_PLUGIN));
        if ("1".equals(exportFormat)) {
            jobInfo.setlName(ResManager.getLocaleString((String)"\u6570\u636e\u5b57\u5178Excel\u5bfc\u51fa", (String)"TableManagerListPlugin_5", (String)BOS_DEVPORTAL_NEW_PLUGIN));
        }
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.bos.newdevportal.table.DataDictExportTask");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("appIds", appIds);
        params.put("exportFormat", exportFormat);
        jobInfo.setParams(params);
        jobInfo.setRunByLang(Lang.get());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CLOSE_CALLBACK_EXPORT);
        JobFormInfo clientJobInfo = new JobFormInfo(jobInfo);
        clientJobInfo.setCloseCallBack(closeCallBack);
        clientJobInfo.setCanBackground(true);
        JobForm.dispatch((JobFormInfo)clientJobInfo, (IFormView)this.getView());
    }

    private Map<String, String> getCloudAndAppIds2Export() {
        HashMap<String, String> r = new HashMap<String, String>(16);
        Map nodeInfo = this.getTreeListView().getTreeView().getTreeState().getFocusNode();
        String nodeId = nodeInfo == null ? "rootNode" : nodeInfo.get("id").toString();
        TreeNode node = this.getTreeListView().getTreeModel().getRoot().getTreeNode(nodeId, 10);
        Object type = node.getData();
        if (StringUtils.equalsIgnoreCase((CharSequence)"cloud", (CharSequence)String.valueOf(type))) {
            List appsIds = BizAppServiceHelp.getAppsIdByCloudId((String)nodeId);
            for (String appsId : appsIds) {
                r.put(nodeId, appsId);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"app", (CharSequence)String.valueOf(type))) {
            TreeNode cldNode = this.getTreeListView().getTreeModel().getRoot().getTreeNode(node.getParentid(), 10);
            r.put(cldNode.getId(), nodeId);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"root", (CharSequence)String.valueOf(type))) {
            for (DynamicObject obj : BizAppServiceHelp.getAllBizApps()) {
                String cloudId = obj.getString("bizcloud");
                String appId = obj.getString("id");
                r.put(cloudId, appId);
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6309\u5b9e\u4f53\u5bfc\u51fa\u3002", (String)"TableManagerListPlugin_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return null;
        }
        return r;
    }

    private List<String> getExportAppIds() {
        ArrayList<String> l = new ArrayList<String>();
        Map nodeInfo = this.getTreeListView().getTreeView().getTreeState().getFocusNode();
        String nodeId = nodeInfo == null ? "rootNode" : nodeInfo.get("id").toString();
        TreeNode node = this.getTreeListView().getTreeModel().getRoot().getTreeNode(nodeId, 10);
        Object type = node.getData();
        if (StringUtils.equalsIgnoreCase((CharSequence)"cloud", (CharSequence)String.valueOf(type))) {
            l.addAll(BizAppServiceHelp.getAppsIdByCloudId((String)nodeId));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"app", (CharSequence)String.valueOf(type))) {
            l.addAll(this.getAppIdsBy(nodeId));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"root", (CharSequence)String.valueOf(type))) {
            for (DynamicObject obj : BizAppServiceHelp.getAllBizApps()) {
                Object id = obj.get("id");
                if (id == null) continue;
                l.add(id.toString());
            }
        }
        return l;
    }

    public void confirmCallBack(MessageBoxClosedEvent arg0) {
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)CLOSE_CALLBACK_EXPORT)) {
            TaskInfo taskInfo;
            String taskInfoStr;
            Map result;
            Object returnData2 = closedCallBackEvent.getReturnData();
            if (returnData2 instanceof Map && (result = (Map)returnData2).containsKey("taskinfo") && StringUtils.isNotBlank((CharSequence)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
                String data = taskInfo.getData();
                JSONObject jsonObject = JSONObject.parseObject((String)data);
                String error = jsonObject.getString("error");
                if (StringUtils.isNotBlank((CharSequence)error)) {
                    this.getView().showErrorNotification(error);
                    return;
                }
                String url = jsonObject.getString("url");
                if (StringUtils.isNotBlank((Object)returnData2)) {
                    this.getView().openUrl(url);
                }
            }
        } else if (CLOSE_CALLBACK_EXPORTPAGE.equals(closedCallBackEvent.getActionId()) && (returnData = closedCallBackEvent.getReturnData()) instanceof Map) {
            Map result = (Map)returnData;
            String exportFormat = (String)result.get("exportFormat");
            List appIds = (List)result.get("exportAppIds");
            if ("2".equals(exportFormat)) {
                this.startExportTask(appIds, exportFormat);
            } else if ("1".equals(exportFormat)) {
                this.startExportTask(appIds, exportFormat);
            }
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode parent = root.getTreeNode(nodeId, 20);
        TreeNode cnode = root.getTreeNode(nodeId, 5);
        e.setChildNodes(cnode.getChildren());
        if (parent != null) {
            this.getTreeListView().getTreeView().expand(nodeId);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent paramHyperLinkClickEvent) {
        FormShowParameter show = new FormShowParameter();
        BillList billList = (BillList)this.getControl(Key_BillListCtl);
        Object pk = billList.getFocusRowPkId();
        show.setFormId("devn_tablesheetdetail");
        String pkStr = String.valueOf(pk);
        String[] info = pkStr.split("@@");
        if (info.length < 2) {
            throw new KDException("err data");
        }
        show.setCustomParam(KEY_TABLENAME, (Object)info[0]);
        show.setCustomParam("entityId", (Object)info[1]);
        String dbroute = EntityMetadataCache.getDataEntityType((String)MetadataDao.getEntityNumberById((String)info[1])).getDBRouteKey();
        show.setCustomParam("dbroute", (Object)dbroute);
        IFormView formView = this.getView();
        ShowType showType = this.getView().getFormShowParameter().getOpenStyle().getShowType();
        if (showType == ShowType.NewTabPage) {
            IFormView mainView = formView.getMainView();
            String mainFormId = "";
            if (mainView != null) {
                mainFormId = formView.getMainView().getFormShowParameter().getFormId();
            }
            if (formView.getMainView() == null || "pc_main_console".equals(mainFormId)) {
                String pageIdKey = "TableManagerList" + info[0];
                String tablePageId = formView.getPageCache().get(pageIdKey);
                String parentPageId = formView.getFormShowParameter().getParentPageId();
                show.setParentPageId(parentPageId);
                show.getOpenStyle().setShowType(ShowType.NewTabPage);
                show.getOpenStyle().setTargetKey("_submaintab_");
                if (StringUtils.isBlank((CharSequence)tablePageId) || formView.getViewNoPlugin(tablePageId) == null) {
                    String pageId = parentPageId + info[0];
                    formView.getPageCache().put(pageIdKey, pageId);
                    show.setPageId(pageId);
                    IFormView parentView = formView.getView(parentPageId);
                    parentView.showForm(show);
                    formView.sendFormAction(parentView);
                } else {
                    IFormView tabView = formView.getView(tablePageId);
                    tabView.activate();
                    formView.sendFormAction(tabView);
                }
            } else if ("home_page".equals(mainFormId)) {
                show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formView.showForm(show);
            }
        } else {
            show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(show);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
    }

    public void hyperLinkClick(ListHyperLinkClickEvent e) {
    }

    static class EntityTableListProvider
    extends ListDataProvider {
        public EntityTableListProvider(Map<String, String> refEntityNums) {
        }

        public EntityTableListProvider(Map<String, String> refEntityNums, IFormView view) {
            this(refEntityNums);
        }

        public int getMaxReturnData() {
            return 10000;
        }

        public int getRealCount() {
            int id;
            ORM orm = ORM.create();
            StringBuilder sb = new StringBuilder();
            sb.append("tablename,id");
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
            qFilterList.add(new QFilter("entity.bizapp.id", "is not null", (Object)""));
            qFilterList.add(new QFilter("entity.id", "is not null", (Object)""));
            qFilterList.add(new QFilter(TableManagerListPlugin.KEY_TABLENAME, "!=", (Object)"t_isv_xxx"));
            if (this.getQueryBuilder().getFilters().length > 0) {
                qFilterList.addAll(Arrays.asList(this.getQueryBuilder().getFilters()));
            }
            try (DataSet dataSet = orm.queryDataSet("tabledictlist", this.getQueryBuilder().getEntityName(), sb.toString(), qFilterList.toArray(new QFilter[qFilterList.size()]));){
                id = dataSet.distinct().count("id", false);
            }
            return id;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            ORM orm = ORM.create();
            StringBuilder sb = new StringBuilder();
            sb.append("tablename,id,").append("entity,entity.id,entity.name,entity.number,entity.bizapp,entity.bizapp.name,").append("entity.bizapp.bizcloud,entity.bizapp.bizcloud.name");
            String selectFields = sb.toString();
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
            qFilterList.add(new QFilter("entity.bizapp.number", "is not null", (Object)""));
            qFilterList.add(new QFilter(TableManagerListPlugin.KEY_TABLENAME, "!=", (Object)"t_isv_xxx"));
            qFilterList.add(new QFilter("entity.number", "is not null", (Object)""));
            qFilterList.add(new QFilter("entity.bizapp.bizcloud", "!=", (Object)"2HGKCE94QELW"));
            qFilterList.add(new QFilter("entity.bizapp", "!=", (Object)"2HGKTA7HH43C"));
            if (this.getQueryBuilder().getFilters().length > 0) {
                qFilterList.addAll(Arrays.asList(this.getQueryBuilder().getFilters()));
            }
            DynamicObjectType type = new DynamicObjectType("queryplain");
            DynamicSimpleProperty pkprop = new DynamicSimpleProperty("id", String.class, (Object)"");
            pkprop.setPrimaryKey(true);
            type.registerSimpleProperty(pkprop);
            type.registerSimpleProperty(new DynamicSimpleProperty(TableManagerListPlugin.KEY_TABLENAME, String.class, null));
            type.registerSimpleProperty(new DynamicSimpleProperty("tabledesc", String.class, null));
            type.registerSimpleProperty(new DynamicSimpleProperty("reftablename", String.class, null));
            type.registerSimpleProperty(new DynamicSimpleProperty("bizapp", String.class, null));
            type.registerSimpleProperty(new DynamicSimpleProperty("bizcloud", String.class, null));
            type.registerSimpleProperty(new DynamicSimpleProperty("refentity", String.class, null));
            type.registerSimpleProperty(new DynamicSimpleProperty("modifier", String.class, null));
            type.registerSimpleProperty(new DynamicSimpleProperty("modifytime", String.class, null));
            type.registerSimpleProperty(new DynamicSimpleProperty("pk", String.class, null));
            DynamicObjectCollection cols = new DynamicObjectCollection(type, null);
            ArrayList<Object> ids = new ArrayList<Object>(10);
            try (DataSet dataSet = orm.queryDataSet("tabledictlist", this.getQueryBuilder().getEntityName(), selectFields, qFilterList.toArray(new QFilter[qFilterList.size()]), null, this.getQueryBuilder().getStart(), this.getQueryBuilder().getLimit());){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Object id = row.get("id");
                    ids.add(id);
                    String tableName = row.getString(TableManagerListPlugin.KEY_TABLENAME);
                    String entityId = String.valueOf(row.getString("entity.id"));
                    DynamicObject object = new DynamicObject(type, (Object)(tableName + "@@" + entityId));
                    object.set("pk", id);
                    object.set(TableManagerListPlugin.KEY_TABLENAME, (Object)tableName.toLowerCase());
                    object.set("bizapp", (Object)row.getString("entity.bizapp.name"));
                    object.set("bizcloud", (Object)row.getString("entity.bizapp.bizcloud.name"));
                    object.set("refentity", (Object)row.getString("entity.name"));
                    object.set("tabledesc", (Object)tableName);
                    cols.add((Object)object);
                }
            }
            SqlBuilder extDataSql = new SqlBuilder();
            extDataSql.append("select fid , fdata from t_meta_tablediction where ", new Object[0]).appendIn("fid", ids.toArray());
            Map extInfos = ids.isEmpty() ? new HashMap(10) : (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)extDataSql, rs -> {
                HashMap<String, Object> ext = new HashMap<String, Object>();
                while (rs.next()) {
                    String id = rs.getString("fid");
                    try {
                        String extData = rs.getString("fdata");
                        if (!StringUtils.isNotBlank((CharSequence)extData)) continue;
                        ext.put(id, SerializationUtils.fromJsonString((String)extData, Map.class));
                    }
                    catch (Exception e) {
                        log.error("\u6570\u636e\u8868\u63cf\u8ff0\u67e5\u8be2\u5931\u8d25:" + e.getMessage(), (Throwable)e);
                    }
                }
                return ext;
            });
            for (DynamicObject obj : cols) {
                String pk = obj.getString("pk");
                Map ext = (Map)extInfos.get(pk);
                if (ext == null) continue;
                Object caption = ext.get("caption");
                Object ptable = ext.get("parenttable");
                if (caption instanceof Map) {
                    LocaleString desc = LocaleString.fromMap((Map)((Map)caption));
                    obj.set("tabledesc", (Object)desc.toString());
                }
                if (!StringUtils.isNotBlank(ptable)) continue;
                obj.set("reftablename", (Object)ptable.toString());
            }
            this.getQueryResult().setCollection(cols);
            return cols;
        }
    }
}

