/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ImageUtil {
    private static final Log logger = LogFactory.getLog(ImageUtil.class);
    private static final String OCR_IMAGE_PER = "data:image/png;base64,";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getImageBase64(String url) {
        FileService imageFileService = FileServiceFactory.getImageFileService();
        try (InputStream in = imageFileService.getInputStream(url);){
            String string = ImageUtil.getImageBase64ByIO(in);
            return string;
        }
        catch (IOException e) {
            logger.warn(String.format("\u83b7\u53d6\u56fe\u7247\u5f02\u5e38\uff1a%s", e.getMessage()), (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private static String getImageBase64ByIO(InputStream in) throws IOException {
        try (ByteArrayOutputStream ba = new ByteArrayOutputStream();){
            int len;
            byte[] bs = new byte[1024];
            while ((len = in.read(bs)) != -1) {
                ba.write(bs, 0, len);
            }
            Base64.Encoder encoder = Base64.getEncoder();
            byte[] imgByte = encoder.encode(ba.toByteArray());
            String string = OCR_IMAGE_PER + new String(imgByte, StandardCharsets.UTF_8);
            return string;
        }
    }
}

