/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.util;

import com.alibaba.fastjson.JSONArray;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class QueryUtils {
    private QueryUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static DynamicObjectCollection getBizCloudNames(String[] ids) {
        ORM orm = ORM.create();
        QFilter q = new QFilter("id", "in", (Object)ids);
        QFilter[] filters = new QFilter[]{q};
        String selectFields = "id,name";
        return orm.query("bos_devportal_bizcloud", selectFields, filters);
    }

    public static DynamicObject getBizCloudName(String id) {
        ORM orm = ORM.create();
        QFilter q = new QFilter("id", "=", (Object)id);
        QFilter[] filters = new QFilter[]{q};
        String selectFields = "id,name";
        return orm.queryOne("bos_devportal_bizcloud", selectFields, filters);
    }

    public static DynamicObjectCollection getBizApps() {
        ORM orm = ORM.create();
        QFilter q = new QFilter("id", "is not null", (Object)"");
        QFilter[] filters = new QFilter[]{q};
        String selectFields = "id,number,name,bizcloud,type,version,deploystatus,modifydate";
        return orm.query("bos_devportal_bizapp", selectFields, filters);
    }

    public static DynamicObjectCollection getRecentBizApps(int limit) {
        int limitInt = limit <= 0 ? 10 : limit;
        ORM orm = ORM.create();
        QFilter q = new QFilter("id", "is not null", (Object)"");
        q.and(new QFilter("modifydate", "is not null", (Object)""));
        QFilter[] filters = new QFilter[]{q};
        String selectFields = "id,number,name,bizcloud,type,version,deploystatus,modifydate,image";
        return orm.query("bos_devportal_bizapp", selectFields, filters, "modifydate desc", limitInt);
    }

    public static DynamicObjectCollection getBizAppsByBizCloud(String id, String isv) {
        ORM orm = ORM.create();
        QFilter bizcloudQFilter = null;
        bizcloudQFilter = !"".equals(id) ? new QFilter("bizcloud", "=", (Object)id) : new QFilter("bizcloud", "is not null", (Object)"");
        QFilter isvQFilter = new QFilter("isv", "=", (Object)isv);
        QFilter[] filters = new QFilter[]{bizcloudQFilter, isvQFilter};
        String selectFields = "id,number,name,bizcloud,type,version,deploystatus";
        return orm.query("bos_devportal_bizapp", selectFields, filters);
    }

    public static DynamicObjectCollection getBizAppsByBizCloudAndType(String id, String type) {
        ORM orm = ORM.create();
        QFilter bizcloudQFilter = null;
        bizcloudQFilter = !"".equals(id) ? new QFilter("bizcloud", "=", (Object)id) : new QFilter("bizcloud", "is not null", (Object)"");
        QFilter typeQFilter = new QFilter("type", "=", (Object)type);
        QFilter[] filters = new QFilter[]{bizcloudQFilter, typeQFilter};
        String selectFields = "id,number,name,bizcloud,type,version,deploystatus";
        return orm.query("bos_devportal_bizapp", selectFields, filters);
    }

    public static DynamicObject getBizAppDetail(String id) {
        ORM orm = ORM.create();
        QFilter q = new QFilter("id", "=", (Object)id);
        QFilter[] filters = new QFilter[]{q};
        return orm.queryOne("bos_devportal_bizapp", "id,number,name,description,bizcloud,type,modifydate,image,simplenumber,deploystatus", filters);
    }

    public static DynamicObjectCollection getBizAppsByType(String type) {
        ORM orm = ORM.create();
        QFilter q = new QFilter("type", "=", (Object)type);
        QFilter[] filters = new QFilter[]{q};
        String selectFields = "id,number,name,bizcloud,type,version,deploystatus";
        return orm.query("bos_devportal_bizapp", selectFields, filters);
    }

    public static DynamicObjectCollection getBizAppsByName(String name) {
        ORM orm = ORM.create();
        QFilter q = new QFilter("name", "like", (Object)name);
        QFilter[] filters = new QFilter[]{q};
        String selectFields = "id,number,name,bizcloud,type,version,deploystatus";
        return orm.query("bos_devportal_bizapp", selectFields, filters);
    }

    public static DynamicObjectCollection getBizAppsByIsv(String isv) {
        ORM orm = ORM.create();
        QFilter q = new QFilter("isv", "=", (Object)isv);
        QFilter[] filters = new QFilter[]{q};
        String selectFields = "id,number,name,bizcloud,type,version,deploystatus";
        return orm.query("bos_devportal_bizapp", selectFields, filters);
    }

    public static DynamicObjectCollection getOriginalBizAppsByName(String name) {
        ORM orm = ORM.create();
        QFilter q1 = new QFilter("type", "=", (Object)"0");
        QFilter q2 = null;
        if (name != null && !"".equals(name)) {
            q2 = new QFilter("name", "like", (Object)name);
        }
        QFilter[] filters = new QFilter[]{q1, q2};
        String selectFields = "id,number,name,bizcloud,type,version,deploystatus";
        return orm.query("bos_devportal_bizapp", selectFields, filters);
    }

    public static DynamicObjectCollection getExtendBizAppsByName(String name) {
        ORM orm = ORM.create();
        QFilter q1 = new QFilter("type", "=", (Object)"2");
        QFilter q2 = null;
        if (name != null && !"".equals(name)) {
            q2 = new QFilter("name", "like", (Object)name);
        }
        QFilter[] filters = new QFilter[]{q1, q2};
        String selectFields = "id,number,name,bizcloud,type,version,deploystatus";
        return orm.query("bos_devportal_bizapp", selectFields, filters);
    }

    public static DynamicObjectCollection getEntityMetasByAppId(String id) {
        ORM orm = ORM.create();
        QFilter q = new QFilter("bizappid", "=", (Object)id);
        QFilter[] filters = new QFilter[]{q};
        String selectFields = "id,number,name,type,createdate,type";
        return orm.query("bos_devpn_entitymeta", selectFields, filters);
    }

    public static DynamicObjectCollection getBaseOrBillEntityMetasByAppId(String id) {
        ORM orm = ORM.create();
        QFilter q = new QFilter("bizappid", "=", (Object)id);
        q.and(new QFilter("modeltype", "in", (Object)new String[]{"BaseFormModel", "BillFormModel"}));
        QFilter[] filters = new QFilter[]{q};
        String selectFields = "id,number,name,type,createdate,modeltype";
        return orm.query("bos_devpn_entitymeta", selectFields, filters);
    }

    public static DynamicObjectCollection getEntityMetas(QFilter[] filters) {
        ORM orm = ORM.create();
        String selectFields = "id,number,name,type,createdate,modeltype";
        return orm.query("bos_devpn_entitymeta", selectFields, filters);
    }

    public static DynamicObjectCollection getFormMetasByAppId(String id) {
        return QueryUtils.getFormMetas(new QFilter("bizappid", "=", (Object)id), null, -1);
    }

    public static DynamicObjectCollection getFormMetas(QFilter qfilter, String orderBys, int top) {
        ORM orm = ORM.create();
        QFilter[] filters = new QFilter[]{qfilter};
        String selectFields = "id,number,name,type,modifierid,modifydate,basedatafield,modeltype,parentid";
        return orm.query("bos_formmeta", selectFields, filters, orderBys, top);
    }

    public static DynamicObject getBizUnitRelation(String id) {
        ORM orm = ORM.create();
        QFilter q = new QFilter("form", "=", (Object)id);
        QFilter[] filters = new QFilter[]{q};
        return orm.queryOne("bos_devportal_unitrelform", "id,bizapp,bizunit,form", filters);
    }

    public static String getHomePageBizUnitId(String bizAppId) {
        JSONArray unitListData = DevportalUtil.getUnitListData((String)bizAppId);
        return unitListData.getJSONObject(0).getString("id");
    }
}

