/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.designer.dao.DesignerData;
import kd.bos.designer.dao.FormTemplateFactory;
import kd.bos.designer.dao.IFormTemplate;
import kd.bos.devportal.common.util.DesignerUtils;
import kd.bos.entity.datamodel.RaiseEventType;
import kd.bos.entity.function.FunctionGroup;
import kd.bos.entity.function.FunctionType;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.metadata.entity.rule.BizRule;
import kd.bos.metadata.extensible.ExtLockTypeEnum;
import kd.bos.metadata.extensible.ExtensibleDao;
import kd.bos.metadata.filter.FilterContainerAp;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.cardentry.CardEntryRowAp;
import kd.bos.metadata.form.cardentry.CardEntryViewAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.FlatFieldAp;
import kd.bos.metadata.form.rule.FormRuleActionType;
import kd.bos.metadata.form.rule.FormRuleActionTypeCache;
import kd.bos.metadata.list.CardListColumnAp;
import kd.bos.metadata.list.CardRowPanelAp;
import kd.bos.metadata.list.ListCardViewAp;
import kd.bos.metadata.list.ListColumnAp;
import kd.bos.metadata.list.ListColumnGroupAp;
import kd.bos.metadata.list.ListGridViewAp;
import kd.bos.metadata.report.ReportCommFilterPanelAp;
import kd.bos.metadata.report.ReportFilterAp;
import kd.bos.metadata.report.ReportMoreFilterPanelAp;
import kd.bos.metadata.treebuilder.BuildOption;
import kd.bos.metadata.treebuilder.ControlsTreeBuildOption;
import kd.bos.metadata.treebuilder.EntityFieldTreeBuildOption;
import kd.bos.metadata.treebuilder.FormFieldTreeBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.newdevportal.util.RuleNavTreeNode;

public class RuleDesignMetaHelper {
    public static final String KEY_SET_DESIGN_META = "setDesignMeta";
    private static final String RULES_DESIGN_META_ENTITY_META = "serviceType";
    private static final String KEY_GLOBAL_SERVICE_TYPE = "globalServiceType";
    private static final String RULES_DESIGN_META_FUNCTION_TYPES = "functionTypes";
    private static final String RULES_DESIGN_META_FUNCTION_OPERATIONS = "functionOperations";
    private static final String RULES_DESIGN_META_TREE_MAP = "treeMap";
    private static final String RULES_DESIGN_META_RULES_TREE = "rulesTree";
    private static final String RULES_DESIGN_META_ENTITY = "entity";
    private static final String RULES_DESIGN_META_PRECONDITION = "PreCondition";
    private static final String META_TYPE_FORM_META = "formmeta";
    private static final String META_TYPE_ENTITY_META = "entitymeta";
    private static final String META_RULES = "Rules";
    private static final String META_CLIENT_RULES = "ClientRules";
    private static final String ITEMS = "Items";
    private static final String ENTITY_META = "entitymeta";
    private static final String FORM_META = "formmeta";
    private static final String CARD_ENTRY_AP = "CardEntryAp";
    private static final String SUB_CARD_ENTRY_AP = "SubCardEntryAp";
    private static final String ENTRY_AP = "EntryAp";
    private static final String ENTRY_ENTITY = "EntryEntity";
    private static final String SUB_ENTRY_ENTITY = "SubEntryEntity";
    private static final String CARD_ENTRY_VIEW_AP = "CardEntryViewAp";
    private static final String CARD_ENTRY_ROW_AP = "CardEntryRowAp";
    private static final String LIST_GRID_VIEW_AP = "ListGridViewAp";
    private static final String CARD_ROW_PANEL_AP = "CardRowPanelAp";
    private static final String ID = "Id";
    private static final String ENTRY_ID = "EntryId";
    private static final String FIELD_TYPE = "FieldType";
    private static final String PARENT_ENTRY_ID = "ParentEntryId";
    private static final String TYPE = "_Type_";
    private static final String LIST_META = "ListMeta";
    private static final String PARENT_ID = "ParentId";
    private static SecureRandom random = new SecureRandom();
    private static final int SERVICE_TYPE_FORM = 1;
    private static final int SERVICE_TYPE_CARD = 2;
    private static final int SERVICE_TYPE_REPORT = 4;
    private static final int SERVICE_TYPE_LIST = 8;
    private static final int SERVICE_TYPE_ALL = -1;
    static final Map<String, String> operationCharacter = new LinkedHashMap<String, String>(21){
        private static final long serialVersionUID = -1374110809763668419L;
        {
            this.put("plus", "+");
            this.put("subtract", "-");
            this.put("multiple", "*");
            this.put("divide", "/");
            this.put("equal", "=");
            this.put("squarebrackets", "<>");
            this.put("less", "<");
            this.put("lessequal", "<=");
            this.put("greater", ">");
            this.put("greaterequal", ">=");
            this.put("leftparentheses", "(");
            this.put("rightparentheses", ")");
            this.put("and", "and");
            this.put("or", "or");
            this.put("not", "NOT");
            this.put("in", "IN");
            this.put("notin", "NOT IN");
            this.put("like", "LIKE");
            this.put("notlike", "NOT LIKE");
            this.put("clr", "CLR");
            this.put("backspace", "Backspace");
        }
    };

    public static Map<String, Object> getRuleDesignMeta(String metaType, int serviceType, Map<String, Object> metaDataContent, boolean isProFormDesign, String xmlFuncs) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("metaType", metaType);
        List<String> entityKeys = RuleDesignMetaHelper.getEntityKeys();
        Map entityMeta = (Map)metaDataContent.get("entitymeta");
        List entityContext = (List)entityMeta.get(ITEMS);
        Map formMeta = (Map)metaDataContent.get("formmeta");
        List formItems = (List)formMeta.get(ITEMS);
        if ("formmeta".equalsIgnoreCase(metaType)) {
            RuleDesignMetaHelper.checkFormRules(formItems);
        }
        List<Map<String, Object>> entityItems = entityContext.stream().filter(c -> entityKeys.contains((String)c.get(TYPE))).collect(Collectors.toList());
        if ("entitymeta".equalsIgnoreCase(metaType)) {
            RuleDesignMetaHelper.checkBusinessRules(entityItems);
        }
        String entityDevType = (String)entityMeta.get("DevType");
        String formDevType = (String)formMeta.get("DevType");
        if ("2".equals(entityDevType) || "2".equals(formDevType)) {
            ret.put("lockRules", RuleDesignMetaHelper.getRulesLockTypeMap(metaType, entityMeta, formMeta, entityContext));
        }
        RuleNavTreeNode rulesTree = RuleDesignMetaHelper.buildRulesTree(metaType, serviceType, entityItems, formItems, null);
        Set<Integer> serviceTypes = RuleDesignMetaHelper.getServiceTypes(rulesTree, null);
        serviceTypes.add(serviceType);
        if (serviceType == 8) {
            serviceTypes.add(2);
            ret.put(RULES_DESIGN_META_RULES_TREE, rulesTree.getChildren());
        } else {
            ret.put(RULES_DESIGN_META_RULES_TREE, (Object)rulesTree);
        }
        List formRuleActionTypes = FormRuleActionTypeCache.getFormRuleActionTypesWithoutExt();
        ArrayList<FormRuleActionType> currentFormTypes = new ArrayList<FormRuleActionType>(10);
        for (FormRuleActionType actionType : formRuleActionTypes) {
            if (!metaType.equalsIgnoreCase(actionType.getMetaType())) continue;
            boolean fit = false;
            for (Integer type : serviceTypes) {
                if ((type & actionType.getServiceTypes()) != type) continue;
                fit = true;
                break;
            }
            if (!fit) continue;
            actionType.setChecked(RuleDesignMetaHelper.parseRet(actionType, actionType.getRaiseEventType()));
            currentFormTypes.add(actionType);
        }
        ret.put(RULES_DESIGN_META_ENTITY_META, currentFormTypes);
        ret.put(KEY_GLOBAL_SERVICE_TYPE, serviceType);
        if (serviceType == 8) {
            for (TreeNode node : rulesTree.getChildren()) {
                RuleDesignMetaHelper.buildTreeMap(ret, currentFormTypes, metaType, serviceType, metaDataContent, entityItems, formItems, isProFormDesign, (RuleNavTreeNode)node);
            }
        } else {
            RuleDesignMetaHelper.buildTreeMap(ret, currentFormTypes, metaType, serviceType, metaDataContent, entityItems, formItems, isProFormDesign, rulesTree);
        }
        FunctionTypes functionTypes = null;
        functionTypes = StringUtils.isNotBlank((CharSequence)xmlFuncs) ? FunctionTypes.get((String)xmlFuncs) : FunctionTypes.get();
        functionTypes.getFunctionGroups().sort((o1, o2) -> o1.getSeq() - o2.getSeq());
        functionTypes.getFunctionTypes().sort((o1, o2) -> o1.getSeq() - o2.getSeq());
        functionTypes.getFunctionTypes().removeIf(t -> "SetFieldFmtAction".equalsIgnoreCase(t.getId()));
        ret.put(RULES_DESIGN_META_FUNCTION_TYPES, RuleDesignMetaHelper.parseToJsonObject(functionTypes));
        ret.put(RULES_DESIGN_META_FUNCTION_OPERATIONS, operationCharacter);
        return ret;
    }

    private static Map<String, Object> getRulesLockTypeMap(String metaType, Map<String, Object> entityMeta, Map<String, Object> formMeta, List<Map<String, Object>> entityContext) {
        String parentId;
        HashMap<String, Object> rulesLockType = new HashMap<String, Object>(16);
        String modelType = (String)entityMeta.get("ModelType");
        String masterId = (String)entityMeta.get("MasterId");
        List isvList = DesignerUtils.ISV_LIST;
        if ("entitymeta".equals(metaType)) {
            parentId = (String)entityMeta.get(PARENT_ID);
            EntityMetadata extEntityMetadata = (EntityMetadata)MetadataDao.readMeta((String)((String)entityMeta.get(ID)), (MetaCategory)MetaCategory.Entity);
            EntityMetadata oriEntityMetadata = (EntityMetadata)ExtensibleDao.getBaseMetadata((String)parentId, (MetaCategory)MetaCategory.Entity);
            List items = oriEntityMetadata.getItems();
            ArrayList rules = new ArrayList(10);
            for (Object entityItem : items) {
                if (!(entityItem instanceof EntryEntity)) continue;
                rules.addAll(((EntryEntity)entityItem).getRules());
            }
            List rootEntityRules = oriEntityMetadata.getRootEntity().getRules();
            rules.addAll(rootEntityRules);
            for (BizRule rule : rules) {
                String ruleId = rule.getId();
                ExtLockTypeEnum lockType = ExtensibleDao.getExtLockType((AbstractMetadata)extEntityMetadata, (String)"BizRule", (String)modelType, (String)parentId, (String)ruleId);
                if (!isvList.contains(rule.getIsv()) || StringUtils.equals((CharSequence)extEntityMetadata.getIsv(), (CharSequence)rule.getIsv())) continue;
                rulesLockType.put(ruleId, lockType.toString());
            }
        }
        if ("formmeta".equals(metaType)) {
            parentId = (String)formMeta.get(PARENT_ID);
            FormMetadata extFormMetadata = (FormMetadata)MetadataDao.readMeta((String)((String)formMeta.get(ID)), (MetaCategory)MetaCategory.Form);
            FormMetadata oriFormMetadata = (FormMetadata)ExtensibleDao.getBaseMetadata((String)parentId, (MetaCategory)MetaCategory.Form);
            ArrayList rules = new ArrayList(10);
            List items = oriFormMetadata.getItems();
            for (ControlAp formItem : items) {
                if (formItem instanceof EntryAp) {
                    rules.addAll(((EntryAp)formItem).getRules());
                    continue;
                }
                if (formItem instanceof ListGridViewAp) {
                    rules.addAll(((ListGridViewAp)formItem).getClientRules());
                    continue;
                }
                if (formItem instanceof CardEntryRowAp) {
                    rules.addAll(((CardEntryRowAp)formItem).getClientRules());
                    continue;
                }
                if (!(formItem instanceof CardRowPanelAp)) continue;
                rules.addAll(((CardRowPanelAp)formItem).getClientRules());
            }
            List rootFormRules = oriFormMetadata.getRootAp().getRules();
            rules.addAll(rootFormRules);
            String elementId = "";
            elementId = StringUtils.isNotBlank((Object)formMeta.get(ID)) && formMeta.get(ID).equals(extFormMetadata.getEntityId()) ? extFormMetadata.getRootAp().getPkId() : extFormMetadata.getParentId();
            for (BizRule rule : rules) {
                String ruleId = rule.getId();
                ExtLockTypeEnum lockType = ExtensibleDao.getExtLockType((AbstractMetadata)extFormMetadata, (String)"FormRule", (String)modelType, (String)elementId, (String)ruleId);
                if (!isvList.contains(rule.getIsv()) || StringUtils.equals((CharSequence)extFormMetadata.getIsv(), (CharSequence)rule.getIsv())) continue;
                rulesLockType.put(ruleId, lockType.toString());
            }
        }
        return rulesLockType;
    }

    public static FunctionType getFunctionType(String functionId, String xmlFuncs) {
        FunctionTypes functionTypes = null;
        functionTypes = StringUtils.isNotBlank((CharSequence)xmlFuncs) ? FunctionTypes.get((String)xmlFuncs) : FunctionTypes.get();
        Optional<FunctionType> first = functionTypes.getFunctionTypes().stream().filter(f -> f.getId().equalsIgnoreCase(functionId)).findFirst();
        if (first.isPresent()) {
            return first.get();
        }
        return null;
    }

    private static void buildTreeMap(Map<String, Object> ret, List<FormRuleActionType> currentFormTypes, String metaType, int serviceType, Map<String, Object> metaDataContent, List<Map<String, Object>> entityItems, List<Map<String, Object>> formItems, boolean isProFormDesign, RuleNavTreeNode rulesTree) {
        HashMap<String, Object> entityMap = new HashMap<String, Object>(10);
        HashMap<String, BuildOption> treeId2optionMap = new HashMap<String, BuildOption>(10);
        if (rulesTree != null) {
            String headEntityId;
            if ("entitymeta".equalsIgnoreCase(metaType)) {
                headEntityId = (String)rulesTree.getData();
                boolean isMainEntity = true;
                HashMap<String, Object> entityItemMap = new HashMap<String, Object>(10);
                entityItemMap.put(RULES_DESIGN_META_PRECONDITION, RuleDesignMetaHelper.buildPreConditionTree(metaType, ret, metaDataContent, headEntityId, null, null, isProFormDesign, treeId2optionMap));
                for (FormRuleActionType actionType : currentFormTypes) {
                    Object actionTree = RuleDesignMetaHelper.buildActionTypeTree(metaType, ret, headEntityId, null, isMainEntity, serviceType, serviceType, actionType, metaDataContent, isProFormDesign, treeId2optionMap);
                    if (actionTree == null) continue;
                    entityItemMap.put(actionType.getId(), actionTree);
                }
                entityMap.put(headEntityId, entityItemMap);
                if (rulesTree.getChildren() != null) {
                    for (TreeNode child : rulesTree.getChildren()) {
                        RuleDesignMetaHelper.buildTreeMap_Entity_Child(child, null, metaType, serviceType, entityItems, formItems, ret, entityMap, treeId2optionMap, currentFormTypes, metaDataContent, isProFormDesign);
                    }
                }
            } else {
                headEntityId = (String)rulesTree.getData();
                boolean isMainEntity = true;
                HashMap<String, Object> entityItemMap = new HashMap<String, Object>(10);
                entityItemMap.put(RULES_DESIGN_META_PRECONDITION, RuleDesignMetaHelper.buildPreConditionTree(metaType, ret, metaDataContent, headEntityId, null, null, isProFormDesign, treeId2optionMap));
                String controllId = null;
                if (serviceType == 8) {
                    controllId = headEntityId;
                }
                for (FormRuleActionType actionType : currentFormTypes) {
                    Object actionTree = RuleDesignMetaHelper.buildActionTypeTree(metaType, ret, headEntityId, controllId, isMainEntity, serviceType, serviceType, actionType, metaDataContent, isProFormDesign, treeId2optionMap);
                    if (actionTree == null) continue;
                    entityItemMap.put(actionType.getId(), actionTree);
                }
                entityMap.put(headEntityId, entityItemMap);
                if (rulesTree.getChildren() != null) {
                    for (TreeNode child : rulesTree.getChildren()) {
                        RuleDesignMetaHelper.buildTreeMap_Form_Child((RuleNavTreeNode)child, null, metaType, serviceType, entityItems, formItems, ret, entityMap, treeId2optionMap, currentFormTypes, metaDataContent, isProFormDesign);
                    }
                }
            }
        }
        if (ret.containsKey(RULES_DESIGN_META_ENTITY)) {
            Map oldEntityMap = (Map)ret.get(RULES_DESIGN_META_ENTITY);
            oldEntityMap.putAll(entityMap);
        } else {
            ret.put(RULES_DESIGN_META_ENTITY, entityMap);
        }
    }

    private static void buildTreeMap_Entity_Child(TreeNode child, TreeNode parent, String metaType, int serviceType, List<Map<String, Object>> entityItems, List<Map<String, Object>> formItems, Map<String, Object> ret, Map<String, Object> entityMap, Map<String, BuildOption> treeId2optionMap, List<FormRuleActionType> currentFormTypes, Map<String, Object> metaDataContent, boolean isProFormDesign) {
        String entityId = (String)child.getData();
        boolean isMainEntity = false;
        HashMap<String, Object> entityItemMap = new HashMap<String, Object>(10);
        entityItemMap.put(RULES_DESIGN_META_PRECONDITION, RuleDesignMetaHelper.buildPreConditionTree(metaType, ret, metaDataContent, entityId, null, null, isProFormDesign, treeId2optionMap));
        for (FormRuleActionType actionType : currentFormTypes) {
            Object actionTree = RuleDesignMetaHelper.buildActionTypeTree(metaType, ret, entityId, null, isMainEntity, serviceType, serviceType, actionType, metaDataContent, isProFormDesign, treeId2optionMap);
            if (actionTree == null) continue;
            entityItemMap.put(actionType.getId(), actionTree);
        }
        entityMap.put(entityId, entityItemMap);
        if (child.getChildren() != null) {
            for (TreeNode childChild : child.getChildren()) {
                RuleDesignMetaHelper.buildTreeMap_Entity_Child(childChild, child, metaType, serviceType, entityItems, formItems, ret, entityMap, treeId2optionMap, currentFormTypes, metaDataContent, isProFormDesign);
            }
        }
    }

    private static void buildTreeMap_Form_Child(RuleNavTreeNode child, TreeNode parent, String metaType, int serviceType, List<Map<String, Object>> entityItems, List<Map<String, Object>> formItems, Map<String, Object> ret, Map<String, Object> entityMap, Map<String, BuildOption> treeId2optionMap, List<FormRuleActionType> currentFormTypes, Map<String, Object> metaDataContent, boolean isProFormDesign) {
        String type = child.getType();
        String id = (String)child.getData();
        int realServiceType = child.getServiceType();
        if (ENTRY_AP.equalsIgnoreCase(type)) {
            String entityId = child.getLongNumber();
            boolean isMainEntity = false;
            HashMap<String, Object> entityItemMap = new HashMap<String, Object>(10);
            entityItemMap.put(RULES_DESIGN_META_PRECONDITION, RuleDesignMetaHelper.buildPreConditionTree(metaType, ret, metaDataContent, entityId, null, ENTRY_AP, isProFormDesign, treeId2optionMap));
            for (FormRuleActionType actionType : currentFormTypes) {
                Object actionTree = RuleDesignMetaHelper.buildActionTypeTree(metaType, ret, entityId, id, isMainEntity, serviceType, realServiceType, actionType, metaDataContent, isProFormDesign, treeId2optionMap);
                if (actionTree == null) continue;
                entityItemMap.put(actionType.getId(), actionTree);
            }
            entityMap.put(id, entityItemMap);
            if (child.getChildren() != null) {
                for (TreeNode childChild : child.getChildren()) {
                    RuleDesignMetaHelper.buildTreeMap_Form_Child((RuleNavTreeNode)childChild, child, metaType, realServiceType, entityItems, formItems, ret, entityMap, treeId2optionMap, currentFormTypes, metaDataContent, isProFormDesign);
                }
            }
        } else if (SUB_ENTRY_ENTITY.equalsIgnoreCase(type)) {
            String entityId = child.getLongNumber();
            boolean isMainEntity = false;
            HashMap<String, Object> entityItemMap = new HashMap<String, Object>(10);
            entityItemMap.put(RULES_DESIGN_META_PRECONDITION, RuleDesignMetaHelper.buildPreConditionTree(metaType, ret, metaDataContent, entityId, null, SUB_ENTRY_ENTITY, isProFormDesign, treeId2optionMap));
            for (FormRuleActionType actionType : currentFormTypes) {
                Object actionTree = RuleDesignMetaHelper.buildActionTypeTree(metaType, ret, entityId, id, isMainEntity, serviceType, realServiceType, actionType, metaDataContent, isProFormDesign, treeId2optionMap);
                if (actionTree == null) continue;
                entityItemMap.put(actionType.getId(), actionTree);
            }
            entityMap.put(id, entityItemMap);
            if (child.getChildren() != null) {
                for (TreeNode childChild : child.getChildren()) {
                    RuleDesignMetaHelper.buildTreeMap_Form_Child((RuleNavTreeNode)childChild, child, metaType, realServiceType, entityItems, formItems, ret, entityMap, treeId2optionMap, currentFormTypes, metaDataContent, isProFormDesign);
                }
            }
        } else if (CARD_ENTRY_AP.equalsIgnoreCase(type)) {
            String controlId = id;
            String entryId = child.getLongNumber();
            boolean isMainEntity = false;
            HashMap<String, Object> entityItemMap = new HashMap<String, Object>(10);
            entityItemMap.put(RULES_DESIGN_META_PRECONDITION, RuleDesignMetaHelper.buildPreConditionTree(metaType, ret, metaDataContent, entryId, null, CARD_ENTRY_AP, isProFormDesign, treeId2optionMap));
            for (FormRuleActionType actionType : currentFormTypes) {
                Object actionTree = RuleDesignMetaHelper.buildActionTypeTree(metaType, ret, entryId, controlId, isMainEntity, serviceType, realServiceType, actionType, metaDataContent, isProFormDesign, treeId2optionMap);
                if (actionTree == null) continue;
                entityItemMap.put(actionType.getId(), actionTree);
            }
            entityMap.put(controlId, entityItemMap);
            if (child.getChildren() != null) {
                for (TreeNode childChild : child.getChildren()) {
                    RuleDesignMetaHelper.buildTreeMap_Form_Child((RuleNavTreeNode)childChild, child, metaType, realServiceType, entityItems, formItems, ret, entityMap, treeId2optionMap, currentFormTypes, metaDataContent, isProFormDesign);
                }
            }
        } else if (SUB_CARD_ENTRY_AP.equalsIgnoreCase(type)) {
            String controlId = id;
            String entryId = child.getLongNumber();
            boolean isMainEntity = false;
            HashMap<String, Object> entityItemMap = new HashMap<String, Object>(10);
            entityItemMap.put(RULES_DESIGN_META_PRECONDITION, RuleDesignMetaHelper.buildPreConditionTree(metaType, ret, metaDataContent, entryId, null, SUB_CARD_ENTRY_AP, isProFormDesign, treeId2optionMap));
            for (FormRuleActionType actionType : currentFormTypes) {
                Object actionTree = RuleDesignMetaHelper.buildActionTypeTree(metaType, ret, entryId, controlId, isMainEntity, serviceType, realServiceType, actionType, metaDataContent, isProFormDesign, treeId2optionMap);
                if (actionTree == null) continue;
                entityItemMap.put(actionType.getId(), actionTree);
            }
            entityMap.put(controlId, entityItemMap);
            if (child.getChildren() != null) {
                for (TreeNode childChild : child.getChildren()) {
                    RuleDesignMetaHelper.buildTreeMap_Form_Child((RuleNavTreeNode)childChild, child, metaType, realServiceType, entityItems, formItems, ret, entityMap, treeId2optionMap, currentFormTypes, metaDataContent, isProFormDesign);
                }
            }
        } else if (CARD_ENTRY_ROW_AP.equalsIgnoreCase(type)) {
            String controlId = id;
            String entryId = child.getLongNumber();
            boolean isMainEntity = false;
            HashMap<String, Object> entityItemMap = new HashMap<String, Object>(10);
            entityItemMap.put(RULES_DESIGN_META_PRECONDITION, RuleDesignMetaHelper.buildPreConditionTree(metaType, ret, metaDataContent, entryId, null, CARD_ENTRY_ROW_AP, isProFormDesign, treeId2optionMap));
            for (FormRuleActionType actionType : currentFormTypes) {
                Object actionTree = RuleDesignMetaHelper.buildActionTypeTree(metaType, ret, entryId, controlId, isMainEntity, serviceType, realServiceType, actionType, metaDataContent, isProFormDesign, treeId2optionMap);
                if (actionTree == null) continue;
                entityItemMap.put(actionType.getId(), actionTree);
            }
            entityMap.put(controlId, entityItemMap);
        } else if (LIST_GRID_VIEW_AP.equalsIgnoreCase(type)) {
            String controlId = id;
            boolean isMainEntity = false;
            HashMap<String, Object> entityItemMap = new HashMap<String, Object>(10);
            entityItemMap.put(RULES_DESIGN_META_PRECONDITION, RuleDesignMetaHelper.buildPreConditionTree(metaType, ret, metaDataContent, null, controlId, LIST_GRID_VIEW_AP, isProFormDesign, treeId2optionMap));
            for (FormRuleActionType actionType : currentFormTypes) {
                Object actionTree;
                if (actionType.getServiceTypes() == 2 || (actionTree = RuleDesignMetaHelper.buildActionTypeTree(metaType, ret, null, controlId, isMainEntity, serviceType, realServiceType, actionType, metaDataContent, isProFormDesign, treeId2optionMap)) == null) continue;
                entityItemMap.put(actionType.getId(), actionTree);
            }
            entityMap.put(controlId, entityItemMap);
        } else if (CARD_ROW_PANEL_AP.equalsIgnoreCase(type)) {
            String controlId = id;
            boolean isMainEntity = false;
            HashMap<String, Object> entityItemMap = new HashMap<String, Object>(10);
            entityItemMap.put(RULES_DESIGN_META_PRECONDITION, RuleDesignMetaHelper.buildPreConditionTree(metaType, ret, metaDataContent, null, controlId, CARD_ROW_PANEL_AP, isProFormDesign, treeId2optionMap));
            for (FormRuleActionType actionType : currentFormTypes) {
                Object actionTree;
                if (actionType.getServiceTypes() == 8 || (actionTree = RuleDesignMetaHelper.buildActionTypeTree(metaType, ret, null, controlId, isMainEntity, serviceType, realServiceType, actionType, metaDataContent, isProFormDesign, treeId2optionMap)) == null) continue;
                entityItemMap.put(actionType.getId(), actionTree);
            }
            entityMap.put(controlId, entityItemMap);
        }
    }

    private static RuleNavTreeNode buildRulesTree(String metaType, int serviceType, List<Map<String, Object>> entityItems, List<Map<String, Object>> formItems, TreeNode parentNode) {
        if ("entitymeta".equalsIgnoreCase(metaType)) {
            List<Map<String, Object>> childItems = entityItems;
            if (parentNode != null) {
                String parentId = (String)parentNode.getData();
                boolean isMain = StringUtils.isBlank((CharSequence)parentNode.getParentid());
                childItems = entityItems.stream().filter(i -> parentId.equalsIgnoreCase((String)i.get(PARENT_ID))).collect(Collectors.toList());
                if (childItems.size() == 0 && isMain) {
                    childItems = entityItems.stream().filter(i -> ENTRY_ENTITY.equalsIgnoreCase((String)i.get(TYPE)) || "TreeEntryEntity".equalsIgnoreCase((String)i.get(TYPE))).collect(Collectors.toList());
                }
                for (Map<String, Object> entityItem : childItems) {
                    String entityId = (String)entityItem.get(ID);
                    if (entityId.equalsIgnoreCase(parentId)) continue;
                    RuleNavTreeNode theNode = new RuleNavTreeNode();
                    theNode.setData(entityId);
                    theNode.setParentid("");
                    theNode.setId((String)entityItem.get("Key"));
                    theNode.setText((String)entityItem.get("Name"));
                    theNode.setServiceType(serviceType);
                    ArrayList rules = (ArrayList)entityItem.get(META_RULES);
                    int ruleCount = rules == null ? 0 : rules.size();
                    theNode.setLongText(theNode.getText() + "(" + ruleCount + ")");
                    theNode.setParentid(parentId);
                    parentNode.addChild((TreeNode)theNode);
                    RuleDesignMetaHelper.buildRulesTree(metaType, serviceType, entityItems, formItems, theNode);
                }
                return null;
            }
            if (childItems == null || childItems.size() == 0) {
                if (formItems.size() > 0) {
                    Map<String, Object> formAp = formItems.get(0);
                    RuleNavTreeNode rootNode = new RuleNavTreeNode();
                    rootNode.setId((String)formAp.get("Key"));
                    rootNode.setData(formAp.get(ID));
                    rootNode.setText((String)formAp.get("Name"));
                    rootNode.setServiceType(serviceType);
                    return rootNode;
                }
                return null;
            }
            Map<String, Object> headEntry = childItems.get(0);
            RuleNavTreeNode rootNode = new RuleNavTreeNode();
            rootNode.setId((String)headEntry.get("Key"));
            rootNode.setData(headEntry.get(ID));
            rootNode.setText((String)headEntry.get("Name"));
            rootNode.setServiceType(serviceType);
            ArrayList rules = (ArrayList)headEntry.get(META_RULES);
            int ruleCount = rules == null ? 0 : rules.size();
            rootNode.setLongText(rootNode.getText() + "(" + ruleCount + ")");
            RuleDesignMetaHelper.buildRulesTree(metaType, serviceType, entityItems, formItems, rootNode);
            return rootNode;
        }
        if (serviceType == 8) {
            Map<String, Object> listCardViewAp;
            Map<String, Object> formAp = formItems.get(0);
            String formApId = (String)formAp.get(ID);
            RuleNavTreeNode rootNode = new RuleNavTreeNode();
            rootNode.setId((String)formAp.get("Key"));
            rootNode.setData(formApId);
            rootNode.setText((String)formAp.get("Name"));
            rootNode.setServiceType(serviceType);
            rootNode.setType(LIST_META);
            int rootRuleCount = 0;
            Map<String, Object> listGridViewAp = RuleDesignMetaHelper.getListGridViewAp(formItems);
            if (listGridViewAp != null) {
                String listGridViewApId = (String)listGridViewAp.get(ID);
                RuleNavTreeNode listGridNode = new RuleNavTreeNode();
                listGridNode.setData(listGridViewApId);
                listGridNode.setId((String)listGridViewAp.get("Key"));
                listGridNode.setText((String)listGridViewAp.get("Name"));
                listGridNode.setType(LIST_GRID_VIEW_AP);
                listGridNode.setServiceType(serviceType);
                rootNode.addChild(listGridNode);
            }
            if ((listCardViewAp = RuleDesignMetaHelper.getListCardViewAp(formItems)) != null) {
                String listCardViewApId = (String)listCardViewAp.get(ID);
                RuleNavTreeNode listCardNode = new RuleNavTreeNode();
                listCardNode.setData(listCardViewApId);
                listCardNode.setId((String)listCardViewAp.get("Key"));
                listCardNode.setText((String)listCardViewAp.get("Name"));
                listCardNode.setType(CARD_ROW_PANEL_AP);
                listCardNode.setServiceType(2);
                rootNode.addChild(listCardNode);
            }
            rootNode.setLongText(rootNode.getText() + "(" + rootRuleCount + ")");
            if (!rootNode.getChildren().isEmpty()) {
                return rootNode;
            }
            return null;
        }
        List<Map<String, Object>> childItems = formItems;
        if (parentNode != null) {
            String parentId = (String)parentNode.getData();
            String parentEntryId = parentNode.getLongNumber();
            String parentNodeType = parentNode.getType();
            if ("FormAp".equalsIgnoreCase(parentNodeType)) {
                ArrayList rules;
                RuleNavTreeNode theNode;
                childItems = formItems.stream().filter(i -> ENTRY_AP.equalsIgnoreCase((String)i.get(TYPE)) && ("TreeEntryEntity".equalsIgnoreCase(RuleDesignMetaHelper.getEntryFieldType(i, entityItems)) || ENTRY_ENTITY.equalsIgnoreCase(RuleDesignMetaHelper.getEntryFieldType(i, entityItems)))).collect(Collectors.toList());
                for (Map<String, Object> entityItem : childItems) {
                    String id = (String)entityItem.get(ID);
                    if (id.equalsIgnoreCase(parentId)) continue;
                    RuleNavTreeNode theNode2 = new RuleNavTreeNode();
                    theNode2.setData(id);
                    theNode2.setLongNumber((String)entityItem.get(ENTRY_ID));
                    theNode2.setParentid("");
                    theNode2.setId((String)entityItem.get("Key"));
                    theNode2.setText((String)entityItem.get("Name"));
                    theNode2.setType(ENTRY_AP);
                    theNode2.setServiceType(serviceType);
                    ArrayList rules2 = (ArrayList)entityItem.get(META_RULES);
                    int ruleCount = rules2 == null ? 0 : rules2.size();
                    theNode2.setLongText(theNode2.getText() + "(" + ruleCount + ")");
                    theNode2.setParentid(parentId);
                    parentNode.addChild((TreeNode)theNode2);
                    RuleDesignMetaHelper.buildRulesTree(metaType, serviceType, entityItems, formItems, theNode2);
                }
                childItems = formItems.stream().filter(i -> CARD_ENTRY_AP.equalsIgnoreCase((String)i.get(TYPE))).collect(Collectors.toList());
                for (Map<String, Object> entityItem : childItems) {
                    theNode = new RuleNavTreeNode();
                    theNode.setData((String)entityItem.get(ID));
                    theNode.setParentid("");
                    theNode.setId((String)entityItem.get("Key"));
                    theNode.setText((String)entityItem.get("Name"));
                    theNode.setLongNumber((String)entityItem.get(ENTRY_ID));
                    theNode.setType((String)entityItem.get(TYPE));
                    theNode.setServiceType(serviceType);
                    rules = (ArrayList)entityItem.get(META_RULES);
                    int ruleCount = rules == null ? 0 : rules.size();
                    theNode.setLongText(theNode.getText() + "(" + ruleCount + ")");
                    theNode.setParentid(parentId);
                    parentNode.addChild((TreeNode)theNode);
                    RuleDesignMetaHelper.buildRulesTree(metaType, serviceType, entityItems, formItems, theNode);
                }
                childItems = formItems.stream().filter(i -> SUB_CARD_ENTRY_AP.equalsIgnoreCase((String)i.get(TYPE))).collect(Collectors.toList());
                for (Map<String, Object> entityItem : childItems) {
                    theNode = new RuleNavTreeNode();
                    theNode.setData((String)entityItem.get(ID));
                    theNode.setParentid("");
                    theNode.setId((String)entityItem.get("Key"));
                    theNode.setText((String)entityItem.get("Name"));
                    theNode.setLongNumber((String)entityItem.get(ENTRY_ID));
                    theNode.setType((String)entityItem.get(TYPE));
                    theNode.setServiceType(serviceType);
                    rules = (ArrayList)entityItem.get(META_RULES);
                    int ruleCount = rules == null ? 0 : rules.size();
                    theNode.setLongText(theNode.getText() + "(" + ruleCount + ")");
                    theNode.setParentid(parentId);
                    parentNode.addChild((TreeNode)theNode);
                    RuleDesignMetaHelper.buildRulesTree(metaType, serviceType, entityItems, formItems, theNode);
                }
                childItems = formItems.stream().filter(i -> LIST_GRID_VIEW_AP.equalsIgnoreCase((String)i.get(TYPE))).collect(Collectors.toList());
                for (Map<String, Object> entityItem : childItems) {
                    theNode = new RuleNavTreeNode();
                    theNode.setData(entityItem.get(ID));
                    theNode.setParentid("");
                    theNode.setId((String)entityItem.get("Key"));
                    theNode.setText((String)entityItem.get("Name"));
                    theNode.setType(LIST_GRID_VIEW_AP);
                    theNode.setServiceType(8);
                    rules = (ArrayList)entityItem.get(META_CLIENT_RULES);
                    int ruleCount = rules == null ? 0 : rules.size();
                    theNode.setLongText(theNode.getText() + "(" + ruleCount + ")");
                    theNode.setParentid(parentId);
                    parentNode.addChild((TreeNode)theNode);
                }
            } else if (ENTRY_AP.equalsIgnoreCase(parentNodeType)) {
                childItems = formItems.stream().filter(i -> ENTRY_AP.equalsIgnoreCase((String)i.get(TYPE)) && SUB_ENTRY_ENTITY.equalsIgnoreCase(RuleDesignMetaHelper.getEntryFieldType(i, entityItems))).collect(Collectors.toList());
                for (Map<String, Object> entityItem : childItems) {
                    String id = (String)entityItem.get(ID);
                    String entityId = (String)entityItem.get(ENTRY_ID);
                    if (!StringUtils.equalsIgnoreCase((CharSequence)parentEntryId, (CharSequence)RuleDesignMetaHelper.getParentEntityId(entityId, entityItems))) continue;
                    RuleNavTreeNode theNode = new RuleNavTreeNode();
                    theNode.setData(id);
                    theNode.setParentid("");
                    theNode.setId((String)entityItem.get("Key"));
                    theNode.setText((String)entityItem.get("Name"));
                    theNode.setLongNumber(entityId);
                    theNode.setType(SUB_ENTRY_ENTITY);
                    theNode.setServiceType(serviceType);
                    ArrayList rules = (ArrayList)entityItem.get(META_RULES);
                    int ruleCount = rules == null ? 0 : rules.size();
                    theNode.setLongText(theNode.getText() + "(" + ruleCount + ")");
                    theNode.setParentid(parentId);
                    parentNode.addChild((TreeNode)theNode);
                }
            } else if (CARD_ENTRY_AP.equalsIgnoreCase(parentNodeType)) {
                childItems = formItems.stream().filter(i -> CARD_ENTRY_ROW_AP.equalsIgnoreCase((String)i.get(TYPE)) && parentId.equalsIgnoreCase(RuleDesignMetaHelper.getCardEntryApId(i, formItems))).collect(Collectors.toList());
                for (Map<String, Object> entityItem : childItems) {
                    String entityId = (String)entityItem.get(ID);
                    RuleNavTreeNode theNode = new RuleNavTreeNode();
                    theNode.setData(entityId);
                    theNode.setParentid("");
                    theNode.setId((String)entityItem.get("Key"));
                    theNode.setText((String)entityItem.get("Name"));
                    theNode.setLongNumber(RuleDesignMetaHelper.getCardEntryApEntityId(entityItem, formItems));
                    theNode.setType(CARD_ENTRY_ROW_AP);
                    theNode.setServiceType(2);
                    ArrayList rules = (ArrayList)entityItem.get(META_CLIENT_RULES);
                    int ruleCount = rules == null ? 0 : rules.size();
                    theNode.setLongText(theNode.getText() + "(" + ruleCount + ")");
                    theNode.setParentid(parentId);
                    parentNode.addChild((TreeNode)theNode);
                    RuleDesignMetaHelper.buildRulesTree(metaType, serviceType, entityItems, formItems, theNode);
                }
                childItems = formItems.stream().filter(i -> ENTRY_AP.equalsIgnoreCase((String)i.get(TYPE)) && ENTRY_ENTITY.equalsIgnoreCase(RuleDesignMetaHelper.getEntryFieldType(i, entityItems))).collect(Collectors.toList());
                for (Map<String, Object> entityItem : childItems) {
                    String id = (String)entityItem.get(ID);
                    String entityId = (String)entityItem.get(ENTRY_ID);
                    if (!StringUtils.equalsIgnoreCase((CharSequence)parentEntryId, (CharSequence)entityId)) continue;
                    RuleNavTreeNode theNode = new RuleNavTreeNode();
                    theNode.setData(id);
                    theNode.setParentid("");
                    theNode.setId((String)entityItem.get("Key"));
                    theNode.setText((String)entityItem.get("Name"));
                    theNode.setLongNumber(entityId);
                    theNode.setType(ENTRY_ENTITY);
                    theNode.setServiceType(serviceType);
                    ArrayList rules = (ArrayList)entityItem.get(META_RULES);
                    int ruleCount = rules == null ? 0 : rules.size();
                    theNode.setLongText(theNode.getText() + "(" + ruleCount + ")");
                    theNode.setParentid(parentId);
                }
            } else if (SUB_CARD_ENTRY_AP.equalsIgnoreCase(parentNodeType)) {
                childItems = formItems.stream().filter(i -> CARD_ENTRY_ROW_AP.equalsIgnoreCase((String)i.get(TYPE)) && parentId.equalsIgnoreCase(RuleDesignMetaHelper.getCardEntryApId(i, formItems))).collect(Collectors.toList());
                for (Map<String, Object> entityItem : childItems) {
                    String entityId = (String)entityItem.get(ID);
                    RuleNavTreeNode theNode = new RuleNavTreeNode();
                    theNode.setData(entityId);
                    theNode.setParentid("");
                    theNode.setId((String)entityItem.get("Key"));
                    theNode.setText((String)entityItem.get("Name"));
                    theNode.setLongNumber(RuleDesignMetaHelper.getCardEntryApEntityId(entityItem, formItems));
                    theNode.setType(CARD_ENTRY_ROW_AP);
                    theNode.setServiceType(2);
                    ArrayList rules = (ArrayList)entityItem.get(META_CLIENT_RULES);
                    int ruleCount = rules == null ? 0 : rules.size();
                    theNode.setLongText(theNode.getText() + "(" + ruleCount + ")");
                    theNode.setParentid(parentId);
                    parentNode.addChild((TreeNode)theNode);
                    RuleDesignMetaHelper.buildRulesTree(metaType, serviceType, entityItems, formItems, theNode);
                }
                childItems = formItems.stream().filter(i -> ENTRY_AP.equalsIgnoreCase((String)i.get(TYPE)) && SUB_ENTRY_ENTITY.equalsIgnoreCase(RuleDesignMetaHelper.getEntryFieldType(i, entityItems))).collect(Collectors.toList());
                for (Map<String, Object> entityItem : childItems) {
                    String id = (String)entityItem.get(ID);
                    String entityId = (String)entityItem.get(ENTRY_ID);
                    if (!StringUtils.equalsIgnoreCase((CharSequence)parentEntryId, (CharSequence)entityId)) continue;
                    RuleNavTreeNode theNode = new RuleNavTreeNode();
                    theNode.setData(id);
                    theNode.setParentid("");
                    theNode.setId((String)entityItem.get("Key"));
                    theNode.setText((String)entityItem.get("Name"));
                    theNode.setLongNumber(entityId);
                    theNode.setType(SUB_ENTRY_ENTITY);
                    theNode.setServiceType(serviceType);
                    ArrayList rules = (ArrayList)entityItem.get(META_RULES);
                    int ruleCount = rules == null ? 0 : rules.size();
                    theNode.setLongText(theNode.getText() + "(" + ruleCount + ")");
                    theNode.setParentid(parentId);
                }
            }
            return null;
        }
        if (childItems == null || childItems.size() == 0) {
            return null;
        }
        Map<String, Object> headEntry = childItems.get(0);
        RuleNavTreeNode rootNode = new RuleNavTreeNode();
        rootNode.setId((String)headEntry.get("Key"));
        rootNode.setData(headEntry.get(ID));
        rootNode.setText((String)headEntry.get("Name"));
        rootNode.setType("FormAp");
        rootNode.setServiceType(serviceType);
        ArrayList rules = (ArrayList)headEntry.get(META_RULES);
        int ruleCount = rules == null ? 0 : rules.size();
        rootNode.setLongText(rootNode.getText() + "(" + ruleCount + ")");
        RuleDesignMetaHelper.buildRulesTree(metaType, serviceType, entityItems, formItems, rootNode);
        return rootNode;
    }

    private static String getCardEntryApId(Map cardEntryRowApMap, List<Map<String, Object>> formItems) {
        Map<String, Object> map = RuleDesignMetaHelper.getCardEntryApMap(cardEntryRowApMap, formItems);
        if (map != null) {
            return (String)map.get(ID);
        }
        return null;
    }

    private static String getCardEntryApEntityId(Map cardEntryRowApMap, List<Map<String, Object>> formItems) {
        Map<String, Object> map = RuleDesignMetaHelper.getCardEntryApMap(cardEntryRowApMap, formItems);
        if (map != null) {
            return (String)map.get(ENTRY_ID);
        }
        return null;
    }

    private static Map<String, Object> getCardEntryApMap(Map cardEntryRowApMap, List<Map<String, Object>> formItems) {
        if (cardEntryRowApMap == null) {
            return null;
        }
        String type = (String)cardEntryRowApMap.get(TYPE);
        if (CARD_ENTRY_AP.equalsIgnoreCase(type) || SUB_CARD_ENTRY_AP.equalsIgnoreCase(type)) {
            return cardEntryRowApMap;
        }
        String parentId = (String)cardEntryRowApMap.get(PARENT_ID);
        if (StringUtils.isBlank((CharSequence)parentId)) {
            return null;
        }
        Optional<Map> first = formItems.stream().filter(i -> parentId.equalsIgnoreCase((String)i.get(ID))).findFirst();
        if (first.isPresent()) {
            Map parentObjectMap = first.get();
            return RuleDesignMetaHelper.getCardEntryApMap(parentObjectMap, formItems);
        }
        return null;
    }

    private static String buildPreConditionTree(String metaType, Map<String, Object> ret, Map<String, Object> metaDataContent, String entityId, String controlId, String apType, boolean isProFormDesign, Map<String, BuildOption> treeId2optionMap) {
        if (StringUtils.isNotBlank((CharSequence)controlId)) {
            if (CARD_ENTRY_ROW_AP.equalsIgnoreCase(apType)) {
                String entityTreeId = RuleDesignMetaHelper.buildPreConditionTree_Entity(ret, metaDataContent, controlId, isProFormDesign, treeId2optionMap);
                String cardTreeId = RuleDesignMetaHelper.buildPreConditionTree_Form(ret, metaDataContent, controlId, apType, isProFormDesign, treeId2optionMap);
                Map entityNode = (Map)ret.get(RULES_DESIGN_META_TREE_MAP);
                TreeNode entityTree = (TreeNode)entityNode.get(entityTreeId);
                TreeNode cardTree = (TreeNode)entityNode.get(cardTreeId);
                if (cardTree != null && cardTree.getChildren() != null) {
                    if (entityTree.getChildren() == null) {
                        entityTree.setChildren(cardTree.getChildren());
                    } else {
                        entityTree.getChildren().addAll(cardTree.getChildren());
                    }
                }
                String treeId = RuleDesignMetaHelper.newTreeId(entityNode, entityTree);
                entityNode.put(treeId, entityTree);
                return treeId;
            }
            return RuleDesignMetaHelper.buildPreConditionTree_Form(ret, metaDataContent, controlId, apType, isProFormDesign, treeId2optionMap);
        }
        return RuleDesignMetaHelper.buildPreConditionTree_Entity(ret, metaDataContent, entityId, isProFormDesign, treeId2optionMap);
    }

    private static String buildPreConditionTree_Entity(Map<String, Object> ret, Map<String, Object> metaDataContent, String entityId, boolean isProFormDesign, Map<String, BuildOption> treeId2optionMap) {
        EntityFieldTreeBuildOption option = new EntityFieldTreeBuildOption();
        boolean includeParentEntity = true;
        boolean isOnlyHeader = false;
        option.addInvalidClassTypes(MuliLangTextField.class);
        option.addInvalidClassTypes(MuliLangTextProp.class);
        option.addInvalidClassTypes(BasedataPropField.class);
        if (isProFormDesign) {
            option.addInvalidClassTypes(FlatFieldAp.class);
        }
        option.setCurrentEntity(entityId);
        option.setIncludeChildEntity(false);
        option.setIncludeParentEntity(includeParentEntity);
        option.setOnlyBillHead(isOnlyHeader);
        String existTreeId = RuleDesignMetaHelper.findExistTree((BuildOption)option, treeId2optionMap);
        if (existTreeId != null) {
            return existTreeId;
        }
        return RuleDesignMetaHelper.buildEntityFieldsTree(metaDataContent, option, ret, treeId2optionMap);
    }

    private static String buildPreConditionTree_Form(Map<String, Object> ret, Map<String, Object> metaDataContent, String controlId, String apType, boolean isProFormDesign, Map<String, BuildOption> treeId2optionMap) {
        FormFieldTreeBuildOption formOption = new FormFieldTreeBuildOption();
        boolean includeParentEntity = true;
        if (CARD_ENTRY_ROW_AP.equalsIgnoreCase(apType)) {
            includeParentEntity = false;
        }
        boolean isOnlyHeader = false;
        formOption.addInvalidClassTypes(MuliLangTextField.class);
        formOption.addInvalidClassTypes(MuliLangTextProp.class);
        formOption.addInvalidClassTypes(BasedataPropField.class);
        if (isProFormDesign) {
            formOption.addInvalidClassTypes(FlatFieldAp.class);
        }
        formOption.setCurrentEntityId(controlId);
        formOption.setIncludeChildEntity(false);
        formOption.setIncludeParentEntity(includeParentEntity);
        formOption.setOnlyBillHead(isOnlyHeader);
        String existTreeId = RuleDesignMetaHelper.findExistTree((BuildOption)formOption, treeId2optionMap);
        if (existTreeId != null) {
            return existTreeId;
        }
        return RuleDesignMetaHelper.buildFormFieldTree(metaDataContent, formOption, ret, treeId2optionMap);
    }

    private static Object buildActionTypeTree(String metaType, Map<String, Object> ret, String entityId, String controllId, boolean isMainEntity, int serviceType, int realServiceType, FormRuleActionType actionType, Map<String, Object> metaDataContent, boolean isProFormDesign, Map<String, BuildOption> treeId2optionMap) {
        if ("entitymeta".equalsIgnoreCase(metaType)) {
            return RuleDesignMetaHelper.buildActionTypeTree_Entity(ret, entityId, isMainEntity, serviceType, actionType, metaDataContent, isProFormDesign, treeId2optionMap);
        }
        return RuleDesignMetaHelper.buildActionTypeTree_Form(ret, entityId, controllId, isMainEntity, serviceType, realServiceType, actionType, metaDataContent, treeId2optionMap);
    }

    private static Object buildActionTypeTree_Entity(Map<String, Object> ret, String entityId, boolean isMainEntity, int serviceType, FormRuleActionType actionType, Map<String, Object> metaDataContent, boolean isProFormDesign, Map<String, BuildOption> treeId2optionMap) {
        EntityFieldTreeBuildOption option = null;
        EntityFieldTreeBuildOption entityOption_source = null;
        EntityFieldTreeBuildOption entityOption_target = null;
        boolean includeParentEntity = true;
        boolean isOnlyHeader = false;
        if ("FormulaAction".equalsIgnoreCase(actionType.getId())) {
            option = new EntityFieldTreeBuildOption();
            option.setCurrentEntity(entityId);
            option.setIncludeChildEntity(false);
            option.setIncludeParentEntity(includeParentEntity);
            option.setOnlyBillHead(isOnlyHeader);
            option.addInvalidClassTypes(MuliLangTextField.class);
            option.addInvalidClassTypes(MuliLangTextProp.class);
            option.addInvalidClassTypes(BasedataPropField.class);
            if (isProFormDesign) {
                option.addInvalidClassTypes(FlatFieldAp.class);
            }
        } else if ("TakeBaseProAction".equalsIgnoreCase(actionType.getId())) {
            entityOption_source = new EntityFieldTreeBuildOption();
            entityOption_source.setCurrentEntity(entityId);
            if (isMainEntity) {
                entityOption_source.setOnlyBillHead(true);
            } else {
                entityOption_source.setIncludeParentEntity(false);
                entityOption_source.setIncludeChildEntity(false);
            }
            entityOption_source.addMatchedClassTypes(BasedataField.class);
            entityOption_source.setIncludeBDRefProp(true);
            entityOption_source.addMatchedClassTypes(DynamicProperty.class);
            entityOption_target = new EntityFieldTreeBuildOption();
            entityOption_target.setCurrentEntity(entityId);
            if (isMainEntity) {
                entityOption_target.setOnlyBillHead(true);
            } else {
                entityOption_target.setIncludeParentEntity(false);
                entityOption_target.setIncludeChildEntity(false);
            }
            entityOption_target.setIncludeBDRefProp(false);
            entityOption_target.addInvalidClassTypes(BasedataPropField.class);
        } else if ("SetEqutionAction".equalsIgnoreCase(actionType.getId())) {
            option = new EntityFieldTreeBuildOption();
            option.setCurrentEntity(entityId);
            if (isMainEntity) {
                option.setOnlyBillHead(true);
            } else {
                option.setIncludeParentEntity(false);
                option.setIncludeChildEntity(false);
            }
            option.setIncludeBDRefProp(false);
            option.addInvalidClassTypes(BasedataPropField.class);
        } else if ("ClearValueAction".equalsIgnoreCase(actionType.getId())) {
            option = new EntityFieldTreeBuildOption();
            option.setCurrentEntity(entityId);
            option.setIncludeBDRefProp(false);
            option.addInvalidClassTypes(MuliLangTextField.class);
            option.addInvalidClassTypes(BasedataPropField.class);
            option.setIncludeParentEntity(false);
            option.setIncludeChildEntity(false);
        }
        if (option != null) {
            String existTreeId = RuleDesignMetaHelper.findExistTree((BuildOption)option, treeId2optionMap);
            if (existTreeId != null) {
                return existTreeId;
            }
            return RuleDesignMetaHelper.buildEntityFieldsTree(metaDataContent, option, ret, treeId2optionMap);
        }
        if (entityOption_source != null && entityOption_target != null) {
            String targetExistTreeId;
            String sourceExistTreeId = RuleDesignMetaHelper.findExistTree((BuildOption)entityOption_source, treeId2optionMap);
            if (sourceExistTreeId == null) {
                sourceExistTreeId = RuleDesignMetaHelper.buildEntityFieldsTree(metaDataContent, entityOption_source, ret, treeId2optionMap);
            }
            if ((targetExistTreeId = RuleDesignMetaHelper.findExistTree(entityOption_target, treeId2optionMap)) == null) {
                targetExistTreeId = RuleDesignMetaHelper.buildEntityFieldsTree(metaDataContent, entityOption_target, ret, treeId2optionMap);
            }
            HashMap<String, String> stMap = new HashMap<String, String>(2);
            stMap.put("source", sourceExistTreeId);
            stMap.put("target", targetExistTreeId);
            return stMap;
        }
        return null;
    }

    private static Object buildActionTypeTree_Form(Map<String, Object> ret, String entityId, String controllId, boolean isMainEntity, int serviceType, int realServiceType, FormRuleActionType actionType, Map<String, Object> metaDataContent, Map<String, BuildOption> treeId2optionMap) {
        int controlType = actionType.getControlType();
        if (controlType == 1) {
            if (serviceType == 8 || serviceType == 2 || realServiceType == 8 || realServiceType == 2) {
                return RuleDesignMetaHelper.buildControlsTreeWithControlId(metaDataContent, ret, serviceType, realServiceType, controllId, controlType);
            }
            FormFieldTreeBuildOption option = new FormFieldTreeBuildOption();
            option.addInvalidClassTypes(FlatFieldAp.class);
            option.setCurrentEntityId(controllId);
            option.setIncludeParentEntity(false);
            String existTreeId = RuleDesignMetaHelper.findExistTree((BuildOption)option, treeId2optionMap);
            if (existTreeId != null) {
                return existTreeId;
            }
            return RuleDesignMetaHelper.buildFormFieldTree(metaDataContent, option, ret, treeId2optionMap);
        }
        if (controlType == 2) {
            ControlsTreeBuildOption option = new ControlsTreeBuildOption();
            option.addInvalidClassTypes(FormAp.class);
            option.addInvalidClassTypes(FieldAp.class);
            option.addInvalidClassTypes(TabPageAp.class);
            option.addInvalidClassTypes(FilterContainerAp.class);
            option.addInvalidClassTypes(ReportFilterAp.class);
            option.addInvalidClassTypes(ReportCommFilterPanelAp.class);
            option.addInvalidClassTypes(ReportMoreFilterPanelAp.class);
            String existTreeId = RuleDesignMetaHelper.findExistTree((BuildOption)option, treeId2optionMap);
            if (existTreeId != null) {
                return existTreeId;
            }
            return RuleDesignMetaHelper.buildControlsTree(metaDataContent, option, ret, treeId2optionMap);
        }
        return null;
    }

    private static String buildControlsTreeWithControlId(Map<String, Object> metaDataContent, Map<String, Object> ret, int serviceType, int realServiceType, String controlId, int controlType) {
        Map formMeta = (Map)metaDataContent.get("formmeta");
        DesignerData designerData = new DesignerData();
        TreeNode root = new TreeNode();
        root.setParentid("");
        String entryText = null;
        FormMetadata formMetadata = null;
        if (serviceType == 8) {
            List formItems = (List)formMeta.get(ITEMS);
            Map listMeta = (Map)((Map)formItems.get(0)).get(LIST_META);
            List listMetaItems = (List)listMeta.get(ITEMS);
            formMetadata = RuleDesignMetaHelper.getFormMetadata(listMetaItems);
            formMetadata.createIndex();
            if (controlType != 1) {
                Iterator listCardViewAp;
                Map<String, Object> listGridViewAp = RuleDesignMetaHelper.getListGridViewAp(formItems);
                if (listGridViewAp != null) {
                    String listGridViewApId = (String)listGridViewAp.get(ID);
                    entryText = (String)listGridViewAp.get("Name");
                    TreeNode gridTree = new TreeNode();
                    gridTree.setText(entryText);
                    gridTree.setLongText(entryText);
                    gridTree.setData((Object)listGridViewApId);
                    gridTree.setId((String)listGridViewAp.get("Key"));
                    gridTree.setText(entryText);
                    root.addChild(gridTree);
                }
                if ((listCardViewAp = RuleDesignMetaHelper.getListCardViewAp(formItems)) != null) {
                    String listCardViewApId = (String)listCardViewAp.get(ID);
                    entryText = (String)listCardViewAp.get("Name");
                    TreeNode cardTree = new TreeNode();
                    cardTree.setText(entryText);
                    cardTree.setLongText(entryText);
                    cardTree.setData((Object)listCardViewApId);
                    cardTree.setId((String)listCardViewAp.get("Key"));
                    cardTree.setText(entryText);
                    root.addChild(cardTree);
                }
                if (root.getChildren().isEmpty()) {
                    return null;
                }
            }
        } else {
            formMetadata = (FormMetadata)designerData.convertTo(metaDataContent, (String)formMeta.get(TYPE));
            formMetadata.createIndex();
        }
        ControlAp controllAp = formMetadata.getItem(controlId);
        entryText = controllAp.getName().toString();
        root.setText(entryText);
        root.setLongText(entryText);
        root.setData((Object)controllAp.getId());
        root.setId(controllAp.getKey());
        for (ControlAp control : formMetadata.getItems()) {
            Optional<ControlAp> op;
            if (!(control instanceof EntryAp) && !(control instanceof ListGridViewAp) && !(control instanceof ListCardViewAp) && !(control instanceof CardEntryViewAp)) continue;
            if (control instanceof ListCardViewAp) {
                op = ((ContainerAp)control).getItems().stream().filter(item -> item instanceof CardRowPanelAp).findFirst();
                if (!op.isPresent()) continue;
                control = op.get();
                for (ControlAp controlAp : ((ContainerAp)control).getItems()) {
                    if (!control.getId().equals(controlId) || !(controlAp instanceof ContainerAp) && !(controlAp instanceof FieldAp) && !(controlAp instanceof ListColumnAp)) continue;
                    if (controlAp instanceof ContainerAp) {
                        RuleDesignMetaHelper.getContainer(root, (ContainerAp)controlAp, entryText);
                        continue;
                    }
                    RuleDesignMetaHelper.addNode(controlAp, root, entryText);
                }
                continue;
            }
            if (control instanceof CardEntryViewAp) {
                op = ((ContainerAp)control).getItems().stream().filter(item -> item instanceof CardEntryRowAp).findFirst();
                if (!op.isPresent()) continue;
                control = op.get();
                for (ControlAp controlAp : ((ContainerAp)control).getItems()) {
                    if (!control.getId().equals(controlId) || !(controlAp instanceof ContainerAp) && !(controlAp instanceof FieldAp)) continue;
                    if (controlAp instanceof ContainerAp) {
                        RuleDesignMetaHelper.getContainer(root, (ContainerAp)controlAp, entryText);
                        continue;
                    }
                    RuleDesignMetaHelper.addNode(controlAp, root, entryText);
                }
                continue;
            }
            for (ControlAp controlAp : ((ContainerAp)control).getItems()) {
                if (!control.getId().equals(controlId) || !(controlAp instanceof FieldAp) && !(controlAp instanceof ListColumnAp) && !(controlAp instanceof ListColumnGroupAp)) continue;
                if (controlAp instanceof ContainerAp) {
                    TreeNode treeNode = new TreeNode();
                    treeNode.setId(controlAp.getKey());
                    treeNode.setText(controlAp.getName().toString());
                    treeNode.setParentid(control.getKey());
                    RuleDesignMetaHelper.getContainer(treeNode, (ContainerAp)controlAp, entryText);
                    root.addChild(treeNode);
                    continue;
                }
                RuleDesignMetaHelper.addNode(controlAp, root, entryText);
            }
        }
        if (root != null) {
            HashMap<String, TreeNode> entityNode = (HashMap<String, TreeNode>)ret.get(RULES_DESIGN_META_TREE_MAP);
            if (entityNode == null) {
                entityNode = new HashMap<String, TreeNode>(10);
                ret.put(RULES_DESIGN_META_TREE_MAP, entityNode);
            }
            String treeId = RuleDesignMetaHelper.newTreeId((Map<String, Object>)entityNode, root);
            entityNode.put(treeId, root);
            return treeId;
        }
        return null;
    }

    private static String newTreeId(Map<String, Object> entityNode, TreeNode root) {
        String treeId = String.valueOf(root.hashCode());
        if (entityNode.containsKey(treeId)) {
            while (!entityNode.containsKey(treeId)) {
                treeId = String.valueOf(random.nextInt(1000000));
            }
            return treeId;
        }
        return treeId;
    }

    private static void addNode(ControlAp<?> controlAp, TreeNode root, String parentText) {
        String longText;
        TreeNode fieldNode = new TreeNode();
        fieldNode.setParentid(root.getId());
        fieldNode.setId(controlAp.getKey());
        fieldNode.setData((Object)controlAp.getId());
        fieldNode.setType(controlAp.getClass().getSimpleName());
        String string = longText = controlAp.getName() == null ? "" : controlAp.getName() + "(" + controlAp.getKey() + ")";
        if (controlAp instanceof ListColumnAp) {
            ListColumnAp listColumnAp = (ListColumnAp)controlAp;
            fieldNode.setText(controlAp.getName() == null ? "" : controlAp.getName() + "(" + listColumnAp.getListFieldId() + ")");
        } else {
            fieldNode.setText(longText);
        }
        if (StringUtils.isNotBlank((CharSequence)parentText)) {
            longText = parentText + "." + longText;
        }
        fieldNode.setLongText(longText);
        root.addChild(fieldNode);
    }

    private static void getContainer(TreeNode entryNode, ContainerAp<?> control, String parentText) {
        for (ControlAp controlAp : control.getItems()) {
            if (controlAp instanceof FieldAp || controlAp instanceof ListColumnAp || controlAp instanceof CardListColumnAp) {
                RuleDesignMetaHelper.addNode(controlAp, entryNode, parentText);
                continue;
            }
            if (!(controlAp instanceof ContainerAp)) continue;
            TreeNode treeNode = new TreeNode();
            treeNode.setId(controlAp.getKey());
            treeNode.setText(controlAp.getName().toString());
            treeNode.setParentid(control.getKey());
            RuleDesignMetaHelper.getContainer(treeNode, (ContainerAp)controlAp, parentText);
            if (treeNode.getChildren() == null || treeNode.getChildren().size() <= 0) continue;
            entryNode.addChild(treeNode);
        }
    }

    private static boolean equalsOption(BuildOption source, BuildOption target) {
        EntityFieldTreeBuildOption tgr;
        EntityFieldTreeBuildOption src;
        if (source == target) {
            return true;
        }
        if (source == null || target == null) {
            return false;
        }
        if (source.getClass() != target.getClass()) {
            return false;
        }
        if (source.getMatchedClassTypes().size() != target.getMatchedClassTypes().size()) {
            return false;
        }
        if (!source.getMatchedClassTypes().equals(target.getMatchedClassTypes())) {
            return false;
        }
        if (source.getInvalidClassTypes().size() != target.getInvalidClassTypes().size()) {
            return false;
        }
        if (!source.getInvalidClassTypes().equals(target.getInvalidClassTypes())) {
            return false;
        }
        if (source instanceof EntityFieldTreeBuildOption) {
            src = (EntityFieldTreeBuildOption)source;
            tgr = (EntityFieldTreeBuildOption)target;
            if (!StringUtils.equalsIgnoreCase((CharSequence)src.getCurrentEntity(), (CharSequence)tgr.getCurrentEntity())) {
                return false;
            }
            if (src.isIncludeChildEntity() != tgr.isIncludeChildEntity()) {
                return false;
            }
            if (src.isIncludeParentEntity() != tgr.isIncludeParentEntity()) {
                return false;
            }
            if (src.isOnlyBillHead() != tgr.isOnlyBillHead()) {
                return false;
            }
            if (src.isIncludeBDRefProp() != tgr.isIncludeBDRefProp()) {
                return false;
            }
        }
        if (source instanceof FormFieldTreeBuildOption) {
            src = (FormFieldTreeBuildOption)source;
            tgr = (FormFieldTreeBuildOption)target;
            if (!StringUtils.equalsIgnoreCase((CharSequence)src.getCurrentEntityId(), (CharSequence)tgr.getCurrentEntityId())) {
                return false;
            }
        }
        if (source instanceof ControlsTreeBuildOption) {
            src = (ControlsTreeBuildOption)source;
            tgr = (ControlsTreeBuildOption)target;
            if (src.isOutKey() != tgr.isOutKey()) {
                return false;
            }
        }
        return true;
    }

    private static String findExistTree(BuildOption option, Map<String, BuildOption> treeId2optionMap) {
        Optional<Map.Entry> exit = treeId2optionMap.entrySet().stream().filter(o -> RuleDesignMetaHelper.equalsOption((BuildOption)o.getValue(), option)).findFirst();
        if (exit.isPresent()) {
            return (String)exit.get().getKey();
        }
        return null;
    }

    private static String buildEntityFieldsTree(Map<String, Object> metaDataContent, EntityFieldTreeBuildOption option, Map<String, Object> ret, Map<String, BuildOption> treeId2optionMap) {
        Map entityMeta = (Map)metaDataContent.get("entitymeta");
        List entityItems = (List)entityMeta.get(ITEMS);
        TreeNode tree = FormTreeBuilder.buildEntityFieldsTree((List)entityItems, (EntityFieldTreeBuildOption)option);
        HashMap<String, TreeNode> entityNode = (HashMap<String, TreeNode>)ret.get(RULES_DESIGN_META_TREE_MAP);
        if (entityNode == null) {
            entityNode = new HashMap<String, TreeNode>(10);
            ret.put(RULES_DESIGN_META_TREE_MAP, entityNode);
        }
        String treeId = RuleDesignMetaHelper.newTreeId((Map<String, Object>)entityNode, tree);
        entityNode.put(treeId, tree);
        treeId2optionMap.put(treeId, (BuildOption)option);
        return treeId;
    }

    private static String buildFormFieldTree(Map<String, Object> metaDataContent, FormFieldTreeBuildOption option, Map<String, Object> ret, Map<String, BuildOption> treeId2optionMap) {
        Map entityMeta = (Map)metaDataContent.get("entitymeta");
        List entityItems = (List)entityMeta.get(ITEMS);
        Map formMeta = (Map)metaDataContent.get("formmeta");
        List formItems = (List)formMeta.get(ITEMS);
        TreeNode tree = FormTreeBuilder.buildFormFieldTree((List)formItems, (List)entityItems, (FormFieldTreeBuildOption)option);
        HashMap<String, TreeNode> entityNode = (HashMap<String, TreeNode>)ret.get(RULES_DESIGN_META_TREE_MAP);
        if (entityNode == null) {
            entityNode = new HashMap<String, TreeNode>(10);
            ret.put(RULES_DESIGN_META_TREE_MAP, entityNode);
        }
        String treeId = RuleDesignMetaHelper.newTreeId((Map<String, Object>)entityNode, tree);
        entityNode.put(treeId, tree);
        treeId2optionMap.put(treeId, (BuildOption)option);
        return treeId;
    }

    private static String buildControlsTree(Map<String, Object> metaDataContent, ControlsTreeBuildOption option, Map<String, Object> ret, Map<String, BuildOption> treeId2optionMap) {
        Map formMeta = (Map)metaDataContent.get("formmeta");
        List formItems = (List)formMeta.get(ITEMS);
        TreeNode tree = FormTreeBuilder.buildControlsTree((List)formItems, (ControlsTreeBuildOption)option);
        HashMap<String, TreeNode> entityNode = (HashMap<String, TreeNode>)ret.get(RULES_DESIGN_META_TREE_MAP);
        if (entityNode == null) {
            entityNode = new HashMap<String, TreeNode>(10);
            ret.put(RULES_DESIGN_META_TREE_MAP, entityNode);
        }
        String treeId = RuleDesignMetaHelper.newTreeId((Map<String, Object>)entityNode, tree);
        entityNode.put(treeId, tree);
        treeId2optionMap.put(treeId, (BuildOption)option);
        return treeId;
    }

    public static List<String> parseRet(FormRuleActionType ruleType, Integer retVal) {
        ArrayList<String> checkedList = new ArrayList<String>(10);
        if (ruleType.isSupportFieldChanged() && (retVal & RaiseEventType.FieldChanged.getValue()) != 0) {
            checkedList.add(RaiseEventType.FieldChanged.name());
        }
        if (ruleType.isSupportInitialized() && (retVal & RaiseEventType.Initialized.getValue()) != 0) {
            checkedList.add(RaiseEventType.Initialized.name());
        }
        if (ruleType.isSupportItemAdded() && (retVal & RaiseEventType.ItemAdded.getValue()) != 0) {
            checkedList.add(RaiseEventType.ItemAdded.name());
        }
        return checkedList;
    }

    private static List<String> getEntityKeys() {
        ArrayList<String> entityKeys = new ArrayList<String>(3);
        entityKeys.add("MainEntity");
        entityKeys.add("BaseEntity");
        entityKeys.add(ENTRY_ENTITY);
        entityKeys.add("TreeEntryEntity");
        entityKeys.add("BillEntity");
        entityKeys.add(SUB_ENTRY_ENTITY);
        return entityKeys;
    }

    private static JSONArray parseToJsonObject(FunctionTypes functionTypes) {
        JSONArray data = new JSONArray();
        List functionGroups = functionTypes.getFunctionGroups();
        Collections.sort(functionGroups, new Comparator<FunctionGroup>(){

            @Override
            public int compare(FunctionGroup o1, FunctionGroup o2) {
                return o1.getSeq() - o2.getSeq();
            }
        });
        for (FunctionGroup functionGroup : functionGroups) {
            if (!functionGroup.isVisible()) continue;
            JSONObject group = new JSONObject();
            group.put("id", (Object)functionGroup.getId());
            group.put("name", (Object)functionGroup.getName().toString());
            group.put("seq", (Object)functionGroup.getSeq());
            group.put("expend", (Object)functionGroup.isExpend());
            List types = functionTypes.getFunctionTypes().stream().filter(t -> functionGroup.getId().equalsIgnoreCase(t.getGroupId())).collect(Collectors.toList());
            Collections.sort(types, new Comparator<FunctionType>(){

                @Override
                public int compare(FunctionType o1, FunctionType o2) {
                    return o1.getSeq() - o2.getSeq();
                }
            });
            JSONArray typesData = new JSONArray();
            for (FunctionType functionType : types) {
                JSONObject type = new JSONObject();
                type.put("id", (Object)functionType.getId());
                type.put("name", (Object)functionType.getName().toString());
                type.put("def", (Object)functionType.getDef());
                type.put("returnType", (Object)functionType.getReturnType());
                String desc = functionType.getDesc().toString();
                type.put("desc", (Object)(StringUtils.isBlank((CharSequence)desc) ? desc : desc.replace("\\n", "\n")));
                type.put("runClass", (Object)functionType.getRunClass());
                type.put("settingFormId", (Object)functionType.getSettingFormId());
                type.put("seq", (Object)functionType.getSeq());
                typesData.add((Object)type);
            }
            group.put("types", (Object)typesData);
            data.add((Object)group);
        }
        return data;
    }

    private static Map<String, Object> getListGridViewAp(List<Map<String, Object>> formItems) {
        Map listMeta = (Map)formItems.get(0).get(LIST_META);
        List listMetaItems = (List)listMeta.get(ITEMS);
        Optional<Map> first = listMetaItems.stream().filter(i -> LIST_GRID_VIEW_AP.equalsIgnoreCase((String)i.get(TYPE))).findFirst();
        if (first.isPresent()) {
            Map listGridViewApMap = first.get();
            return listGridViewApMap;
        }
        return null;
    }

    private static Map<String, Object> getListCardViewAp(List<Map<String, Object>> formItems) {
        Map listMeta = (Map)formItems.get(0).get(LIST_META);
        List listMetaItems = (List)listMeta.get(ITEMS);
        Optional<Map> first = listMetaItems.stream().filter(i -> CARD_ROW_PANEL_AP.equalsIgnoreCase((String)i.get(TYPE))).findFirst();
        if (first.isPresent()) {
            Map listCardViewApMap = first.get();
            return listCardViewApMap;
        }
        return null;
    }

    private static String getParentEntityId(String entityId, List<Map<String, Object>> entityItems) {
        Optional<Map> first;
        if (StringUtils.isNotBlank((CharSequence)entityId) && (first = entityItems.stream().filter(i -> entityId.equalsIgnoreCase((String)i.get(ID))).findFirst()).isPresent()) {
            Map parentEntityMap = first.get();
            return (String)parentEntityMap.get(PARENT_ENTRY_ID);
        }
        return null;
    }

    private static String getEntryFieldType(Map itemMap, List<Map<String, Object>> entityItems) {
        if (itemMap.containsKey(FIELD_TYPE)) {
            return (String)itemMap.get(FIELD_TYPE);
        }
        String entryId = (String)itemMap.get(ENTRY_ID);
        if (StringUtils.isBlank((CharSequence)entryId)) {
            entryId = (String)itemMap.get(ID);
        }
        String finalEntryId = entryId;
        Optional<Map> first = entityItems.stream().filter(i -> finalEntryId.equalsIgnoreCase((String)i.get(ID))).findFirst();
        if (first.isPresent()) {
            Map map = first.get();
            return (String)map.get(TYPE);
        }
        return null;
    }

    private static Set<Integer> getServiceTypes(RuleNavTreeNode rulesTreeNode, Set<Integer> r) {
        if (r == null) {
            r = new HashSet<Integer>(10);
            if (rulesTreeNode != null) {
                r.add(rulesTreeNode.getServiceType());
            }
        } else {
            r.add(rulesTreeNode.getServiceType());
        }
        if (rulesTreeNode != null && rulesTreeNode.getChildren() != null) {
            for (TreeNode child : rulesTreeNode.getChildren()) {
                RuleDesignMetaHelper.getServiceTypes((RuleNavTreeNode)child, r);
            }
        }
        return r;
    }

    private static FormMetadata getFormMetadata(List<Map<String, Object>> formContext) {
        HashMap<String, Object> formMeta = new HashMap<String, Object>();
        formMeta.put(ITEMS, formContext);
        formMeta.put(TYPE, "FormMetadata");
        String modelType = "DynamicFormModel";
        String type = formContext.get(0).get(TYPE).toString();
        if ("MobileBillFormAp".equalsIgnoreCase(type)) {
            modelType = "MobileBillFormModel";
        } else if ("BasedataFormAp".equalsIgnoreCase(type)) {
            modelType = "BaseFormModel";
        } else if ("BillFormAp".equalsIgnoreCase(type)) {
            modelType = "BillFormModel";
        } else if ("MobileListFormAp".equalsIgnoreCase(type)) {
            modelType = "MobileListModel";
        } else if ("FormAp".equalsIgnoreCase(type)) {
            modelType = "DynamicFormModel";
        } else if ("MobileFormAp".equalsIgnoreCase(type)) {
            modelType = "MobileFormModel";
        } else if ("ReportFormAp".equalsIgnoreCase(type)) {
            modelType = "ReportFormModel";
        } else if ("CardAp".equalsIgnoreCase(type)) {
            modelType = "CardModel";
        }
        IFormTemplate template = FormTemplateFactory.createTemplate((String)modelType);
        FormMetadata formMetadata = (FormMetadata)template.deserializeFromMap(formMeta, null);
        return formMetadata;
    }

    public static List<Map<String, Object>> getDesignItems(AbstractFormPlugin plugin) {
        PropertyEditHelper helper = new PropertyEditHelper();
        List items = helper.getEntityMeta(plugin.getView());
        boolean isProFormDesign = Boolean.parseBoolean((String)plugin.getView().getFormShowParameter().getCustomParam("isproformdesign"));
        boolean isEntityDesign = Boolean.parseBoolean((String)plugin.getView().getFormShowParameter().getCustomParam("isEntityDesign"));
        if (items == null) {
            items = (List)plugin.getView().getFormShowParameter().getCustomParams().get("context");
            if (isProFormDesign) {
                String entityStr = (String)plugin.getView().getFormShowParameter().getCustomParam("proEntityStr");
                items = SerializationUtils.fromJsonStringToList((String)entityStr, Map.class);
            }
            if (isEntityDesign) {
                List context = (List)plugin.getView().getFormShowParameter().getCustomParam("context");
                items = (List)context.get(0);
            }
        }
        return items;
    }

    private static void checkFormRules(List<Map<String, Object>> formItemList) {
        if (formItemList == null) {
            return;
        }
        List formRuleActionTypes = FormRuleActionTypeCache.getFormRuleActionTypesWithoutExt();
        ArrayList<String> actionTypes = new ArrayList<String>(10);
        if (formRuleActionTypes != null) {
            for (FormRuleActionType formRuleActionType : formRuleActionTypes) {
                actionTypes.add(formRuleActionType.getId());
            }
        }
        for (Map map : formItemList) {
            List clientRules;
            List rules = (List)map.get(META_RULES);
            if (rules != null) {
                RuleDesignMetaHelper.checkRule(rules, actionTypes);
            }
            if ((clientRules = (List)map.get(META_CLIENT_RULES)) == null) continue;
            RuleDesignMetaHelper.checkRule(clientRules, actionTypes);
        }
    }

    private static void checkRule(List<Map<String, Object>> rules, List<String> actionTypes) {
        for (Map<String, Object> rule : rules) {
            List trueActionList = (List)rule.get("TrueActions");
            RuleDesignMetaHelper.checkActions(trueActionList, actionTypes);
            List falseActionList = (List)rule.get("FalseActions");
            RuleDesignMetaHelper.checkActions(falseActionList, actionTypes);
        }
    }

    private static void checkBusinessRules(List<Map<String, Object>> entityItemList) {
        if (entityItemList == null) {
            return;
        }
        List formRuleActionTypes = FormRuleActionTypeCache.getFormRuleActionTypesWithoutExt();
        ArrayList<String> actionTypes = new ArrayList<String>(10);
        if (formRuleActionTypes != null) {
            for (FormRuleActionType formRuleActionType : formRuleActionTypes) {
                actionTypes.add(formRuleActionType.getId());
            }
        }
        for (Map map : entityItemList) {
            List rules = (List)map.get(META_RULES);
            if (rules == null) continue;
            for (Map rule : rules) {
                List trueActionList = (List)rule.get("TrueActions");
                RuleDesignMetaHelper.checkActions(trueActionList, actionTypes);
                List falseActionList = (List)rule.get("FalseActions");
                RuleDesignMetaHelper.checkActions(falseActionList, actionTypes);
            }
        }
    }

    private static boolean checkActions(List<Map<String, Object>> actionList, List<String> actionTypes) {
        if (actionList == null) {
            return true;
        }
        for (Map<String, Object> action : actionList) {
            String actionType = (String)action.get("ActionType");
            if (actionTypes.contains(actionType)) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u89c4\u5219Action\u7c7b\u578b[%s]\u3002", (String)"RuleDesignMetaHelper_0", (String)"bos-devportal-new-plugin", (Object[])new Object[0]), actionType);
            throw new KDBizException(new ErrorCode("ActionNotSupport", msg), new Object[]{msg});
        }
        return true;
    }
}

