/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.app.plugin;

import java.security.SecureRandom;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;

public class AppImportProgressFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String CACHEKEY_JOBFORMINFO = "appimport_jobforminfo";
    private static final String CACHEKEY_TASKID = "appimport_taskid";
    private static final String CACHEKEY_ISSTART = "isstart";
    private static final String CACHEKEY_ISFINISHED = "isfinished";
    private boolean canClose = false;
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String PROGRESSBARAP = "progressbarap";
    private static final String CUSTPARAM_ENTITYNAME = "entityname";
    private static final String APP_IMPORT_IS_CANCEL = "APP_IMPORT_IS_CANCEL";
    private static final String FORMID = "formid";
    private static final String URLARR = "urlarr";
    private static final String BIZCLOUDID = "bizcloudid";
    private static final String PARENTPAGEID = "parentpageid";
    private static final String FORMID_RESULT = "bos_devp_installappmsg";
    private static final Log LOG = LogFactory.getLog(AppImportProgressFormPlugin.class);

    public void registerListener(EventObject e) {
        ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESSBARAP);
        progressbar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{"btncancel"});
    }

    public void onProgress(ProgressEvent e) {
        try {
            String taskId = this.getTaskId();
            boolean start = this.isStart();
            this.setStart(true);
            if (!start && StringUtils.isBlank((CharSequence)taskId)) {
                this.dispatchTask();
                double n = new SecureRandom().nextDouble();
                e.setProgress((int)(50.0 * n));
                return;
            }
            if (StringUtils.isBlank((CharSequence)taskId)) {
                return;
            }
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            if (taskInfo.isTaskEnd()) {
                boolean isFinished = this.isFinished();
                this.setFinished(true);
                if (!isFinished) {
                    e.setProgress(99);
                    return;
                }
                IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
                String taskInfoData = taskInfo.getData();
                if (taskInfoData != null) {
                    Map data = (Map)SerializationUtils.fromJsonString((String)taskInfoData, Map.class);
                    if (StringUtils.equalsIgnoreCase((CharSequence)"FAILED", (CharSequence)taskInfo.getStatus())) {
                        this.getView().showErrMessage(taskInfo.getFailureReason(), "");
                        this.stopBar();
                        return;
                    }
                    if (Boolean.parseBoolean((String)data.get("success"))) {
                        Object installMsg = data.get("detail");
                        if (Boolean.parseBoolean(String.valueOf(data.get("oldMode"))) || installMsg == null) {
                            this.showOldAppImportResult(data);
                        } else {
                            this.showAppImportResult(installMsg);
                        }
                        e.setProgress(100);
                    } else {
                        parentView.showErrMessage("" + data.get("error"), "");
                        this.getView().sendFormAction(parentView);
                    }
                }
                this.stopBar();
                this.closeForm();
                this.getCurrentAppCache().remove(APP_IMPORT_IS_CANCEL);
            } else {
                int progress = taskInfo.getProgress();
                if (progress >= 100) {
                    progress = 99;
                }
                e.setProgress(progress);
            }
        }
        catch (Exception exception) {
            this.stopBar();
            IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            parentView.showErrMessage(String.format(ResManager.loadKDString((String)"\u62a5\u9519\u4fe1\u606f: %s", (String)"AppImportProgressFormPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), exception.getMessage()), "");
            LOG.error((Throwable)exception);
            this.getView().sendFormAction(parentView);
            this.closeForm();
        }
    }

    private void showOldAppImportResult(Map<String, Object> data) {
        FormShowParameter para = new FormShowParameter();
        para.setFormId(FORMID_RESULT);
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        Map installMsg = (Map)data.get("installmsg");
        para.setCustomParam("installmsg", (Object)installMsg);
        para.setCustomParam("parentPageId", (Object)parentView.getPageId());
        para.setCustomParam("oldMode", (Object)"true");
        parentView.showForm(para);
        this.getView().sendFormAction(parentView);
    }

    private void showAppImportResult(Object installMsg) {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        FormShowParameter para = new FormShowParameter();
        para.setFormId("bos_devp_installappms_inh");
        para.setCaption(ResManager.loadKDString((String)"\u5e94\u7528\u5b89\u88c5\u4fe1\u606f", (String)"AppImportProgressFormPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.setCustomParam("installmsg", installMsg);
        para.setCustomParam("parentPageId", (Object)parentView.getPageId());
        parentView.showForm(para);
        this.getView().sendFormAction(parentView);
    }

    private boolean isFinished() {
        String finished = this.getPageCache().get(CACHEKEY_ISFINISHED);
        if (StringUtils.isBlank((CharSequence)finished)) {
            return false;
        }
        return Boolean.parseBoolean(finished);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String isStop = (String)this.getCurrentAppCache().get(APP_IMPORT_IS_CANCEL, String.class);
        if (!this.isStart()) {
            if (isStop != null && Boolean.parseBoolean(isStop)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u8981\u7ec8\u6b62\u5e94\u7528\u5bfc\u5165\uff1f", (String)"AppImportProgressFormPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("CLOSE_UNSTART", (IFormPlugin)this));
                e.setCancel(true);
                return;
            }
            e.setCancel(true);
            return;
        }
        if (this.canClose || this.isFinished()) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getTaskId())) {
            if (isStop != null && Boolean.parseBoolean(isStop)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u8981\u7ec8\u6b62\u5e94\u7528\u5bfc\u5165\uff1f", (String)"AppImportProgressFormPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("CLOSE_START", (IFormPlugin)this));
                this.stopBar();
                e.setCancel(true);
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u8981\u628a\u5e94\u7528\u5bfc\u5165\u8f6c\u4e3a\u540e\u53f0\u6267\u884c\uff1f", (String)"AppImportProgressFormPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("CLOSE_CONFIRMED", (IFormPlugin)this));
            this.stopBar();
            e.setCancel(true);
        }
    }

    private void closeForm() {
        this.canClose = true;
        TaskClientProxy.setProgressPageId((String)this.getTaskId(), (String)"");
        this.getView().close();
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
        bar.stop();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
        bar.start();
        String taskId = this.getTaskId();
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 99;
            }
            bar.setPercent(progress);
        }
    }

    private String getTaskId() {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey(CACHEKEY_TASKID)) {
            return (String)this.getView().getFormShowParameter().getCustomParam(CACHEKEY_TASKID);
        }
        return this.getPageCache().get(CACHEKEY_TASKID);
    }

    private boolean isStart() {
        String start = this.getPageCache().get(CACHEKEY_ISSTART);
        if (StringUtils.isBlank((CharSequence)start)) {
            return false;
        }
        return Boolean.parseBoolean(start);
    }

    private void setStart(boolean start) {
        this.getPageCache().put(CACHEKEY_ISSTART, String.valueOf(start));
    }

    private void dispatchTask() {
        JobFormInfo jobFormInfo = this.buildJobFormInfo();
        String isStop = (String)this.getCurrentAppCache().get(APP_IMPORT_IS_CANCEL, String.class);
        if (isStop != null && Boolean.parseBoolean(isStop)) {
            this.getCurrentAppCache().remove(APP_IMPORT_IS_CANCEL);
            return;
        }
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        this.putTaskId(taskId);
        this.putJobFormInfo(jobFormInfo);
    }

    private void putTaskId(String taskId) {
        this.getPageCache().put(CACHEKEY_TASKID, taskId);
    }

    private JobFormInfo buildJobFormInfo() {
        JobInfo jobInfo = new JobInfo();
        FormShowParameter fs = this.getView().getFormShowParameter();
        jobInfo.setName(ResManager.loadKDString((String)"\u5f00\u53d1\u5e73\u53f0\u5bfc\u5165\u5e94\u7528", (String)"AppImportProgressFormPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId(fs.getServiceAppId());
        jobInfo.setTaskClassname("kd.bos.devportal.app.plugin.AppImportTask");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARENTPAGEID, fs.getParentPageId());
        params.put(BIZCLOUDID, fs.getCustomParam(BIZCLOUDID));
        params.put(URLARR, fs.getCustomParam(URLARR));
        jobInfo.setParams(params);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setParentPageId(fs.getParentPageId());
        jobFormInfo.setRootPageId(fs.getRootPageId());
        jobFormInfo.setTimeout(this.getImportTimes());
        jobFormInfo.getParams().putAll(fs.getCustomParams());
        if (fs.getCloseCallBack() != null) {
            jobFormInfo.setCloseCallBack(fs.getCloseCallBack());
        } else {
            CloseCallBack closeCallBack = new CloseCallBack("kd.bos.devportal.app.plugin.AppImportCloseCallBack", "");
            jobFormInfo.setCloseCallBack(closeCallBack);
        }
        return jobFormInfo;
    }

    private String getEntityName() {
        String name = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_ENTITYNAME);
        if (name == null) {
            name = "";
        }
        return name;
    }

    private void setFinished(boolean finished) {
        this.getPageCache().put(CACHEKEY_ISFINISHED, String.valueOf(finished));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageboxclosedevent) {
        super.confirmCallBack(messageboxclosedevent);
        if ("CLOSE_START".equals(messageboxclosedevent.getCallBackId())) {
            if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
                ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
                bar.stop();
                this.closeForm();
            } else {
                ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
                bar.start();
            }
        } else if ("CLOSE_UNSTART".equals(messageboxclosedevent.getCallBackId())) {
            if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
                ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
                bar.stop();
                this.closeForm();
            } else {
                this.dispatchTask();
            }
        } else if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
            this.toBackground();
        } else {
            ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
            bar.start();
        }
        this.getCurrentAppCache().remove(APP_IMPORT_IS_CANCEL);
    }

    private void toBackground() {
        this.closeForm();
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (!TaskClientProxy.isExistTask((String)taskId)) {
            JobFormInfo jobFormInfo = this.getJobFormInfo();
            TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)jobFormInfo, (TaskInfo)taskInfo);
            BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
            ThreadPools.executeOnce((String)"task-background-monitor", (Runnable)subscriber);
        }
    }

    private void putJobFormInfo(JobFormInfo jobFormInfo) {
        if (jobFormInfo == null) {
            this.getPageCache().remove(CACHEKEY_JOBFORMINFO);
        } else {
            String str = SerializationUtils.toJsonString((Object)jobFormInfo);
            this.getPageCache().put(CACHEKEY_JOBFORMINFO, str);
        }
    }

    private JobFormInfo getJobFormInfo() {
        String str = null;
        str = this.getView().getFormShowParameter().getCustomParams().containsKey(CACHEKEY_JOBFORMINFO) ? (String)this.getView().getFormShowParameter().getCustomParam(CACHEKEY_JOBFORMINFO) : this.getPageCache().get(CACHEKEY_JOBFORMINFO);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return (JobFormInfo)SerializationUtils.fromJsonString((String)str, JobFormInfo.class);
    }

    private IAppCache getCurrentAppCache() {
        return AppCache.get((String)this.getView().getFormShowParameter().getFormConfig().getAppId());
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if ("btncancel".equals(c.getKey())) {
            this.getCurrentAppCache().put(APP_IMPORT_IS_CANCEL, (Object)"true");
            this.getView().close();
        }
    }

    private int getImportTimes() {
        return 1800;
    }
}

