/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.app.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.bind.JAXBException;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.devportal.upgrade.entity.DeployResultEnum;
import kd.bos.devportal.upgrade.entity.DeployResultInfo;
import kd.bos.devportal.util.AppPackageUtil;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.botp.DesignConvertRuleMeta;
import kd.bos.metadata.botp.DesignWriteBackRuleMeta;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetaLogType;
import kd.bos.metadata.dao.MetaType;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployAppMetadata;
import kd.bos.metadata.deploy.DeployMetadata;
import kd.bos.metadata.deploy.DeployScript;
import kd.bos.metadata.deploy.DeployScriptBinder;
import kd.bos.metadata.devportal.DesignAppMeta;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.param.ParameterReader;
import kd.bos.schedule.dataentity.DeployScheduleEntity;
import kd.bos.schedule.dataentity.dao.ScheduleModelBinder;
import kd.bos.schedule.deploy.IScheduleDeployService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataLogService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.sqlscript.PreInsDataScriptWriter;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.SAXReaderUtil;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Node;

public class DeployUtil {
    private static final long LIMITSIZ = 0x1400000L;
    private static final String DATAMODEL = "datamodel";
    private static final String MAIN = "main";
    private static final String METADATA = "metadata";
    private static final String DBSCHEMA = "dbschema";
    private static final String PREINSDATA = "preinsdata";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final Log logger = LogFactory.getLog(DeployUtil.class);

    public static JSONObject install(JSONArray patchUrlArr, String cloudId) {
        JSONObject result = new JSONObject();
        result.put("success", (Object)"true");
        TempRecord tempRecord = new TempRecord();
        tempRecord.defaultCldId = StringUtils.isNotEmpty((CharSequence)cloudId) ? cloudId : tempRecord.defaultCldId;
        ArrayList<DeployResultInfo> deployResultList = new ArrayList<DeployResultInfo>();
        long logId = DB.genGlobalLongId();
        for (Object obj : patchUrlArr) {
            JSONObject jSONObject = (JSONObject)obj;
            String patchName = (String)jSONObject.keySet().stream().findFirst().get();
            String patchUrl = jSONObject.getString(patchName);
            DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u8bfb\u53d6\u8865\u4e01\u5305 %s \u7684\u6587\u4ef6\u5185\u5bb9", (String)"DeployUtil_12", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), patchName));
            DeployResultInfo patchDeployInfo = DeployUtil.getDeployFileContent(patchName, patchUrl, tempRecord);
            deployResultList.add(patchDeployInfo);
            if (!StringUtils.equalsIgnoreCase((CharSequence)patchDeployInfo.getResult(), (CharSequence)DeployResultEnum.FAIL.getCode())) continue;
            ArrayList<String> deployErrList = new ArrayList<String>();
            deployErrList.add(SerializationUtils.toJsonString((Object)patchDeployInfo));
            result.put("detail", deployErrList);
            return result;
        }
        if (!tempRecord.dbschemaSqlInfo.isEmpty()) {
            DeployUtil.deploySqlFile(DBSCHEMA, deployResultList, tempRecord);
        }
        if (!tempRecord.preinsdataSqlInfo.isEmpty()) {
            DeployUtil.deploySqlFile(PREINSDATA, deployResultList, tempRecord);
        }
        if (!tempRecord.portalSchemaInfo.isEmpty()) {
            DeployUtil.deployPortalSchema(deployResultList, tempRecord);
        }
        if (!tempRecord.cloudInfo.isEmpty()) {
            DeployUtil.deployCloudMeta(deployResultList, tempRecord);
        }
        if (!tempRecord.appInfo.isEmpty()) {
            DeployUtil.deployAppMeta(deployResultList, logId, tempRecord);
        }
        ArrayList<String> notExist = new ArrayList<String>();
        for (Map.Entry entry : tempRecord.sourceAppIds.entrySet()) {
            List appIdList = (List)entry.getValue();
            String fileFullName = (String)entry.getKey();
            if (appIdList == null || appIdList.isEmpty()) continue;
            for (String bizAppId : appIdList) {
                DeployResultInfo appDeployResult;
                boolean bizAppExist = QueryServiceHelper.exists((String)"bos_devportal_bizapp", (Object)bizAppId);
                if (bizAppExist) continue;
                notExist.add(bizAppId);
                String errMsg = String.format(ResManager.loadKDString((String)"\u6240\u5c5e\u5e94\u7528(id:%s)\u5728\u5f53\u524d\u73af\u5883\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u5b89\u88c5\u8be5\u5e94\u7528\u3002", (String)"DeployUtil_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), bizAppId);
                String[] fileNameArr = fileFullName.split("@");
                int fileNameCnt = fileNameArr.length;
                DeployResultInfo patchDeployInfo = DeployUtil.getDeployResultInfo(deployResultList, fileNameArr[0]);
                if (patchDeployInfo == null) {
                    return result;
                }
                List<DeployResultInfo> dmZipDeployInfoList = patchDeployInfo.getSubDeployResultInfoList();
                if (fileNameCnt == 2) {
                    appDeployResult = DeployUtil.getDeployResultInfo(dmZipDeployInfoList, fileNameArr[1]);
                    if (appDeployResult == null) {
                        return result;
                    }
                    appDeployResult.addErrorMsg(errMsg);
                    DeployUtil.updateParentDeployResult(patchDeployInfo, appDeployResult);
                    continue;
                }
                if (fileNameCnt != 3) continue;
                DeployResultInfo dmZipDeployInfo = DeployUtil.getDeployResultInfo(dmZipDeployInfoList, fileNameArr[1]);
                List<DeployResultInfo> dmEntryDeployInfoList = dmZipDeployInfo.getSubDeployResultInfoList();
                appDeployResult = DeployUtil.getDeployResultInfo(dmEntryDeployInfoList, fileNameArr[2]);
                DeployUtil.updateParentDeployResult(dmZipDeployInfo, appDeployResult);
                DeployUtil.updateParentDeployResult(patchDeployInfo, dmZipDeployInfo);
            }
        }
        if (!notExist.isEmpty()) {
            result.put("detail", deployResultList.stream().map(SerializationUtils::toJsonString).collect(Collectors.toList()));
            return result;
        }
        ArrayList<String> runtimeFormIdList = new ArrayList<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!tempRecord.pageInfo.isEmpty()) {
            DeployUtil.deployPageMeta(arrayList, runtimeFormIdList, deployResultList, logId, tempRecord);
        }
        if (!tempRecord.rebuildPageInfos.isEmpty() || !tempRecord.rebuildAppInfos.isEmpty()) {
            DeployUtil.rebuildMetaData(runtimeFormIdList, deployResultList, tempRecord);
        }
        if (tempRecord.scriptInfo.size() > 0) {
            DeployUtil.deployScript(deployResultList, tempRecord);
        }
        if (tempRecord.wfInfo.size() > 0) {
            DeployUtil.deployWorkflow(deployResultList, tempRecord);
        }
        if (tempRecord.botpInfo.size() > 0) {
            DeployUtil.deployBotp(deployResultList, tempRecord);
        }
        if (!tempRecord.scheduleInfo.isEmpty()) {
            DeployUtil.deploySchedule(deployResultList, tempRecord);
        }
        if (!arrayList.isEmpty()) {
            DeployUtil.updateRelationOfPageAndScript(arrayList);
        }
        result.put("detail", deployResultList.stream().map(SerializationUtils::toJsonString).collect(Collectors.toList()));
        return result;
    }

    private static void updateRelationOfPageAndScript(List<String> designformIdList) {
        SqlBuilder sb = new SqlBuilder();
        sb.append("delete from t_meta_scriptrelpage where ", new Object[0]).appendIn("fpageid", designformIdList.toArray());
        DB.execute((DBRoute)DBRoute.meta, (SqlBuilder)sb);
        HashMap<String, HashMap<String, Plugin>> datas = new HashMap<String, HashMap<String, Plugin>>();
        int count = 0;
        for (String id : designformIdList) {
            try {
                FormAp formAp;
                FormMetadata metadata = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
                if (metadata == null || StringUtils.equals((CharSequence)"bos_devp_pagerelscript", (CharSequence)(formAp = metadata.getRootAp()).getKey())) continue;
                HashMap<String, Plugin> ksIds = new HashMap<String, Plugin>();
                DeployUtil.addKSRefId(ksIds, formAp.getPlugins());
                if (formAp instanceof BillFormAp) {
                    List plugins;
                    BillFormAp bfAp = (BillFormAp)formAp;
                    FormMetadata meta = bfAp.getListMeta();
                    if (meta != null) {
                        plugins = meta.getRootAp().getPlugins();
                        DeployUtil.addKSRefId(ksIds, plugins);
                    }
                    if ((meta = bfAp.getMobListMeta()) != null) {
                        plugins = meta.getRootAp().getPlugins();
                        DeployUtil.addKSRefId(ksIds, plugins);
                    }
                    if ((meta = bfAp.getMobMeta()) != null) {
                        plugins = meta.getRootAp().getPlugins();
                        DeployUtil.addKSRefId(ksIds, plugins);
                    }
                }
                datas.put(metadata.getId(), ksIds);
                count += ksIds.size();
            }
            catch (Exception e) {
                DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u6784\u5efa\u811a\u672c\u5f15\u7528\u5173\u7cfb\u5f02\u5e38,formId=%1$s,msg=%2$s", (String)"DeployUtil_13", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), id, e.getMessage(), e));
            }
        }
        if (count == 0) {
            return;
        }
        Object[] objs = new DynamicObject[count];
        long[] pkids = DB.genGlobalLongIds((int)count);
        if (datas.size() != 0) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((URL)DeployScriptBinder.class.getResource("/SystemEntity/ScriptRelPageEntity.xml"));
            int i = 0;
            for (Map.Entry it : datas.entrySet()) {
                for (Map.Entry sub : ((Map)it.getValue()).entrySet()) {
                    DynamicObject obj = new DynamicObject((DynamicObjectType)mainEntityType);
                    obj.set("id", (Object)pkids[i]);
                    obj.set("pageid", it.getKey());
                    obj.set("scriptid", sub.getKey());
                    obj.set("enable", (Object)(((Plugin)sub.getValue()).isEnabled() ? "1" : "0"));
                    objs[i] = obj;
                    ++i;
                }
            }
            BusinessDataWriter.save((IDataEntityType)mainEntityType, (Object[])objs);
        }
    }

    private static void addKSRefId(Map<String, Plugin> ksIds, List<Plugin> list) {
        for (int i = 0; i < list.size(); ++i) {
            Plugin plugin = list.get(i);
            if (1 != plugin.getType()) continue;
            ksIds.put(plugin.getFpk(), plugin);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DeployResultInfo getDeployFileContent(String patchName, String patchUrl, TempRecord tempRecord) {
        Throwable throwable;
        DeployResultInfo patchDeployInfo = new DeployResultInfo(patchName);
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        try (InputStream inputStream = cache.getInputStream(patchUrl);){
            throwable = null;
            try (ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
                if (zipInputStream.getNextEntry() == null) {
                    String errMsg = ResManager.loadKDString((String)"\u8865\u4e01\u6587\u4ef6\u6709\u8bef\uff0c\u4e0d\u5305\u542b\u4efb\u4f55\u53ef\u90e8\u7f72\u7684\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"DeployUtil_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
                    patchDeployInfo.addErrorMsg(errMsg);
                    DeployUtil.setErrorLog(errMsg);
                    DeployResultInfo deployResultInfo = patchDeployInfo;
                    return deployResultInfo;
                }
            }
            catch (Throwable errMsg) {
                throwable = errMsg;
                throw errMsg;
            }
        }
        catch (Exception e) {
            String errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            patchDeployInfo.addErrorMsg(errMsg);
            DeployUtil.setErrorLog(errMsg);
            return patchDeployInfo;
        }
        tempRecord.patchNameSet.add(patchName);
        HashSet<String> dmZipSet = new HashSet<String>();
        tempRecord.dmZipFileMap.put(patchName, dmZipSet);
        try {
            throwable = null;
            try (InputStream inStream = cache.getInputStream(patchUrl);
                 ZipInputStream zipInputStream = new ZipInputStream(inStream);){
                ZipEntry zipEntry;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    Object errMsgObj;
                    boolean isReadFileSuccess;
                    String content;
                    if (zipEntry.isDirectory()) continue;
                    String zipEntryFileName = zipEntry.getName();
                    zipEntryFileName = zipEntryFileName.replace(File.separator, "/");
                    DeployResultInfo zipEntryDeployInfo = new DeployResultInfo(zipEntryFileName);
                    DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u8bfb\u53d6\u8865\u4e01 %1$s \u4e2d\u6587\u4ef6 %2$s \u7684\u5185\u5bb9", (String)"DeployUtil_44", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), patchName, zipEntryFileName));
                    if ("kdpkgs.xml".equals(zipEntryFileName)) continue;
                    if ("errorInfo.txt".equals(zipEntryFileName)) {
                        content = AppPackageUtil.readFileContent(zipInputStream);
                        String errMsg = StringUtils.join((Object[])new String[]{String.format(ResManager.loadKDString((String)"\u5b89\u88c5\u5305\u5b58\u5728\u9519\u8bef\u65e5\u5fd7errorInfo.txt\u3002\u8be6\u60c5\u5982\u4e0b\uff1a%s", (String)"DeployUtil_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), content), System.lineSeparator()});
                        patchDeployInfo.addWarnMsg(errMsg);
                        DeployUtil.setErrorLog(errMsg);
                        continue;
                    }
                    if ("appInfo.xml".equals(zipEntryFileName)) {
                        content = AppPackageUtil.readFileContent(zipInputStream);
                        Document document = SAXReaderUtil.parseText((String)content);
                        List nodeList = document.selectNodes("/AppDataModel/AppSeq/@id");
                        for (Node node : nodeList) {
                            Attribute attr = (Attribute)node;
                            String selectAppNum = attr.getStringValue();
                            DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"dm\u76ee\u5f55\u4e0b\u5143\u6570\u636e\u8865\u4e01\u5305\u6267\u884c\u987a\u5e8f: \u7b2c%1$s\u4e2a: %2$s", (String)"DeployUtil_14", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), nodeList.indexOf(node), selectAppNum));
                            tempRecord.dmZipDeploySequenceSet.add(selectAppNum);
                        }
                        continue;
                    }
                    if (zipEntryFileName.startsWith("jar") && zipEntryFileName.endsWith(".zip") || zipEntryFileName.startsWith("res") && zipEntryFileName.endsWith(".zip")) continue;
                    if (zipEntryFileName.endsWith(".zip") && zipEntryFileName.startsWith("dm")) {
                        String dmZipFileFullName = String.format("%1$s@%2$s", patchName, zipEntryFileName);
                        dmZipSet.add(dmZipFileFullName);
                        try {
                            ZipEntry dmZipEntry;
                            byte[] ret = AppPackageUtil.readFileContentToByteArr(zipInputStream);
                            ZipInputStream dmZipIn = new ZipInputStream(new ByteArrayInputStream(ret));
                            while ((dmZipEntry = dmZipIn.getNextEntry()) != null) {
                                Object errMsgObj2;
                                boolean isReadDmZipEntryFileSuccess;
                                String dmZipEntryFileName;
                                if (dmZipEntry.isDirectory() || (dmZipEntryFileName = dmZipEntry.getName()).contains("filelist.txt")) continue;
                                dmZipEntryFileName = dmZipEntryFileName.replace(File.separator, "/");
                                DeployResultInfo dmZipEntryDeployInfo = new DeployResultInfo(dmZipEntryFileName);
                                DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u8bfb\u53d6\u5143\u6570\u636e\u8865\u4e01(%1$s)\u4e2d\u6587\u4ef6 %2$s \u7684\u5185\u5bb9...", (String)"DeployUtil_15", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), zipEntryFileName, dmZipEntryFileName));
                                boolean isIgnore = false;
                                try {
                                    Map<String, Object> retMap = DeployUtil.getMetadataContent(dmZipFileFullName, dmZipEntryFileName, dmZipIn, tempRecord);
                                    isReadDmZipEntryFileSuccess = Boolean.parseBoolean(retMap.get("success").toString());
                                    errMsgObj2 = retMap.get("message");
                                    isIgnore = Boolean.parseBoolean(retMap.get("ignore").toString());
                                }
                                catch (Exception e) {
                                    isReadDmZipEntryFileSuccess = false;
                                    errMsgObj2 = String.format(ResManager.loadKDString((String)"\u8865\u4e01\u5305\u8bfb\u53d6\u5931\u8d25\uff0c\u8be6\u60c5\u5982\u4e0b\uff1a%s", (String)"DeployUtil_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                                    DeployUtil.setErrorLog(errMsgObj2.toString());
                                }
                                if (!isIgnore) {
                                    zipEntryDeployInfo.addSubDeployResultInfo(dmZipEntryDeployInfo);
                                    DeployUtil.updateParentDeployResult(zipEntryDeployInfo, isReadDmZipEntryFileSuccess);
                                }
                                if (isReadDmZipEntryFileSuccess) continue;
                                dmZipEntryDeployInfo.addErrorMsg(errMsgObj2.toString());
                                DeployUtil.updateParentDeployResult(zipEntryDeployInfo, isReadDmZipEntryFileSuccess);
                                patchDeployInfo.addErrorMsg(errMsgObj2.toString());
                                DeployResultInfo deployResultInfo = patchDeployInfo;
                                return deployResultInfo;
                            }
                        }
                        catch (Exception e) {
                            String errMsg = String.format(ResManager.loadKDString((String)"\u8865\u4e01\u5305\u8bfb\u53d6\u5931\u8d25\uff0c\u8be6\u60c5\u5982\u4e0b\uff1a%s", (String)"DeployUtil_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                            DeployUtil.setErrorLog(errMsg);
                            zipEntryDeployInfo.addErrorMsg(errMsg);
                        }
                        patchDeployInfo.addSubDeployResultInfo(zipEntryDeployInfo);
                        DeployUtil.updateParentDeployResult(patchDeployInfo, zipEntryDeployInfo);
                        continue;
                    }
                    boolean isIgnore = false;
                    try {
                        Map<String, Object> retMap = DeployUtil.getMetadataContent(patchName, zipEntryFileName, zipInputStream, tempRecord);
                        isReadFileSuccess = Boolean.parseBoolean(retMap.get("success").toString());
                        errMsgObj = retMap.get("message");
                        isIgnore = Boolean.parseBoolean(retMap.get("ignore").toString());
                    }
                    catch (Exception e) {
                        isReadFileSuccess = false;
                        errMsgObj = String.format(ResManager.loadKDString((String)"\u8865\u4e01\u5305\u8bfb\u53d6\u5931\u8d25\uff0c\u8be6\u60c5\u5982\u4e0b\uff1a%s", (String)"DeployUtil_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                        DeployUtil.setErrorLog(errMsgObj.toString());
                    }
                    if (isIgnore) {
                        if (errMsgObj != null) {
                            zipEntryDeployInfo.addWarnMsg(errMsgObj.toString());
                        } else {
                            DeployUtil.setInfoLog(String.format("/*DeployUtil*/ deploy file:%s ,isIgnore=true,errMsg is null", zipEntryFileName));
                        }
                    }
                    patchDeployInfo.addSubDeployResultInfo(zipEntryDeployInfo);
                    DeployUtil.updateParentDeployResult(patchDeployInfo, zipEntryDeployInfo);
                    if (isReadFileSuccess) continue;
                    if (errMsgObj != null) {
                        zipEntryDeployInfo.addErrorMsg(errMsgObj.toString());
                    } else {
                        DeployUtil.setInfoLog(String.format("/*DeployUtil*/ faild to read file %s,but errMsg is null", zipEntryFileName));
                    }
                    DeployResultInfo deployResultInfo = patchDeployInfo;
                    return deployResultInfo;
                }
                DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u5171\u8bfb\u53d6\u5230\u8865\u4e01\u5305%1$s\u4e2ddm\u76ee\u5f55\u4e0b\u542b\u6709%2$s\u4e2a\u5143\u6570\u636e\u8865\u4e01\u5305", (String)"DeployUtil_16", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), patchName, dmZipSet.size()));
                return patchDeployInfo;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Exception e) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u8865\u4e01\u5305\u8bfb\u53d6\u5931\u8d25\uff0c\u8be6\u60c5\u5982\u4e0b\uff1a%s", (String)"DeployUtil_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            DeployUtil.setErrorLog(errMsg);
            patchDeployInfo.addErrorMsg(errMsg);
        }
        return patchDeployInfo;
    }

    private static Map<String, Object> getMetadataContent(String dmZipFileFullName, String fileName, ZipInputStream zipInputStream, TempRecord tempRecord) throws IOException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", true);
        resultMap.put("ignore", false);
        String fileContent = AppPackageUtil.readFileContent(zipInputStream);
        if (StringUtils.isBlank((CharSequence)fileContent)) {
            resultMap.put("success", false);
            resultMap.put("message", String.format(ResManager.loadKDString((String)"\u8865\u4e01\u8bfb\u53d6\u5931\u8d25\uff0c\u6587\u4ef6\u201c%s\u201d\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"DeployUtil_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), fileName));
            return resultMap;
        }
        String fileFullName = DeployUtil.updateDeployFileMap(dmZipFileFullName, fileName, tempRecord);
        if (fileName.endsWith("app") || fileName.endsWith("appx")) {
            tempRecord.appInfo.put(fileFullName, fileContent);
            if (fileName.endsWith("app")) {
                Map<String, Object> retMap = DeployUtil.validateAppIndustry(fileContent, tempRecord);
                resultMap.put("success", retMap.get("isequal"));
                if (!Boolean.parseBoolean(retMap.get("isequal").toString())) {
                    resultMap.put("message", retMap.get("message"));
                }
            }
        } else if (fileName.endsWith("cld") || fileName.endsWith("cldx")) {
            tempRecord.cloudInfo.put(fileFullName, fileContent);
        } else if (fileName.endsWith("dym") || fileName.endsWith("dymx")) {
            tempRecord.pageInfo.put(fileFullName, fileContent);
            if (fileName.endsWith("dym")) {
                DcxmlSerializer serializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
                serializer.setColloctionIgnorePKValue(true);
                DeployMetadata deployNew = (DeployMetadata)serializer.deserializeFromString(fileContent, null);
                String bizAppId = deployNew.getBizappId();
                tempRecord.sourceAppIds.put(fileFullName, Collections.singletonList(bizAppId));
            }
        } else if (fileName.endsWith("ks") || fileName.endsWith(".ts")) {
            tempRecord.scriptInfo.put(fileFullName, fileContent);
            DcxmlSerializer serializer = new DcxmlSerializer(DeployScript.getDCBinder());
            serializer.setColloctionIgnorePKValue(true);
            DeployScript deployNew = (DeployScript)serializer.deserializeFromString(fileContent, null);
            List designDatas = deployNew.getScripts();
            ArrayList<String> appIdList = new ArrayList<String>(designDatas.size());
            for (DynamicObject dyn : designDatas) {
                String bizAppId = dyn.getString("bizappid");
                appIdList.add(bizAppId);
            }
            tempRecord.sourceAppIds.put(fileFullName, appIdList);
        } else if (fileName.endsWith("process")) {
            tempRecord.wfInfo.put(fileFullName, fileContent);
        } else if (fileName.endsWith("cr") || fileName.endsWith("crx") || fileName.endsWith("wb") || fileName.endsWith("wbx")) {
            tempRecord.botpInfo.put(fileFullName, fileContent);
            DcxmlSerializer serializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
            serializer.setColloctionIgnorePKValue(true);
            DeployMetadata deployNew = (DeployMetadata)serializer.deserializeFromString(fileContent, null);
            if (fileName.endsWith("cr")) {
                DesignConvertRuleMeta designConvertRuleMeta = (DesignConvertRuleMeta)deployNew.getDesignMetas().get(0);
                String bizAppId = designConvertRuleMeta.getBizappId();
                tempRecord.sourceAppIds.put(fileFullName, Collections.singletonList(bizAppId));
            } else if (fileName.endsWith("wb")) {
                DesignWriteBackRuleMeta designWriteBackRuleMeta = (DesignWriteBackRuleMeta)deployNew.getDesignMetas().get(0);
                String bizAppId = designWriteBackRuleMeta.getBizappId();
                tempRecord.sourceAppIds.put(fileFullName, Collections.singletonList(bizAppId));
            }
        } else if (fileName.contains(DBSCHEMA) && fileName.endsWith("sql")) {
            if (!DeployUtil.isIgnoreSql()) {
                tempRecord.dbschemaSqlInfo.put(fileFullName, fileContent);
            }
        } else if (fileName.contains(PREINSDATA) && fileName.endsWith("sql")) {
            if (!DeployUtil.isIgnoreSql()) {
                tempRecord.preinsdataSqlInfo.put(fileFullName, fileContent);
            }
        } else if (fileName.endsWith(".xml") && !fileName.contains("t_bas_cardconfig") && !fileName.equals("appInfo.xml")) {
            if (fileName.endsWith("datamodel.xml")) {
                tempRecord.dataModelXmlInfo.put(fileFullName, fileContent);
            } else {
                tempRecord.appXMLInfo.put(fileFullName, fileContent);
            }
            resultMap.put("ignore", true);
        } else if (fileName.contains("t_bas_cardconfig") && fileName.endsWith(".xml")) {
            tempRecord.portalSchemaInfo.put(fileFullName, fileContent);
        } else if (fileName.endsWith("schdata")) {
            tempRecord.scheduleInfo.put(fileFullName, fileContent);
        } else {
            resultMap.put("ignore", true);
            resultMap.put("message", String.format(ResManager.loadKDString((String)"\u540e\u7f00\u7c7b\u578b\u4e3a\u201c%s\u201d\u7684\u6587\u4ef6\u4e0d\u652f\u6301\u5728\u5f00\u53d1\u5e73\u53f0\u5bfc\u5165\u3002", (String)"DeployUtil_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), fileName.substring(fileName.lastIndexOf(".") + 1)));
        }
        DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u5230\u6587\u4ef6%1$s\u7684\u5185\u5bb9, \u957f\u5ea6: %2$s", (String)"DeployUtil_17", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), fileFullName, fileContent.length()));
        return resultMap;
    }

    private static String updateDeployFileMap(String dmZipFileFullName, String deployFileName, TempRecord tempRecord) {
        String fullFileName = deployFileName;
        if (StringUtils.isNotBlank((CharSequence)dmZipFileFullName)) {
            fullFileName = String.format("%1$s@%2$s", dmZipFileFullName, deployFileName);
            DeployUtil.addValue(tempRecord.deployFileMap, dmZipFileFullName, fullFileName);
        }
        return fullFileName;
    }

    private static void addValue(Map<String, Set<String>> map, String key, String newVal) {
        Set<String> oldValSet = map.get(key);
        if (oldValSet == null || oldValSet.isEmpty()) {
            oldValSet = new HashSet<String>();
        }
        oldValSet.add(newVal);
        map.put(key, oldValSet);
    }

    private static Map<String, Object> validateAppIndustry(String content, TempRecord tempRecord) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("isequal", true);
        DcxmlSerializer serializer = new DcxmlSerializer(DeployAppMetadata.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        DeployAppMetadata deployNew = (DeployAppMetadata)serializer.deserializeFromString(content, null);
        DesignAppMeta designAppMeta = (DesignAppMeta)deployNew.getDesignMetas().get(0);
        if (designAppMeta.getIndustryId() != null) {
            long bizAppIndustry = designAppMeta.getIndustryId();
            long cloudIndustry = BusinessDataServiceHelper.loadSingleFromCache((Object)tempRecord.defaultCldId, (String)"bos_devportal_bizcloud", (String)"industry").getLong("industry_id");
            if (cloudIndustry != 0L && bizAppIndustry != 0L && bizAppIndustry != cloudIndustry) {
                resultMap.put("isequal", false);
                resultMap.put("message", ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u7684\u884c\u4e1a\u4e0e\u4e91\u7684\u884c\u4e1a\u4e0d\u4e00\u81f4\u3002", (String)"DeployUtil_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            }
        }
        return resultMap;
    }

    private static boolean isIgnoreSql() {
        Map map = ParameterReader.loadPublicParameterFromCache();
        return map.get("ignoresql") != null && (Boolean)map.get("ignoresql") != false;
    }

    private static void updateParentDeployResult(DeployResultInfo parentResult, boolean isSubSuccess) {
        String subResult;
        String string = subResult = isSubSuccess ? DeployResultEnum.SUCCESS.getCode() : DeployResultEnum.FAIL.getCode();
        if (StringUtils.equalsIgnoreCase((CharSequence)parentResult.getResult(), (CharSequence)DeployResultEnum.SUCCESS.getCode())) {
            parentResult.setResult(subResult);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)parentResult.getResult(), (CharSequence)DeployResultEnum.WARN.getCode()) && StringUtils.equalsIgnoreCase((CharSequence)subResult, (CharSequence)DeployResultEnum.FAIL.getCode())) {
            parentResult.setResult(subResult);
        }
    }

    private static void updateParentDeployResult(DeployResultInfo parentResultInfo, DeployResultInfo subResultInfo) {
        if (parentResultInfo == null || subResultInfo == null) {
            return;
        }
        String subResult = subResultInfo.getResult();
        if (StringUtils.equalsIgnoreCase((CharSequence)parentResultInfo.getResult(), (CharSequence)DeployResultEnum.SUCCESS.getCode())) {
            parentResultInfo.setResult(subResult);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)parentResultInfo.getResult(), (CharSequence)DeployResultEnum.WARN.getCode()) && StringUtils.equalsIgnoreCase((CharSequence)subResult, (CharSequence)DeployResultEnum.FAIL.getCode())) {
            parentResultInfo.setResult(subResult);
        }
    }

    private static void deploySqlFile(String fileType, List<DeployResultInfo> deployResultList, TempRecord tempRecord) {
        for (String patchName : tempRecord.patchNameSet) {
            DeployResultInfo patchDeployInfo = DeployUtil.getDeployResultInfo(deployResultList, patchName);
            if (patchDeployInfo == null) {
                return;
            }
            try {
                List<DeployResultInfo> dmZipDeployInfoList = patchDeployInfo.getSubDeployResultInfoList();
                Set dmZipSet = (Set)tempRecord.dmZipFileMap.get(patchName);
                DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u8865\u4e01\u6587\u4ef6%1$s\u4e2d\u8bfb\u53d6\u5230%2$s\u4e2a\u5143\u6570\u636e\u8865\u4e01\u5305(dm\u76ee\u5f55\u4e0b\u7684\u538b\u7f29\u5305)", (String)"DeployUtil_18", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), patchName, dmZipSet.size()));
                for (String dmZipName : dmZipSet) {
                    DeployResultInfo dmZipDeployInfo = DeployUtil.getDeployResultInfo(dmZipDeployInfoList, dmZipName.substring(dmZipName.lastIndexOf("@") + 1));
                    if (dmZipDeployInfo == null) {
                        return;
                    }
                    List<DeployResultInfo> dmEntryDeployInfoList = dmZipDeployInfo.getSubDeployResultInfoList();
                    Set deployFileSet = (Set)tempRecord.deployFileMap.get(dmZipName);
                    for (String deployFileFullName : deployFileSet) {
                        if (!deployFileFullName.endsWith("datamodel.xml")) continue;
                        String datamodelXmlContent = (String)tempRecord.dataModelXmlInfo.get(deployFileFullName);
                        DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u5230\u6587\u4ef6%1$s\u7684\u5927\u5c0f\u4e3a: %2$s", (String)"DeployUtil_19", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), deployFileFullName, datamodelXmlContent.length()));
                        List<Map<String, String>> appXmlPathList = AppPackageUtil.getAppXmlPathByDataModelXml(datamodelXmlContent);
                        for (Map<String, String> appXmlPathMap : appXmlPathList) {
                            String appXmlPath = appXmlPathMap.get("appxmlpath");
                            String appXmlFullPath = String.format("%1$s@%2$s", dmZipName, appXmlPath);
                            appXmlFullPath = appXmlFullPath.replace(File.separator, "/");
                            String appXmlContent = (String)tempRecord.appXMLInfo.get(appXmlFullPath);
                            if (StringUtils.isBlank((CharSequence)appXmlContent)) continue;
                            DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u5230\u6587\u4ef6%1$s\u7684\u5927\u5c0f\u4e3a: %2$s", (String)"DeployUtil_19", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), appXmlFullPath, appXmlContent.length()));
                            String version = appXmlPathMap.get("version");
                            String appNum = appXmlPathMap.get("appname");
                            String pkname = appXmlPathMap.get("pkname");
                            List<Map<String, String>> sqlFileList = AppPackageUtil.paraseAppXml(appXmlContent);
                            for (Map<String, String> sqlFileMap : sqlFileList) {
                                tempRecord.seq = tempRecord.seq < 0 ? tempRecord.seq + 10000 : tempRecord.seq;
                                String sqlFileRelativePath = sqlFileMap.get("sqlfilepath");
                                String sqlFileName = null;
                                if (!sqlFileRelativePath.contains(fileType)) continue;
                                sqlFileName = sqlFileRelativePath.substring(fileType.length() + 1);
                                String type = sqlFileMap.get("type");
                                String separator = sqlFileMap.get("separator");
                                String dbKey = sqlFileMap.get("dbkey");
                                String errorLevel = sqlFileMap.get("errorlevel");
                                String plugin = sqlFileMap.get("plugin");
                                String funcAppPath = appXmlPath.substring(0, appXmlPath.lastIndexOf("/"));
                                String sqlFilePath = String.format("%1$s%2$s%3$s", funcAppPath, File.separator, sqlFileRelativePath);
                                sqlFilePath = sqlFilePath.replace(File.separator, "/");
                                String sqlFileFullPath = String.format("%1$s@%2$s", dmZipName, sqlFilePath);
                                sqlFileFullPath = sqlFileFullPath.replace(File.separator, "/");
                                String sqlFileContent = "";
                                if (StringUtils.equalsIgnoreCase((CharSequence)DBSCHEMA, (CharSequence)fileType)) {
                                    sqlFileContent = (String)tempRecord.dbschemaSqlInfo.get(sqlFileFullPath);
                                } else if (StringUtils.equalsIgnoreCase((CharSequence)PREINSDATA, (CharSequence)fileType)) {
                                    sqlFileContent = (String)tempRecord.preinsdataSqlInfo.get(sqlFileFullPath);
                                }
                                DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u5230\u6587\u4ef6%1$s\u7684\u5927\u5c0f\u4e3a: %2$s", (String)"DeployUtil_19", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), sqlFileFullPath, sqlFileContent.length()));
                                DeployResultInfo deployResult = DeployUtil.getDeployResultInfo(dmEntryDeployInfoList, sqlFilePath);
                                if (deployResult == null) {
                                    return;
                                }
                                try {
                                    Object errorInfo;
                                    Map<String, Object> returnMap = AppPackageUtil.deploySqlFile(sqlFileContent, sqlFileName, type, separator, dbKey, errorLevel, plugin, pkname, appNum, version);
                                    if (Boolean.parseBoolean(returnMap.get("success").toString())) {
                                        errorInfo = (String)returnMap.get("errorinfo");
                                        String checkInfo = (String)returnMap.get("checkinfo");
                                        if (StringUtils.isBlank((CharSequence)errorInfo) && StringUtils.isBlank((CharSequence)checkInfo)) {
                                            deployResult.setResult(DeployResultEnum.SUCCESS.getCode());
                                        } else if (StringUtils.isNotBlank((CharSequence)checkInfo)) {
                                            String info = ResManager.loadKDString((String)"\u5df2\u88ab\u6267\u884c\u8fc7", (String)"DeployUtil_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
                                            if (checkInfo.contains(info)) {
                                                deployResult.addWarnMsg(returnMap.get("checkinfo").toString());
                                            } else {
                                                deployResult.addInfo(returnMap.get("checkinfo").toString());
                                            }
                                        }
                                    } else {
                                        errorInfo = tempRecord;
                                        ((TempRecord)errorInfo).seq = ((TempRecord)errorInfo).seq - 10000;
                                        String resString = JSON.toJSONString(returnMap);
                                        deployResult.addErrorMsg(resString);
                                    }
                                }
                                catch (Exception e) {
                                    String errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                                    DeployUtil.setErrorLog(errMsg);
                                    TempRecord tempRecord2 = tempRecord;
                                    tempRecord2.seq = tempRecord2.seq - 10000;
                                    deployResult.addErrorMsg(errMsg);
                                }
                                deployResult.setSeq(tempRecord.seq++);
                                DeployUtil.updateParentDeployResult(dmZipDeployInfo, deployResult);
                            }
                        }
                    }
                    DeployUtil.updateParentDeployResult(patchDeployInfo, dmZipDeployInfo);
                }
            }
            catch (Exception e) {
                String errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                patchDeployInfo.addErrorMsg(errMsg);
                DeployUtil.setErrorLog(errMsg);
            }
        }
    }

    private static DeployResultInfo getDeployResultInfo(List<DeployResultInfo> resultList, String fileName) {
        DeployResultInfo deployResultInfo = null;
        for (DeployResultInfo result : resultList) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)result.getFileName(), (CharSequence)fileName)) continue;
            deployResultInfo = result;
            break;
        }
        if (deployResultInfo == null) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u5904\u7406%s\u7684\u8fd4\u56de\u7ed3\u679c\u65f6\u51fa\u73b0\u9519\u8bef\u3002", (String)"DeployUtil_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), fileName);
            DeployUtil.setErrorLog(errMsg);
        }
        return deployResultInfo;
    }

    private static void deployPortalSchema(List<DeployResultInfo> deployResultList, TempRecord tempRecord) {
        PreInsDataScriptWriter preInsDataScriptWriter = new PreInsDataScriptWriter();
        for (Map.Entry entry : tempRecord.portalSchemaInfo.entrySet()) {
            tempRecord.seq = tempRecord.seq < 0 ? tempRecord.seq + 10000 : tempRecord.seq;
            String fullPortalSchemaName = (String)entry.getKey();
            DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u90e8\u7f72\u5e94\u7528\u5de5\u4f5c\u53f0/\u9996\u9875\u65b9\u6848 %s", (String)"DeployUtil_20", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), fullPortalSchemaName));
            String[] fileNameArr = fullPortalSchemaName.split("@");
            DeployResultInfo patchDeployInfo = DeployUtil.getDeployResultInfo(deployResultList, fileNameArr[0]);
            if (patchDeployInfo == null) {
                return;
            }
            List<DeployResultInfo> dmZipDeployInfoList = patchDeployInfo.getSubDeployResultInfoList();
            DeployResultInfo dmZipDeployInfo = DeployUtil.getDeployResultInfo(dmZipDeployInfoList, fileNameArr[1]);
            if (dmZipDeployInfo == null) {
                return;
            }
            String fileName = "";
            fileName = fileNameArr.length < 3 ? fileNameArr[1].substring(fileNameArr[1].lastIndexOf("/") + 1) : fileNameArr[2];
            List<DeployResultInfo> dmEntryDeployInfoList = dmZipDeployInfo.getSubDeployResultInfoList();
            DeployResultInfo portalSchemaDeployResult = DeployUtil.getDeployResultInfo(dmEntryDeployInfoList, fileName);
            if (portalSchemaDeployResult == null) {
                return;
            }
            String portalSchemaContent = (String)entry.getValue();
            ByteArrayInputStream portalSchemaStream = new ByteArrayInputStream(portalSchemaContent.getBytes(StandardCharsets.UTF_8));
            try {
                preInsDataScriptWriter.insertPreInsData((InputStream)portalSchemaStream);
                DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u5e94\u7528\u5de5\u4f5c\u53f0/\u9996\u9875\u65b9\u6848 %s \u90e8\u7f72\u6210\u529f", (String)"DeployUtil_21", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), fullPortalSchemaName));
            }
            catch (JAXBException e) {
                String errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)((Object)e));
                portalSchemaDeployResult.addErrorMsg(errMsg);
                TempRecord tempRecord2 = tempRecord;
                tempRecord2.seq = tempRecord2.seq - 10000;
                DeployUtil.updateParentDeployResult(dmZipDeployInfo, portalSchemaDeployResult);
                DeployUtil.updateParentDeployResult(patchDeployInfo, dmZipDeployInfo);
                DeployUtil.setErrorLog(errMsg);
            }
            portalSchemaDeployResult.setSeq(tempRecord.seq++);
        }
    }

    private static void deployCloudMeta(List<DeployResultInfo> deployResultList, TempRecord tempRecord) {
        for (Map.Entry entry : tempRecord.cloudInfo.entrySet()) {
            tempRecord.seq = tempRecord.seq < 0 ? tempRecord.seq + 10000 : tempRecord.seq;
            String fullCloudName = (String)entry.getKey();
            DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u90e8\u7f72\u4e1a\u52a1\u4e91 %s", (String)"DeployUtil_22", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), fullCloudName));
            String[] fileNameArr = fullCloudName.split("@");
            DeployResultInfo patchDeployInfo = DeployUtil.getDeployResultInfo(deployResultList, fileNameArr[0]);
            if (patchDeployInfo == null) {
                return;
            }
            List<DeployResultInfo> dmZipDeployInfoList = patchDeployInfo.getSubDeployResultInfoList();
            DeployResultInfo dmZipDeployInfo = DeployUtil.getDeployResultInfo(dmZipDeployInfoList, fileNameArr[1]);
            if (dmZipDeployInfo == null) {
                return;
            }
            List<DeployResultInfo> dmEntryDeployInfoList = dmZipDeployInfo.getSubDeployResultInfoList();
            if (dmEntryDeployInfoList == null) {
                return;
            }
            DeployResultInfo cldDeployResult = DeployUtil.getDeployResultInfo(dmEntryDeployInfoList, fileNameArr[2]);
            if (cldDeployResult == null) {
                return;
            }
            String cloudContent = (String)entry.getValue();
            try {
                MetadataDao.deployCloud((String)cloudContent);
                DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91 %s \u90e8\u7f72\u6210\u529f", (String)"DeployUtil_23", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), fullCloudName));
            }
            catch (Exception e) {
                String errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                cldDeployResult.addErrorMsg(errMsg);
                TempRecord tempRecord2 = tempRecord;
                tempRecord2.seq = tempRecord2.seq - 10000;
                DeployUtil.updateParentDeployResult(dmZipDeployInfo, cldDeployResult);
                DeployUtil.updateParentDeployResult(patchDeployInfo, dmZipDeployInfo);
                DeployUtil.setErrorLog(errMsg);
            }
            cldDeployResult.setSeq(tempRecord.seq++);
        }
    }

    private static void deployAppMeta(List<DeployResultInfo> deployResultList, long logId, TempRecord tempRecord) {
        HashMap<String, String> refAppIdMap = new HashMap<String, String>();
        for (String string : tempRecord.patchNameSet) {
            DeployResultInfo patchDeployInfo = DeployUtil.getDeployResultInfo(deployResultList, string);
            if (patchDeployInfo == null) {
                return;
            }
            try {
                List<DeployResultInfo> dmZipDeployInfoList = patchDeployInfo.getSubDeployResultInfoList();
                Set dmZipSet = (Set)tempRecord.dmZipFileMap.get(string);
                HashSet<String> dmZipDeploySet = new HashSet<String>();
                if (tempRecord.dmZipDeploySequenceSet.isEmpty()) {
                    dmZipDeploySet.addAll(dmZipSet);
                } else {
                    block5: for (String dmZipSeq : tempRecord.dmZipDeploySequenceSet) {
                        for (String dmZipName : dmZipSet) {
                            if (!dmZipName.endsWith(String.format("%s-dm.zip", dmZipSeq))) continue;
                            dmZipDeploySet.add(dmZipName);
                            continue block5;
                        }
                    }
                }
                for (String dmZipName : dmZipDeploySet) {
                    DeployResultInfo dmZipDeployInfo = DeployUtil.getDeployResultInfo(dmZipDeployInfoList, dmZipName.substring(dmZipName.lastIndexOf("@") + 1));
                    if (dmZipDeployInfo == null) {
                        return;
                    }
                    List<DeployResultInfo> dmEntryDeployInfoList = dmZipDeployInfo.getSubDeployResultInfoList();
                    Set deployFileSet = (Set)tempRecord.deployFileMap.get(dmZipName);
                    for (String deployFileFullName : deployFileSet) {
                        if (!deployFileFullName.endsWith("datamodel.xml")) continue;
                        String datamodelXmlContent = (String)tempRecord.dataModelXmlInfo.get(deployFileFullName);
                        DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u5230datamodel.xml\u6587\u4ef6: %1$s, \u5927\u5c0f\u4e3a: %2$s", (String)"DeployUtil_24", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), deployFileFullName, datamodelXmlContent.length()));
                        List<Map<String, String>> appXmlPathList = AppPackageUtil.getAppXmlPathByDataModelXml(datamodelXmlContent);
                        for (Map<String, String> appXmlPathMap : appXmlPathList) {
                            String appXmlFilePath = appXmlPathMap.get("appxmlpath");
                            String funcAppPath = appXmlFilePath.substring(0, appXmlFilePath.lastIndexOf("/"));
                            String appFileName = appXmlFilePath.substring(appXmlFilePath.lastIndexOf("/") + 1).replace(".xml", "");
                            String appFilePath = String.format("%1$s%2$s%3$s%4$s%5$s", funcAppPath, Character.valueOf(File.separatorChar), METADATA, Character.valueOf(File.separatorChar), appFileName);
                            String appFileFullPath = String.format("%1$s@%2$s", dmZipName, appFilePath);
                            appFileFullPath = appFileFullPath.replace(File.separator, "/");
                            for (Map.Entry entry : tempRecord.appInfo.entrySet()) {
                                tempRecord.seq = tempRecord.seq < 0 ? tempRecord.seq + 10000 : tempRecord.seq;
                                String appFullName = (String)entry.getKey();
                                if (!appFullName.contains(appFileFullPath)) continue;
                                DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u90e8\u7f72\u4e1a\u52a1\u5e94\u7528 %s", (String)"DeployUtil_25", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), appFullName));
                                boolean appMetaError = false;
                                DeployResultInfo appDeployResult = DeployUtil.getDeployResultInfo(dmEntryDeployInfoList, appFullName.split("@")[2]);
                                if (appDeployResult == null) {
                                    return;
                                }
                                try {
                                    String appContent = (String)entry.getValue();
                                    DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u5230\u6587\u4ef6%1$s\u7684\u5927\u5c0f\u4e3a: %2$s", (String)"DeployUtil_19", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), appFileFullPath, appContent.length()));
                                    String logAppId = "";
                                    if (appFullName.endsWith(".app")) {
                                        DcxmlSerializer serializer = new DcxmlSerializer(DeployAppMetadata.getDCBinder());
                                        serializer.setColloctionIgnorePKValue(true);
                                        DeployAppMetadata deployNew = (DeployAppMetadata)serializer.deserializeFromString(appContent, null);
                                        DesignAppMeta designAppMeta = (DesignAppMeta)deployNew.getDesignMetas().get(0);
                                        String bizAppId = deployNew.getId();
                                        logAppId = deployNew.getId();
                                        String designCloudId = designAppMeta.getBizCloudID();
                                        String refAppId = designAppMeta.getRefAppId();
                                        if (StringUtils.isNotBlank((CharSequence)refAppId)) {
                                            refAppIdMap.put(appFullName, refAppId);
                                        }
                                        tempRecord.rebuildAppInfos.put(appFullName, bizAppId);
                                        if (designAppMeta.getIsv() != null) {
                                            String exportAppIsv = designAppMeta.getIsv();
                                            String importCountIsv = ISVService.getISVInfo().getId();
                                            boolean cloudExist = QueryServiceHelper.exists((String)"bos_devportal_bizcloud", (Object)designCloudId);
                                            if (cloudExist && !exportAppIsv.equals(importCountIsv)) {
                                                tempRecord.defaultCldId = designCloudId;
                                            }
                                        }
                                    }
                                    AppMetaServiceHelper.deployAppMetadata((String)appContent, (String)tempRecord.defaultCldId);
                                    if (StringUtils.isNotBlank((CharSequence)logAppId)) {
                                        DeployUtil.writeAppLog(logAppId, logId);
                                    }
                                    DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91 %s \u90e8\u7f72\u6210\u529f", (String)"DeployUtil_26", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), appFullName));
                                }
                                catch (Exception e) {
                                    String errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                                    appDeployResult.addErrorMsg(errMsg);
                                    appMetaError = true;
                                    TempRecord tempRecord2 = tempRecord;
                                    tempRecord2.seq = tempRecord2.seq - 10000;
                                    DeployUtil.updateParentDeployResult(dmZipDeployInfo, appDeployResult);
                                    DeployUtil.setErrorLog(errMsg);
                                }
                                appDeployResult.setSeq(tempRecord.seq++);
                                if (!appMetaError) continue;
                                return;
                            }
                        }
                    }
                    DeployUtil.updateParentDeployResult(patchDeployInfo, dmZipDeployInfo);
                }
            }
            catch (Exception e) {
                String errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                patchDeployInfo.addErrorMsg(errMsg);
                DeployUtil.setErrorLog(errMsg);
            }
        }
        for (Map.Entry entry : refAppIdMap.entrySet()) {
            boolean isRefAppExist;
            String appFullName = (String)entry.getKey();
            String refAppId = (String)entry.getValue();
            if (!StringUtils.isNotBlank((CharSequence)refAppId) || (isRefAppExist = QueryServiceHelper.exists((String)"bos_devportal_bizapp", (Object)refAppId))) continue;
            String warnMsg = String.format(ResManager.loadKDString((String)"\u5173\u8054\u5e94\u7528%1$s\u4e0d\u5b58\u5728\u3002", (String)"DeployUtil_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), refAppId);
            logger.warn(warnMsg);
            String[] fileNameArr = appFullName.split("@");
            DeployResultInfo patchDeployInfo = DeployUtil.getDeployResultInfo(deployResultList, fileNameArr[0]);
            if (patchDeployInfo == null) {
                return;
            }
            List<DeployResultInfo> dmZipDeployInfoList = patchDeployInfo.getSubDeployResultInfoList();
            DeployResultInfo dmZipDeployInfo = DeployUtil.getDeployResultInfo(dmZipDeployInfoList, fileNameArr[1]);
            if (dmZipDeployInfo == null) {
                return;
            }
            List<DeployResultInfo> dmEntryDeployInfoList = dmZipDeployInfo.getSubDeployResultInfoList();
            DeployResultInfo appDeployResult = DeployUtil.getDeployResultInfo(dmEntryDeployInfoList, fileNameArr[3]);
            if (appDeployResult == null) {
                return;
            }
            appDeployResult.addWarnMsg(warnMsg);
        }
    }

    private static void deployPageMeta(List<String> designFormIds, List<String> rebuildformIdList, List<DeployResultInfo> deployResultList, long logId, TempRecord tempRecord) {
        for (Map.Entry entry : tempRecord.pageInfo.entrySet()) {
            tempRecord.seq = tempRecord.seq < 0 ? tempRecord.seq + 10000 : tempRecord.seq;
            String pageFullName = (String)entry.getKey();
            DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u90e8\u7f72\u9875\u9762\u5143\u6570\u636e %s", (String)"DeployUtil_27", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), pageFullName));
            String[] fileNameArr = pageFullName.split("@");
            int fileNameCnt = fileNameArr.length;
            DeployResultInfo patchDeployInfo = DeployUtil.getDeployResultInfo(deployResultList, fileNameArr[0]);
            if (patchDeployInfo == null) {
                return;
            }
            List<DeployResultInfo> dmZipDeployInfoList = patchDeployInfo.getSubDeployResultInfoList();
            DeployResultInfo dmZipDeployInfo = null;
            DeployResultInfo pageDeployResult = null;
            if (fileNameCnt == 2) {
                pageDeployResult = DeployUtil.getDeployResultInfo(dmZipDeployInfoList, fileNameArr[1]);
            } else if (fileNameCnt == 3) {
                dmZipDeployInfo = DeployUtil.getDeployResultInfo(dmZipDeployInfoList, fileNameArr[1]);
                if (dmZipDeployInfo == null) {
                    return;
                }
                List<DeployResultInfo> dmEntryDeployInfoList = dmZipDeployInfo.getSubDeployResultInfoList();
                if (CollectionUtils.isEmpty(dmEntryDeployInfoList)) {
                    return;
                }
                pageDeployResult = DeployUtil.getDeployResultInfo(dmEntryDeployInfoList, fileNameArr[2]);
            }
            String pageContent = (String)entry.getValue();
            try {
                MetadataDao.deployMetadata((String)pageContent, null, null);
                if (pageFullName.endsWith(".dym")) {
                    DcxmlSerializer serializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
                    serializer.setColloctionIgnorePKValue(true);
                    DeployMetadata deployNew = (DeployMetadata)serializer.deserializeFromString(pageContent, null);
                    String masterId = deployNew.getMasterId();
                    String formId = deployNew.getId();
                    designFormIds.add(formId);
                    if (StringUtils.isNotBlank((CharSequence)masterId)) {
                        rebuildformIdList.add(masterId);
                    } else {
                        rebuildformIdList.add(formId);
                    }
                    tempRecord.rebuildPageInfos.put(pageFullName, masterId);
                    DeployUtil.writeLog(formId, null, pageContent, logId);
                }
                DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u9875\u9762 %s \u90e8\u7f72\u6210\u529f", (String)"DeployUtil_28", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), pageFullName));
            }
            catch (Exception e) {
                String errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                if (null != pageDeployResult) {
                    pageDeployResult.addErrorMsg(errMsg);
                }
                TempRecord tempRecord2 = tempRecord;
                tempRecord2.seq = tempRecord2.seq - 10000;
                if (fileNameCnt == 2) {
                    DeployUtil.updateParentDeployResult(patchDeployInfo, pageDeployResult);
                } else if (fileNameCnt == 3) {
                    DeployUtil.updateParentDeployResult(dmZipDeployInfo, pageDeployResult);
                    DeployUtil.updateParentDeployResult(patchDeployInfo, dmZipDeployInfo);
                }
                DeployUtil.setErrorLog(errMsg);
            }
            if (null == pageDeployResult) continue;
            pageDeployResult.setSeq(tempRecord.seq++);
        }
    }

    private static void writeLog(String formId, String formNumber, String content, long logId) {
        try {
            if (StringUtils.isBlank((CharSequence)formId)) {
                DeployUtil.setInfoLog(ResManager.loadKDString((String)"\u4ece\u5e94\u7528\u5bfc\u5165\u5143\u6570\u636eID\u4e3a\u7a7a\uff0c\u9000\u51fa.", (String)"DeployUtil_29", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            MetadataLogService logService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
            logService.addMetaLog(formId, formNumber, content, (int)MetaLogType.AppImport.getValue(), logId, (int)MetaType.Form.getValue());
        }
        catch (Exception e) {
            DeployUtil.setErrorLog(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5143\u6570\u636e\u65e5\u5fd7\u5931\u8d25\uff0cerr\uff1a%s", (String)"DeployUtil_30", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
    }

    private static void writeAppLog(String appId, long logId) {
        try {
            MetadataLogService logService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
            logService.addAppMetaLog(appId, (int)MetaLogType.AppImport.getValue(), logId, (int)MetaType.App.getValue());
        }
        catch (Exception e) {
            DeployUtil.setInfoLog(e.getMessage());
        }
    }

    private static void rebuildMetaData(List<String> formIdList, List<DeployResultInfo> deployResultList, TempRecord tempRecord) {
        TempRecord tempRecord2;
        String errMsg;
        DeployResultInfo patchDeployInfo;
        MetadataDao.clearSubRuntimeMeta(formIdList);
        for (Map.Entry entry : tempRecord.rebuildPageInfos.entrySet()) {
            tempRecord.seq = tempRecord.seq < 0 ? tempRecord.seq + 10000 : tempRecord.seq;
            String rebuildPageFullName = (String)entry.getKey();
            DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u91cd\u5efa\u9875\u9762\u5143\u6570\u636e: %s", (String)"DeployUtil_31", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), rebuildPageFullName));
            String[] fileNameArr = rebuildPageFullName.split("@");
            int fileNameCnt = fileNameArr.length;
            patchDeployInfo = DeployUtil.getDeployResultInfo(deployResultList, fileNameArr[0]);
            if (patchDeployInfo == null) {
                return;
            }
            DeployResultInfo dmZipDeployInfo = null;
            DeployResultInfo pageRebuildResult = null;
            if (fileNameCnt == 2) {
                pageRebuildResult = new DeployResultInfo(String.format("%s@rebuild", fileNameArr[1]));
                patchDeployInfo.addSubDeployResultInfo(pageRebuildResult);
            } else if (fileNameCnt == 3) {
                pageRebuildResult = new DeployResultInfo(String.format("%s@rebuild", fileNameArr[2]));
                List<DeployResultInfo> dmZipDeployInfoList = patchDeployInfo.getSubDeployResultInfoList();
                dmZipDeployInfo = DeployUtil.getDeployResultInfo(dmZipDeployInfoList, fileNameArr[1]);
                dmZipDeployInfo.addSubDeployResultInfo(pageRebuildResult);
            } else {
                pageRebuildResult = new DeployResultInfo();
                dmZipDeployInfo = new DeployResultInfo();
            }
            String masterId = (String)entry.getValue();
            try {
                MetadataDao.rebuildRuntimeMetaById((String)masterId);
                DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u9875\u9762 %s \u91cd\u5efa\u5143\u6570\u636e\u6210\u529f", (String)"DeployUtil_32", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), rebuildPageFullName));
            }
            catch (Exception e) {
                errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                pageRebuildResult.addErrorMsg(errMsg);
                tempRecord2 = tempRecord;
                tempRecord2.seq = tempRecord2.seq - 10000;
                if (fileNameCnt == 2) {
                    DeployUtil.updateParentDeployResult(patchDeployInfo, pageRebuildResult);
                } else if (fileNameCnt == 3) {
                    DeployUtil.updateParentDeployResult(dmZipDeployInfo, pageRebuildResult);
                    DeployUtil.updateParentDeployResult(patchDeployInfo, dmZipDeployInfo);
                }
                DeployUtil.setErrorLog(errMsg);
            }
            pageRebuildResult.setSeq(tempRecord.seq++);
        }
        for (Map.Entry entry : tempRecord.rebuildAppInfos.entrySet()) {
            tempRecord.seq = tempRecord.seq < 0 ? tempRecord.seq + 10000 : tempRecord.seq;
            String rebuildAppFullName = (String)entry.getKey();
            String rebuildAppId = (String)entry.getValue();
            DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u91cd\u5efa\u5e94\u7528\u5143\u6570\u636e: %s", (String)"DeployUtil_33", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), rebuildAppFullName));
            String[] fileNameArr = rebuildAppFullName.split("@");
            patchDeployInfo = DeployUtil.getDeployResultInfo(deployResultList, fileNameArr[0]);
            if (patchDeployInfo == null) {
                return;
            }
            DeployResultInfo appRebuildResult = new DeployResultInfo(String.format("%s@rebuild", fileNameArr[2]));
            List<DeployResultInfo> dmZipDeployInfoList = patchDeployInfo.getSubDeployResultInfoList();
            DeployResultInfo dmZipDeployInfo = DeployUtil.getDeployResultInfo(dmZipDeployInfoList, fileNameArr[1]);
            if (dmZipDeployInfo == null) {
                return;
            }
            dmZipDeployInfo.addSubDeployResultInfo(appRebuildResult);
            try {
                MetadataDao.rebuildRuntimeAppMetaById((String)rebuildAppId);
                DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u5e94\u7528 %s \u90e8\u7f72\u6210\u529f", (String)"DeployUtil_34", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), rebuildAppFullName));
            }
            catch (Exception e) {
                errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                appRebuildResult.addErrorMsg(errMsg);
                tempRecord2 = tempRecord;
                tempRecord2.seq = tempRecord2.seq - 10000;
                DeployUtil.updateParentDeployResult(dmZipDeployInfo, appRebuildResult);
                DeployUtil.updateParentDeployResult(patchDeployInfo, dmZipDeployInfo);
                DeployUtil.setErrorLog(errMsg);
            }
            appRebuildResult.setSeq(tempRecord.seq++);
        }
    }

    private static void deployScript(List<DeployResultInfo> deployResultList, TempRecord tempRecord) {
        for (Map.Entry entry : tempRecord.scriptInfo.entrySet()) {
            tempRecord.seq = tempRecord.seq < 0 ? tempRecord.seq + 10000 : tempRecord.seq;
            String scriptName = (String)entry.getKey();
            DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u90e8\u7f72\u811a\u672c\u63d2\u4ef6 %s", (String)"DeployUtil_35", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), scriptName));
            String[] fileNameArr = scriptName.split("@");
            DeployResultInfo patchDeployInfo = DeployUtil.getDeployResultInfo(deployResultList, fileNameArr[0]);
            if (patchDeployInfo == null) {
                return;
            }
            List<DeployResultInfo> dmZipDeployInfoList = patchDeployInfo.getSubDeployResultInfoList();
            DeployResultInfo dmZipDeployInfo = DeployUtil.getDeployResultInfo(dmZipDeployInfoList, fileNameArr[1]);
            if (dmZipDeployInfo == null) {
                return;
            }
            List<DeployResultInfo> dmEntryDeployInfoList = dmZipDeployInfo.getSubDeployResultInfoList();
            DeployResultInfo scriptDeployResult = DeployUtil.getDeployResultInfo(dmEntryDeployInfoList, fileNameArr[2]);
            if (null == scriptDeployResult) {
                return;
            }
            String scriptContent = (String)entry.getValue();
            try {
                MetadataDao.deployScript((String)scriptContent, null, null);
                DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u811a\u672c\u63d2\u4ef6 %s \u90e8\u7f72\u6210\u529f", (String)"DeployUtil_36", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), scriptName));
            }
            catch (Exception e) {
                String errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                scriptDeployResult.addErrorMsg(errMsg);
                TempRecord tempRecord2 = tempRecord;
                tempRecord2.seq = tempRecord2.seq - 10000;
                DeployUtil.updateParentDeployResult(dmZipDeployInfo, scriptDeployResult);
                DeployUtil.updateParentDeployResult(patchDeployInfo, dmZipDeployInfo);
                DeployUtil.setErrorLog(errMsg);
            }
            scriptDeployResult.setSeq(tempRecord.seq++);
        }
    }

    private static void deployWorkflow(List<DeployResultInfo> deployResultList, TempRecord tempRecord) {
        for (Map.Entry entry : tempRecord.wfInfo.entrySet()) {
            tempRecord.seq = tempRecord.seq < 0 ? tempRecord.seq + 10000 : tempRecord.seq;
            String wfName = (String)entry.getKey();
            DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u90e8\u7f72\u5de5\u4f5c\u6d41 %s", (String)"DeployUtil_37", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), wfName));
            String[] fileNameArr = wfName.split("@");
            DeployResultInfo patchDeployInfo = DeployUtil.getDeployResultInfo(deployResultList, fileNameArr[0]);
            if (null == patchDeployInfo) {
                return;
            }
            List<DeployResultInfo> dmZipDeployInfoList = patchDeployInfo.getSubDeployResultInfoList();
            DeployResultInfo dmZipDeployInfo = DeployUtil.getDeployResultInfo(dmZipDeployInfoList, fileNameArr[1]);
            if (null == dmZipDeployInfo) {
                return;
            }
            List<DeployResultInfo> dmEntryDeployInfoList = dmZipDeployInfo.getSubDeployResultInfoList();
            if (CollectionUtils.isEmpty(dmEntryDeployInfoList)) {
                return;
            }
            DeployResultInfo wfDeployResult = DeployUtil.getDeployResultInfo(dmEntryDeployInfoList, fileNameArr[2]);
            if (null == wfDeployResult) {
                return;
            }
            String wfContent = (String)entry.getValue();
            try {
                WorkflowServiceHelper.deployModel((String)wfContent);
                DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41 %s \u90e8\u7f72\u6210\u529f", (String)"DeployUtil_38", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), wfName));
            }
            catch (Exception e) {
                String errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                wfDeployResult.addErrorMsg(errMsg);
                TempRecord tempRecord2 = tempRecord;
                tempRecord2.seq = tempRecord2.seq - 10000;
                DeployUtil.updateParentDeployResult(dmZipDeployInfo, wfDeployResult);
                DeployUtil.updateParentDeployResult(patchDeployInfo, dmZipDeployInfo);
                DeployUtil.setErrorLog(errMsg);
            }
            wfDeployResult.setSeq(tempRecord.seq++);
        }
    }

    private static void deployBotp(List<DeployResultInfo> deployResultList, TempRecord tempRecord) {
        for (Map.Entry entry : tempRecord.botpInfo.entrySet()) {
            tempRecord.seq = tempRecord.seq < 0 ? tempRecord.seq + 10000 : tempRecord.seq;
            String botpName = (String)entry.getKey();
            DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u90e8\u7f72\u5355\u636e\u8f6c\u6362 %s", (String)"DeployUtil_39", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), botpName));
            String[] fileNameArr = botpName.split("@");
            int fileNameCnt = fileNameArr.length;
            DeployResultInfo patchDeployInfo = DeployUtil.getDeployResultInfo(deployResultList, fileNameArr[0]);
            if (null == patchDeployInfo) {
                return;
            }
            List<DeployResultInfo> dmZipDeployInfoList = patchDeployInfo.getSubDeployResultInfoList();
            DeployResultInfo dmZipDeployInfo = null;
            DeployResultInfo botpDeployResult = null;
            if (fileNameCnt == 2) {
                botpDeployResult = DeployUtil.getDeployResultInfo(dmZipDeployInfoList, fileNameArr[1]);
            } else if (fileNameCnt == 3) {
                dmZipDeployInfo = DeployUtil.getDeployResultInfo(dmZipDeployInfoList, fileNameArr[1]);
                if (null == dmZipDeployInfo) {
                    return;
                }
                List<DeployResultInfo> dmEntryDeployInfoList = dmZipDeployInfo.getSubDeployResultInfoList();
                botpDeployResult = DeployUtil.getDeployResultInfo(dmEntryDeployInfoList, fileNameArr[2]);
            }
            String botpContent = (String)entry.getValue();
            try {
                MetadataDao.deployMetadata((String)botpContent, null, null);
                DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u5355\u636e\u8f6c\u6362 %s \u90e8\u7f72\u6210\u529f", (String)"DeployUtil_40", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), botpName));
            }
            catch (Exception e) {
                String errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                if (null != botpDeployResult) {
                    botpDeployResult.addErrorMsg(errMsg);
                }
                TempRecord tempRecord2 = tempRecord;
                tempRecord2.seq = tempRecord2.seq - 10000;
                if (fileNameCnt == 2) {
                    DeployUtil.updateParentDeployResult(patchDeployInfo, botpDeployResult);
                } else if (fileNameCnt == 3) {
                    DeployUtil.updateParentDeployResult(dmZipDeployInfo, botpDeployResult);
                    DeployUtil.updateParentDeployResult(patchDeployInfo, dmZipDeployInfo);
                }
                DeployUtil.setErrorLog(errMsg);
            }
            if (null == botpDeployResult) continue;
            botpDeployResult.setSeq(tempRecord.seq++);
        }
    }

    private static void deploySchedule(List<DeployResultInfo> deployResultList, TempRecord tempRecord) {
        ScheduleModelBinder binder = new ScheduleModelBinder();
        DcxmlSerializer dcxmlSerializer = new DcxmlSerializer((DcBinder)binder);
        dcxmlSerializer.setNeedDBIgnore(true);
        IScheduleDeployService service = (IScheduleDeployService)ServiceFactory.getService((String)"IScheduleDeployService");
        for (Map.Entry entry : tempRecord.scheduleInfo.entrySet()) {
            tempRecord.seq = tempRecord.seq < 0 ? tempRecord.seq + 10000 : tempRecord.seq;
            String scheduleFileName = (String)entry.getKey();
            DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u90e8\u7f72\u540e\u53f0\u8c03\u5ea6\u4efb\u52a1 %s", (String)"DeployUtil_41", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), scheduleFileName));
            String[] fileNameArr = scheduleFileName.split("@");
            DeployResultInfo patchDeployInfo = DeployUtil.getDeployResultInfo(deployResultList, fileNameArr[0]);
            if (null == patchDeployInfo) {
                return;
            }
            List<DeployResultInfo> dmZipDeployInfoList = patchDeployInfo.getSubDeployResultInfoList();
            DeployResultInfo dmZipDeployInfo = DeployUtil.getDeployResultInfo(dmZipDeployInfoList, fileNameArr[1]);
            if (null == dmZipDeployInfo) {
                return;
            }
            List<DeployResultInfo> dmEntryDeployInfoList = dmZipDeployInfo.getSubDeployResultInfoList();
            DeployResultInfo scheduleDeployResult = DeployUtil.getDeployResultInfo(dmEntryDeployInfoList, fileNameArr[2]);
            if (null == scheduleDeployResult) {
                return;
            }
            String scheduleContent = (String)entry.getValue();
            try {
                ArrayList<DeployScheduleEntity> scheduleList = new ArrayList<DeployScheduleEntity>(1);
                DeployScheduleEntity entity = (DeployScheduleEntity)dcxmlSerializer.deserializeFromString(scheduleContent, null);
                scheduleList.add(entity);
                Map result = service.deploy(scheduleList);
                String resultStr = ResManager.loadKDString((String)"\u6210\u529f", (String)"DeployUtil_10", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
                if (!Boolean.parseBoolean(String.valueOf(result.get("success")))) {
                    scheduleDeployResult.setResult(DeployResultEnum.FAIL.getCode());
                    scheduleDeployResult.addErrorMsg(result.get("msg").toString());
                    resultStr = ResManager.loadKDString((String)"\u5931\u8d25", (String)"DeployUtil_11", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
                }
                DeployUtil.setInfoLog(String.format(ResManager.loadKDString((String)"\u540e\u53f0\u8c03\u5ea6\u4efb\u52a1 %1$s \u90e8\u7f72%2$s", (String)"DeployUtil_42", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), scheduleFileName, resultStr));
            }
            catch (Exception e) {
                String errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                scheduleDeployResult.addErrorMsg(errMsg);
                TempRecord tempRecord2 = tempRecord;
                tempRecord2.seq = tempRecord2.seq - 10000;
                DeployUtil.updateParentDeployResult(dmZipDeployInfo, scheduleDeployResult);
                DeployUtil.updateParentDeployResult(patchDeployInfo, dmZipDeployInfo);
                DeployUtil.setErrorLog(String.format(ResManager.loadKDString((String)"\u6587\u4ef6 %1$s \u90e8\u7f72\u5931\u8d25\uff1a %2$s", (String)"DeployUtil_43", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), scheduleFileName, errMsg));
            }
            scheduleDeployResult.setSeq(tempRecord.seq++);
        }
    }

    private static void setErrorLog(String errorMes) {
        logger.error(errorMes);
    }

    private static void setInfoLog(String infoMes) {
        logger.info(infoMes);
    }

    private static class TempRecord {
        private String defaultCldId = null;
        private int seq = 0;
        private Map<String, List<String>> sourceAppIds = new HashMap<String, List<String>>();
        private Set<String> patchNameSet = new HashSet<String>();
        private Map<String, Set<String>> dmZipFileMap = new HashMap<String, Set<String>>();
        private Map<String, Set<String>> deployFileMap = new HashMap<String, Set<String>>();
        private Map<String, String> dataModelXmlInfo = new HashMap<String, String>();
        private Map<String, String> appXMLInfo = new HashMap<String, String>();
        private Map<String, String> cloudInfo = new HashMap<String, String>();
        private Map<String, String> appInfo = new HashMap<String, String>();
        private Map<String, String> rebuildAppInfos = new HashMap<String, String>();
        private Map<String, String> pageInfo = new HashMap<String, String>();
        private Map<String, String> rebuildPageInfos = new HashMap<String, String>();
        private Map<String, String> dbschemaSqlInfo = new HashMap<String, String>();
        private Map<String, String> preinsdataSqlInfo = new HashMap<String, String>();
        private Map<String, String> scriptInfo = new HashMap<String, String>();
        private Map<String, String> wfInfo = new HashMap<String, String>();
        private Map<String, String> botpInfo = new HashMap<String, String>();
        private Map<String, String> portalSchemaInfo = new HashMap<String, String>();
        private Map<String, String> scheduleInfo = new HashMap<String, String>();
        private Set<String> dmZipDeploySequenceSet = new HashSet<String>();

        private TempRecord() {
        }
    }
}

