/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.bizobjext;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.designer.dao.DesignerData;
import kd.bos.devportal.bizobjext.BizObjExtStatusEnum;
import kd.bos.devportal.bizobjext.MyBizObjExtUtils;
import kd.bos.devportal.bizobjext.imports.BillModel;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.devportal.util.MetaDataUtil;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.ID;
import kd.bos.isv.ISVService;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.FormmetaDaoPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.devportal.AppWriter;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.xdb.util.DateUtil;

public class MyBizObjExtList
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener,
EntryGridBindDataListener {
    private static final Log log = LogFactory.getLog(MyBizObjExtList.class);
    public static final String SYSTEM_TYPE = "bos-devportal-plugin";
    private static final String EXT_ENTITY_NAME = "bos_bizextmeta";
    private static final String KEY_SUCCESS = "success";
    private static final String KEY_ERRORS = "errors";
    private static final String Key_TreeView = "treeviewap";
    protected static final String Key_EntryEntity = "entryentity";
    protected static final String Key_Search = "search";
    protected static final String Key_SearchCloud = "searchcloud";
    private static final String CacheId_TreeNodes = "nodes";
    private static final String CacheId_CurrNode = "currnode";
    protected static final String CacheId_CurrView = "currview";
    protected static final String Key_root_Id = "0";
    protected static final String Key_ID = "id";
    private static final String Key_Name = "name";
    private static final String Key_BizCloud = "bizCloud";
    protected static final String Key_CardId = "cardid";
    private static final String Key_CardName = "cardname";
    protected static final String Key_CardStatus = "cardstatus";
    protected static final String Key_View_Card = "1";
    private static final String PREFIX_APP = "app_";
    private static final String PREFIX_CLOUD = "cloud_";
    private static final String Key_modeltype = "modeltype";
    private static final String Key_ModelTypeName = "modeltypename";
    private static final String Key_modifier = "modifier";
    private static final String Key_modifydate = "modifydate";
    private static final String Key_parentid = "parentid";
    private static final String Key_TestButton = "testbutton";
    private static final String Key_PublishButton = "publishbutton";
    private static final String Key_DeleteButton = "deletebutton";
    private static final String Key_RefreshButton = "refreshbutton";
    private static final String Key_ToBeTestIcon = "tobetested";
    private static final String Key_ToBePublishIcon = "tobereleased";
    private static final String Key_PublishedIcon = "havereleased";
    private TreeNode rootNode;
    protected static final String Key_BizApp_ID = "bizapp_id";
    protected static final String Key_BizAppID = "bizappid";
    protected static final String Key_BizCloudAppName = "bizcloudappname";
    private static final String Key_Fid = "fid";
    private static final String Key_number = "number";
    private static final String Key_Fnumber = "Fnumber";
    private static final String Key_bizapp = "bizapp";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"tbar_main"});
        TreeView tView = (TreeView)this.getControl(Key_TreeView);
        tView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl(Key_Search);
        search.addEnterListener((SearchEnterListener)this);
        Search searchCloud = (Search)this.getControl(Key_SearchCloud);
        searchCloud.addEnterListener((SearchEnterListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl(Key_EntryEntity);
        entryGrid.addItemClickListener((ItemClickListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType old = e.getOriginalEntityType();
        MainEntityType newType = null;
        try {
            newType = (MainEntityType)old.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
        e.setNewEntityType(newType);
    }

    public void afterCreateNewData(EventObject e) {
        TreeNode rootNode = this.buildTreeNodes(null);
        TreeView tView = (TreeView)this.getControl(Key_TreeView);
        tView.addNode(rootNode);
        tView.focusNode(rootNode);
        String bizCloudId = (String)this.getView().getFormShowParameter().getCustomParam("bizcloudId");
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappId");
        if (rootNode.getChildren() != null && rootNode.getChildren().size() > 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"showifempty"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"nodata"});
            this.refreshView(bizCloudId, "", "");
        } else {
            this.showEmptyTip();
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{Key_EntryEntity});
        if (StringUtils.isNotBlank((CharSequence)bizAppId)) {
            this.markTargetPage(bizCloudId, bizAppId);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String bizCloudId = (String)this.getView().getFormShowParameter().getCustomParam("bizcloudId");
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappId");
        this.markTargetPage(bizCloudId, bizAppId);
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String currNodeId;
        String newNodeId = (String)e.getNodeId();
        if (newNodeId.equals(currNodeId = this.getPageCache().get(CacheId_CurrNode))) {
            return;
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(Key_Search, "setSearchCondition", new Object[]{""});
        this.sortOrderChangeToDefault();
        this.refreshView(newNodeId, "", "");
        this.getPageCache().put(CacheId_CurrNode, newNodeId);
    }

    protected TreeNode getRootNode() {
        if (this.rootNode == null) {
            this.buildTreeNodes(null);
        }
        return this.rootNode;
    }

    protected TreeNode buildTreeNodes(List<TreeNode> clouds) {
        if (clouds == null) {
            List<Object> bizObjCloudData = this.getBizObjCloudData();
            if (bizObjCloudData != null && ((ArrayList)bizObjCloudData.get(0)).size() == 0) {
                TreeNode root = new TreeNode();
                root.setId(Key_root_Id);
                String text = ResManager.loadKDString((String)"\u5168\u90e8", (String)"MyBizObjExtList_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                root.setText(text);
                root.setParentid("");
                root.setIsOpened(true);
                root.setChildren(clouds);
                this.rootNode = root;
                return this.rootNode;
            }
            clouds = this.getCloudAndAppNodes(bizObjCloudData);
        }
        TreeNode root = new TreeNode();
        root.setId(Key_root_Id);
        String text = ResManager.loadKDString((String)"\u5168\u90e8", (String)"MyBizObjExtList_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        root.setText(text);
        root.setParentid("");
        root.setIsOpened(true);
        root.setChildren(clouds);
        this.rootNode = root;
        String json = SerializationUtils.toJsonString(clouds);
        this.getPageCache().put(CacheId_TreeNodes, json);
        return root;
    }

    public List<Object> getBizObjCloudData() {
        String sql = "SELECT distinct fbizcloudid,fappid FROM t_meta_bizobj_ext order by fbizcloudid,fappid";
        Object[] param = null;
        ResultSetHandler action = rs -> {
            ArrayList tempIdList = new ArrayList(10);
            while (rs.next()) {
                HashMap<String, String> cloudApp = new HashMap<String, String>();
                cloudApp.put("fbizcloudid", rs.getString("fbizcloudid"));
                cloudApp.put("fappid", rs.getString("fappid"));
                tempIdList.add(cloudApp);
            }
            return Collections.singletonList(tempIdList);
        };
        List appIds = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, param, (ResultSetHandler)action);
        return appIds;
    }

    public void search(SearchEnterEvent e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"showifempty"});
        this.sortOrderChangeToDefault();
        Search search = (Search)e.getSource();
        if (StringUtils.equals((CharSequence)Key_Search, (CharSequence)search.getKey())) {
            ArrayList searchTypeList;
            List searchFields = e.getSearchFields();
            String searchType = "All";
            if (searchFields != null && (searchTypeList = (ArrayList)((Map)searchFields.get(0)).get("fieldName")).size() == 1) {
                searchType = (String)searchTypeList.get(0);
            }
            String searchText = e.getText();
            String currNodeId = this.getPageCache().get(CacheId_CurrNode);
            this.refreshView(currNodeId, searchText, searchType);
            TreeNode root = new TreeNode();
            root.setId(Key_root_Id);
            TreeView tv = (TreeView)this.getControl(Key_TreeView);
            tv.focusNode(root);
        } else if (StringUtils.equals((CharSequence)Key_SearchCloud, (CharSequence)search.getKey())) {
            String searchText = e.getText();
            List<TreeNode> clouds = this.getAllCloudAndAppForSearch(searchText);
            TreeNode rootNode = this.buildTreeNodes(clouds);
            TreeView tView = (TreeView)this.getControl(Key_TreeView);
            tView.updateNode(rootNode);
        }
    }

    protected void refreshView() {
        TreeView tv = (TreeView)this.getControl(Key_TreeView);
        String currNodeId = tv.getTreeState().getFocusNodeId();
        this.refreshView(currNodeId, "", "");
    }

    public void refreshView(String nodeId, String searchText, String searchType) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
        if (StringUtils.isNotBlank((CharSequence)nodeId) && !Key_root_Id.equals(nodeId)) {
            if (nodeId.contains(PREFIX_CLOUD)) {
                filters.add(new QFilter("bizcloud", "=", (Object)nodeId.substring(6)));
            } else if (nodeId.contains(PREFIX_APP)) {
                filters.add(new QFilter(Key_bizapp, "=", (Object)nodeId.substring(4)));
            }
        }
        Map<Object, Object> bizObjs = new HashMap();
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            Map billList = new HashMap();
            SqlBuilder sql = new SqlBuilder();
            sql.append(" select  distinct t1.fnumber  from t_meta_formdesign t1 inner join t_meta_formdesign_l  t2 on t1.FID = t2.FID ", new Object[0]).append(" and t2.FLocaleId = ?", new Object[]{Lang.get()}).append("where  (", new Object[0]).append("t1.fid <> t1.fentityid  or t1.fmasterid = ' ')  and  t1.fmodeltype in ('BillFormModel','BaseFormModel') ", new Object[0]);
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                if (Key_number.equalsIgnoreCase(searchType)) {
                    sql.append(" and ( t1.fnumber like ? ", new Object[]{"%" + searchText + "%"});
                } else if (Key_Name.equalsIgnoreCase(searchType)) {
                    sql.append(" and ( t2.fname like ? ", new Object[]{"%" + searchText + "%"});
                } else {
                    sql.append(" and ( t1.fnumber like ? ", new Object[]{"%" + searchText + "%"});
                    sql.append(" or  t2.fname like ? ", new Object[]{"%" + searchText + "%"});
                }
                sql.append(")", new Object[0]);
            }
            sql.append(" order by t1.fnumber", new Object[0]);
            billList = (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sql, rs -> {
                HashMap<String, String> ret = new HashMap<String, String>(16);
                while (rs.next()) {
                    ret.put(rs.getString("fnumber"), rs.getString("fnumber"));
                }
                return ret;
            });
            if (billList.size() > 0) {
                filters.add(new QFilter(Key_number, "in", billList.keySet()));
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"showcards"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"nodata"});
                return;
            }
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"showcards"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"nodata"});
        bizObjs = MyBizObjExtUtils.loadBizObjList(filters);
        this.getModel().deleteEntryData(Key_EntryEntity);
        if (bizObjs == null || bizObjs.isEmpty()) {
            return;
        }
        this.renderCardEntry(bizObjs);
    }

    private List<TreeNode> getCloudAndAppNodes(List<Object> bizObjCloudData) {
        if (bizObjCloudData == null || bizObjCloudData.size() == 0) {
            return new ArrayList<TreeNode>(0);
        }
        HashSet cloudSet = new HashSet();
        HashSet appSet = new HashSet();
        ArrayList cloudAndAppList = (ArrayList)bizObjCloudData.get(0);
        for (HashMap map : cloudAndAppList) {
            cloudSet.add(map.get("fbizcloudid"));
            appSet.add(map.get("fappid"));
        }
        String[] cloudArray = null;
        String[] appArray = null;
        if (cloudSet.size() > 0) {
            cloudArray = new String[cloudSet.size()];
            cloudArray = cloudSet.toArray(cloudArray);
        }
        if (appSet.size() > 0) {
            appArray = new String[appSet.size()];
            appArray = appSet.toArray(appArray);
        }
        TreeNode root = (TreeNode)BizAppServiceHelp.getSubsysTree((String[])cloudArray, (String[])appArray, null, (String)"app", (boolean)false, (boolean)false, (boolean)false);
        List clouds = null;
        if (root != null) {
            clouds = root.getChildren();
        }
        if (clouds == null) {
            return new ArrayList<TreeNode>(0);
        }
        ArrayList<TreeNode> cloudsReslut = new ArrayList<TreeNode>(clouds.size());
        Iterator cloudIterator = clouds.iterator();
        while (cloudIterator.hasNext()) {
            TreeNode cloud = (TreeNode)cloudIterator.next();
            TreeNode cloudNew = new TreeNode();
            cloudNew.setText(cloud.getText());
            String cloudNodeId = PREFIX_CLOUD + cloud.getId();
            cloudNew.setId(cloudNodeId);
            cloudNew.setData((Object)"cloud");
            List apps = cloud.getChildren();
            if (apps == null) {
                cloudIterator.remove();
                continue;
            }
            cloudNew.setChildren(new ArrayList());
            Iterator iterator = apps.iterator();
            while (iterator.hasNext()) {
                TreeNode app;
                TreeNode appNew = app = (TreeNode)iterator.next();
                String appNodeId = PREFIX_APP + app.getId();
                appNew.setId(appNodeId);
                appNew.setParentid(cloudNodeId);
                appNew.setData((Object)"app");
                cloudNew.addChild(appNew);
            }
            cloudsReslut.add(cloudNew);
        }
        return cloudsReslut;
    }

    protected void markTargetPage(String bizCloudId, String bizAppId) {
        if (StringUtils.isNotBlank((CharSequence)bizCloudId)) {
            TreeView tView = (TreeView)this.getControl(Key_TreeView);
            TreeNode node = this.getRootNode().getTreeNode(bizCloudId, 10);
            tView.focusNode(node);
            this.getPageCache().put(CacheId_CurrNode, bizCloudId);
        }
        if (StringUtils.isNotBlank((CharSequence)bizAppId)) {
            String currView = this.getPageCache().get(CacheId_CurrView);
            EntryGrid grid = (EntryGrid)this.getControl(Key_EntryEntity);
            int rowIndex = this.findRowById(Key_EntryEntity, bizAppId);
            grid.selectRows(rowIndex, true);
        }
    }

    private int findRowById(String entryEntityKey, String bizAppId) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryEntityKey);
        String idKey = Key_Fid;
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject info = (DynamicObject)entryEntity.get(i);
            if (!bizAppId.equals(info.getString(idKey))) continue;
            return i;
        }
        return -1;
    }

    private void renderCardEntry(Map<Object, DynamicObject> bizObjs) {
        HashSet<Object> allKeys = new HashSet<Object>(16);
        allKeys.addAll(bizObjs.keySet());
        int rowCount = allKeys.size();
        this.getModel().batchCreateNewEntryRow(Key_EntryEntity, rowCount);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(Key_EntryEntity);
        int index = 0;
        EntryGrid entryGrid = (EntryGrid)this.getControl(Key_EntryEntity);
        for (Map.Entry<Object, DynamicObject> entry : bizObjs.entrySet()) {
            DynamicObject app = entry.getValue();
            DynamicObject row = (DynamicObject)entryEntity.get(index);
            this.renderCardRow(row, app, entryGrid, index);
            ++index;
        }
        this.getView().updateView(Key_EntryEntity);
    }

    private void renderCardRow(DynamicObject row, DynamicObject app, EntryGrid entryGrid, int index) {
        int deployStatus = app.getInt("status");
        if (deployStatus == BizObjExtStatusEnum.INIT.value) {
            MyBizObjExtList.setIconButtonVisible((CardEntry)entryGrid, index, false, false, true, false, false, false, false);
        } else if (deployStatus == BizObjExtStatusEnum.TOBETEST.value) {
            MyBizObjExtList.setIconButtonVisible((CardEntry)entryGrid, index, true, false, true, false, true, false, false);
        } else if (deployStatus == BizObjExtStatusEnum.TOBEPUBLISH.value) {
            MyBizObjExtList.setIconButtonVisible((CardEntry)entryGrid, index, false, true, true, false, false, true, false);
        } else if (deployStatus == BizObjExtStatusEnum.PUBLISHED.value) {
            MyBizObjExtList.setIconButtonVisible((CardEntry)entryGrid, index, false, false, false, true, false, false, true);
        }
        DynamicObject cloud = app.getDynamicObject(Key_BizCloud);
        String cloudName = cloud == null ? null : cloud.getString(Key_Name);
        row.set(Key_CardId, (Object)app.getString(Key_ID));
        row.set(Key_Fid, (Object)app.getString(Key_ID));
        row.set(Key_BizAppID, (Object)app.getString(Key_BizApp_ID));
        DynamicObject bizApp = app.getDynamicObject(Key_bizapp);
        String appName = bizApp == null ? null : bizApp.getString(Key_Name);
        row.set(Key_BizCloudAppName, (Object)(cloudName + "/" + appName));
        QFilter[] formMetaFilters = null;
        QFilter appRelFormFilter = new QFilter(Key_number, "in", (Object)app.getString(Key_number));
        formMetaFilters = new QFilter[]{appRelFormFilter};
        String formMetaFields = "id,number,name,modeltype,version,basedatafield,type,parentid,createdate,modifydate,modifierid,masterid,isextended,isinherit,enabled";
        try (DataSet formMetaDataSet = QueryServiceHelper.queryDataSet((String)"bos_formmeta", (String)"bos_formmeta", (String)formMetaFields, (QFilter[])formMetaFilters, (String)"number asc");){
            for (Row row1 : formMetaDataSet) {
                String name = row1.getString(Key_Name);
                String fnumber = "(" + app.getString(Key_number) + ")";
                row.set(Key_CardName, (Object)(name + fnumber));
                String formId = row1.getString(Key_ID);
                String entityId = row1.getString("basedatafield");
                String modelType = row1.getString(Key_modeltype);
                if (("BillFormModel".equals(modelType) || "BaseFormModel".equals(modelType)) && !formId.equals(entityId)) {
                    row.set(Key_ModelTypeName, (Object)ResManager.loadKDString((String)"\u5e03\u5c40", (String)"MyBizObjExtList_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    continue;
                }
                if ("BillFormModel".equals(modelType)) {
                    row.set(Key_ModelTypeName, (Object)ResManager.loadKDString((String)"\u5355\u636e", (String)"MyBizObjExtList_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    continue;
                }
                if (!"BaseFormModel".equals(modelType)) continue;
                row.set(Key_ModelTypeName, (Object)ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"MyBizObjExtList_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            row.set(Key_CardStatus, (Object)deployStatus);
        }
        if (app.getDynamicObject(Key_modifier) != null) {
            row.set(Key_modifier, app.getDynamicObject(Key_modifier).get(2));
        } else {
            row.set(Key_modifier, (Object)"");
        }
        row.set(Key_modifydate, (Object)DateUtil.getDateFormat((String)"yyyy-MM-dd HH:mm:ss").format(app.getDate(Key_modifydate)));
        row.set(Key_Fnumber, (Object)app.getString(Key_number));
        row.set(Key_modeltype, (Object)app.getString(Key_modeltype));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("orderbyfield".equalsIgnoreCase(e.getProperty().getName())) {
            DynamicObjectCollection entryentity;
            String orderExpr = "modifydate,desc";
            String orderby = (String)this.getModel().getValue("orderbyfield");
            if (!"default".equals(orderby)) {
                if ("modeltypeorder".equals(orderby)) {
                    orderExpr = "modeltype,asc";
                } else if ("statusorder".equals(orderby)) {
                    orderExpr = "cardstatus,asc";
                } else if ("modifierorder".equals(orderby)) {
                    orderExpr = "modifier,asc";
                }
            }
            if ((entryentity = this.getModel().getEntryEntity(Key_EntryEntity)) == null || entryentity.size() == 0) {
                return;
            }
            final String[] orderBys = orderExpr.split(",");
            entryentity.sort((Comparator)new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    String[] s = orderBys;
                    int result = 0;
                    String one = "";
                    String two = "";
                    one = o1.getString(s[0]);
                    result = one.compareTo(two = o2.getString(s[0]));
                    if (result != 0 && !s[1].equals("asc")) {
                        result = -1 * result;
                    }
                    return result;
                }
            });
            this.renderCardEntry(entryentity);
        }
    }

    private void orderChangeRenderCardRow(DynamicObject row, DynamicObject app, EntryGrid entryGrid, int index) {
        int deployStatus = app.getInt(Key_CardStatus);
        if (deployStatus == BizObjExtStatusEnum.INIT.value) {
            MyBizObjExtList.setIconButtonVisible((CardEntry)entryGrid, index, false, false, true, false, false, false, false);
        } else if (deployStatus == BizObjExtStatusEnum.TOBETEST.value) {
            MyBizObjExtList.setIconButtonVisible((CardEntry)entryGrid, index, true, false, true, false, true, false, false);
        } else if (deployStatus == BizObjExtStatusEnum.TOBEPUBLISH.value) {
            MyBizObjExtList.setIconButtonVisible((CardEntry)entryGrid, index, false, true, true, false, false, true, false);
        } else if (deployStatus == BizObjExtStatusEnum.PUBLISHED.value) {
            MyBizObjExtList.setIconButtonVisible((CardEntry)entryGrid, index, false, false, false, true, false, false, true);
        }
        row.set(Key_BizAppID, (Object)app.getString(Key_BizAppID));
        row.set(Key_CardId, (Object)app.getString(Key_CardId));
        row.set(Key_CardStatus, (Object)deployStatus);
        row.set(Key_modeltype, (Object)app.getString(Key_modeltype));
        row.set(Key_ModelTypeName, (Object)app.getString(Key_ModelTypeName));
        row.set(Key_CardName, (Object)app.getString(Key_CardName));
        row.set(Key_modifier, (Object)app.getString(Key_modifier));
        row.set(Key_modifydate, (Object)app.getString(Key_modifydate));
        row.set(Key_Fid, (Object)app.getString(Key_Fid));
        row.set(Key_Fnumber, (Object)app.getString(Key_Fnumber));
        row.set(Key_BizCloudAppName, (Object)app.getString(Key_BizCloudAppName));
    }

    private static void setIconButtonVisible(CardEntry entryGrid, int index, boolean testButtonBoolean, boolean publishButtonBoolean, boolean deleteButtonBoolean, boolean refreshButtonBoolean, boolean toBeTestIconBoolean, boolean toBePublishIconBoolean, boolean publishedIcon) {
        entryGrid.setChildVisible(testButtonBoolean, index, new String[]{Key_TestButton});
        entryGrid.setChildVisible(publishButtonBoolean, index, new String[]{Key_PublishButton});
        entryGrid.setChildVisible(deleteButtonBoolean, index, new String[]{Key_DeleteButton});
        entryGrid.setChildVisible(refreshButtonBoolean, index, new String[]{Key_RefreshButton});
        entryGrid.setChildVisible(toBeTestIconBoolean, index, new String[]{Key_ToBeTestIcon});
        entryGrid.setChildVisible(toBePublishIconBoolean, index, new String[]{Key_ToBePublishIcon});
        entryGrid.setChildVisible(publishedIcon, index, new String[]{Key_PublishedIcon});
        if (!(toBeTestIconBoolean || toBePublishIconBoolean || publishedIcon)) {
            entryGrid.setChildVisible(false, index, new String[]{"billstate"});
        }
    }

    private void renderCardEntry(DynamicObjectCollection dynamicObjectCollection) {
        int rowCount = dynamicObjectCollection.size();
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
            dynamicObjectList.add(dynamicObject);
        }
        this.getModel().deleteEntryData(Key_EntryEntity);
        this.getModel().batchCreateNewEntryRow(Key_EntryEntity, rowCount);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(Key_EntryEntity);
        int index = 0;
        EntryGrid entryGrid = (EntryGrid)this.getControl(Key_EntryEntity);
        Iterator iterator = dynamicObjectList.iterator();
        while (iterator.hasNext()) {
            DynamicObject dynamicObject;
            DynamicObject app = dynamicObject = (DynamicObject)iterator.next();
            DynamicObject row = (DynamicObject)entryEntity.get(index);
            this.orderChangeRenderCardRow(row, app, entryGrid, index);
            ++index;
        }
        this.getView().updateView(Key_EntryEntity);
    }

    private List<TreeNode> getAllCloudAndAppForSearch(String searchText) {
        List<Object> bizObjCloudData = this.getBizObjCloudData();
        List<TreeNode> clouds = this.getCloudAndAppNodes(bizObjCloudData);
        ArrayList<TreeNode> searchResultCloudAndApp = new ArrayList<TreeNode>(10);
        if (StringUtils.isBlank((CharSequence)searchText)) {
            return clouds;
        }
        for (TreeNode node : clouds) {
            String name = node.getText();
            if (!StringUtils.isNotBlank((CharSequence)name)) continue;
            if (name.contains(searchText)) {
                searchResultCloudAndApp.add(node);
                continue;
            }
            if (node.getChildren().size() <= 0) continue;
            ArrayList<TreeNode> cloudChildNode = new ArrayList<TreeNode>(10);
            for (TreeNode appNode : node.getChildren()) {
                String appName = appNode.getText();
                if (!StringUtils.isNotBlank((CharSequence)appName) || !appName.contains(searchText)) continue;
                cloudChildNode.add(appNode);
            }
            if (cloudChildNode.size() <= 0) continue;
            node.getChildren().clear();
            node.setChildren(cloudChildNode);
            searchResultCloudAndApp.add(node);
        }
        return searchResultCloudAndApp;
    }

    private void showEmptyTip() {
        this.getView().setVisible(Boolean.FALSE, new String[]{Key_TreeView});
        this.getView().setVisible(Boolean.FALSE, new String[]{"showcards"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"showifempty"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"nodata"});
    }

    public void refreshTreeAndCard(String fid) {
        TreeNode rootNode = this.buildTreeNodes(null);
        TreeView tView = (TreeView)this.getControl(Key_TreeView);
        tView.addNode(rootNode);
        tView.focusNode(rootNode);
        tView.updateNode(rootNode);
        if (rootNode.getChildren() != null && rootNode.getChildren().size() > 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"showifempty"});
            this.getView().setVisible(Boolean.TRUE, new String[]{Key_TreeView});
            this.getView().setVisible(Boolean.TRUE, new String[]{"showcards"});
            this.getPageCache().put(CacheId_CurrNode, "");
            this.refreshView("", "", "");
        } else {
            this.showEmptyTip();
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{Key_EntryEntity});
        if (StringUtils.isNotBlank((CharSequence)fid)) {
            this.markTargetCard(fid);
        }
    }

    public void refreshSelectedNode() {
        TreeNode rootNode = this.buildTreeNodes(null);
        TreeView tView = (TreeView)this.getControl(Key_TreeView);
        tView.addNode(rootNode);
        tView.focusNode(rootNode);
        tView.updateNode(rootNode);
        String bizCloudId = (String)this.getView().getFormShowParameter().getCustomParam("bizcloudId");
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappId");
        if (rootNode.getChildren().size() > 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"showifempty"});
            this.getView().setVisible(Boolean.TRUE, new String[]{Key_TreeView});
            this.getView().setVisible(Boolean.TRUE, new String[]{"showcards"});
            String currNodeId = this.getPageCache().get(CacheId_CurrNode);
            this.refreshView(currNodeId, "", "");
        } else {
            this.showEmptyTip();
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{Key_EntryEntity});
        if (StringUtils.isNotBlank((CharSequence)bizAppId)) {
            this.markTargetPage(bizCloudId, bizAppId);
        }
    }

    public void reloadForm(String id) {
        log.info("\u5f00\u59cb\u91cd\u65b0\u52a0\u8f7d\u5355\u636e\uff0c\u5355\u636eId={}", (Object)id);
        DynamicObject dynamicObject = this.validateForm(id);
        if (dynamicObject == null) {
            return;
        }
        String number = dynamicObject.getString(Key_number);
        BillModel lastExtBill = this.getLastExtId(number);
        if (lastExtBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u6269\u5c55\u5355\u636e\u5f02\u5e38\uff0c\u8bf7\u6838\u5bf9\u6570\u636e\u3002", (String)"MyBizObjExtList_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            log.warn("The last parallel extension bill of the query bill is empty.Please check the data.fid={},number={}", (Object)id, (Object)number);
            return;
        }
        if (id.equals(lastExtBill.getFid())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u5bf9\u8c61\u5df2\u662f\u6700\u65b0\u6570\u636e\uff0c\u65e0\u9700\u91cd\u65b0\u52a0\u8f7d\u3002", (String)"MyBizObjExtList_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        } else {
            DynamicObject formMeta = BusinessDataServiceHelper.loadSingle((String)"bos_formmeta", (QFilter[])new QFilter[]{new QFilter(Key_number, "=", (Object)number)});
            if (formMeta == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u67e5\u8be2\u5355\u636e\u5143\u6570\u636e\u4fe1\u606f\u3002", (String)"MyBizObjExtList_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                log.debug("No data related to the bill number was retrieved.Bill number\uff1a{}", (Object)number);
                return;
            }
            this.saveFormAndBindForm(formMeta, true);
            this.refreshSelectedNodeData();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u65b0\u52a0\u8f7d\u6210\u529f\u3002", (String)"MyBizObjExtList_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    private DynamicObject validateForm(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u64cd\u4f5c\u3002", (String)"MyBizObjExtList_15", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            log.debug("Failed to reload the extension bill,the fid of the bill was not obtained.");
            return null;
        }
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)EXT_ENTITY_NAME, (String)"number,status", (QFilter[])new QFilter[]{new QFilter(Key_ID, "=", (Object)id)});
        if (dynamicObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u6269\u5c55\u5355\u636e\u4e3a\u7a7a\u3002", (String)"MyBizObjExtList_16", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            log.debug("Failed to reload the extension bill,no data was queried in the bos-bizextmeta entity according to the overloaded fid\u3002fid={}", (Object)id);
            return null;
        }
        String status = dynamicObject.getString("status");
        return dynamicObject;
    }

    protected List<String> selectImportedFormNumber() {
        String sql = "SELECT fnumber FROM t_meta_bizobj_ext ";
        ResultSetHandler action = rs -> {
            ArrayList<String> tempNumberList = new ArrayList<String>(10);
            while (rs.next()) {
                tempNumberList.add(rs.getString("fnumber"));
            }
            return tempNumberList;
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)action);
    }

    protected void saveSelectData(ClosedCallBackEvent evn) {
        if (evn.getReturnData() == null) {
            return;
        }
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)evn.getReturnData();
        int[] rowKeys = selectedRows.getRowKeys();
        if (rowKeys.length == 0) {
            return;
        }
        String fid = (String)selectedRows.get(0).getPrimaryKeyValue();
        DynamicObject formData = BusinessDataServiceHelper.loadSingleFromCache((Object)fid, (String)"bos_formmeta");
        if (formData == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u67e5\u8be2\u5355\u636e\u5143\u6570\u636e\u4fe1\u606f\u3002", (String)"MyBizObjExtList_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            log.warn("\u672a\u83b7\u53d6\u5230\u5355\u636enumber\u7684\u76f8\u5173\u6570\u636e\u3002\u5355\u636eId\uff1a{}", (Object)fid);
            return;
        }
        String number = formData.getString(Key_number);
        if (QueryServiceHelper.exists((String)EXT_ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter(Key_number, "=", (Object)number)})) {
            log.info("The business object has already been imported.{}", (Object)fid);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u5bf9\u8c61\u5df2\u7ecf\u88ab\u5bfc\u5165\u8fc7\u3002", (String)"MyBizObjExtList_13", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        this.saveFormAndBindForm(formData, false);
        this.refreshTreeAndCard(fid);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"MyBizObjExtList_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
    }

    private void saveFormAndBindForm(DynamicObject data, boolean isReload) {
        String entity_id;
        String form_id;
        String number = data.getString(Key_number);
        BillModel billModel = this.getLastExtId(number);
        String oriUnitId = billModel.getUnitId();
        String extBizAppId = data.getString(Key_BizAppID);
        String oriFormId = billModel.getFid();
        String modelType = data.getString(Key_modeltype);
        String parentEntityId = billModel.getEntityId();
        MetaDataUtil metaDataUtil = new MetaDataUtil();
        String extPageNumber = this.getDefaultExtNumber(billModel.getNumber(), metaDataUtil);
        Object extPageName = data.get(Key_Name);
        this.getModel().setDataChanged(false);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bizunitid", oriUnitId);
        map.put(Key_Name, extPageName);
        map.put(Key_ID, extPageNumber);
        map.put("modelType", modelType);
        map.put("parentId", oriFormId);
        map.put("devType", "2");
        map.put("subSysId", 99);
        if (!parentEntityId.equals(oriFormId) && !"PrintModel".equals(modelType)) {
            map.put("entityId", parentEntityId);
        }
        if (!(form_id = data.getString(Key_ID)).equals(entity_id = data.getString("basedatafield.id")) && ("BillFormModel".equals(modelType) || "BaseFormModel".equals(modelType))) {
            map.put("islayout", Boolean.TRUE);
        }
        Map<Object, Object> save = new HashMap();
        try (TXHandle tx = TX.required((String)"mdl_BizObjImportPlugin_saveFormAndBindForm");){
            try {
                extBizAppId = this.selectOrMakeExtApp(extBizAppId);
                map.put(Key_BizAppID, extBizAppId);
                Map<String, Object> content = metaDataUtil.createBlankModel(map);
                content.put("isDeveloper", true);
                boolean isLayout = false;
                if (content.containsKey("formmeta")) {
                    Map formdata = (Map)content.get("formmeta");
                    String entityId = (String)formdata.get("EntityId");
                    String fid = (String)formdata.get("Id");
                    boolean bl = isLayout = StringUtils.isNotEmpty((CharSequence)entityId) && !entityId.equals(fid);
                }
                if ((save = this.saveMetadata(content)).get(KEY_SUCCESS) != null && !((Boolean)save.get(KEY_SUCCESS)).booleanValue()) {
                    String msg = (String)save.get("message");
                    List errorInfos = (List)save.get(KEY_ERRORS);
                    String errors = this.buildErrMsg(errorInfos);
                    msg = StringUtils.isEmpty((CharSequence)msg) ? errors : msg + ":" + errors;
                    log.warn("Failed to save the extension page.message:{}", (Object)msg);
                    throw new KDBizException(msg);
                }
                String formId = (String)content.get(Key_ID);
                DynamicObject newUnitrelform = BusinessDataServiceHelper.newDynamicObject((String)"bos_devportal_unitrelform");
                newUnitrelform.set(Key_bizapp, (Object)extBizAppId);
                newUnitrelform.set("bizunit", (Object)oriUnitId);
                newUnitrelform.set("form", (Object)formId);
                MainEntityType unitrelformEntityType = EntityMetadataCache.getDataEntityType((String)"bos_devportal_unitrelform");
                BusinessDataServiceHelper.save((IDataEntityType)unitrelformEntityType, (Object[])new DynamicObject[]{newUnitrelform});
                if (isReload && !this.removeExt(number)) {
                    log.error("\u91cd\u65b0\u52a0\u8f7d\u65f6\uff0c\u5220\u9664\u6269\u5c55\u8868\u7684\u6570\u636e\u5f02\u5e38\u3002\u5355\u636enumber={}", (Object)number);
                    throw new KDBizException(ResManager.loadKDString((String)"\u539f\u5355\u5220\u9664\u5f02\u5e38\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"MyBizObjExtList_11", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                this.saveImportExt(data, billModel.getFid(), formId, isLayout, extBizAppId);
            }
            catch (Exception exp) {
                tx.markRollback();
                throw exp;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private String buildErrMsg(List<ErrorInfo> errorList) {
        void var4_7;
        ArrayList<String> list = new ArrayList<String>(10);
        for (ErrorInfo errorInfo : errorList) {
            list.add(errorInfo.getError());
        }
        StringBuilder str = new StringBuilder();
        for (String c : list) {
            str.append(c);
        }
        boolean bl = false;
        while (var4_7 < str.length() - 1) {
            if (str.charAt((int)var4_7) == '\u3002') {
                str.setCharAt((int)var4_7, '\uff0c');
            }
            ++var4_7;
        }
        return str.toString();
    }

    private Map<String, Object> saveMetadata(Map<String, Object> content) {
        DesignerData designerData = new DesignerData(){

            protected MetadataWriter getMetadataWriter(String modelType) {
                return new MetadataWriter(modelType){

                    public Map<String, Object> save(Boolean isDraft, AbstractMetadata ... metadatas) {
                        this.plugIn = new FormmetaDaoPlugin(){

                            public void saveRuntimeMeta(boolean isDraft, AbstractMetadata[] metadatas) {
                            }
                        };
                        return super.save(isDraft, metadatas);
                    }
                };
            }
        };
        return designerData.save(content);
    }

    private boolean removeExt(String number) {
        return DeleteServiceHelper.delete((String)EXT_ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter(Key_number, "=", (Object)number)}) > 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String selectOrMakeExtApp(String extBizAppId) {
        QFilter parentFilter = new QFilter("masterid", "=", (Object)extBizAppId);
        String isv = ISVService.getISVInfo().getId();
        QFilter isvFilter = new QFilter("isv", "=", (Object)isv);
        QFilter[] filters = new QFilter[]{parentFilter, isvFilter};
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (QFilter[])filters);
        if (dynamicObjectMap.isEmpty()) {
            QFilter idFilter = new QFilter(Key_ID, "=", (Object)extBizAppId);
            QFilter[] filters1 = new QFilter[]{idFilter, isvFilter};
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_devportal_bizapp", (QFilter[])filters1);
            if (dynamicObject != null && "2".equals(dynamicObject.get("type"))) {
                return this.getLastExtAppId(extBizAppId, isv);
            }
            DynamicObject parentApp = BusinessDataServiceHelper.loadSingleFromCache((Object)extBizAppId, (String)"bos_devportal_bizapp");
            String parentId = parentApp.getString(Key_ID);
            extBizAppId = ID.genStringId();
            String extBizAppNumber = this.getAppPDExtNumber(parentApp.getString(Key_number));
            parentApp.set(Key_parentid, (Object)parentId);
            parentApp.set("masterid", StringUtils.isBlank((Object)parentApp.get("masterid")) ? parentId : parentApp.get("masterid"));
            String prefixValue = "";
            if (StringUtils.isNotBlank((Object)parentApp.get("inheritpath"))) {
                prefixValue = parentApp.get("inheritpath") + ",";
            }
            parentApp.set("inheritpath", (Object)(prefixValue + parentId));
            parentApp.set("type", (Object)"2");
            parentApp.set(Key_ID, (Object)extBizAppId);
            parentApp.set(Key_number, (Object)extBizAppNumber);
            parentApp.set("type", (Object)"2");
            AppMetadata appMetadata = AppMetaServiceHelper.getAppMetadata((DynamicObject)parentApp);
            AppWriter appWrite = new AppWriter();
            Map result = appWrite.save(appMetadata);
            if ("true".equalsIgnoreCase(result.get(KEY_SUCCESS).toString())) {
                PermissionServiceHelper.clearAllUserAppCache();
                return extBizAppId;
            }
            log.warn("Failed to query or generate the default extended application.Application={}", (Object)extBizAppId);
            throw new KDBizException(result.get("message") + "");
        }
        String[] inheritPaths = new String[]{};
        Iterator iterator = dynamicObjectMap.values().iterator();
        while (iterator.hasNext()) {
            DynamicObject dyn = (DynamicObject)iterator.next();
            if (dyn.getString("inheritpath").split(",").length <= inheritPaths.length) continue;
            extBizAppId = dyn.getString(Key_ID);
            inheritPaths = dyn.getString("inheritpath").split(",");
        }
        return extBizAppId;
    }

    private String getLastExtAppId(String appId, String isv) {
        QFilter parentIdFilter = new QFilter(Key_parentid, "=", (Object)appId);
        QFilter isvFilter = new QFilter("isv", "=", (Object)isv);
        QFilter[] filters = new QFilter[]{parentIdFilter, isvFilter};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_devportal_bizapp", (QFilter[])filters);
        if (dynamicObject != null) {
            appId = this.getLastExtAppId(dynamicObject.getString(Key_ID), isv);
        }
        return appId;
    }

    private String getAppPDExtNumber(String number) {
        if ((number = DevportalUtil.autoIsvNumber(number + "_pdext")).length() > 25) {
            number = number.substring(0, 25);
        }
        int index = 1;
        while (true) {
            QFilter qFilter = new QFilter(Key_number, "=", (Object)number);
            boolean exists = QueryServiceHelper.exists((String)"bos_devportal_bizapp", (QFilter[])new QFilter[]{qFilter});
            if (!exists) break;
            if (index >= 10) {
                log.error("Attempt 10 Failed to generate encoding, cancel the attempt");
                throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u9ed8\u8ba4\u7f16\u7801\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u68c0\u67e5\u65e5\u5fd7\u3002", (String)"MyBizObjExtList_12", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            number = number.substring(0, number.length() - 1) + index++;
        }
        return number;
    }

    private String getDefaultExtNumber(String number, MetaDataUtil metaDataUtil) {
        if ((number = number + "_pdext").length() > 25) {
            number = number.substring(0, 25);
        }
        int index = 1;
        while (true) {
            boolean exists;
            if (!(exists = metaDataUtil.checkNumber(number))) break;
            log.info("\u7b2c{}\u6b21\u5c1d\u8bd5\u81ea\u52a8\u751f\u6210\u552f\u4e00\u7f16\u7801\u5931\u8d25,number={},", (Object)index, (Object)number);
            if (index >= 10) {
                log.warn("Attempt 10 Failed to generate encoding, cancel the attempt");
                throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u9ed8\u8ba4\u7f16\u7801\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u68c0\u67e5\u65e5\u5fd7\u3002", (String)"MyBizObjExtList_12", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            number = number.substring(0, number.length() - 1) + index++;
        }
        log.info("\u7b2c{}\u6b21\u5c1d\u8bd5\u81ea\u52a8\u751f\u6210\u552f\u4e00\u7f16\u7801\u6210\u529f,number={},", (Object)index, (Object)number);
        return number;
    }

    private void saveImportExt(DynamicObject data, String parentId, String fid, Boolean isLayout, String extBizAppId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)EXT_ENTITY_NAME);
        String bizappid = data.getString(Key_BizAppID);
        DynamicObject appObj = BusinessDataServiceHelper.loadSingle((String)"bos_devportal_bizapp", (QFilter[])new QFilter[]{new QFilter(Key_ID, "=", (Object)bizappid)});
        if (appObj == null) {
            log.warn("Get application object cloud information exception.Application id:{}", (Object)bizappid);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5e94\u7528\u5bf9\u5e94\u4e91\u4fe1\u606f\u5f02\u5e38\u3002", (String)"MyBizObjExtList_14", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        String cloudId = appObj.getString("bizcloud.id");
        dynamicObject.set(Key_ID, (Object)fid);
        dynamicObject.set("status", (Object)Key_root_Id);
        dynamicObject.set(Key_number, (Object)data.getString(Key_number));
        dynamicObject.set("bizcloud", (Object)cloudId);
        dynamicObject.set(Key_bizapp, (Object)(StringUtils.isBlank((CharSequence)appObj.getString("masterid")) ? bizappid : appObj.getString("masterid")));
        dynamicObject.set("masterid", (Object)(StringUtils.isBlank((CharSequence)appObj.getString("masterid")) ? bizappid : appObj.getString("masterid")));
        dynamicObject.set(Key_parentid, (Object)parentId);
        dynamicObject.set(Key_modeltype, (Object)data.getString(Key_modeltype));
        dynamicObject.set("createdate", (Object)new Date());
        dynamicObject.set(Key_modifier, (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set(Key_modifydate, (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private BillModel getLastExtId(String number) {
        String masterId = MetadataDao.getIdByNumber((String)number, (MetaCategory)MetaCategory.Form);
        String sql = "select a.fid,a.fnumber,b.fbizunitid,a.fentityid from t_meta_formdesign a \n left join t_meta_bizunitrelform b  on a.fid=b.fformid \n where (a.fmasterid  =? or a.fid = ?) order by a.finheritpath ";
        Object[] parameter = new SqlParameter[]{new SqlParameter("masterid", 12, (Object)masterId), new SqlParameter("masterid", 12, (Object)masterId)};
        BillModel billModel = new BillModel();
        return (BillModel)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])parameter, rs -> {
            while (rs.next()) {
                billModel.setFid(rs.getString(Key_Fid));
                billModel.setNumber(rs.getString("fnumber"));
                billModel.setUnitId(rs.getString("fbizunitid"));
                billModel.setEntityId(rs.getString("fentityid"));
            }
            return billModel;
        });
    }

    public Boolean isNotExist() {
        String currentIsv = ISVService.getISVInfo().getId();
        return StringUtils.isBlank((CharSequence)currentIsv);
    }

    public void refreshSelectedNodeData() {
        String currNodeId = this.getPageCache().get(CacheId_CurrNode);
        this.refreshView(currNodeId, "", "");
    }

    protected void markTargetCard(String fId) {
        if (StringUtils.isNotBlank((CharSequence)fId)) {
            String currView = this.getPageCache().get(CacheId_CurrView);
            EntryGrid grid = (EntryGrid)this.getControl(Key_EntryEntity);
            int rowIndex = this.findRowById(Key_EntryEntity, fId);
            grid.selectRows(rowIndex, true);
        }
    }

    public void sortOrderChangeToDefault() {
        String orderby = (String)this.getModel().getValue("orderbyfield");
        if (!"default".equals(orderby)) {
            this.getModel().setValue("orderbyfield", (Object)"default");
        }
    }
}

