/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.bizobjext.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.hash.Hashing;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.devportal.bizobjext.exports.BizObjExportPluginConstant;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.AppPackageUtil;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.FileUtils;
import org.apache.commons.codec.digest.DigestUtils;

public class BizObjExportPlugin
extends AbstractFormPlugin
implements BizObjExportPluginConstant,
SearchEnterListener {
    private static final Log logger = LogFactory.getLog(BizObjExportPlugin.class);
    private static final String CacheId_TreeNodes = "nodes";
    private static final String Key_LeftSearch = "leftsearchap";
    private static final String Key_RightSearch = "rightsearchap";
    private static final String SUCCESS_MSG = "success";
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String KEY_MD5 = "md5";
    private static final String KEY_SHA256 = "sha256";
    protected static final String BIZAPPID = "bizappid";
    private static final String LOCALPATH = System.getProperty("java.io.tmpdir") + File.separator + "KINGDEEDOWNLOAD";
    protected static final String DATAMODEL = "datamodel";
    protected static final String MAIN = "main";
    protected static final String PREINSDATA = "preinsdata";
    protected static final String KEY_RESOURCETYPE_JAR = "jar";
    private Map<String, Map<String, List<Map<String, String>>>> selectAppFileInfoMap = new HashMap<String, Map<String, List<Map<String, String>>>>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_addnode", "btn_delnode", "commit"});
        Search leftTreeSearch = (Search)this.getControl(Key_LeftSearch);
        leftTreeSearch.addEnterListener((SearchEnterListener)this);
        Search rightTreeSearch = (Search)this.getControl(Key_RightSearch);
        rightTreeSearch.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        TreeNode leftRoot = this.initLeftTree();
        TreeView leftTree = (TreeView)this.getView().getControl("treeviewapsource");
        leftTree.addNode(leftRoot);
        leftTree.setRootVisible(false);
        TreeNode rightRoot = new TreeNode("", "rootnode", ResManager.loadKDString((String)"\u5df2\u9009\u5143\u6a21\u578b", (String)"BizObjExportPlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        rightRoot.setIsOpened(true);
        TreeView rightTree = (TreeView)this.getView().getControl("treeviewselect");
        rightTree.addNode(rightRoot);
        rightTree.setRootVisible(false);
    }

    private TreeNode initLeftTree() {
        String treeJson = this.getView().getParentView().getPageCache().get(CacheId_TreeNodes);
        List clouds = JSON.parseArray((String)treeJson, TreeNode.class);
        TreeNode leftRoot = new TreeNode("", "rootnode", ResManager.loadKDString((String)"\u6e90\u6570\u636e", (String)"BizObjExportPlugin_1", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        leftRoot.setIsOpened(true);
        ArrayList<TreeNode> exportLeftTree = new ArrayList<TreeNode>();
        for (TreeNode cloudNode : clouds) {
            cloudNode.setParentid(leftRoot.getId());
            List appNodes = new ArrayList();
            appNodes = cloudNode.getChildren();
            ArrayList<String> removeAppNodeId = new ArrayList<String>();
            for (TreeNode appNode : appNodes) {
                List<Map<String, String>> billList = this.getBillListByAppId(appNode.getId());
                if (billList.size() > 0) {
                    String appId = appNode.getId().substring(4);
                    appNode.setId(appId);
                    ArrayList<TreeNode> billNodes = new ArrayList<TreeNode>(billList.size());
                    for (Map<String, String> bill : billList) {
                        TreeNode billNode = new TreeNode();
                        billNode.setId(bill.get("fid"));
                        billNode.setText(bill.get("fname"));
                        billNode.setParentid(appNode.getId());
                        billNode.setLongNumber(bill.get("fnumber"));
                        billNode.setLongText(bill.get("fbizappid"));
                        billNodes.add(billNode);
                    }
                    appNode.setChildren(billNodes);
                    continue;
                }
                removeAppNodeId.add(appNode.getId());
            }
            for (String appNodeId : removeAppNodeId) {
                cloudNode.deleteChildNode(appNodeId);
            }
            if (cloudNode.getChildren() == null || cloudNode.getChildren().size() <= 0) continue;
            exportLeftTree.add(cloudNode);
        }
        leftRoot.addChildren(exportLeftTree);
        String leftTreeNodesValue = SerializationUtils.toJsonString((Object)leftRoot);
        this.getPageCache().put("leftRoot", leftTreeNodesValue);
        return leftRoot;
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase(Locale.ENGLISH)) {
            case "btn_addnode": {
                this.addNode();
                break;
            }
            case "btn_delnode": {
                this.delNode();
                break;
            }
            case "commit": {
                this.commitExportData();
                break;
            }
        }
    }

    private void commitExportData() {
        String rightNodeCache = this.getPageCache().get("rightRoot");
        TreeNode rightRoot = null;
        if (StringUtils.isNotBlank((CharSequence)rightNodeCache)) {
            rightRoot = (TreeNode)SerializationUtils.fromJsonString((String)rightNodeCache, TreeNode.class);
            try {
                this.confirmToExport(rightRoot);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                this.getView().showErrorNotification(e.getMessage());
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53f3\u6811\u65e0\u6570\u636e\u8bf7\u9009\u62e9\u6570\u636e\u5728\u63d0\u4ea4\u3002", (String)"BizObjExportPlugin_2", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        }
        this.getView().close();
    }

    private void delNode() {
        TreeView selectTree = (TreeView)this.getView().getControl("treeviewselect");
        List ids = selectTree.getTreeState().getCheckedNodeIds();
        if (ids.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u79fb\u9664\u7684\u6570\u636e\u3002", (String)"BizObjExportPlugin_3", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            return;
        }
        ids.remove("rootnode");
        String rightNodeCache = this.getPageCache().get("rightRoot");
        if (StringUtils.isNotBlank((CharSequence)rightNodeCache)) {
            TreeNode selectNode = (TreeNode)SerializationUtils.fromJsonString((String)rightNodeCache, TreeNode.class);
            ids.forEach(id -> selectNode.deleteChildNode(id));
            if (!CollectionUtils.isEmpty((Collection)selectNode.getChildren())) {
                rightNodeCache = SerializationUtils.toJsonString((Object)selectNode);
                this.getPageCache().put("rightRoot", rightNodeCache);
            } else {
                this.getPageCache().put("rightRoot", "");
            }
        }
        selectTree.deleteNodes(ids);
        selectTree.uncheckNode("rootnode");
    }

    private TreeNode buildRightTreeNode() {
        TreeView leftTree = (TreeView)this.getView().getControl("treeviewapsource");
        List selectNodes = leftTree.getTreeState().getSelectedNodes();
        String rightNodeCache = this.getPageCache().get("rightRoot");
        String leftRootCache = this.getPageCache().get("leftRoot");
        if (StringUtils.isBlank((CharSequence)leftRootCache)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e\u3002", (String)"BizObjExportPlugin_4", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            return new TreeNode("", "rootnode", ResManager.loadKDString((String)"\u5df2\u9009\u5143\u6a21\u578b", (String)"BizObjExportPlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        }
        TreeNode leftRoot = (TreeNode)SerializationUtils.fromJsonString((String)leftRootCache, TreeNode.class);
        if (null == leftRoot || CollectionUtils.isEmpty((Collection)leftRoot.getChildren())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e\u3002", (String)"BizObjExportPlugin_4", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            return new TreeNode("", "rootnode", ResManager.loadKDString((String)"\u5df2\u9009\u5143\u6a21\u578b", (String)"BizObjExportPlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        }
        TreeNode rightRoot = StringUtils.isNotBlank((CharSequence)rightNodeCache) ? (TreeNode)SerializationUtils.fromJsonString((String)rightNodeCache, TreeNode.class) : new TreeNode("", "rootnode", ResManager.loadKDString((String)"\u5df2\u9009\u4e1a\u52a1\u5bf9\u8c61", (String)"BizObjExportPlugin_5", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        for (Map selectNode : selectNodes) {
            String parentId = (String)selectNode.get("parentid");
            String id = (String)selectNode.get("id");
            String text = (String)selectNode.get("text");
            TreeNode treeNode = rightRoot.getTreeNode(id);
            if (null != treeNode) continue;
            TreeNode curNode = new TreeNode(parentId, id, text);
            TreeNode leftRootAppNode = new TreeNode();
            boolean isBillNode = false;
            if (!curNode.getId().startsWith("cloud_") && !curNode.getParentid().startsWith("cloud_")) {
                block1: for (TreeNode cloudNode : leftRoot.getChildren()) {
                    List appNodeList = cloudNode.getChildren();
                    for (TreeNode appNode : appNodeList) {
                        if (!appNode.getId().equalsIgnoreCase(curNode.getParentid())) continue;
                        leftRootAppNode = appNode;
                        continue block1;
                    }
                }
                isBillNode = true;
                this.saveTreeNode(leftRoot, rightRoot, curNode, leftRootAppNode, isBillNode);
                continue;
            }
            this.saveTreeNode(leftRoot, rightRoot, curNode, leftRootAppNode, isBillNode);
        }
        String rightNode = SerializationUtils.toJsonString((Object)rightRoot);
        this.getPageCache().put("rightRoot", rightNode);
        return rightRoot;
    }

    private void saveTreeNode(TreeNode leftRoot, TreeNode rightRoot, TreeNode curNode, TreeNode leftRootAppNode, boolean isBillNode) {
        String parentId = curNode.getParentid();
        TreeNode parentNode = rightRoot.getTreeNode(parentId);
        if (null == parentNode) {
            parentNode = leftRoot.getTreeNode(parentId);
            String parentid = parentNode.getParentid();
            if (!"".equalsIgnoreCase(parentid)) {
                TreeNode treeNode = new TreeNode(parentid, parentNode.getId(), parentNode.getText());
                treeNode.addChild(curNode);
                this.saveTreeNode(leftRoot, rightRoot, treeNode, leftRootAppNode, isBillNode);
            }
        } else {
            if (isBillNode) {
                List billNodeList = leftRootAppNode.getChildren();
                for (TreeNode billNode : billNodeList) {
                    if (!billNode.getId().equalsIgnoreCase(curNode.getId())) continue;
                    curNode.setLongText(billNode.getLongText());
                    break;
                }
            }
            parentNode.addChild(curNode);
            return;
        }
    }

    private void addNode() {
        TreeView rightTree = (TreeView)this.getView().getControl("treeviewselect");
        TreeView leftTree = (TreeView)this.getView().getControl("treeviewapsource");
        List leftSelectIds = leftTree.getTreeState().getCheckedNodeIds();
        if (leftSelectIds.isEmpty()) {
            return;
        }
        TreeNode selectedNode = this.buildRightTreeNode();
        selectedNode.setIsOpened(true);
        rightTree.deleteAllNodes();
        rightTree.addNode(selectedNode);
        rightTree.updateNode(selectedNode);
        if (leftSelectIds.size() == 1) {
            List selectNodes = leftTree.getTreeState().getSelectedNodes();
            Map selectNodeInfo = (Map)selectNodes.get(0);
            String nodeId = (String)selectNodeInfo.get("id");
            String parentNodeId = (String)selectNodeInfo.get("parentid");
            boolean isParent = (Boolean)selectNodeInfo.get("isParent");
            if (isParent) {
                rightTree.showNode(nodeId);
                rightTree.expand(nodeId);
            } else {
                rightTree.showNode(parentNodeId);
                rightTree.expand(parentNodeId);
            }
        }
    }

    private List<Map<String, String>> getBillListByAppId(String nodeId) {
        if (StringUtils.isNotBlank((CharSequence)nodeId)) {
            if (nodeId.contains("cloud_")) {
                nodeId = nodeId.substring(6);
            } else if (nodeId.contains("app_")) {
                nodeId = nodeId.substring(4);
            }
        }
        Map billList = new HashMap();
        SqlBuilder sql = new SqlBuilder();
        sql.append("select distinct t1.fid,t1.fbizappid,t2.fnumber,t2.fname from t_meta_formdesign t1 inner join t_meta_formdesign_l t2 on t1.FID = t2.FID ", new Object[0]).append("and t2.FLocaleId = ?", new Object[]{Lang.get()}).append("inner join t_meta_bizobj_ext t3 on t1.FID = t3.FID and t3.fstatus = '3' ", new Object[0]).append("where t3.FappId = ?", new Object[]{nodeId});
        sql.append("order by t2.fnumber ", new Object[0]);
        billList = (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sql, rs -> {
            HashMap<String, Cloneable> ret = new HashMap<String, Cloneable>(2);
            HashMap<String, String> keyset = new HashMap<String, String>(16);
            ArrayList result = new ArrayList(16);
            while (rs.next()) {
                keyset.put(rs.getString("fid"), rs.getString("fid"));
                HashMap<String, String> row = new HashMap<String, String>();
                row.put("fid", rs.getString("fid"));
                row.put("fname", rs.getString("fname"));
                row.put("fnumber", rs.getString("fnumber"));
                row.put("fbizappid", rs.getString("fbizappid"));
                result.add(row);
            }
            ret.put("keyset", keyset);
            ret.put("result", result);
            return ret;
        });
        ArrayList<Map<String, String>> result = new ArrayList();
        result = (List)billList.get("result");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void confirmToExport(TreeNode rightRoot) {
        Serializable deployDataExpFile;
        List rightCloudNodes = rightRoot.getChildren();
        HashSet<String> allSelectAppIdSet = new HashSet<String>(10);
        HashMap<String, TreeNode> allAppNodesMap = new HashMap<String, TreeNode>(16);
        for (TreeNode cloudNode : rightCloudNodes) {
            if (cloudNode.getChildren() == null || cloudNode.getChildren().size() <= 0) continue;
            List rightAppNodes = cloudNode.getChildren();
            for (TreeNode appNode : rightAppNodes) {
                List billNodes = appNode.getChildren();
                for (TreeNode billNode : billNodes) {
                    String actualityAppId = billNode.getLongText();
                    if (allSelectAppIdSet.contains(actualityAppId)) continue;
                    allSelectAppIdSet.add(actualityAppId);
                    TreeNode actAppNode = new TreeNode();
                    actAppNode.setId(actualityAppId);
                    ArrayList<TreeNode> actbillNodes = new ArrayList<TreeNode>();
                    for (TreeNode billNodeInfo : billNodes) {
                        if (!billNodeInfo.getLongText().equalsIgnoreCase(actualityAppId)) continue;
                        actbillNodes.add(billNodeInfo);
                    }
                    actAppNode.setChildren(actbillNodes);
                    allAppNodesMap.put(actualityAppId, actAppNode);
                }
            }
        }
        String defaultAppId = (String)allSelectAppIdSet.iterator().next();
        AppMetadata defaultAppMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)defaultAppId, (boolean)false);
        String defaultAppNum = defaultAppMeta.getNumber().toLowerCase();
        DynamicObject defaultCloudObject = BizCloudServiceHelp.getBizCloudByAppID((String)defaultAppId);
        String defaultCloudNum = defaultCloudObject.getString("number").toLowerCase();
        String defaultAppPackageName = String.format("%1$s-%2$s-dm", defaultCloudNum, defaultAppNum);
        String defaultZipPath = this.getZipPath(defaultAppId);
        Map<String, Object> resultMap = this.metaConfirmToExport(allAppNodesMap, defaultZipPath);
        if (!Boolean.parseBoolean(resultMap.get(SUCCESS_MSG).toString())) {
            this.getView().showErrorNotification(resultMap.get("message").toString());
            return;
        }
        HashMap<String, Map<String, String>> md5Map = new HashMap<String, Map<String, String>>(16);
        HashMap<String, Map<String, String>> shaMap = new HashMap<String, Map<String, String>>(16);
        ArrayList<String> appZipNames = new ArrayList<String>();
        HashMap<String, String> appMD5Map = new HashMap<String, String>();
        HashMap<String, String> appSHAMap = new HashMap<String, String>();
        md5Map.put("dm", appMD5Map);
        shaMap.put("dm", appSHAMap);
        for (String selectAppId : allSelectAppIdSet) {
            try {
                AppMetadata selectAppMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)selectAppId, (boolean)false);
                String selectAppNum = selectAppMeta.getNumber().toLowerCase();
                String selectAppVersion = DevportalUtil.getAppVerion(selectAppNum);
                String deployDataExpPath = this.getDeployDataExportPath(defaultZipPath, selectAppNum);
                String datamodelPath = this.getDataModelPath(defaultZipPath, selectAppNum);
                String mainPath = this.getMainPath(defaultZipPath, selectAppVersion, selectAppNum);
                try {
                    deployDataExpFile = new File(deployDataExpPath).getCanonicalFile();
                    if (!((File)deployDataExpFile).exists()) {
                        ((File)deployDataExpFile).mkdirs();
                    }
                }
                catch (IOException e) {
                    String errMsg = String.format(ResManager.loadKDString((String)"\u5b89\u88c5\u5305\u521b\u5efa\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\uff1a%s", (String)"BizObjExportPlugin_7", (String)"bos-devportal-plugin", (Object[])new Object[0]), e.getMessage());
                    logger.error(errMsg);
                    this.getView().showErrorNotification(errMsg);
                    return;
                }
                logger.info(String.format(ResManager.loadKDString((String)"\u5df2\u9009\u5e94\u7528(%1$s)\u6210\u529f\u521b\u5efa\u6587\u4ef6\u5939: %2$s", (String)"BizObjExportPlugin_11", (String)"bos-devportal-plugin", (Object[])new Object[0]), selectAppNum, deployDataExpPath));
                Map<String, List<Map<String, String>>> funcAppMap = this.selectAppFileInfoMap.get(selectAppId);
                for (Map.Entry entry : funcAppMap.entrySet()) {
                    List sqlScriptList = (List)entry.getValue();
                    String funcAppFile = (String)entry.getKey();
                    AppPackageUtil.createAppXML(funcAppFile, sqlScriptList, mainPath, false);
                }
                Set<String> funcAppFileNameSet = funcAppMap.keySet();
                AppPackageUtil.createDataModelXML(selectAppId, funcAppFileNameSet, datamodelPath);
                DynamicObject dynamicObject = BizCloudServiceHelp.getBizCloudByAppID((String)selectAppId);
                String selectCloudNum = dynamicObject.getString("number").toLowerCase();
                String appPackageName = String.format("%1$s-%2$s-dm", selectCloudNum, selectAppNum);
                appZipNames.add(appPackageName);
                ArrayList<String> fileList = new ArrayList<String>();
                List<String> appSourceList = DevportalUtil.recursiveFiles(datamodelPath, fileList);
                StringBuilder appRelPathBuilder = new StringBuilder();
                appSourceList.forEach(appSource -> {
                    int datamodelIndex = appSource.indexOf(DATAMODEL);
                    String appRelPath = appSource.substring(datamodelIndex + DATAMODEL.length());
                    if (!appRelPath.endsWith("filelist.txt")) {
                        appRelPathBuilder.append(appRelPath);
                        appRelPathBuilder.append(System.lineSeparator());
                    }
                });
                String appInfoPath = String.format("%1$s%2$s%3$s", datamodelPath, File.separator, "filelist.txt");
                this.createLogInfo(appRelPathBuilder.toString(), appInfoPath);
                this.zipDMFile(deployDataExpPath, appPackageName, defaultZipPath);
                String dmPath = String.format("%1$s%2$s%3$s%4$s%5$s.zip", defaultZipPath, File.separator, "dm", File.separator, appPackageName);
                this.getEncodeVal(dmPath, appMD5Map, appSHAMap);
                if (!((File)deployDataExpFile).exists()) continue;
                AppUtils.deleteKd((File)deployDataExpFile);
            }
            catch (Exception e) {
                this.getView().showErrorNotification(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                return;
            }
        }
        InputStream zipInput = null;
        try {
            String pkVersion = "5.0.028";
            String pkgDesc = ResManager.loadKDString((String)"\u538b\u7f29\u5305\u6307\u5b9a", (String)"BizObjExportPlugin_12", (String)"bos-devportal-plugin", (Object[])new Object[0]);
            AppPackageUtil.createKdpkgsXML(defaultAppId, pkVersion, pkgDesc, appZipNames, null, defaultZipPath, md5Map, shaMap);
            DevportalUtil.zipFiles(appZipNames, defaultZipPath, defaultAppPackageName);
            String downloadPath = FileUtils.cleanString((String)(defaultZipPath + File.separator + defaultAppPackageName + ".zip"));
            String filePath = FileUtils.cleanString((String)DevportalUtil.checkFilePath(downloadPath));
            Path dowloadFilePath = Paths.get(filePath, new String[0]);
            File downloadFile = new File(downloadPath);
            if (downloadFile.exists()) {
                try {
                    InputStream input = Files.newInputStream(dowloadFilePath, new OpenOption[0]);
                    deployDataExpFile = null;
                    try {
                        byte[] b = new byte[input.available()];
                        int len = input.read(b);
                        BigDecimal bigDecimal = new BigDecimal(len);
                        BigDecimal kbBigDecimal = new BigDecimal(1024);
                        BigDecimal kb = bigDecimal.divide(kbBigDecimal);
                        logger.info(String.format(ResManager.loadKDString((String)"\u5b89\u88c5\u5305zip\u6587\u4ef6\u5927\u5c0f\u4e3a\uff1a%s", (String)"BizObjExportPlugin_10", (String)"bos-devportal-plugin", (Object[])new Object[0]), kb.setScale(1, 4) + "kb"));
                    }
                    catch (Throwable b) {
                        deployDataExpFile = b;
                        throw b;
                    }
                    finally {
                        if (input != null) {
                            if (deployDataExpFile != null) {
                                try {
                                    input.close();
                                }
                                catch (Throwable b) {
                                    ((Throwable)deployDataExpFile).addSuppressed(b);
                                }
                            } else {
                                input.close();
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    logger.error("generate patch error: {}", (Object)exception.getMessage());
                }
            }
            zipInput = Files.newInputStream(dowloadFilePath, new OpenOption[0]);
            String zipName = ResManager.loadKDString((String)"\u5bfc\u51fa\u6269\u5c55\u5bf9\u8c61", (String)"BizObjExportPlugin_13", (String)"bos-devportal-plugin", (Object[])new Object[0]);
            Date date = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            String dataFormat = sdf.format(date);
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(zipName + "-" + dataFormat + ".zip", zipInput, 5000);
            logger.info(string);
            this.getView().openUrl(string);
        }
        catch (IOException e) {
            this.getView().showErrorNotification(e.getMessage());
            return;
        }
        finally {
            try {
                String filePath;
                File zipFile;
                if (zipInput != null) {
                    zipInput.close();
                }
                if ((zipFile = new File(filePath = FileUtils.cleanString((String)defaultZipPath)).getCanonicalFile()).exists()) {
                    AppUtils.deleteKd((File)zipFile);
                    String appNumberStr = LOCALPATH + File.separator + defaultAppPackageName;
                    File appNumberPath = new File(FileUtils.cleanString((String)appNumberStr));
                    if (appNumberPath.listFiles().length == 0) {
                        boolean deleteFlag = appNumberPath.delete();
                        logger.info(appNumberPath + "delete:" + deleteFlag);
                    }
                }
            }
            catch (Exception ioExp) {
                logger.error((Throwable)ioExp);
            }
        }
        this.getView().returnDataToParent((Object)SUCCESS_MSG);
        this.getView().close();
    }

    private String getappPackageName(String appId) {
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)false);
        String appNum = appMeta.getNumber().toLowerCase();
        DynamicObject cldObj = BizCloudServiceHelp.getBizCloudByAppID((String)appId);
        String cloudNum = cldObj.getString("number").toLowerCase();
        return String.format("%1$s-%2$s-dm", cloudNum, appNum);
    }

    private String getDMPath(String appId) {
        String appPackageName = this.getappPackageName(appId);
        return FileUtils.cleanString((String)String.format("%1$s%2$s%3$s", LOCALPATH, File.separator, appPackageName));
    }

    private String getZipPath(String appId) {
        String dmPath = this.getDMPath(appId);
        String traceIdHash = Hashing.sha256().hashString((CharSequence)RequestContext.get().getTraceId(), StandardCharsets.UTF_8).toString();
        return FileUtils.cleanString((String)String.format("%1$s%2$s%3$s", dmPath, File.separator, traceIdHash));
    }

    private Map<String, Object> metaConfirmToExport(Map<String, TreeNode> allAppNodesMap, String defaultZipPath) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put(SUCCESS_MSG, true);
        for (Map.Entry<String, TreeNode> nodeEntry : allAppNodesMap.entrySet()) {
            String selectAppId = nodeEntry.getKey();
            TreeNode appNode = nodeEntry.getValue();
            ArrayList<String> pageIds = new ArrayList<String>();
            if (appNode.getChildren() != null && appNode.getChildren().size() > 0) {
                List formNodes = appNode.getChildren();
                for (TreeNode formNode : formNodes) {
                    String pageId = formNode.getId();
                    pageIds.add(pageId);
                }
            }
            AppMetadata selectAppMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)selectAppId, (boolean)false);
            String selectAppNum = selectAppMeta.getNumber().toLowerCase();
            String selectAppVersion = DevportalUtil.getAppVerion(selectAppNum);
            DynamicObject selectCldObj = BizCloudServiceHelp.getBizCloudByAppID((String)selectAppId);
            String selectCloudId = selectCldObj.getPkValue().toString();
            String mainPath = this.getMainPath(defaultZipPath, selectAppVersion, selectAppNum);
            String appPath = FileUtils.cleanString((String)String.format("%1$s%2$s%3$s", mainPath, File.separator, selectAppNum));
            try {
                File appFile = new File(appPath).getCanonicalFile();
                if (!appFile.exists()) {
                    appFile.mkdirs();
                }
                this.updateFileDirInfo(selectAppId, selectAppNum, new ArrayList<Map<String, String>>());
                DevportalUtil.expAppMetadata(selectAppId, appPath, "EXPORT_APP");
                if (pageIds.isEmpty()) continue;
                for (String pageId : pageIds) {
                    if (!QueryServiceHelper.exists((String)"bos_formmeta", (Object)pageId)) continue;
                    DevportalUtil.expFormMetadata(pageId, appPath, "EXPORT_PAGE");
                }
            }
            catch (Exception e) {
                resultMap.put(SUCCESS_MSG, false);
                resultMap.put("message", e.getMessage());
                return resultMap;
            }
        }
        return resultMap;
    }

    private String getDeployDataExportPath(String defaultZipPath, String selectAppNum) {
        if (StringUtils.isBlank((CharSequence)defaultZipPath)) {
            String defaultAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
            defaultZipPath = this.getZipPath(defaultAppId);
        }
        return FileUtils.cleanString((String)String.format("%1$s%2$s%3$s", defaultZipPath, File.separator, selectAppNum));
    }

    private String getDataModelPath(String defaultZipPath, String selectAppNum) {
        String exportPath = this.getDeployDataExportPath(defaultZipPath, selectAppNum);
        return FileUtils.cleanString((String)String.format("%1$s%2$s%3$s", exportPath, File.separator, DATAMODEL));
    }

    private String getMainPath(String defaultZipPath, String appVer, String selectAppNum) {
        String datamodelPath = this.getDataModelPath(defaultZipPath, selectAppNum);
        return FileUtils.cleanString((String)String.format("%1$s%2$s%3$s%4$s%5$s", datamodelPath, File.separator, appVer, File.separator, MAIN));
    }

    private void updateFileDirInfo(String selectAppId, String funcAppFileName, List<Map<String, String>> sqlList) {
        Map<String, List<Map<String, String>>> funcAppInfoMap = this.selectAppFileInfoMap.get(selectAppId);
        if (funcAppInfoMap == null) {
            funcAppInfoMap = new HashMap<String, List<Map<String, String>>>();
            funcAppInfoMap.put(funcAppFileName, sqlList);
            this.selectAppFileInfoMap.put(selectAppId, funcAppInfoMap);
        } else {
            List<Map<String, String>> sqlScriptlist = funcAppInfoMap.get(funcAppFileName);
            if (sqlScriptlist == null) {
                funcAppInfoMap.put(funcAppFileName, sqlList);
            } else {
                sqlScriptlist.addAll(sqlList);
            }
        }
    }

    private void getEncodeVal(String fileFullPathStr, Map<String, String> fileMD5Map, Map<String, String> fileSHAMap) {
        fileFullPathStr = FileUtils.cleanString((String)fileFullPathStr);
        Path fileFullPath = Paths.get(fileFullPathStr, new String[0]);
        Map<String, String> fileEncodeMap = this.encodeFile(fileFullPath);
        String md5Val = fileEncodeMap.get(KEY_MD5);
        String shaVal = fileEncodeMap.get(KEY_SHA256);
        fileFullPathStr = fileFullPathStr.replace(File.separator, "/");
        String fileName = fileFullPathStr.substring(fileFullPathStr.lastIndexOf("/") + 1);
        fileMD5Map.put(fileName, md5Val);
        fileSHAMap.put(fileName, shaVal);
    }

    private Map<String, String> encodeFile(Path filePath) {
        HashMap<String, String> encodeMap = new HashMap<String, String>(2);
        String md5Val = "";
        String shaVal = "";
        try (InputStream inputStream = Files.newInputStream(filePath, new OpenOption[0]);
             ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) > -1) {
                byteArrayOutputStream.write(buffer, 0, len);
            }
            byteArrayOutputStream.flush();
            md5Val = DigestUtils.md5Hex((byte[])byteArrayOutputStream.toByteArray());
            shaVal = DigestUtils.sha256Hex((byte[])byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
        }
        encodeMap.put(KEY_MD5, md5Val);
        encodeMap.put(KEY_SHA256, shaVal);
        return encodeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createLogInfo(String detailErrorInfo, String packagePath) {
        String checkPackagePath = DevportalUtil.checkFilePath(packagePath);
        checkPackagePath = FileUtils.cleanString((String)checkPackagePath);
        File packageFile = new File(FileUtils.cleanString((String)packagePath));
        OutputStream fos = null;
        try {
            boolean packageCreate;
            if (packageFile.exists()) {
                boolean packageDelete = packageFile.delete();
                logger.debug(packageFile + "delete:" + packageDelete);
            }
            if (packageCreate = packageFile.createNewFile()) {
                Path customZipPath = Paths.get(checkPackagePath, new String[0]);
                fos = Files.newOutputStream(customZipPath, new OpenOption[0]);
                fos.write(detailErrorInfo.getBytes(UTF8));
            }
        }
        catch (IOException e) {
            logger.error("createLogInfo error: {}", (Object)e.getMessage());
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {
                    logger.error("createLogInfo error: {}", (Object)exception.getMessage());
                }
            }
        }
    }

    private void zipDMFile(String sourcePath, String appPackageName, String dmFileExpPath) {
        File dmFile;
        JSONArray files = new JSONArray();
        File file = new File(sourcePath);
        if (file.exists()) {
            files.add((Object)sourcePath);
        }
        if (!(dmFile = new File(String.format("%1$s%2$s%3$s", dmFileExpPath, File.separator, "dm"))).exists()) {
            dmFile.mkdirs();
        }
        String zipFilePath = dmFileExpPath + File.separator + "dm" + File.separator + appPackageName + ".zip";
        Path customZipPath = Paths.get(DevportalUtil.checkFilePath(zipFilePath), new String[0]);
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(customZipPath, new OpenOption[0]));){
            DevportalUtil.zipFile(files, out, "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void search(SearchEnterEvent e) {
        Search search = (Search)e.getSource();
        String searchText = e.getText();
        if (StringUtils.equals((CharSequence)Key_LeftSearch, (CharSequence)search.getKey())) {
            String leftTreeNodesValue = this.getPageCache().get("leftRoot");
            TreeNode leftRoot = null;
            List<Object> clouds = new ArrayList<TreeNode>();
            if (StringUtils.isNotBlank((CharSequence)leftTreeNodesValue)) {
                leftRoot = (TreeNode)SerializationUtils.fromJsonString((String)leftTreeNodesValue, TreeNode.class);
                clouds = leftRoot.getChildren();
            }
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                BizObjExportPlugin.searchTree(searchText, clouds);
            }
            TreeView leftTree = (TreeView)this.getView().getControl("treeviewapsource");
            leftTree.deleteAllNodes();
            leftTree.addNode(leftRoot);
            leftTree.setRootVisible(false);
            leftTree.focusNode(leftRoot);
        } else if (StringUtils.equals((CharSequence)Key_RightSearch, (CharSequence)search.getKey())) {
            String rightTreeNodesCacheValue = this.getPageCache().get("rightRoot");
            TreeNode rightRoot = new TreeNode();
            List<Object> clouds = new ArrayList<TreeNode>();
            if (StringUtils.isNotBlank((CharSequence)rightTreeNodesCacheValue)) {
                rightRoot = (TreeNode)SerializationUtils.fromJsonString((String)rightTreeNodesCacheValue, TreeNode.class);
                clouds = rightRoot.getChildren();
            }
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                BizObjExportPlugin.searchTree(searchText, clouds);
            }
            TreeView rightTree = (TreeView)this.getView().getControl("treeviewselect");
            rightTree.deleteAllNodes();
            rightRoot.setIsOpened(true);
            rightTree.addNode(rightRoot);
            rightTree.setRootVisible(false);
            rightTree.focusNode(rightRoot);
            rightTree.updateNode(rightRoot);
        }
    }

    private static void searchTree(String searchText, List<TreeNode> clouds) {
        ArrayList<TreeNode> removCloudNode = new ArrayList<TreeNode>();
        for (TreeNode cloudNode : clouds) {
            if (cloudNode.getText().contains(searchText)) continue;
            List appNodes = new ArrayList();
            appNodes = cloudNode.getChildren();
            ArrayList<String> removeAppNodeId = new ArrayList<String>();
            for (TreeNode appNode : appNodes) {
                if (appNode.getText().contains(searchText)) continue;
                List billNodes = new ArrayList();
                billNodes = appNode.getChildren();
                ArrayList<String> removeBillId = new ArrayList<String>();
                for (TreeNode bill : billNodes) {
                    if (bill.getText().contains(searchText)) continue;
                    removeBillId.add(bill.getId());
                }
                if (removeBillId.size() == billNodes.size()) {
                    removeAppNodeId.add(appNode.getId());
                    continue;
                }
                for (String billID : removeBillId) {
                    appNode.deleteChildNode(billID);
                }
            }
            if (removeAppNodeId.size() == appNodes.size()) {
                removCloudNode.add(cloudNode);
                continue;
            }
            for (String appID : removeAppNodeId) {
                cloudNode.deleteChildNode(appID);
            }
        }
        for (TreeNode cloudNode : removCloudNode) {
            clouds.remove(cloudNode);
        }
    }
}

