/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.checking.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class CheckingItemPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String KEY_BIZAPPENTRY = "bizappentry";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_METADATAITEM = "metadataitem";
    private static final String KEY_RELATIONITEM = "relationitem";

    public void registerListener(EventObject e) {
        AbstractGrid cloudGrid = (AbstractGrid)this.getControl(KEY_BIZAPPENTRY);
        cloudGrid.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"btnok", "selectallbt1", "selectallbt2"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        JSONArray apps = CheckingItemPlugin.getAppsInCloud((String)parameter.getCustomParam("bizcloudid"));
        this.getModel().deleteEntryData(KEY_BIZAPPENTRY);
        if (apps.size() > 0) {
            this.getModel().batchCreateNewEntryRow(KEY_BIZAPPENTRY, apps.size());
            for (int i = 0; i < apps.size(); ++i) {
                JSONObject app = apps.getJSONObject(i);
                this.getModel().setValue("apptext", (Object)(app.getString("name") + "(" + app.getString(KEY_NUMBER) + ")"), i);
                this.getModel().setValue("appid", (Object)apps.getJSONObject(i).getString("id"), i);
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "btnok": {
                this.getCheckingItem();
                break;
            }
            case "selectallbt1": {
                AbstractGrid grid = (AbstractGrid)this.getControl(KEY_BIZAPPENTRY);
                int[] items = grid.getEntryState().getSelectedRows();
                int size = this.getModel().getEntryEntity(KEY_BIZAPPENTRY).size();
                if (items.length < size) {
                    int[] item = new int[size];
                    for (int i = 0; i < size; ++i) {
                        item[i] = i;
                    }
                    grid.selectRows(item, 0);
                    break;
                }
                grid.selectRows(new int[0], 0);
                break;
            }
            case "selectallbt2": {
                if (((Boolean)this.getModel().getValue(KEY_METADATAITEM)).booleanValue() && ((Boolean)this.getModel().getValue(KEY_RELATIONITEM)).booleanValue()) {
                    this.getModel().setValue(KEY_METADATAITEM, (Object)Boolean.FALSE);
                    this.getModel().setValue(KEY_RELATIONITEM, (Object)Boolean.FALSE);
                    break;
                }
                this.getModel().setValue(KEY_METADATAITEM, (Object)Boolean.TRUE);
                this.getModel().setValue(KEY_RELATIONITEM, (Object)Boolean.TRUE);
                break;
            }
        }
    }

    private void getCheckingItem() {
        JSONObject arg = new JSONObject();
        JSONArray apps = new JSONArray();
        JSONArray errorApps = new JSONArray();
        JSONArray item = new JSONArray();
        AbstractGrid grid = (AbstractGrid)this.getControl(KEY_BIZAPPENTRY);
        int[] items = grid.getEntryState().getSelectedRows();
        for (int i = 0; i < items.length; ++i) {
            String appId = ((DynamicObject)this.getModel().getEntryEntity(KEY_BIZAPPENTRY).get(items[i])).getString("appid");
            try {
                AppMetaServiceHelper.loadAppMetadataById((String)appId, (boolean)false);
                apps.add((Object)appId);
                continue;
            }
            catch (KDException e) {
                errorApps.add((Object)appId);
            }
        }
        arg.put("appIds", (Object)apps);
        if (((Boolean)this.getModel().getValue(KEY_METADATAITEM)).booleanValue()) {
            item.add((Object)1);
        }
        if (((Boolean)this.getModel().getValue(KEY_RELATIONITEM)).booleanValue()) {
            item.add((Object)2);
        }
        arg.put("item", (Object)item);
        if (apps.isEmpty() && errorApps.isEmpty() || item.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u68c0\u67e5\u5185\u5bb9", (String)"CheckingItemPlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        HashMap<String, JSONArray> returnData = new HashMap<String, JSONArray>();
        returnData.put("items", item);
        returnData.put("apps", apps);
        returnData.put("errorapps", errorApps);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private static JSONArray getAppsInCloud(String bizCloudId) {
        String isv = AppUtils.getDeveloperInfo();
        JSONArray bizAppObjects = new JSONArray();
        QFilter q = new QFilter("bizcloud", "=", (Object)bizCloudId);
        QFilter[] filters = new QFilter[]{q};
        DynamicObject[] appObjects = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"id,name,number", (QFilter[])filters, (String)"isv desc");
        for (int i = 0; i < appObjects.length; ++i) {
            JSONObject app = new JSONObject();
            app.put("id", (Object)appObjects[i].getString("id"));
            app.put("name", (Object)appObjects[i].getLocaleString("name").getLocaleValue());
            app.put(KEY_NUMBER, (Object)appObjects[i].getString(KEY_NUMBER));
            bizAppObjects.add((Object)app);
        }
        return bizAppObjects;
    }
}

