/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.git;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.UUID;
import java.util.regex.Matcher;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.business.git.GitContext;
import kd.bos.devportal.business.git.GitDiffContext;
import kd.bos.devportal.business.git.GitLoginHandler;
import kd.bos.devportal.business.git.GitSettingDao;
import kd.bos.devportal.business.hosting.GitOperationUtil;
import kd.bos.encrypt.Encrypters;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.util.VersionManageUtil;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;

public class GitUtil {
    private static final String APP_TYPE = "APP_TYPE";
    private static final String BIZ_APP_ID = "bizappid";
    private static final String GIT_URL = "giturl";
    private static final String GIT_REPOSITORY = "gitrepository";
    private static final String GIT_GITBRANCH = "gitbranch";
    private static final String GIT_GITROOTPATH = "gitrootpath";
    public static final String CALLBACK_APP_GIT_CHECK_IN = "callback_app_git_check_in";
    public static final String CALLBACK_APP_GIT_LOGIN = "callback_app_git_login";
    public static final String CALLBACK_APP_GIT_LOGIN_UPDATE = "callback_app_git_login_update";
    private static final String GIT_CHOOSEFILE_CALLBACK = "gitChooseFileCallBack";
    private static final String BOS_DEVPORTAL_BUSINESS = "bos-devportal-business";
    private static final String GITMSG = "gitmsg";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String USERNAME = "username";
    private static final String P = "password";
    private static final String GITOPERATETYPE = "gitoperatetype";
    private static final String BIZAPPID = "bizappid";
    private static final String BIZUNITID = "bizunitid";
    public static final String GIT_USERNAME = "gitusername";
    private static final String LAST = "last";
    private static final String CURRENT = "current";
    private static final String COMMIT_ID = "commitId";
    private static final String CURRENT_COMMIT_ID = "currentCommitId";
    private static final String PERSONALGITREPOSITORY = "personalgitrepository";
    private static final String KEY_GITROOTPATH = "gitrootpath";
    private static final String TXT_SCRIPTNUMBER = "txt_scriptnumber";
    private static final String KEY_NUMBER = "number";
    private static final String CLOUD = "cloud";
    private static final String APP = "app";
    private static final String IS_SAVE = "issave";

    public static void checkInApp(JSONObject arg, AbstractFormPlugin plugin) {
        String bizAppId = arg.getString("bizappid");
        String sessionId = arg.getString(GITMSG);
        JSONObject cachedLoginInfo = GitOperationUtil.getCachedLoginInfo((String)sessionId, (String)bizAppId, null);
        if (cachedLoginInfo == null || StringUtils.isBlank((CharSequence)cachedLoginInfo.getString(USERNAME))) {
            GitUtil.showGitLoginPage("commit", APP, plugin, bizAppId);
            return;
        }
        String userName = cachedLoginInfo.getString(USERNAME);
        String password = cachedLoginInfo.getString(P);
        DynamicObject gitSetting = GitOperationUtil.getGitSetting((String)bizAppId, null, (String)userName);
        if (gitSetting == null) {
            String appNumber = MetadataDao.getAppNumberByAppId((String)bizAppId);
            if (appNumber == null) {
                appNumber = ResManager.loadKDString((String)"\u672a\u77e5\u5e94\u7528", (String)"TestObjectResult_0", (String)"bos-mservice-form", (Object[])new Object[0]);
            }
            plugin.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528[%s]\u6ca1\u6709\u914dgit\u5730\u5740\uff0c\u8bf7\u5148\u5230\u5e94\u7528\u5361\u7247\u4e0a\u914d\u7f6e\u3002", (String)"GitOperationUtil_7", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), appNumber));
            return;
        }
        String gitUrl = gitSetting.getString(GIT_URL);
        if (StringUtils.isBlank((CharSequence)gitUrl)) {
            plugin.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528git\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5230\u5e94\u7528\u5361\u7247\u4e0a\u914d\u7f6e\u3002", (String)"GitOperationUtil_8", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            return;
        }
        String gitRepository = gitSetting.getString(GIT_REPOSITORY);
        if (StringUtils.isBlank((CharSequence)gitRepository)) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u4ed3\u5e93\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5230\u5e94\u7528\u5361\u7247\u4e0a\u914d\u7f6e\u3002", (String)"GitOperationUtil_9", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            return;
        }
        String gitbranch = gitSetting.getString(GIT_GITBRANCH);
        if (gitbranch.trim().length() == 0) {
            plugin.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u586b\u5199Git\u8fdc\u7a0b\u5206\u652f\u3002", (String)"GITManagePlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String gitrootpath = gitSetting.getString("gitrootpath");
        if (gitrootpath.trim().length() == 0) {
            plugin.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u586b\u5199Git\u8fdc\u7a0b\u6839\u76ee\u5f55\u3002", (String)"GITManagePlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        plugin.getPageCache().put("jsessionid", sessionId);
        plugin.getPageCache().put("bizappid", bizAppId);
        plugin.getPageCache().put("checkintype", APP_TYPE);
        GitOperationUtil.commitByApp((String)bizAppId, (String)gitUrl, (String)gitRepository, (String)gitbranch, (String)gitrootpath, (String)sessionId, (AbstractFormPlugin)plugin, (String)userName, (String)password);
    }

    public static void chooseFileByAppId(JSONObject arg, AbstractFormPlugin plugin) {
        String bizAppId = arg.getString("bizappid");
        String sessionId = arg.getString(GITMSG);
        GitContext context = new GitContext();
        context.setBizAppId(bizAppId);
        context.setSessionId(sessionId);
        boolean hasLogin = GitLoginHandler.hasLogin((GitContext)context, (AbstractFormPlugin)plugin);
        if (hasLogin) {
            return;
        }
        GitSettingDao dao = new GitSettingDao();
        DynamicObject setting = dao.getSetting(context.getBizAppId(), context.getBizUnitId(), context.getUserName());
        String gitBranch = setting.getString(GIT_GITBRANCH);
        String gitRepository = setting.getString(GIT_REPOSITORY);
        String gitRootPath = setting.getString("gitrootpath");
        String personalGitRepository = GitOperationUtil.getPersonalGitRepository((String)gitRepository, (String)context.getUserName());
        String personalRepositoryPath = personalGitRepository + File.separator + ".git";
        File file = new File(personalRepositoryPath);
        if (!file.exists()) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u5730\u4ed3\u5e93\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u70b9\u51fb\u62c9\u53d6\u5c06\u8fdc\u7a0b\u4ed3\u5e93\u62c9\u53d6\u81f3\u672c\u5730\u3002", (String)"GitUtil_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devp_gitchoosefile");
        gitRootPath = GitUtil.getMetadataRootPath(gitRootPath);
        parameter.setCustomParam("type", (Object)APP_TYPE);
        parameter.setCustomParam("gitoperatekey", (Object)"commit");
        parameter.setCustomParam(GITOPERATETYPE, (Object)APP);
        parameter.setCustomParam(GITMSG, (Object)sessionId);
        parameter.setCustomParam("address", (Object)personalGitRepository);
        parameter.setCustomParam(GIT_GITBRANCH, (Object)gitBranch);
        parameter.setCustomParam("bizappid", (Object)bizAppId);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)plugin, GIT_CHOOSEFILE_CALLBACK);
        parameter.setCloseCallBack(callBack);
        plugin.getView().showForm(parameter);
    }

    private static void showGitLoginPage(String operateKey, String type, AbstractFormPlugin plugin, String bizAppId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devp_gitlogin");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, CALLBACK_APP_GIT_LOGIN));
        parameter.setCustomParam(GITOPERATETYPE, (Object)operateKey);
        parameter.setCustomParam(GITOPERATETYPE, (Object)type);
        parameter.setCustomParam(GITMSG, (Object)UUID.randomUUID().toString());
        parameter.setCustomParam("bizappid", (Object)bizAppId);
        plugin.getView().showForm(parameter);
    }

    private static String getCachedLoginInfo(String gitUrl, String sessionId) {
        SessionDAO sessionDao = SessionDAOFactory.getSessionDAO((String)sessionId);
        String sessionKey = GitOperationUtil.getSessionKey((String)gitUrl, (String)sessionId);
        return sessionDao.getAttribute(sessionKey);
    }

    public static void UpdateApp(JSONObject arg, AbstractFormPlugin plugin) {
        String selectFields = "id,giturl,gitrepository,gitbranch,gitrootpath,managetype";
        String bizAppId = arg.getString("bizappid");
        QFilter filter = new QFilter("bizappid", "=", (Object)bizAppId);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"svnmanage", (String)selectFields, (QFilter[])new QFilter[]{filter});
        if (dynamicObjects.length == 0) {
            String appNumber = MetadataDao.getAppNumberByAppId((String)bizAppId);
            if (appNumber == null) {
                appNumber = ResManager.loadKDString((String)"\u672a\u77e5\u5e94\u7528", (String)"TestObjectResult_0", (String)"bos-mservice-form", (Object[])new Object[0]);
            }
            plugin.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528[%s]\u6ca1\u6709\u914dgit\u5730\u5740\uff0c\u8bf7\u5148\u5230\u5e94\u7528\u5361\u7247\u4e0a\u914d\u7f6e\u3002", (String)"GitOperationUtil_7", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), appNumber));
            return;
        }
        String gitUrl = dynamicObjects[0].getString(GIT_URL);
        if (StringUtils.isBlank((CharSequence)gitUrl)) {
            plugin.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528git\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5230\u5e94\u7528\u5361\u7247\u4e0a\u914d\u7f6e\u3002", (String)"GitOperationUtil_8", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            return;
        }
        String gitRepository = dynamicObjects[0].getString(GIT_REPOSITORY);
        if (StringUtils.isBlank((CharSequence)gitRepository)) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u4ed3\u5e93\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5230\u5e94\u7528\u5361\u7247\u4e0a\u914d\u7f6e\u3002", (String)"GitOperationUtil_9", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            return;
        }
        String gitbranch = dynamicObjects[0].getString(GIT_GITBRANCH);
        String gitrootpath = dynamicObjects[0].getString("gitrootpath");
        String sessionId = arg.getString(GITMSG);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParam("gitoperatekey", (Object)"commit");
        parameter.setCustomParam(GITOPERATETYPE, (Object)APP);
        parameter.setCustomParam(GITMSG, (Object)sessionId);
        parameter.setCustomParam("bizappid", (Object)bizAppId);
        parameter.setCustomParam(GIT_URL, (Object)gitUrl);
        parameter.setCustomParam(GIT_REPOSITORY, (Object)gitRepository);
        parameter.setCustomParam(GIT_GITBRANCH, (Object)gitbranch);
        parameter.setCustomParam("gitrootpath", (Object)gitrootpath);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devp_gitlogin");
        parameter.setCaption(ResManager.loadKDString((String)"\u767b\u5f55GIT", (String)"GITManagePlugin_20", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)plugin, CALLBACK_APP_GIT_LOGIN_UPDATE);
        if (StringUtils.isBlank((CharSequence)sessionId) || "undefined".equals(sessionId) || "null".equals(sessionId)) {
            sessionId = UUID.randomUUID().toString();
        } else {
            String loginInfo = GitUtil.getCachedLoginInfo(gitUrl, sessionId);
            if (StringUtils.isNotBlank((CharSequence)loginInfo)) {
                JSONObject userLogin = JSONObject.parseObject((String)loginInfo);
                String userName = userLogin.getString(USERNAME);
                String passWord = userLogin.getString(P);
                if (StringUtils.isNotBlank((CharSequence)userName) && StringUtils.isNotBlank((CharSequence)passWord)) {
                    plugin.getPageCache().put(USERNAME, userName);
                    plugin.getPageCache().put(P, passWord);
                    String id = arg.getString("id");
                    GitOperationUtil.gitConfirmOperate((String)id, (String)APP, (String)"pull", (String)arg.getString(GITMSG), (AbstractFormPlugin)plugin);
                }
            }
        }
    }

    public static void showDiff(GitDiffContext context, FormShowParameter parameter) {
        QFilter qFilter;
        parameter.setFormId("bos_devp_gitdifference");
        parameter.setPageId(UUID.randomUUID().toString());
        String noUpdate = (String)parameter.getCustomParam("noUpdate");
        if (!"true".equals(noUpdate)) {
            String rootPath = context.getGitRootPath();
            String personalRepository = context.getPersonalGitRepository();
            parameter.setCustomParam(PERSONALGITREPOSITORY, (Object)personalRepository);
            parameter.setCustomParam("gitrootpath", (Object)rootPath);
        }
        parameter.setCustomParam(COMMIT_ID, (Object)context.getOldCommit());
        parameter.setCustomParam(CURRENT_COMMIT_ID, (Object)context.getNewCommit());
        parameter.setCustomParam(LAST, (Object)Encrypters.encode((String)VersionManageUtil.compress((String)context.getOldContent())));
        parameter.setCustomParam(CURRENT, (Object)Encrypters.encode((String)VersionManageUtil.compress((String)context.getNewContent())));
        parameter.setCustomParam(IS_SAVE, (Object)false);
        String fileName = context.getFileName();
        String[] split = fileName.trim().split("\\.");
        boolean isCloud = split[split.length - 1].contains("cld");
        boolean isApp = split[split.length - 1].contains(APP);
        String type = null;
        DynamicObject dym = null;
        if (fileName.endsWith("ks")) {
            String scriptName = fileName.split("\\.")[0];
            qFilter = new QFilter(TXT_SCRIPTNUMBER, "=", (Object)scriptName);
            dym = BusinessDataServiceHelper.loadSingle((String)"ide_pluginscript", (String)"ID,bizappid", (QFilter[])new QFilter[]{qFilter});
            type = "script";
        } else if (fileName.contains("dym")) {
            String pageName = fileName.split("\\.")[0];
            qFilter = new QFilter(KEY_NUMBER, "=", (Object)pageName);
            dym = BusinessDataServiceHelper.loadSingle((String)"bos_formmeta", (String)"ID,bizappid", (QFilter[])new QFilter[]{qFilter});
            type = "page";
        } else if (isCloud) {
            type = CLOUD;
        } else if (isApp) {
            String appNumber = fileName.split("\\.")[0];
            qFilter = new QFilter(KEY_NUMBER, "=", (Object)appNumber);
            dym = BusinessDataServiceHelper.loadSingle((String)"bos_devportal_bizapp", (String)"ID,bizappid", (QFilter[])new QFilter[]{qFilter});
            type = APP;
        }
        if (dym != null) {
            String id = dym.getString("ID");
            String bizAppId = null;
            bizAppId = StringUtils.equals((CharSequence)APP, (CharSequence)type) ? dym.getString("id") : dym.getString("bizappid");
            parameter.setCustomParam("id", (Object)id);
            parameter.setCustomParam("bizappid", (Object)bizAppId);
        }
        parameter.setCustomParam("filepath", (Object)context.getFilePath());
        parameter.setCustomParam("type", (Object)type);
        parameter.setCaption(ResManager.loadKDString((String)"\u6587\u4ef6\u6bd4\u8f83", (String)"GITPushPlugin_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        OpenStyle style = new OpenStyle();
        StyleCss cssStyle = new StyleCss();
        cssStyle.setHeight("760");
        cssStyle.setWidth("1200");
        style.setInlineStyleCss(cssStyle);
        style.setShowType(ShowType.Modal);
        parameter.setOpenStyle(style);
    }

    public static String getMetadataRootPath(String gitRootpath) {
        String result = "";
        String separator = Matcher.quoteReplacement(File.separator);
        if (!StringUtils.isBlank((CharSequence)gitRootpath)) {
            result = !(gitRootpath = gitRootpath.replaceAll("\\\\", separator).replaceAll("/", separator)).startsWith(File.separator) ? File.separator + gitRootpath : gitRootpath;
        }
        return result;
    }
}

