/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.git.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.plugin.BaseBizAppTreePlugin;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;

public class BizAppTreeWithGitPlugin
extends BaseBizAppTreePlugin {
    private static final String BTN_COMMIT = "btn_commit";
    private static final String BTN_PUSH = "btn_push";
    private static final String BTN_COMMIT_PUSH = "btn_commit_push";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_COMMIT, BTN_PUSH, BTN_COMMIT_PUSH});
    }

    @Override
    protected boolean setPath(String bizAppId) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object giturl = showParameter.getCustomParam("giturl");
        Object gitbranch = showParameter.getCustomParam("gitbranch");
        Object gitrepository = showParameter.getCustomParam("gitrepository");
        this.getModel().setValue("git_path", giturl);
        this.getModel().setValue("git_repository", gitrepository);
        this.getModel().setValue("gitbranch", gitbranch);
        return true;
    }

    @Override
    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "btn_commit": {
                this.commit();
                break;
            }
            case "btn_push": {
                break;
            }
            case "btn_commit_push": {
                break;
            }
        }
    }

    private void commit() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String bizAppId = (String)formShowParameter.getCustomParam("bizappid");
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            this.getView().showTipNotification(DevportalUtil.getNoPermissionTip());
            return;
        }
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        List selectNodes = tree.getTreeState().getSelectedNodes();
        boolean containAppResource = (Boolean)this.getModel().getValue("checkinapp");
        String type = (String)formShowParameter.getCustomParam("type");
        if (!containAppResource && "APP_TYPE".equals(type) && selectNodes.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u5143\u6570\u636e\u3002", (String)"BizAppTreePlugin_3", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> pageIds = new ArrayList<String>();
        ArrayList<String> scriptIds = new ArrayList<String>();
        ArrayList<String> unitTestIds = new ArrayList<String>();
        for (Map selectNode : selectNodes) {
            String parentId = (String)selectNode.get("parentid");
            String bizId = (String)selectNode.get("id");
            if (parentId.endsWith("_page")) {
                pageIds.add(bizId);
                continue;
            }
            if (parentId.endsWith("_script")) {
                scriptIds.add(bizId);
                continue;
            }
            if (!parentId.endsWith("_unittest")) continue;
            unitTestIds.add(bizId);
        }
        String annotation = (String)this.getModel().getValue("annotation");
        String pageUnits = this.getView().getPageCache().get("pageUnits");
        String scriptUnits = this.getView().getPageCache().get("scriptUnits");
        JSONObject msg = new JSONObject();
        msg.put("gitoperatekey", (Object)"commit");
        msg.put("bizappid", (Object)bizAppId);
        msg.put("type", (Object)"app");
        msg.put("annotation", (Object)annotation);
        msg.put("pageids", (Object)SerializationUtils.toJsonString(pageIds));
        msg.put("scriptids", (Object)SerializationUtils.toJsonString(scriptIds));
        msg.put("unittestids", (Object)SerializationUtils.toJsonString(unitTestIds));
        msg.put("checkinappflag", (Object)containAppResource);
        msg.put("gitmsg", formShowParameter.getCustomParam("gitmsg"));
        msg.put("username", formShowParameter.getCustomParam("username"));
        msg.put("password", formShowParameter.getCustomParam("password"));
        msg.put("pageUnits", (Object)pageUnits);
        msg.put("scriptUnits", (Object)scriptUnits);
        this.getView().returnDataToParent((Object)msg.toJSONString());
        this.getView().close();
    }
}

