/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.git.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.business.hosting.GITCodeHostingServiceImpl;
import kd.bos.devportal.business.hosting.GitOperationUtil;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class GITCommitPlugin
extends AbstractFormPlugin {
    private static final String KEY_GITURL = "giturl";
    private static final String KEY_GITBRANCH = "gitbranch";
    private static final String KEY_ANNOTATION = "annotation";
    private static final String KEY_GITREPOSITORY = "gitrepository";
    private static final String KEY_PAGEIDS = "pageids";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"commit", "commitandpush"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String giturl = (String)formShowParameter.getCustomParam(KEY_GITURL);
        String gitBranch = (String)formShowParameter.getCustomParam(KEY_GITBRANCH);
        String gitRepository = (String)formShowParameter.getCustomParam(KEY_GITREPOSITORY);
        String type = (String)formShowParameter.getCustomParam("gitoperatetype");
        String id = (String)formShowParameter.getCustomParam("gitoperateid");
        this.getModel().setValue(KEY_GITURL, (Object)giturl);
        this.getModel().setValue(KEY_GITBRANCH, (Object)gitBranch);
        this.getModel().setValue(KEY_GITREPOSITORY, (Object)gitRepository);
        if ("page".equals(type)) {
            List<DeployFile> list = MetadataDao.getFormDeployFile((String)id);
            list = list.stream().filter(f -> !GitOperationUtil.isIgnoreFile((String)f.getFileName())).collect(Collectors.toList());
            this.addToEntryRow(list, 0);
        } else if ("script".equals(type)) {
            List deployFileList = MetadataDao.getScriptDeployFile((String[])new String[]{id});
            DeployFile df = (DeployFile)deployFileList.get(0);
            String fileName = df.getFileName();
            this.getModel().batchCreateNewEntryRow("entryentity", 1);
            this.getModel().setValue("filename", (Object)fileName, 0);
            this.getModel().setValue("status", (Object)ResManager.loadKDString((String)"\u5f85\u63d0\u4ea4", (String)"GITCommitPlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]), 0);
        } else if ("app".equals(type)) {
            JSONObject commitParams = JSONObject.parseObject((String)((String)formShowParameter.getCustomParam("commitParams")));
            String bizAppId = commitParams.getString("bizappid");
            this.getModel().setValue(KEY_ANNOTATION, (Object)commitParams.getString(KEY_ANNOTATION), 0);
            List scriptIds = (List)SerializationUtils.fromJsonString((String)commitParams.getString("scriptids"), List.class);
            List pageIds = (List)SerializationUtils.fromJsonString((String)commitParams.getString(KEY_PAGEIDS), List.class);
            Map pageUnits = (Map)SerializationUtils.fromJsonString((String)commitParams.getString("pageUnits"), Map.class);
            boolean containAppMenu = commitParams.getBooleanValue("checkinappflag");
            int startIndex = 0;
            if (scriptIds != null && !scriptIds.isEmpty()) {
                List scriptDeployFile = MetadataDao.getScriptDeployFile((String[])scriptIds.toArray(new String[0]));
                this.addToEntryRow(scriptDeployFile, startIndex);
                startIndex += scriptDeployFile.size();
            }
            if (pageIds != null && !pageIds.isEmpty()) {
                for (String pageId : pageIds) {
                    String unitId = (String)pageUnits.get(pageId);
                    List<DeployFile> formDeployFile = MetadataDao.getFormDeployFile((String)pageId, (String)bizAppId, (String)unitId);
                    formDeployFile = formDeployFile.stream().filter(f -> !GitOperationUtil.isIgnoreFile((String)f.getFileName())).collect(Collectors.toList());
                    this.addToEntryRow(formDeployFile, startIndex);
                    startIndex += formDeployFile.size();
                }
            }
            if (containAppMenu) {
                List<DeployFile> appMenus = AppMetaServiceHelper.getAppDeployFile((String)bizAppId);
                appMenus = appMenus.stream().filter(f -> !GitOperationUtil.isIgnoreFile((String)f.getFileName())).collect(Collectors.toList());
                this.addToEntryRow(appMenus, startIndex);
            }
        } else if ("cloud".equals(type)) {
            List list = MetadataDao.getCloudDeployFile((String)id);
            this.addToEntryRow(list, 0);
        } else if ("botp_cr".equals(type) || "botp_wb".equals(type) || "botp_bur".equals(type)) {
            JSONArray ruleIds = (JSONArray)JSONArray.parse((String)formShowParameter.getCustomParam("ruleIds").toString());
            List<DeployFile> convertRuleDeployFiles = GitOperationUtil.getBotpDeployFiles((String)type, (JSONArray)ruleIds);
            convertRuleDeployFiles = convertRuleDeployFiles.stream().filter(f -> !GitOperationUtil.isIgnoreFile((String)f.getFileName())).collect(Collectors.toList());
            this.addToEntryRow(convertRuleDeployFiles, 0);
        }
    }

    private void addToEntryRow(List<DeployFile> fileList, int startIndex) {
        this.getModel().batchCreateNewEntryRow("entryentity", fileList.size());
        for (int i = 0; i < fileList.size(); ++i) {
            this.getModel().setValue("filename", (Object)fileList.get(i).getFileName(), startIndex + i);
            this.getModel().setValue("status", (Object)ResManager.loadKDString((String)"\u5f85\u63d0\u4ea4", (String)"GITCommitPlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]), startIndex + i);
        }
    }

    public void click(EventObject e) {
        String key = ((Control)e.getSource()).getKey().toLowerCase();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String userName = (String)formShowParameter.getCustomParam("username");
        String passWord = (String)formShowParameter.getCustomParam("password");
        String personalGitRepository = (String)formShowParameter.getCustomParam("personalgitrepository");
        String type = (String)formShowParameter.getCustomParam("gitoperatetype");
        String id = (String)formShowParameter.getCustomParam("gitoperateid");
        String gitBranch = (String)formShowParameter.getCustomParam(KEY_GITBRANCH);
        String gitRootpath = (String)formShowParameter.getCustomParam("gitrootpath");
        String annotation = (String)this.getModel().getValue(KEY_ANNOTATION);
        if (StringUtils.isBlank((CharSequence)annotation)) {
            annotation = ResManager.loadKDString((String)"git\u63d0\u4ea4\u64cd\u4f5c", (String)"GITCommitPlugin_1", (String)"bos-devportal-plugin", (Object[])new Object[0]);
        }
        String bizAppId = GitOperationUtil.getBizAppIdAndFileNameByType((String)type, (String)id).getString("bizappid");
        String metaDataGitRepository = GitOperationUtil.getMetadataGitRepository((String)personalGitRepository, (String)bizAppId, (String)gitRootpath);
        ArrayList<String> fileNames = new ArrayList<String>();
        String result = null;
        if ("page".equals(type)) {
            this.addPageToCommitFiles(id, metaDataGitRepository, fileNames);
        } else if ("cloud".equals(type)) {
            this.addCloudToCommitFiles(id, metaDataGitRepository, fileNames);
        } else if ("script".equals(type)) {
            this.addScriptToCommitFiles(id, metaDataGitRepository, fileNames);
        } else if ("APP_TYPE".equals(type) || "app".equals(type)) {
            JSONObject commitParams = JSONObject.parseObject((String)((String)formShowParameter.getCustomParam("commitParams")));
            String gitoperatekey = commitParams.getString("gitoperatekey");
            List scriptIds = (List)SerializationUtils.fromJsonString((String)commitParams.getString("scriptids"), List.class);
            List pageIds = (List)SerializationUtils.fromJsonString((String)commitParams.getString(KEY_PAGEIDS), List.class);
            boolean containAppMenu = commitParams.getBooleanValue("checkinappflag");
            for (String scriptId : scriptIds) {
                this.addScriptToCommitFiles(scriptId, metaDataGitRepository, fileNames);
            }
            for (String pageId : pageIds) {
                this.addPageToCommitFiles(pageId, metaDataGitRepository, fileNames);
            }
            if (containAppMenu) {
                this.addAppToCommitFiles(bizAppId, metaDataGitRepository, fileNames);
            }
        } else if ("botp_cr".equals(type) || "botp_wb".equals(type) || "botp_bur".equals(type)) {
            JSONArray ruleIds = (JSONArray)JSONArray.parse((String)formShowParameter.getCustomParam("ruleIds").toString());
            List convertRuleDeployFiles = GitOperationUtil.getBotpDeployFiles((String)type, (JSONArray)ruleIds);
            this.addConvertRuleToCommitFiles(bizAppId, metaDataGitRepository, convertRuleDeployFiles, fileNames);
        }
        result = GITCodeHostingServiceImpl.commit((String)personalGitRepository, (String)annotation, fileNames, (String)userName);
        this.writeLog(id);
        JSONObject returnResult = new JSONObject();
        if ("commitandpush".equals(key)) {
            result = result + "_commitandpush";
            String gitUrl = (String)formShowParameter.getCustomParam(KEY_GITURL);
            String gitRepository = (String)formShowParameter.getCustomParam(KEY_GITREPOSITORY);
            String gitbranch = (String)formShowParameter.getCustomParam(KEY_GITBRANCH);
            String gitrootpath = (String)formShowParameter.getCustomParam("gitrootpath");
            String projectURL = (String)formShowParameter.getCustomParam("projecturl");
            returnResult.put(KEY_GITURL, (Object)gitUrl);
            returnResult.put(KEY_GITREPOSITORY, (Object)gitRepository);
            returnResult.put(KEY_GITBRANCH, (Object)gitbranch);
            returnResult.put("gitrootpath", (Object)gitrootpath);
            returnResult.put("projecturl", (Object)projectURL);
            returnResult.put("personalgitrepository", (Object)personalGitRepository);
            returnResult.put("id", (Object)id);
            returnResult.put("type", (Object)type);
            returnResult.put("username", (Object)userName);
            returnResult.put("password", (Object)passWord);
        }
        returnResult.put("result", (Object)result);
        this.getView().returnDataToParent((Object)returnResult);
        this.getView().close();
    }

    private void writeLog(String id) {
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u63d0\u4ea4", "GitCommitPlugin_12", "bos-devportal-plugin");
        MultiLangEnumBridge opDescription = new MultiLangEnumBridge("Git\u63d0\u4ea4\u5143\u6570\u636e", "GitCommitPlugin_14", "bos-devportal-plugin");
        AppUtils.addOpLog((String)id, (String)"commit", (String)id, (String)"1", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[0]);
    }

    private void addScriptToCommitFiles(String id, String metaDataGitRepository, List<String> fileNames) {
        List deployFileList = MetadataDao.getScriptDeployFile((String[])new String[]{id});
        DeployFile df = (DeployFile)deployFileList.get(0);
        String fileName = df.getFileName();
        String fileContent = df.getFileContent();
        fileNames.add(fileName);
        GitOperationUtil.saveFile((String)fileName, (String)fileContent, (String)metaDataGitRepository);
    }

    private void addPageToCommitFiles(String id, String metaDataGitRepository, List<String> fileNames) {
        List list = MetadataDao.getFormDeployFile((String)id);
        for (DeployFile deployFile : list) {
            String fileName = deployFile.getFileName();
            if (GitOperationUtil.isIgnoreFile((String)fileName)) continue;
            String fileContent = deployFile.getFileContent();
            GitOperationUtil.saveFile((String)fileName, (String)fileContent, (String)metaDataGitRepository);
            fileNames.add(fileName);
        }
    }

    private void addAppToCommitFiles(String bizAppId, String metaDataGitRepository, List<String> fileNames) {
        List list = AppMetaServiceHelper.getAppDeployFile((String)bizAppId);
        for (DeployFile deployFile : list) {
            String fileName = deployFile.getFileName();
            if (GitOperationUtil.isIgnoreFile((String)fileName)) continue;
            String fileContent = deployFile.getFileContent();
            GitOperationUtil.saveFile((String)fileName, (String)fileContent, (String)metaDataGitRepository);
            fileNames.add(fileName);
        }
    }

    private void addConvertRuleToCommitFiles(String bizAppId, String metaDataGitRepository, List<DeployFile> convertRuleDeployFiles, List<String> fileNames) {
        for (DeployFile deployFile : convertRuleDeployFiles) {
            String fileName = deployFile.getFileName();
            if (GitOperationUtil.isIgnoreFile((String)fileName)) continue;
            String fileContent = deployFile.getFileContent();
            GitOperationUtil.saveFile((String)fileName, (String)fileContent, (String)metaDataGitRepository);
            fileNames.add(fileName);
        }
    }

    private void addCloudToCommitFiles(String id, String metaDataGitRepository, List<String> fileNames) {
        List list = MetadataDao.getCloudDeployFile((String)id);
        for (DeployFile deployFile : list) {
            String fileName = deployFile.getFileName();
            if (GitOperationUtil.isIgnoreFile((String)fileName)) continue;
            String fileContent = deployFile.getFileContent();
            GitOperationUtil.saveFile((String)fileName, (String)fileContent, (String)metaDataGitRepository);
            fileNames.add(fileName);
        }
    }
}

