/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.git.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.business.hosting.GITCodeHostingServiceImpl;
import kd.bos.devportal.business.hosting.GitOperationUtil;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.encrypt.Encrypters;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import org.eclipse.jgit.api.errors.GitAPIException;

public class GITLoginPlugin
extends AbstractFormPlugin {
    private static final String KEY_BIZAPPID = "bizappid";
    private static final String KEY_GITURL = "giturl";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String CALL_FROM_GIT_MANAGE = "callFromGitManage";
    private static final String GIT_BRANCH = "gitbranch";
    private static final String USERNAME = "username";
    private static final String HIDEITEM = "password";
    private static final String GIT_REPOSITORY = "gitrepository";
    private static final String GIT_ROOT_PATH = "gitrootpath";
    private static final String GITMSG = "gitmsg";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject gitSetting;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String bizAppId = (String)formShowParameter.getCustomParam(KEY_BIZAPPID);
        if (StringUtils.isBlank((CharSequence)bizAppId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5e94\u7528ID\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"GITLoginPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        QFilter filter = new QFilter(KEY_BIZAPPID, "=", (Object)bizAppId);
        String bizunitid = (String)formShowParameter.getCustomParam("bizunitid");
        String selectFields = "id,giturl,gitbranch,gitrootpath,bizunitid";
        String gitUrl = (String)formShowParameter.getCustomParam(KEY_GITURL);
        String gitBranch = "";
        String callFromGitManage = (String)formShowParameter.getCustomParam(CALL_FROM_GIT_MANAGE);
        if (!StringUtils.isBlank((CharSequence)callFromGitManage)) {
            gitUrl = (String)formShowParameter.getCustomParam(KEY_GITURL);
            gitBranch = (String)formShowParameter.getCustomParam(GIT_BRANCH);
        } else if (StringUtils.isBlank((CharSequence)gitUrl) && (gitSetting = GitOperationUtil.getGitSetting((String)bizAppId, (String)bizunitid, null)) != null) {
            gitUrl = gitSetting.getString(KEY_GITURL);
            gitBranch = gitSetting.getString(GIT_BRANCH);
        }
        if (StringUtils.isBlank((CharSequence)gitUrl)) {
            gitUrl = DevportalUtil.getGitCommonRemoteUrl();
        }
        this.getModel().setValue(KEY_GITURL, (Object)gitUrl);
        this.getModel().setValue(GIT_BRANCH, (Object)gitBranch);
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "btnok": {
                this.btnOk();
                break;
            }
        }
    }

    private String getNotAuthorizedMsg() {
        return ResManager.loadKDString((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u6b63\u786e\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002", (String)"GITLoginPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
    }

    private void btnOk() {
        String passWord;
        String userName = (String)this.getModel().getValue(USERNAME);
        if (this.checkAccount(userName, passWord = (String)this.getModel().getValue(HIDEITEM))) {
            return;
        }
        String encryptPassWord = Encrypters.encode((String)passWord);
        boolean ischecked = (Boolean)this.getModel().getValue("ischecked");
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String sessionId = (String)parameter.getCustomParam(GITMSG);
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            sessionId = UUID.randomUUID().toString();
        }
        String bizappid = (String)parameter.getCustomParam(KEY_BIZAPPID);
        String bizunitid = (String)parameter.getCustomParam("bizunitid");
        String gitUrl = (String)this.getModel().getValue(KEY_GITURL);
        String gitBranch = (String)this.getModel().getValue(GIT_BRANCH);
        try {
            GITCodeHostingServiceImpl.checkRemoteAccount((String)gitUrl, (String)userName, (String)passWord);
            List branchs = GitOperationUtil.getBranchs((String)gitUrl, (String)userName, (String)passWord);
            String branch = gitBranch == null ? "" : gitBranch;
            boolean existBranch = branchs.stream().anyMatch(b -> b.equals(branch));
            if (!existBranch) {
                this.getView().showMessage(ResManager.loadKDString((String)"Git\u8fdc\u7a0b\u5206\u652f\u4e0d\u5b58\u5728\u6216\u6ca1\u6709\u6743\u9650\u67e5\u770b\u3002", (String)"GITManagePlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            if (ischecked) {
                this.saveGitLoginInfo(gitUrl, bizappid, bizunitid, userName, encryptPassWord, sessionId);
            }
        }
        catch (GitAPIException e) {
            if (e.getMessage().contains("not authorized")) {
                this.getView().showMessage(this.getNotAuthorizedMsg());
            } else {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u8fdc\u7a0b\u4ed3\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u65e0\u6cd5\u8fde\u63a5\u201c%s\u201d\u3002", (String)"GITLoginPlugin_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), e.getMessage()));
            }
            return;
        }
        String gitRepository = (String)parameter.getCustomParam(GIT_REPOSITORY);
        String gitRootpath = (String)parameter.getCustomParam(GIT_ROOT_PATH);
        String callFromGitManage = (String)parameter.getCustomParam(CALL_FROM_GIT_MANAGE);
        if (!StringUtils.isBlank((CharSequence)callFromGitManage)) {
            JSONObject msg = new JSONObject();
            msg.put(KEY_GITURL, (Object)gitUrl);
            if (StringUtils.isBlank((CharSequence)gitBranch)) {
                gitBranch = (String)parameter.getCustomParam(GIT_BRANCH);
            }
            msg.put(GIT_BRANCH, (Object)gitBranch);
            msg.put(USERNAME, (Object)userName);
            msg.put(HIDEITEM, (Object)passWord);
            msg.put(CALL_FROM_GIT_MANAGE, (Object)callFromGitManage);
            this.getView().returnDataToParent((Object)msg.toJSONString());
            this.getView().close();
            return;
        }
        DynamicObject gitSetting = GitOperationUtil.getGitSetting((String)bizappid, (String)bizunitid, (String)userName);
        if (gitSetting == null) {
            String appNumber = MetadataDao.getAppNumberByAppId((String)bizappid);
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528[%s]\u6ca1\u6709\u914dgit\u5730\u5740\uff0c\u8bf7\u5148\u5230\u5e94\u7528\u5361\u7247\u4e0a\u914d\u7f6e\u3002", (String)"GitOperationUtil_7", (String)"bos-devportal-business", (Object[])new Object[0]), appNumber));
            return;
        }
        gitUrl = gitSetting.getString(KEY_GITURL);
        gitRepository = gitSetting.getString(GIT_REPOSITORY);
        gitBranch = gitSetting.getString(GIT_BRANCH);
        gitRootpath = gitSetting.getString(GIT_ROOT_PATH);
        String personalGitRepository = GitOperationUtil.getPersonalGitRepository((String)gitRepository, (String)userName);
        boolean result = false;
        try {
            result = GITCodeHostingServiceImpl.checkAccount((String)gitUrl, (String)personalGitRepository, (String)gitBranch, (String)gitRootpath, (String)userName, (String)passWord);
        }
        catch (GitAPIException e) {
            String msg = String.format(ResManager.loadKDString((String)"\u8fdc\u7a0b\u4ed3\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u65e0\u6cd5\u8fde\u63a5\u201c%s\u201d\u3002", (String)"GITLoginPlugin_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), e.getMessage());
            this.getView().showMessage(msg);
            return;
        }
        if (!result) {
            this.getView().showMessage(this.getNotAuthorizedMsg());
            return;
        }
        JSONObject msg = new JSONObject();
        msg.put(KEY_GITURL, (Object)gitUrl);
        msg.put(USERNAME, (Object)userName);
        msg.put(HIDEITEM, (Object)encryptPassWord);
        msg.put("ischecked", (Object)ischecked);
        msg.put("gitoperatekey", parameter.getCustomParam("gitoperatekey"));
        msg.put("gitoperateid", parameter.getCustomParam("gitoperateid"));
        msg.put("gitoperatetype", parameter.getCustomParam("gitoperatetype"));
        msg.put(GITMSG, (Object)sessionId);
        msg.put(GIT_REPOSITORY, (Object)gitRepository);
        msg.put(GIT_BRANCH, (Object)gitBranch);
        msg.put(GIT_ROOT_PATH, (Object)gitRootpath);
        msg.put("personalgitrepository", (Object)personalGitRepository);
        msg.put(KEY_BIZAPPID, (Object)bizappid);
        if (ischecked) {
            this.saveGitLoginInfo(gitUrl, bizappid, bizunitid, userName, encryptPassWord, sessionId);
        }
        this.getView().returnDataToParent((Object)msg.toJSONString());
        this.getView().close();
    }

    private boolean checkAccount(String userName, String passWord) {
        if (StringUtils.isBlank((CharSequence)userName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GITLoginPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return true;
        }
        if (StringUtils.isBlank((CharSequence)passWord)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GITLoginPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void saveGitLoginInfo(String gitUrl, String bizAppId, String bizUnitId, String userName, String passWord, String sessionId) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String sessionKey = GitOperationUtil.getSessionKey((String)gitUrl, (String)sessionId);
        SessionDAO sessionDao = SessionDAOFactory.getSessionDAO((String)sessionId);
        JSONObject userInfo = new JSONObject();
        userInfo.put(USERNAME, (Object)userName);
        userInfo.put(HIDEITEM, (Object)passWord);
        userInfo.put("sessionid", (Object)sessionId);
        String jsonString = userInfo.toJSONString();
        sessionDao.setAttribute(sessionKey, jsonString);
        String sessionKeyByApp = GitOperationUtil.getSessionKeyByApp((String)bizAppId, (String)bizUnitId, (String)sessionId);
        sessionDao.setAttribute(sessionKeyByApp, jsonString);
        SessionManager.getCurrent().put(GitOperationUtil.getSessionByRequestContext() + "gitusername", userName);
        SessionManager.getCurrent().put(GitOperationUtil.getSessionByRequestContext() + "gitpassword", passWord);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("SAVE_SVN_MSG", (Object)userInfo);
        JSONObject sessionObj = new JSONObject();
        sessionObj.put("svnmsg", (Object)sessionId);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("SAVE_JSESSION_ID", (Object)sessionObj);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).setClientLocalStorage(GITMSG, sessionId);
    }
}

