/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.git.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.devportal.business.hosting.GitOperationUtil;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.encrypt.Encrypters;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.util.DevportalCommonUtil;
import org.eclipse.jgit.api.errors.GitAPIException;

public class GITManagePlugin
extends AbstractFormPlugin {
    public static final Log logger = LogFactory.getLog(GITManagePlugin.class);
    private static final String LOGINCALLBACK = "LoginCallBack";
    private static final String KEY_GITBRANCH = "gitbranch";
    private static final String KEY_BIZAPPID = "bizappid";
    private static final String KEY_BIZUNITID = "bizunitid";
    private static final String KEY_SVNMSG = "svnmsg";
    private static final String KEY_GITURL = "giturl";
    private static final String KEY_GITROOTPATH = "gitrootpath";
    private static final String KEY_GITREPOSITORY = "gitrepository";
    private static final String KEY_GITUSERNAME = "gitusername";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok", "changsvnmanage", KEY_GITBRANCH});
    }

    public void afterCreateNewData(EventObject e) {
        String gitrootpath;
        boolean isGitMultiParallel = DevportalUtil.isGitMultiParallel();
        String globalGitUrl = DevportalUtil.getGitCommonRemoteUrl();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String bizAppId = (String)formShowParameter.getCustomParam(KEY_BIZAPPID);
        String bizappnumber = (String)formShowParameter.getCustomParam("bizappnumber");
        String bizunitid = (String)formShowParameter.getCustomParam(KEY_BIZUNITID);
        String sessionid = (String)formShowParameter.getCustomParam(KEY_SVNMSG);
        if (isGitMultiParallel) {
            JSONObject cachedLoginInfo = GitOperationUtil.getCachedLoginInfo((String)globalGitUrl, (String)sessionid);
            if (cachedLoginInfo == null || StringUtils.isBlank((CharSequence)cachedLoginInfo.getString("username"))) {
                this.showGitLoginPage(bizAppId, bizunitid, globalGitUrl, "", "init");
            } else {
                String userName = cachedLoginInfo.getString("username");
                DynamicObject setting = this.getSetting(userName);
                this.loadSetting(setting);
            }
        } else {
            DynamicObject setting = this.getSetting(null);
            this.loadSetting(setting);
        }
        String giturl = (String)this.getModel().getValue(KEY_GITURL);
        if (StringUtils.isBlank((CharSequence)giturl)) {
            this.getModel().setValue(KEY_GITURL, (Object)globalGitUrl);
        }
        if (StringUtils.isBlank((CharSequence)(gitrootpath = (String)this.getModel().getValue(KEY_GITROOTPATH)))) {
            DynamicObject bizCloud = BizCloudServiceHelp.getBizCloudByAppID((String)bizAppId);
            String bizCloudNumber = bizCloud.getString("number");
            gitrootpath = String.format("datamodel/%s/%s/main/%s/metadata", bizCloudNumber, ResManager.loadKDString((String)"\u7248\u672c\u53f7", (String)"GITManagePlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), bizappnumber);
            this.getModel().setValue(KEY_GITROOTPATH, (Object)gitrootpath);
        }
    }

    public void click(EventObject e) {
        Control c = (Control)e.getSource();
        String key = c.getKey().toLowerCase();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String bizAppId = (String)formShowParameter.getCustomParam(KEY_BIZAPPID);
        String bizunitid = (String)formShowParameter.getCustomParam(KEY_BIZUNITID);
        String gitUrl = (String)this.getModel().getValue(KEY_GITURL);
        String gitbranch = (String)this.getModel().getValue(KEY_GITBRANCH);
        if ("btnok".equals(key)) {
            if (gitUrl.trim().length() == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u586b\u5199Git\u5730\u5740\u3002", (String)"GITManagePlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            if (gitbranch.trim().length() == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u586b\u5199Git\u8fdc\u7a0b\u5206\u652f\u3002", (String)"GITManagePlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            String gitrootpath = (String)this.getModel().getValue(KEY_GITROOTPATH);
            if (gitrootpath.trim().length() == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u586b\u5199Git\u8fdc\u7a0b\u6839\u76ee\u5f55\u3002", (String)"GITManagePlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            if (gitrootpath.contains(ResManager.loadKDString((String)"\u7248\u672c\u53f7", (String)"GITManagePlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]))) {
                this.getView().showMessage(ResManager.loadKDString((String)"Git\u5143\u6570\u636e\u76ee\u5f55\u4e2d\uff0c\u7248\u672c\u53f7\u9700\u8981\u6307\u5b9a\u3002", (String)"GITManagePlugin_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            String repository = (String)this.getModel().getValue(KEY_GITREPOSITORY);
            if (repository.trim().length() == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4ed3\u5e93\u5730\u5740\u3002", (String)"GITManagePlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            this.doSave(bizAppId, bizunitid, gitUrl, repository, gitbranch, gitrootpath);
            this.getView().returnDataToParent((Object)"gitmanage");
            this.getView().close();
        } else if ("changsvnmanage".equals(key)) {
            JSONObject ret = new JSONObject();
            ret.put("bizappnumber", formShowParameter.getCustomParam("bizappnumber"));
            ret.put(KEY_SVNMSG, formShowParameter.getCustomParam(KEY_SVNMSG));
            ret.put(KEY_BIZAPPID, (Object)bizAppId);
            this.getView().returnDataToParent((Object)ret);
            this.getView().close();
        } else if (KEY_GITBRANCH.equals(key)) {
            this.validateBranch(gitUrl, gitbranch, null, null);
        } else if (KEY_GITROOTPATH.equals(key)) {
            this.showGitLoginPage(bizAppId, bizunitid, gitUrl, gitbranch, key);
        }
    }

    private void doSave(String bizAppId, String bizUnitId, String gitUrl, String repository, String gitbranch, String gitrootpath) {
        String gitUserName = null;
        DynamicObject setting = null;
        if (DevportalUtil.isGitMultiParallel()) {
            String loginInfo = this.getPageCache().get("loginInfo");
            if (StringUtils.isNotBlank((CharSequence)loginInfo)) {
                JSONObject info = JSONObject.parseObject((String)loginInfo);
                gitUserName = info.getString("username");
            }
            if (StringUtils.isBlank(gitUserName)) {
                JSONObject cachedLoginInfo = GitOperationUtil.getCachedLoginInfo((String)gitUrl, (String)((String)this.getView().getFormShowParameter().getCustomParam(KEY_SVNMSG)));
                gitUserName = cachedLoginInfo.getString("username");
            }
            setting = this.getSetting(gitUserName);
        } else {
            setting = this.getSetting(null);
        }
        if (setting == null) {
            setting = BusinessDataServiceHelper.newDynamicObject((String)"svnmanage");
            setting.set("id", (Object)DB.genStringId((String)"t_meta_svnmanage"));
            setting.set(KEY_BIZAPPID, (Object)bizAppId);
        }
        setting.set(KEY_GITURL, (Object)gitUrl.trim());
        setting.set(KEY_GITREPOSITORY, (Object)repository.trim());
        setting.set(KEY_GITBRANCH, (Object)gitbranch.trim());
        setting.set(KEY_GITROOTPATH, (Object)gitrootpath.trim());
        setting.set("managetype", (Object)"git");
        setting.set(KEY_BIZUNITID, (Object)bizUnitId);
        if (gitUserName != null) {
            setting.set(KEY_GITUSERNAME, (Object)gitUserName);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{setting});
    }

    private void showGitLoginPage(String bizAppId, String bizunitid, String gitUrl, String gitBranch, String key) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devp_gitlogin");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, LOGINCALLBACK));
        parameter.setCustomParam(KEY_BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam(KEY_BIZUNITID, (Object)bizunitid);
        parameter.setCustomParam(KEY_GITURL, (Object)gitUrl);
        parameter.setCustomParam(KEY_GITBRANCH, (Object)gitBranch);
        parameter.setCustomParam("callFromGitManage", (Object)key);
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() != null && LOGINCALLBACK.equals(e.getActionId())) {
            JSONObject sourceMsg = JSONObject.parseObject((String)((String)e.getReturnData()));
            String gitUrl = sourceMsg.getString(KEY_GITURL);
            String gitBranch = sourceMsg.getString(KEY_GITBRANCH);
            String userName = sourceMsg.getString("username");
            String passWord = sourceMsg.getString("password");
            String callFromGitManage = sourceMsg.getString("callFromGitManage");
            this.getPageCache().put("loginInfo", (String)e.getReturnData());
            this.getModel().setValue(KEY_GITBRANCH, (Object)gitBranch);
            if (KEY_GITBRANCH.equals(callFromGitManage)) {
                this.validateBranch(gitUrl, gitBranch, userName, passWord);
            } else if ("init".equals(callFromGitManage)) {
                this.getModel().setValue(KEY_GITURL, (Object)gitUrl);
                this.getModel().setValue(KEY_GITBRANCH, (Object)gitBranch);
                DynamicObject setting = this.getSetting(userName);
                this.loadSetting(setting);
            }
        }
    }

    private DynamicObject getSetting(String gitUserName) {
        QFilter userFilter;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String bizAppId = (String)formShowParameter.getCustomParam(KEY_BIZAPPID);
        String bizappnumber = (String)formShowParameter.getCustomParam("bizappnumber");
        String bizunitid = (String)formShowParameter.getCustomParam(KEY_BIZUNITID);
        QFilter filter = new QFilter(KEY_BIZAPPID, "=", (Object)bizAppId);
        Object[] filters = new QFilter[]{filter};
        if (!StringUtils.isBlank((CharSequence)bizunitid)) {
            QFilter unitFilter = new QFilter(KEY_BIZUNITID, "=", (Object)bizunitid);
            filters = (QFilter[])ArrayUtils.add((Object[])filters, (Object)unitFilter);
        }
        if (!StringUtils.isBlank((CharSequence)gitUserName) && DevportalCommonUtil.isGitMultiParallel()) {
            userFilter = new QFilter(KEY_GITUSERNAME, "=", (Object)gitUserName);
            filters = (QFilter[])ArrayUtils.add((Object[])filters, (Object)userFilter);
        } else {
            userFilter = new QFilter(KEY_GITUSERNAME, "=", (Object)Character.valueOf(' '));
            filters = (QFilter[])ArrayUtils.add((Object[])filters, (Object)userFilter);
        }
        String selectFields = "id,giturl,gitrepository,gitbranch,gitrootpath,bizunitid,managetype,gitusername";
        DynamicObject[] gitSettings = BusinessDataServiceHelper.load((String)"svnmanage", (String)selectFields, (QFilter[])filters);
        if (gitSettings.length > 0) {
            String gitRootPath = gitSettings[0].getString(KEY_GITROOTPATH);
            if (StringUtils.isNotBlank((CharSequence)gitRootPath) && !gitRootPath.endsWith("/metadata")) {
                gitRootPath = gitRootPath + "/" + bizappnumber + "/metadata";
            }
            return gitSettings[0];
        }
        return null;
    }

    private void loadSetting(DynamicObject setting) {
        if (setting == null) {
            return;
        }
        this.getModel().setValue(KEY_GITURL, (Object)setting.getString(KEY_GITURL));
        this.getModel().setValue(KEY_GITREPOSITORY, (Object)setting.getString(KEY_GITREPOSITORY));
        this.getModel().setValue(KEY_GITBRANCH, (Object)setting.getString(KEY_GITBRANCH));
        this.getModel().setValue(KEY_GITROOTPATH, (Object)setting.getString(KEY_GITROOTPATH));
    }

    private void validateBranch(String gitUrl, String gitBranch, String userName, String passWord) {
        if (StringUtils.isBlank((CharSequence)userName) || StringUtils.isBlank((CharSequence)passWord)) {
            JSONObject cachedLoginInfo = GitOperationUtil.getCachedLoginInfo((String)gitUrl, (String)((String)this.getView().getFormShowParameter().getCustomParam(KEY_SVNMSG)));
            if (cachedLoginInfo == null || StringUtils.isBlank((CharSequence)cachedLoginInfo.getString("username")) || StringUtils.isBlank((CharSequence)cachedLoginInfo.getString("password"))) {
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                String bizAppId = (String)formShowParameter.getCustomParam(KEY_BIZAPPID);
                String bizunitid = (String)formShowParameter.getCustomParam(KEY_BIZUNITID);
                this.showGitLoginPage(bizAppId, bizunitid, gitUrl, gitBranch, KEY_GITBRANCH);
                return;
            }
            userName = cachedLoginInfo.getString("username");
            try {
                passWord = Encrypters.decode((String)cachedLoginInfo.getString("password"));
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        try {
            List branchs = GitOperationUtil.getBranchs((String)gitUrl, (String)userName, (String)passWord);
            boolean existBranch = branchs.stream().anyMatch(b -> b.equals(gitBranch));
            if (!existBranch) {
                logger.info(ResManager.loadKDString((String)"Git\u8fdc\u7a0b\u5206\u652f\u4e0d\u5b58\u5728\u6216\u6ca1\u6709\u6743\u9650\u67e5\u770b\u3002", (String)"GITManagePlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                String bizAppId = (String)formShowParameter.getCustomParam(KEY_BIZAPPID);
                String bizunitid = (String)formShowParameter.getCustomParam(KEY_BIZUNITID);
                this.showGitLoginPage(bizAppId, bizunitid, gitUrl, gitBranch, KEY_GITBRANCH);
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"Git\u8fdc\u7a0b\u5206\u652f\u9a8c\u8bc1\u6210\u529f\u3002", (String)"GITManagePlugin_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            }
        }
        catch (GitAPIException e) {
            String msg = String.format(ResManager.loadKDString((String)"Git\u8fdc\u7a0b\u5206\u652f\u9a8c\u8bc1\u5931\u8d25\uff0c%s\u3002", (String)"GITManagePlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), e.getMessage());
            this.getView().showMessage(msg);
        }
    }
}

