/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.git.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.business.hosting.GITCodeHostingServiceImpl;
import kd.bos.devportal.business.hosting.GitOperationUtil;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;

public class GITPushPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
HyperLinkClickListener {
    private static Log logger = LogFactory.getLog(GITPushPlugin.class);
    private static final String TXT_SCRIPTNUMBER = "txt_scriptnumber";
    private static final String KEY_PERSONALGITREPOSITORY = "personalgitrepository";
    private static final String KEY_NUMBER = "number";
    private static final String CLOUD = "cloud";
    private static final String APP = "app";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"push", "operate"});
        AbstractGrid grid = (AbstractGrid)this.getControl("entryentity");
        grid.addHyperClickListener((HyperLinkClickListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String giturl = (String)formShowParameter.getCustomParam("giturl");
        String gitbranch = (String)formShowParameter.getCustomParam("gitbranch");
        String gitRepository = (String)formShowParameter.getCustomParam("gitrepository");
        this.getModel().setValue("giturl", (Object)giturl);
        this.getModel().setValue("gitbranch", (Object)gitbranch);
        this.getModel().setValue("gitrepository", (Object)gitRepository);
        String fileString = (String)formShowParameter.getCustomParam("filearr");
        JSONArray arr = JSONArray.parseArray((String)fileString);
        fileString = fileString.substring(1, fileString.length() - 1);
        this.getModel().batchCreateNewEntryRow("entryentity", arr.size());
        for (int i = 0; i < arr.size(); ++i) {
            JSONObject fileObj = arr.getJSONObject(i);
            String filePath = fileObj.getString("filepath");
            String type = fileObj.getString("type");
            String[] spl = filePath.split("/");
            this.getModel().setValue("filename", (Object)spl[spl.length - 1], i);
            this.getModel().setValue("action", (Object)type, i);
            this.getModel().setValue("path", (Object)filePath, i);
            if ("DELETE".equals(type)) {
                this.getModel().setValue("issave", (Object)Boolean.TRUE, i);
                continue;
            }
            this.getModel().setValue("status", (Object)ResManager.loadKDString((String)"\u672a\u6bd4\u8f83", (String)"GITPushPlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]), i);
            this.getModel().setValue("operate", (Object)ResManager.loadKDString((String)"\u6bd4\u8f83", (String)"GITPushPlugin_1", (String)"bos-devportal-plugin", (Object[])new Object[0]), i);
        }
        String projectURL = (String)formShowParameter.getCustomParam("projecturl");
        try (Git git = null;){
            git = Git.open((File)new File(projectURL));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() != null && "diffCloseCallBack".equals(e.getActionId())) {
            boolean isSave = Boolean.parseBoolean(e.getReturnData().toString());
            EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
            int row = grid.getSelectRows()[0];
            if (isSave) {
                this.getModel().setValue("status", (Object)ResManager.loadKDString((String)"\u5df2\u4fdd\u5b58", (String)"GITPushPlugin_2", (String)"bos-devportal-plugin", (Object[])new Object[0]), row);
                this.getModel().setValue("issave", (Object)Boolean.TRUE, row);
            } else {
                this.getModel().setValue("status", (Object)ResManager.loadKDString((String)"\u672a\u4fdd\u5b58", (String)"GITPushPlugin_3", (String)"bos-devportal-plugin", (Object[])new Object[0]), row);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if ("pushConfirmCallBack".equals(e.getCallBackId()) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            HashSet pushFiles = new HashSet();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String personalGitRepository = (String)formShowParameter.getCustomParam(KEY_PERSONALGITREPOSITORY);
            String userName = (String)formShowParameter.getCustomParam("username");
            String passWord = (String)formShowParameter.getCustomParam("password");
            String gitBranch = (String)formShowParameter.getCustomParam("gitbranch");
            String gitRootpath = (String)formShowParameter.getCustomParam("gitrootpath");
            String bizAppId = (String)formShowParameter.getCustomParam("bizappid");
            String successMsg = ResManager.loadKDString((String)"\u63a8\u9001\u6210\u529f\u3002", (String)"GITPushPlugin_4", (String)"bos-devportal-plugin", (Object[])new Object[0]);
            String failMsg = ResManager.loadKDString((String)"\u63a8\u9001\u5931\u8d25\uff1a", (String)"GITPushPlugin_5", (String)"bos-devportal-plugin", (Object[])new Object[0]);
            try {
                GITCodeHostingServiceImpl.pull((String)personalGitRepository, (String)gitBranch, (String)gitRootpath, (String)userName, (String)passWord);
                String result = GITCodeHostingServiceImpl.push((String)bizAppId, (String)personalGitRepository, (String)gitBranch, (String)gitRootpath, (String)userName, (String)passWord, pushFiles);
                if ("success".equals(result)) {
                    this.getView().showMessage(successMsg);
                } else {
                    this.getView().showMessage(failMsg + result);
                }
            }
            catch (IOException ioException) {
                this.getView().showMessage(failMsg + ioException.getMessage());
            }
            catch (GitAPIException gitAPIException) {
                this.getView().showMessage(failMsg + gitAPIException.getMessage());
            }
            this.getView().close();
        }
    }

    private String beforePush(Set<String> pushFiles) {
        int size = this.getModel().getEntryEntity("entryentity").size();
        Map<String, String> numberIdMap = this.getNumberAndIdPair(size, pushFiles);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String personalGitRepository = (String)formShowParameter.getCustomParam(KEY_PERSONALGITREPOSITORY);
        StringBuilder exceptionMsg = new StringBuilder(ResManager.loadKDString((String)"\u63a8\u9001\u6210\u529f\uff0c\u5b58\u5728\u95ee\u9898", (String)"GITPushPlugin_8", (String)"bos-devportal-plugin", (Object[])new Object[0])).append(":");
        boolean flag = false;
        for (int i = 0; i < size; ++i) {
            String id;
            pushFiles.add(this.getModel().getValue("path", i).toString());
            boolean isSave = Boolean.parseBoolean(this.getModel().getValue("issave", i).toString());
            if (isSave) continue;
            String filePath = (String)this.getModel().getValue("path", i);
            String fileName = (String)this.getModel().getValue("filename", i);
            String content = null;
            String type = null;
            if (fileName.endsWith("ks")) {
                type = "script";
                content = GitOperationUtil.getScriptFile((String)(personalGitRepository + File.separator + filePath));
                id = numberIdMap.get(fileName.split("\\.")[0]);
                if (id == null) continue;
                try {
                    GitOperationUtil.updateFileToLocal((String)type, (String)id, (String)content);
                }
                catch (Exception e) {
                    exceptionMsg.append(e.getMessage());
                    flag = true;
                }
                continue;
            }
            if (fileName.contains("dym")) {
                type = "page";
                content = GitOperationUtil.getPageFile((String)(personalGitRepository + File.separator + filePath));
                id = numberIdMap.get(fileName.split("\\.")[0]);
                if (id == null) continue;
                try {
                    GitOperationUtil.updateFileToLocal((String)type, (String)id, (String)content);
                }
                catch (Exception e) {
                    exceptionMsg.append(e.getMessage());
                    flag = true;
                }
                continue;
            }
            if (fileName.endsWith("cr") || fileName.endsWith("crx")) {
                type = "botp_cr";
                content = GitOperationUtil.getPageFile((String)(personalGitRepository + File.separator + filePath));
                try {
                    GitOperationUtil.updateFileToLocal((String)type, null, (String)content);
                }
                catch (Exception e) {
                    exceptionMsg.append(e.getMessage());
                    flag = true;
                }
                continue;
            }
            if (fileName.endsWith("wb") || fileName.endsWith("wbx")) {
                type = "botp_wb";
                content = GitOperationUtil.getPageFile((String)(personalGitRepository + File.separator + filePath));
                try {
                    GitOperationUtil.updateFileToLocal((String)type, null, (String)content);
                }
                catch (Exception e) {
                    exceptionMsg.append(e.getMessage());
                    flag = true;
                }
                continue;
            }
            if (!fileName.endsWith("bur") && !fileName.endsWith("burx")) continue;
            type = "botp_bur";
            content = GitOperationUtil.getPageFile((String)(personalGitRepository + File.separator + filePath));
            try {
                GitOperationUtil.updateFileToLocal((String)type, null, (String)content);
                continue;
            }
            catch (Exception e) {
                exceptionMsg.append(e.getMessage());
                flag = true;
            }
        }
        if (flag) {
            return exceptionMsg.toString();
        }
        return null;
    }

    private Map<String, String> getNumberAndIdPair(int size, Set<String> pushFiles) {
        HashSet<String> scriptNumberSet = new HashSet<String>();
        HashSet<String> pageNumberSet = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            pushFiles.add(this.getModel().getValue("path", i).toString());
            boolean isSave = Boolean.parseBoolean(this.getModel().getValue("issave", i).toString());
            if (isSave) continue;
            String fileName = (String)this.getModel().getValue("filename", i);
            if (fileName.endsWith("ks")) {
                String scriptNumber = fileName.split("\\.")[0];
                scriptNumberSet.add(scriptNumber);
                continue;
            }
            if (!fileName.contains("dym")) continue;
            String pageNumber = fileName.split("\\.")[0];
            pageNumberSet.add(pageNumber);
        }
        HashMap<String, String> numberIdMap = new HashMap<String, String>();
        if (!scriptNumberSet.isEmpty()) {
            DynamicObject[] scriptDym;
            QFilter qFilter = new QFilter(TXT_SCRIPTNUMBER, "in", scriptNumberSet);
            for (DynamicObject dym : scriptDym = BusinessDataServiceHelper.load((String)"ide_pluginscript", (String)"ID,bizappid,txt_scriptnumber", (QFilter[])new QFilter[]{qFilter})) {
                numberIdMap.put(dym.getString(TXT_SCRIPTNUMBER), dym.getString("ID"));
            }
        }
        if (!pageNumberSet.isEmpty()) {
            DynamicObject[] pageDym;
            QFilter qFilter = new QFilter(KEY_NUMBER, "in", pageNumberSet);
            for (DynamicObject dym : pageDym = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)"ID,bizappid,number", (QFilter[])new QFilter[]{qFilter})) {
                numberIdMap.put(dym.getString(KEY_NUMBER), dym.getString("ID"));
            }
        }
        return numberIdMap;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "operate": {
                this.gotoDiff();
                break;
            }
            case "push": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6240\u6709\u6587\u4ef6\u5c06\u63a8\u9001\u5230\u8fdc\u7a0b\u4ed3\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"GITPushPlugin_6", (String)"bos-devportal-plugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("pushConfirmCallBack"));
                break;
            }
        }
    }

    private void gotoDiff() {
        QFilter qFilter;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_gitdiff");
        parameter.setPageId(UUID.randomUUID().toString());
        parameter.setCustomParam("projecturl", formShowParameter.getCustomParam("projecturl"));
        parameter.setCustomParam("gitrepository", formShowParameter.getCustomParam("gitrepository"));
        parameter.setCustomParam(KEY_PERSONALGITREPOSITORY, formShowParameter.getCustomParam(KEY_PERSONALGITREPOSITORY));
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        int row = grid.getSelectRows()[0];
        parameter.setCustomParam("issave", this.getModel().getValue("issave", row));
        String fileName = (String)this.getModel().getValue("filename", row);
        String[] split = fileName.trim().split("\\.");
        boolean isCloud = split[split.length - 1].contains("cld");
        boolean isApp = split[split.length - 1].contains(APP);
        String type = null;
        DynamicObject dym = null;
        if (fileName.endsWith("ks")) {
            String scriptName = fileName.split("\\.")[0];
            qFilter = new QFilter(TXT_SCRIPTNUMBER, "=", (Object)scriptName);
            dym = BusinessDataServiceHelper.loadSingle((String)"ide_pluginscript", (String)"ID,bizappid", (QFilter[])new QFilter[]{qFilter});
            type = "script";
        } else if (fileName.contains("dym")) {
            String pageName = fileName.split("\\.")[0];
            qFilter = new QFilter(KEY_NUMBER, "=", (Object)pageName);
            dym = BusinessDataServiceHelper.loadSingle((String)"bos_formmeta", (String)"ID,bizappid", (QFilter[])new QFilter[]{qFilter});
            type = "page";
        } else if (isCloud) {
            type = CLOUD;
        } else if (isApp) {
            String appNumber = fileName.split("\\.")[0];
            qFilter = new QFilter(KEY_NUMBER, "=", (Object)appNumber);
            dym = BusinessDataServiceHelper.loadSingle((String)"bos_devportal_bizapp", (String)"ID,bizappid", (QFilter[])new QFilter[0]);
            type = APP;
        }
        if (dym != null) {
            String id = dym.getString("ID");
            String bizAppId = null;
            bizAppId = StringUtils.equals((CharSequence)APP, (CharSequence)type) ? dym.getString("id") : dym.getString("bizappid");
            parameter.setCustomParam("id", (Object)id);
            parameter.setCustomParam("bizappid", (Object)bizAppId);
        }
        parameter.setCustomParam("filepath", this.getModel().getValue("path", row));
        parameter.setCustomParam("type", (Object)type);
        parameter.setCaption(ResManager.loadKDString((String)"\u6587\u4ef6\u6bd4\u8f83", (String)"GITPushPlugin_7", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        OpenStyle style = new OpenStyle();
        StyleCss cssStyle = new StyleCss();
        cssStyle.setHeight("760");
        cssStyle.setWidth("1200");
        style.setInlineStyleCss(cssStyle);
        style.setShowType(ShowType.Modal);
        parameter.setOpenStyle(style);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "diffCloseCallBack"));
        this.getView().showForm(parameter);
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String key;
        switch (key = e.getFieldName()) {
            case "operate": {
                this.gotoDiff();
                break;
            }
        }
    }
}

