/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.git.plugin;

import com.alibaba.fastjson.JSONArray;
import java.io.File;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.devportal.business.hosting.GITCodeHostingServiceImpl;
import kd.bos.devportal.business.hosting.GitOperationUtil;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.eclipse.jgit.api.Git;

public class GITResolvePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
HyperLinkClickListener {
    private static Log logger = LogFactory.getLog(GITResolvePlugin.class);
    private static final String GITURL = "giturl";
    private static final String IDANDBIZAPPID = "ID,bizappid";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"commit", "operate"});
        AbstractGrid grid = (AbstractGrid)this.getControl("entryentity");
        grid.addHyperClickListener((HyperLinkClickListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String giturl = (String)formShowParameter.getCustomParam(GITURL);
        String gitRepository = (String)formShowParameter.getCustomParam("gitrepository");
        String gitbranch = (String)formShowParameter.getCustomParam("gitbranch");
        String gitrootpath = (String)formShowParameter.getCustomParam("gitrootpath");
        this.getModel().setValue(GITURL, (Object)giturl);
        this.getModel().setValue("gitrepository", (Object)gitRepository);
        this.getModel().setValue("gitbranch", (Object)gitbranch);
        String fileString = (String)formShowParameter.getCustomParam("filearr");
        JSONArray arr = JSONArray.parseArray((String)fileString);
        fileString = fileString.substring(1, fileString.length() - 1);
        this.getModel().batchCreateNewEntryRow("entryentity", arr.size());
        for (int i = 0; i < arr.size(); ++i) {
            String fileName = arr.getString(i);
            String[] spl = fileName.split("/");
            this.getModel().setValue("filename", (Object)spl[spl.length - 1], i);
            this.getModel().setValue("path", (Object)fileName, i);
            this.getModel().setValue("status", (Object)ResManager.loadKDString((String)"\u672a\u6bd4\u8f83", (String)"GITResolvePlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]), i);
            this.getModel().setValue("operate", (Object)ResManager.loadKDString((String)"\u6bd4\u8f83", (String)"GITResolvePlugin_1", (String)"bos-devportal-plugin", (Object[])new Object[0]), i);
        }
        String projectURL = (String)formShowParameter.getCustomParam("projecturl");
        try (Git git = null;){
            git = Git.open((File)new File(projectURL));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() != null && "diffCloseCallBack".equals(e.getActionId())) {
            Boolean isSave = Boolean.valueOf(e.getReturnData().toString());
            EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
            int row = grid.getSelectRows()[0];
            if (isSave.booleanValue()) {
                this.getModel().setValue("status", (Object)ResManager.loadKDString((String)"\u5df2\u4fdd\u5b58", (String)"GITResolvePlugin_2", (String)"bos-devportal-plugin", (Object[])new Object[0]), row);
                this.getModel().setValue("issave", (Object)Boolean.TRUE, row);
            } else {
                this.getModel().setValue("status", (Object)ResManager.loadKDString((String)"\u672a\u4fdd\u5b58", (String)"GITResolvePlugin_3", (String)"bos-devportal-plugin", (Object[])new Object[0]), row);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if ("commitConfirmCallBack".equals(e.getCallBackId()) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            ArrayList<String> resolveFile = new ArrayList<String>();
            this.beforeResolve(resolveFile);
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String gitUrl = (String)formShowParameter.getCustomParam(GITURL);
            String gitRepository = (String)formShowParameter.getCustomParam("gitrepository");
            String gitBranch = (String)formShowParameter.getCustomParam("gitbranch");
            String gitRootpath = (String)formShowParameter.getCustomParam("gitrootpath");
            String bizAppId = (String)formShowParameter.getCustomParam("bizappid");
            String personalGitRepository = (String)formShowParameter.getCustomParam("personalgitrepository");
            String userName = (String)formShowParameter.getCustomParam("username");
            String passWord = (String)formShowParameter.getCustomParam("password");
            String id = (String)formShowParameter.getCustomParam("id");
            String type = (String)formShowParameter.getCustomParam("type");
            String result = GITCodeHostingServiceImpl.resolve((String)bizAppId, (String)personalGitRepository, (String)gitBranch, (String)gitRootpath, resolveFile);
            if ("success".equals(result)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"GITResolvePlugin_4", (String)"bos-devportal-plugin", (Object[])new Object[0]));
                GitOperationUtil.revert((String)gitRepository, (String)gitBranch, (String)gitRootpath, (String)personalGitRepository, (String)userName, (String)passWord, (String)id, (String)type, (AbstractFormPlugin)this, (String)GITURL);
            } else {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff1a%s", (String)"GITResolvePlugin_9", (String)"bos-devportal-plugin", (Object[])new Object[0]), result));
            }
            this.getView().close();
        }
    }

    private void beforeResolve(List<String> resolveFile) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String personalGitRepository = (String)formShowParameter.getCustomParam("personalgitrepository");
        int size = this.getModel().getEntryEntity("entryentity").size();
        for (int i = 0; i < size; ++i) {
            String content;
            QFilter qFilter;
            resolveFile.add(this.getModel().getValue("path", i).toString());
            Boolean isSave = Boolean.valueOf(this.getModel().getValue("issave", i).toString());
            if (isSave.booleanValue()) continue;
            String filePath = (String)this.getModel().getValue("path", i);
            String fileName = (String)this.getModel().getValue("filename", i);
            String type = null;
            DynamicObject dym = null;
            if (fileName.endsWith("ks")) {
                String scriptName = fileName.split("\\.")[0];
                qFilter = new QFilter("txt_scriptname", "=", (Object)scriptName);
                dym = BusinessDataServiceHelper.loadSingle((String)"ide_pluginscript", (String)IDANDBIZAPPID, (QFilter[])new QFilter[]{qFilter});
                type = "script";
            } else if (fileName.contains("dym")) {
                String pageName = fileName.split("\\.")[0];
                qFilter = new QFilter("number", "=", (Object)pageName);
                dym = BusinessDataServiceHelper.loadSingle((String)"bos_formmeta", (String)IDANDBIZAPPID, (QFilter[])new QFilter[]{qFilter});
                type = "page";
            }
            if (dym == null) continue;
            String id = dym.getString("ID");
            if ("script".equals(type)) {
                content = GitOperationUtil.getScriptFile((String)(personalGitRepository + File.separator + filePath));
                GitOperationUtil.updateFileToLocal((String)type, (String)id, (String)content);
                continue;
            }
            if (!"page".equals(type)) continue;
            content = GitOperationUtil.getPageFile((String)(personalGitRepository + File.separator + filePath));
            GitOperationUtil.updateFileToLocal((String)type, (String)id, (String)content);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "operate": {
                this.gotoDiff();
                break;
            }
            case "commit": {
                Boolean isNotSave = Boolean.FALSE;
                int size = this.getModel().getEntryEntity("entryentity").size();
                for (int i = 0; i < size; ++i) {
                    if (((Boolean)this.getModel().getValue("issave", i)).booleanValue()) continue;
                    isNotSave = Boolean.TRUE;
                    break;
                }
                if (isNotSave.booleanValue()) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u5904\u7406\u6240\u6709\u51b2\u7a81\u6587\u4ef6\uff0c\u518d\u8fdb\u884c\u63d0\u4ea4\u3002", (String)"GITResolvePlugin_6", (String)"bos-devportal-plugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6240\u6709\u6587\u4ef6\u5c06\u63d0\u4ea4\u5230\u672c\u5730\u4ed3\u5e93\uff0c\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\uff1f", (String)"GITResolvePlugin_7", (String)"bos-devportal-plugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("commitConfirmCallBack"));
                break;
            }
        }
    }

    private void gotoDiff() {
        QFilter qFilter;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_gitdiff");
        parameter.setPageId(UUID.randomUUID().toString());
        parameter.setCustomParam("projecturl", formShowParameter.getCustomParam("projecturl"));
        parameter.setCustomParam("gitrepository", formShowParameter.getCustomParam("gitrepository"));
        parameter.setCustomParam("personalgitrepository", formShowParameter.getCustomParam("personalgitrepository"));
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        int row = grid.getSelectRows()[0];
        parameter.setCustomParam("issave", this.getModel().getValue("issave", row));
        String fileName = (String)this.getModel().getValue("filename", row);
        String type = null;
        DynamicObject dym = null;
        if (fileName.endsWith("ks")) {
            String scriptName = fileName.split("\\.")[0];
            qFilter = new QFilter("txt_scriptnumber", "=", (Object)scriptName);
            dym = BusinessDataServiceHelper.loadSingle((String)"ide_pluginscript", (String)IDANDBIZAPPID, (QFilter[])new QFilter[]{qFilter});
            type = "script";
        } else if (fileName.contains("dym")) {
            String pageName = fileName.split("\\.")[0];
            qFilter = new QFilter("number", "=", (Object)pageName);
            dym = BusinessDataServiceHelper.loadSingle((String)"bos_formmeta", (String)IDANDBIZAPPID, (QFilter[])new QFilter[]{qFilter});
            type = "page";
        }
        parameter.setCustomParam("filepath", this.getModel().getValue("path", row));
        parameter.setCustomParam("type", type);
        if (dym != null) {
            String id = dym.getString("ID");
            String bizAppId = dym.getString("bizappid");
            parameter.setCustomParam("id", (Object)id);
            parameter.setCustomParam("bizappid", (Object)bizAppId);
        }
        parameter.setCaption(ResManager.loadKDString((String)"\u6587\u4ef6\u6bd4\u8f83", (String)"GITResolvePlugin_8", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        OpenStyle style = new OpenStyle();
        StyleCss cssStyle = new StyleCss();
        cssStyle.setHeight("760");
        cssStyle.setWidth("1200");
        style.setInlineStyleCss(cssStyle);
        style.setShowType(ShowType.Modal);
        parameter.setOpenStyle(style);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "diffCloseCallBack"));
        this.getView().showForm(parameter);
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String key;
        switch (key = e.getFieldName()) {
            case "operate": {
                this.gotoDiff();
                break;
            }
        }
    }
}

