/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.git.pluginnew;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.devportal.business.git.GitRepositoryHelper;
import kd.bos.devportal.business.git.UserCacheInfo;
import kd.bos.devportal.business.hosting.GITCodeHostingServiceImpl;
import kd.bos.devportal.business.hosting.GitOperationUtil;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.util.DevportalCommonUtil;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;

public class GITManagePlugin
extends AbstractFormPlugin {
    public static final Log logger = LogFactory.getLog(GITManagePlugin.class);
    private static final String LOGINCALLBACK = "LoginCallBack";
    private static final String KEY_GITBRANCH = "gitbranch";
    private static final String KEY_BIZAPPID = "bizappid";
    private static final String KEY_BIZUNITID = "bizunitid";
    private static final String KEY_SVNMSG = "svnmsg";
    private static final String GIT_MSG = "gitmsg";
    private static final String KEY_GITURL = "giturl";
    private static final String KEY_GITROOTPATH = "gitrootpath";
    private static final String KEY_MANAGE_TYPE = "managetype";
    private static final String KEY_GITREPOSITORY = "gitrepository";
    private static final String KEY_GITUSERNAME = "gitusername";
    private static final String SESSION_ID = "sessionId";
    private static final String CHECK_RESULT = "checkResult";
    private static final String USERNAME = "userName";
    private static final String PD = "passWord";
    private static final String BTN_OK = "btnok";
    private static final String SETTING = "setting";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK, "changsvnmanage", KEY_GITBRANCH, KEY_GITREPOSITORY, SETTING});
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject dynamicObject;
        String sessionId = this.getSessionId();
        if (!this.isDev()) {
            this.setTextEditStyle();
        }
        this.fillInfo();
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            this.fillInfo(this.getSetting(null));
            this.getPageCache().put(SESSION_ID, "1");
            return;
        }
        String userName = null;
        try {
            userName = Encrypters.decode((String)sessionId);
        }
        catch (Exception exception) {
            this.getPageCache().put(SESSION_ID, "1");
            logger.error("userName decode error", (Throwable)exception);
        }
        if (StringUtils.isBlank((CharSequence)userName)) {
            this.fillInfo(this.getSetting(userName));
            return;
        }
        String gitMsg = this.getPageCache().get(GIT_MSG);
        if (StringUtils.isBlank((CharSequence)gitMsg)) {
            this.getPageCache().put(GIT_MSG, sessionId);
        }
        if (null == (dynamicObject = this.getSetting(userName))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SETTING});
            return;
        }
        this.fillInfo(dynamicObject);
    }

    private String getSessionId() {
        FormShowParameter parameter;
        String type;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String sessionId = (String)formShowParameter.getCustomParam(KEY_SVNMSG);
        if (StringUtils.isBlank((CharSequence)sessionId) && StringUtils.isBlank((CharSequence)(sessionId = (String)formShowParameter.getCustomParam(GIT_MSG))) && (type = (String)(parameter = this.getView().getFormShowParameter()).getCustomParam("type")) != null && type.startsWith("botp")) {
            sessionId = (String)parameter.getCustomParam("gitSessionId");
        }
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            sessionId = this.getPageCache().get(GIT_MSG);
        }
        return sessionId;
    }

    public void click(EventObject e) {
        String gitRepository;
        String gitRootPath;
        String gitBranch;
        Control control = (Control)e.getSource();
        String key = control.getKey().toLowerCase();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String bizAppId = (String)formShowParameter.getCustomParam(KEY_BIZAPPID);
        String bizunitid = (String)formShowParameter.getCustomParam(KEY_BIZUNITID);
        String gitUrl = (String)this.getModel().getValue(KEY_GITURL);
        if (StringUtils.isNotBlank((CharSequence)gitUrl)) {
            gitUrl = gitUrl.trim();
        }
        if (StringUtils.isNotBlank((CharSequence)(gitBranch = (String)this.getModel().getValue(KEY_GITBRANCH)))) {
            gitBranch = gitBranch.trim();
        }
        if (StringUtils.isNotBlank((CharSequence)(gitRootPath = (String)this.getModel().getValue(KEY_GITROOTPATH)))) {
            gitRootPath = gitRootPath.trim();
        }
        if (StringUtils.isNotBlank((CharSequence)(gitRepository = (String)this.getModel().getValue(KEY_GITREPOSITORY)))) {
            gitRepository = gitRepository.trim();
        }
        if (StringUtils.isNotBlank((CharSequence)gitRepository)) {
            gitRepository = this.checkPath(gitRepository);
        }
        if (BTN_OK.equals(key)) {
            if (!this.checkParameter(gitUrl, gitBranch, gitRootPath, gitRepository)) {
                return;
            }
            if (this.popLoginView()) {
                this.showGitLoginPage(gitUrl, gitBranch, bizAppId);
                return;
            }
            if (!this.checkAccount(gitUrl, gitBranch)) {
                return;
            }
            if (!this.checkBranch(gitRepository, gitBranch)) {
                this.getView().hideLoading();
                return;
            }
            this.doSave(bizAppId, bizunitid, gitUrl, gitRepository, gitBranch, gitRootPath);
            String sessionId = this.getSessionId();
            if (StringUtils.isNotBlank((CharSequence)sessionId)) {
                this.getView().getParentView().getPageCache().put("gitSessionId", sessionId);
            }
            this.setRepositoryPullUrl(gitRepository, gitUrl);
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().returnDataToParent((Object)"gitmanage");
            this.getView().close();
        } else if (KEY_GITBRANCH.equals(key)) {
            if (!this.checkParameter(gitUrl, gitBranch, gitRootPath, gitRepository)) {
                return;
            }
            this.validateBranch(gitUrl, gitBranch, bizAppId);
        } else if (SETTING.equals(key)) {
            this.showGitSetting(gitRepository);
        } else if (KEY_GITREPOSITORY.equals(key) && this.isDev()) {
            this.showGitChoosePath();
        }
    }

    private String checkPath(String gitRepositoryPath) {
        if (File.separatorChar == gitRepositoryPath.charAt(gitRepositoryPath.length() - 1)) {
            return gitRepositoryPath.substring(0, gitRepositoryPath.length() - 1);
        }
        return gitRepositoryPath;
    }

    private boolean checkParameter(String gitUrl, String gitBranch, String gitRootPath, String gitRepository) {
        if (StringUtils.isBlank((CharSequence)gitUrl)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"Git\u8fdc\u7a0b\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GITManagePlugin_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)gitUrl) && !gitUrl.endsWith(".git")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"Git\u8fdc\u7a0b\u5730\u5740\u4e0d\u6b63\u786e\u3002", (String)"GITManagePlugin_21", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isBlank((CharSequence)gitBranch)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"Git\u8fdc\u7a0b\u5206\u652f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GITManagePlugin_10", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isBlank((CharSequence)gitRootPath)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5143\u6570\u636e\u76ee\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GITManagePlugin_11", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (gitRootPath.contains(ResManager.loadKDString((String)"\u7248\u672c\u53f7", (String)"GITManagePlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"Git\u5143\u6570\u636e\u76ee\u5f55\u4e2d\uff0c\u7248\u672c\u53f7\u9700\u8981\u6307\u5b9a\u3002", (String)"GITManagePlugin_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isBlank((CharSequence)gitRepository)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u5730\u4ed3\u5e93\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GITManagePlugin_12", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void setTextEditStyle() {
        LinkedHashMap<String, Boolean> editor = new LinkedHashMap<String, Boolean>(2);
        editor.put("eb", true);
        editor.put("showEditButton", false);
        LinkedHashMap<String, LinkedHashMap<String, Boolean>> ctl = new LinkedHashMap<String, LinkedHashMap<String, Boolean>>(1);
        ctl.put("item", editor);
        this.getView().updateControlMetadata(KEY_GITREPOSITORY, ctl);
    }

    private void setRepositoryPullUrl(String gitRepository, String gitUrl) {
        String sessionId = this.getSessionId();
        String userName = Encrypters.decode((String)sessionId);
        String personalGitRepository = GitOperationUtil.getPersonalGitRepository((String)gitRepository, (String)userName);
        String gitPath = personalGitRepository + File.separator + ".git";
        File file = new File(gitPath);
        if (!file.exists()) {
            return;
        }
        try (Repository repository = GitRepositoryHelper.openRepository((String)personalGitRepository);){
            StoredConfig config = repository.getConfig();
            String gitPullUrl = config.getString("remote", "origin", "url");
            if (!gitUrl.equals(gitPullUrl)) {
                config.setString("remote", "origin", "url", gitUrl);
                config.save();
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private void validateBranch(String gitUrl, String gitBranch, String bizAppId) {
        if (this.popLoginView()) {
            this.showGitLoginPage(gitUrl, gitBranch, bizAppId);
            return;
        }
        try {
            String userName = this.getPageCache().get(USERNAME);
            String passWord = this.getPageCache().get(PD);
            List branchs = GitOperationUtil.getBranchs((String)gitUrl, (String)userName, (String)passWord);
            boolean existBranch = branchs.stream().anyMatch(b -> b.equals(gitBranch));
            if (!existBranch) {
                logger.debug(ResManager.loadKDString((String)"Git\u8fdc\u7a0b\u5206\u652f\u4e0d\u5b58\u5728\u6216\u6ca1\u6709\u6743\u9650\u67e5\u770b\u3002", (String)"GITManagePlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                this.showGitLoginPage(gitUrl, gitBranch, bizAppId);
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"Git\u8fdc\u7a0b\u5206\u652f\u9a8c\u8bc1\u6210\u529f\u3002", (String)"GITManagePlugin_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            }
        }
        catch (GitAPIException e) {
            String msg = String.format(ResManager.loadKDString((String)"Git\u8fdc\u7a0b\u5206\u652f\u9a8c\u8bc1\u5931\u8d25\uff0c%s\u3002", (String)"GITManagePlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), e.getMessage());
            this.getView().showTipNotification(msg);
            logger.error((Throwable)e);
        }
    }

    private void showGitSetting(String gitRepository) {
        String sessionId = this.getSessionId();
        String userName = Encrypters.decode((String)sessionId);
        String personalGitRepository = GitOperationUtil.getPersonalGitRepository((String)gitRepository, (String)userName);
        String path = personalGitRepository + File.separator + ".git";
        File file = new File(path);
        if (!file.exists()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u5730\u4ed3\u5e93\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u70b9\u51fb\u62c9\u53d6\u5c06\u8fdc\u7a0b\u4ed3\u5e93\u62c9\u53d6\u81f3\u672c\u5730\u3002", (String)"GitUtil_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_gitsetting");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(SESSION_ID, (Object)sessionId);
        parameter.setCustomParam("personalRepository", (Object)personalGitRepository);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "gitSetting"));
        this.getView().showForm(parameter);
    }

    private void showGitChoosePath() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_gitfile");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "gitChooseFilePath"));
        this.getView().showForm(parameter);
    }

    private boolean isDev() {
        String clientFullContextPath = RequestContext.get().getClientFullContextPath();
        return clientFullContextPath != null && (clientFullContextPath.contains("localhost") || clientFullContextPath.contains("172.0.0.1"));
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private boolean checkBranch(String gitRepository, String branch) {
        block29: {
            String sessionId = this.getSessionId();
            String userName = Encrypters.decode((String)sessionId);
            String personalGitRepository = GitOperationUtil.getPersonalGitRepository((String)gitRepository, (String)userName);
            String projectURL = personalGitRepository + File.separator + ".git";
            String checkProjectURL = AppUtils.checkFilePath((String)projectURL);
            File gitFile = new File(checkProjectURL);
            if (!gitFile.exists()) break block29;
            try {
                Throwable throwable = null;
                try (Git git = Git.open((File)gitFile);){
                    String currentBranchName;
                    block32: {
                        Repository repository = git.getRepository();
                        currentBranchName = repository.getBranch();
                        if (StringUtils.isBlank((CharSequence)branch) || branch.equalsIgnoreCase(currentBranchName)) break block29;
                        Set call = git.clean().setCleanDirectories(true).setDryRun(false).call();
                        logger.debug("clean file {}", (Object)call);
                        if (!this.branchLocalExist(git, branch)) break block32;
                        try {
                            git.checkout().setCreateBranch(false).setName(branch).call();
                            boolean bl = true;
                            return bl;
                        }
                        catch (GitAPIException e) {
                            boolean bl;
                            block30: {
                                block31: {
                                    logger.error((Throwable)e);
                                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u672c\u5730\u4ed3\u5e93\u5206\u652f\u4e3a%1$s\uff0c\u5207\u6362\u4e3a\u5206\u652f%2$s\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"GITManagePlugin_18", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), currentBranchName, branch));
                                    this.getView().showTipNotification(e.getMessage());
                                    bl = false;
                                    if (git == null) break block30;
                                    if (throwable == null) break block31;
                                    try {
                                        git.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    break block30;
                                }
                                git.close();
                            }
                            return bl;
                        }
                    }
                    try {
                        git.checkout().setCreateBranch(true).setName(branch).setStartPoint("remotes/origin/" + branch).call();
                        break block29;
                    }
                    catch (GitAPIException e) {
                        logger.error((Throwable)e);
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u672c\u5730\u4ed3\u5e93\u5206\u652f\u4e3a%1$s\uff0c\u5207\u6362\u4e3a\u5206\u652f%2$s\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"GITManagePlugin_18", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), currentBranchName, branch));
                        this.getView().showTipNotification(e.getMessage());
                        boolean bl = false;
                        if (git != null) {
                            if (throwable != null) {
                                try {
                                    git.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                git.close();
                            }
                        }
                        return bl;
                    }
                    {
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            throw throwable5;
                        }
                    }
                }
            }
            catch (IOException | GitAPIException e) {
                logger.error(e);
            }
        }
        return true;
    }

    private boolean branchLocalExist(Git git, String branchName) throws GitAPIException {
        List refs = git.branchList().call();
        for (Ref ref : refs) {
            if (!ref.getName().contains(branchName)) continue;
            return true;
        }
        return false;
    }

    private void doSave(String bizAppId, String bizUnitId, String gitUrl, String repository, String gitBranch, String gitRootPath) {
        QFilter filter3;
        String sessionId = this.getSessionId();
        String userName = Encrypters.decode((String)sessionId);
        QFilter filter1 = new QFilter(KEY_BIZAPPID, "=", (Object)bizAppId);
        if (DevportalCommonUtil.isGitMultiParallel()) {
            QFilter filter2 = new QFilter(KEY_GITUSERNAME, "=", (Object)userName);
            filter1.and(filter2);
        } else {
            QFilter userFilter = new QFilter(KEY_GITUSERNAME, "=", (Object)"");
            filter1.and(userFilter);
        }
        if (StringUtils.isNotBlank((CharSequence)bizUnitId)) {
            filter3 = new QFilter(KEY_BIZUNITID, "=", (Object)bizUnitId);
            filter1.and(filter3);
        }
        filter3 = new QFilter(KEY_MANAGE_TYPE, "=", (Object)"git");
        filter1.and(filter3);
        QFilter[] filters = new QFilter[]{filter1};
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)"svnmanage", (QFilter[])filters);
        if (object != null) {
            object.set(KEY_GITURL, (Object)gitUrl.trim());
            object.set(KEY_GITREPOSITORY, (Object)repository.trim());
            object.set(KEY_GITBRANCH, (Object)gitBranch.trim());
            object.set(KEY_GITROOTPATH, (Object)gitRootPath.trim());
            object.set(KEY_BIZUNITID, (Object)bizUnitId);
            if (DevportalCommonUtil.isGitMultiParallel()) {
                object.set(KEY_GITUSERNAME, (Object)userName);
            }
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{object});
        } else {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"svnmanage");
            dynamicObject.set("id", (Object)DB.genStringId((String)"t_meta_svnmanage"));
            dynamicObject.set(KEY_BIZAPPID, (Object)bizAppId);
            dynamicObject.set(KEY_GITURL, (Object)gitUrl.trim());
            dynamicObject.set(KEY_GITREPOSITORY, (Object)repository.trim());
            dynamicObject.set(KEY_GITBRANCH, (Object)gitBranch.trim());
            dynamicObject.set(KEY_GITROOTPATH, (Object)gitRootPath.trim());
            dynamicObject.set(KEY_MANAGE_TYPE, (Object)"git");
            dynamicObject.set(KEY_BIZUNITID, (Object)bizUnitId);
            if (DevportalCommonUtil.isGitMultiParallel()) {
                dynamicObject.set(KEY_GITUSERNAME, (Object)userName);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u786e\u5b9a", "GITManagePlugin_16", BOS_DEVPORTAL_PLUGIN);
        MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u914d\u7f6eGit\u4fe1\u606f", "GITManagePlugin_17", BOS_DEVPORTAL_PLUGIN);
        AppUtils.addOpLog((String)"bos_devp_gitmanager_new", (String)"save", (String)"bos_devp_gitmanager_new", (String)"1", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[0]);
    }

    private boolean popLoginView() {
        String sessionId = this.getSessionId();
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            return true;
        }
        UserCacheInfo cacheInfo = new UserCacheInfo();
        JSONObject userInfo = cacheInfo.getUserInfo(sessionId);
        if (userInfo == null || userInfo.get((Object)"password") == null) {
            return true;
        }
        try {
            String userName = Encrypters.decode((String)sessionId);
            String pd = (String)userInfo.get((Object)"password");
            String passWord = Encrypters.decode((String)pd);
            this.getPageCache().put(USERNAME, userName);
            this.getPageCache().put(PD, passWord);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return true;
        }
        return false;
    }

    private boolean checkAccount(String gitUrl, String gitBranch) {
        this.getView().showLoading(new LocaleString(""));
        String isLogin = this.getPageCache().get(CHECK_RESULT);
        if (isLogin != null && StringUtils.equals((CharSequence)"success", (CharSequence)isLogin)) {
            return true;
        }
        String userName = this.getPageCache().get(USERNAME);
        String passWord = this.getPageCache().get(PD);
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_BIZAPPID);
        Map<String, String> res = this.checkAccount(gitUrl, gitBranch, userName, passWord);
        String result = res.get("result");
        if (StringUtils.equals((CharSequence)"false", (CharSequence)result)) {
            this.getView().hideLoading();
            String checkLogin = res.get("checkLogin");
            if (StringUtils.equals((CharSequence)"true", (CharSequence)checkLogin)) {
                this.showGitLoginPage(gitUrl, gitBranch, bizAppId);
                return false;
            }
            return false;
        }
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() != null) {
            if (LOGINCALLBACK.equals(e.getActionId())) {
                JSONObject res = JSONObject.parseObject((String)((String)e.getReturnData()));
                String checkResult = res.getString(CHECK_RESULT);
                this.getPageCache().put(CHECK_RESULT, checkResult);
                if (StringUtils.equals((CharSequence)"success", (CharSequence)checkResult)) {
                    String sessionId = res.getString(GIT_MSG);
                    this.getPageCache().put(GIT_MSG, sessionId);
                }
            } else if ("gitChooseFilePath".equals(e.getActionId()) && e.getReturnData() != null) {
                String path = (String)e.getReturnData();
                this.getModel().setValue(KEY_GITREPOSITORY, (Object)path);
            } else if ("gitSetting".equals(e.getActionId()) && e.getReturnData() != null) {
                Map res = (Map)e.getReturnData();
                String url = (String)res.get("url");
                String result = (String)res.get("result");
                String pushUrl = (String)res.get("pushUrl");
                String disableSSL = (String)res.get("sslVerify");
                if ("success".equals(result) && (StringUtils.isNotBlank((CharSequence)pushUrl) || StringUtils.isNotBlank((CharSequence)disableSSL))) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u6210\u529f\u3002", (String)"GITManagePlugin_22", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                }
                if (StringUtils.isNotBlank((CharSequence)url)) {
                    this.getModel().setValue(KEY_GITURL, (Object)url);
                }
            }
        }
    }

    private void showGitLoginPage(String gitUrl, String gitBranch, String bizAppId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devp_gitinfo");
        parameter.setCustomParam(KEY_GITURL, (Object)gitUrl);
        parameter.setCustomParam(KEY_GITBRANCH, (Object)gitBranch);
        parameter.setCustomParam(KEY_BIZAPPID, (Object)bizAppId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, LOGINCALLBACK));
        this.getView().showForm(parameter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DynamicObject getSetting(String gitUserName) {
        QFilter userFilter;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String bizAppId = (String)formShowParameter.getCustomParam(KEY_BIZAPPID);
        String bizunitid = (String)formShowParameter.getCustomParam(KEY_BIZUNITID);
        QFilter filter = new QFilter(KEY_BIZAPPID, "=", (Object)bizAppId);
        Object[] filters = new QFilter[]{filter};
        if (!StringUtils.isBlank((CharSequence)bizunitid)) {
            QFilter unitFilter = new QFilter(KEY_BIZUNITID, "=", (Object)bizunitid);
            filters = (QFilter[])ArrayUtils.add((Object[])filters, (Object)unitFilter);
        }
        if (DevportalCommonUtil.isGitMultiParallel()) {
            if (!StringUtils.isNotBlank((CharSequence)gitUserName)) return null;
            userFilter = new QFilter(KEY_GITUSERNAME, "=", (Object)gitUserName);
            filters = (QFilter[])ArrayUtils.add((Object[])filters, (Object)userFilter);
        } else {
            userFilter = new QFilter(KEY_GITUSERNAME, "=", (Object)"");
            filters = (QFilter[])ArrayUtils.add((Object[])filters, (Object)userFilter);
        }
        QFilter gitFilter = new QFilter(KEY_MANAGE_TYPE, "=", (Object)"git");
        filters = (QFilter[])ArrayUtils.add((Object[])filters, (Object)gitFilter);
        String selectFields = "id,giturl,gitrepository,gitbranch,gitrootpath,bizunitid,managetype,gitusername";
        DynamicObject[] gitSettings = BusinessDataServiceHelper.load((String)"svnmanage", (String)selectFields, (QFilter[])filters);
        if (gitSettings.length <= 0) return null;
        return gitSettings[0];
    }

    private void fillInfo(DynamicObject setting) {
        if (StringUtils.isBlank((Object)setting)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SETTING});
            return;
        }
        this.getModel().setValue(KEY_GITURL, (Object)setting.getString(KEY_GITURL));
        this.getModel().setValue(KEY_GITREPOSITORY, (Object)setting.getString(KEY_GITREPOSITORY));
        this.getModel().setValue(KEY_GITBRANCH, (Object)setting.getString(KEY_GITBRANCH));
        this.getModel().setValue(KEY_GITROOTPATH, (Object)setting.getString(KEY_GITROOTPATH));
    }

    private void fillInfo() {
        String bizAppId;
        String gitBranch;
        String gitCommonRemoteUrl = DevportalCommonUtil.getGitCommonRemoteUrl();
        if (StringUtils.isNotBlank((CharSequence)gitCommonRemoteUrl)) {
            this.getModel().setValue(KEY_GITURL, (Object)gitCommonRemoteUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)(gitBranch = DevportalCommonUtil.getGitBranch()))) {
            this.getModel().setValue(KEY_GITBRANCH, (Object)gitBranch);
        }
        if (StringUtils.isBlank((CharSequence)(bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_BIZAPPID)))) {
            return;
        }
        DynamicObject bizCloud = BizCloudServiceHelp.getBizCloudByAppID((String)bizAppId);
        String bizCloudNumber = bizCloud.getString("number");
        if (StringUtils.isNotBlank((CharSequence)bizCloudNumber)) {
            bizCloudNumber = bizCloudNumber.toLowerCase();
        }
        String bizAppNumber = MetadataDao.getAppNumberByAppId((String)bizAppId);
        String gitRootPath = String.format("datamodel/%s/%s/main/%s/metadata", bizCloudNumber, "1.5", bizAppNumber);
        this.getModel().setValue(KEY_GITROOTPATH, (Object)gitRootPath);
    }

    private String buildErrorInfo(String userName) {
        return String.format(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5f53\u524d\u8d26\u53f7\uff1a%s\u662f\u5426\u6b63\u786e\uff0c\u6216\u8005\u68c0\u67e5\u8d26\u53f7\u662f\u5426\u5177\u6709\u76f8\u5e94\u7684\u6743\u9650\u3002", (String)"GITManagePlugin_19", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), userName);
    }

    private Map<String, String> checkAccount(String gitUrl, String gitBranch, String userName, String passWord) {
        HashMap<String, String> res = new HashMap<String, String>(2);
        res.put("result", "true");
        try {
            GITCodeHostingServiceImpl.checkRemoteAccount((String)gitUrl, (String)userName, (String)passWord);
            List branchs = GitOperationUtil.getBranchs((String)gitUrl, (String)userName, (String)passWord);
            String branch = gitBranch == null ? "" : gitBranch;
            boolean existBranch = branchs.stream().anyMatch(b -> b.equals(branch));
            if (!existBranch) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"Git\u8fdc\u7a0b\u5206\u652f\u4e0d\u5b58\u5728\u6216\u6ca1\u6709\u6743\u9650\u67e5\u770b\u3002", (String)"GITManagePlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                res.put("result", "false");
                res.put("checkLogin", "false");
                return res;
            }
        }
        catch (GitAPIException e) {
            if (e.getMessage().contains("not authorized")) {
                res.put("result", "false");
                res.put("checkLogin", "true");
                this.getView().showTipNotification(this.buildErrorInfo(userName));
            } else if (e.getMessage().contains("timed out")) {
                res.put("result", "false");
                res.put("checkLogin", "true");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u68c0\u67e5\u8d26\u53f7\u662f\u5426\u6b63\u786e\u6216\u8005\u7f51\u7edc\u662f\u5426\u6b63\u5e38\u540e\u91cd\u8bd5\u3002", (String)"GITManagePlugin_15", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            } else {
                res.put("result", "false");
                res.put("checkLogin", "false");
                String msg = e.getMessage();
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8fdc\u7a0b\u4ed3\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u65e0\u6cd5\u8fde\u63a5\u201c%s\u201d\u3002", (String)"GITLoginPlugin_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), msg));
            }
            logger.error((Throwable)e);
            return res;
        }
        return res;
    }
}

