/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.git.pluginnew;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.business.git.GitCommit;
import kd.bos.devportal.business.git.GitDiffEntry;
import kd.bos.devportal.business.git.GitOperationUtils;
import kd.bos.devportal.business.git.GitRevFilter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.service.KDDateUtils;
import org.eclipse.jgit.api.errors.GitAPIException;

public class GitBaseLogPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(GitBaseLogPlugin.class);
    private static final String GITROOTPATH = "gitrootpath";
    private static final String PERSONALGITREPOSITORY = "personalgitrepository";
    private static final String GITOPERATETYPE = "gitoperatetype";
    public static final String GITOPERATEID = "gitoperateid";
    private static final String LOG_ENTRY = "logentry";
    private static final String FILE_PATH_ENTRY = "filepathentry";
    private static final String TXT_DESC = "txtdesc";
    private static final String TXT_AUTHOR = "txtauthor";
    private static final String TXT_COMMIT_DATE = "txtcommitdate";
    private static final String TXT_COMMIT_DATE1 = "txtcommitdate1";
    private static final String TXT_NAME = "txtname";
    private static final String CACHE_PATH_PREFIX = ".path";
    private static final String M_TXT_DETAIL = "mtxtdetail";
    private static final String TXT_PATH = "txtpath";
    private static final String LAST_DYM = "lastDym";
    private static final String BASE_DYM = "baseDym";
    private static final String PAGE = "page";
    private static final String BOS_DEVP_METAMERGE = "bos_devp_metadatadiff";
    private static final String DATA_MODEL = "dataModel";

    public void registerListener(EventObject e) {
        EntryGrid logEntryGrid = (EntryGrid)this.getControl(LOG_ENTRY);
        logEntryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid filePathEntry = (EntryGrid)this.getControl(FILE_PATH_ENTRY);
        filePathEntry.addRowClickListener((RowClickEventListener)this);
        filePathEntry.addHyperClickListener((HyperLinkClickListener)this);
    }

    protected void showLog() {
        this.showLog(null);
    }

    protected void showLog(GitRevFilter gitRevFilter) {
        String gitRootPath;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String gitRootPathParam = (String)parameter.getCustomParam(GITROOTPATH);
        String type = (String)parameter.getCustomParam(GITOPERATETYPE);
        String personalGitRepository = (String)parameter.getCustomParam(PERSONALGITREPOSITORY);
        String string = gitRootPath = StringUtils.contains((CharSequence)gitRootPathParam, (CharSequence)"\\") ? StringUtils.replace((String)gitRootPathParam, (String)"\\", (String)File.separator) : gitRootPathParam;
        if (DATA_MODEL.equals(type)) {
            String[] split = gitRootPath.split("/main");
            gitRootPath = split[0] + "/";
        }
        List gitCommits = new ArrayList();
        try {
            gitCommits = gitRevFilter != null ? GitOperationUtils.showLog((String)personalGitRepository, (String)gitRootPath, (GitRevFilter)gitRevFilter) : GitOperationUtils.showLog((String)personalGitRepository, (String)gitRootPath);
        }
        catch (GitAPIException e) {
            logger.error((Throwable)e);
        }
        this.setLogEntry(personalGitRepository, gitRootPath, gitCommits, true);
    }

    protected void showLog(String since, String HEAD) {
        String gitRootPath;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String gitRootPathParam = (String)parameter.getCustomParam(GITROOTPATH);
        String type = (String)parameter.getCustomParam(GITOPERATETYPE);
        String personalGitRepository = (String)parameter.getCustomParam(PERSONALGITREPOSITORY);
        String string = gitRootPath = StringUtils.contains((CharSequence)gitRootPathParam, (CharSequence)"\\") ? StringUtils.replace((String)gitRootPathParam, (String)"\\", (String)File.separator) : gitRootPathParam;
        if (DATA_MODEL.equals(type)) {
            String[] split = gitRootPath.split("/main");
            gitRootPath = split[0] + "/";
        }
        ArrayList<GitCommit> gitCommits = new ArrayList();
        try {
            gitCommits = GitOperationUtils.showLog((String)personalGitRepository, (String)gitRootPath, (String)since, (String)HEAD);
        }
        catch (GitAPIException e) {
            logger.error((Throwable)e);
        }
        this.setLogEntry(personalGitRepository, gitRootPath, gitCommits, false);
    }

    protected void setLogEntry(String personalGitRepository, String gitRootPath, List<GitCommit> gitCommits, boolean isFilter) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String type = (String)parameter.getCustomParam(GITOPERATETYPE);
        String gitoperateid = (String)parameter.getCustomParam(GITOPERATEID);
        String number = PAGE.equalsIgnoreCase(type) ? MetadataDao.getNumberById((String)gitoperateid) : "";
        this.getModel().deleteEntryData(LOG_ENTRY);
        for (GitCommit gitCommit : gitCommits) {
            List scriptDeployFile;
            String scriptNumber;
            String commitName = gitCommit.getName();
            List changedFilePaths = GitOperationUtils.getChangedFilePaths((String)personalGitRepository, (String)gitRootPath, (String)commitName);
            if (isFilter && PAGE.equalsIgnoreCase(type) && StringUtils.isNotBlank((CharSequence)number) && !this.isContainsCurrentFileNumber(changedFilePaths, number) || isFilter && "script".equalsIgnoreCase(type) && !this.isContainsCurrentFileNumber(changedFilePaths, scriptNumber = ((DeployFile)(scriptDeployFile = MetadataDao.getScriptDeployFile((String[])new String[]{gitoperateid})).get(0)).getFileName().split("\\.")[0])) continue;
            int row = this.getModel().createNewEntryRow(LOG_ENTRY);
            this.getModel().setValue(TXT_DESC, (Object)gitCommit.getShortMessage(), row);
            this.getModel().setValue(TXT_AUTHOR, (Object)gitCommit.getAuthorName(), row);
            this.getModel().setValue(TXT_COMMIT_DATE, (Object)gitCommit.getCommitDateTime(), row);
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                dateFormat.setTimeZone(KDDateUtils.getUserTimeZone());
                Date date = dateFormat.parse(gitCommit.getCommitDateTime());
                this.getModel().setValue(TXT_COMMIT_DATE1, (Object)date, row);
            }
            catch (ParseException dateFormat) {
                // empty catch block
            }
            String shortName = commitName.substring(0, 8);
            this.getModel().setValue(TXT_NAME, (Object)shortName, row);
            this.getPageCache().put(shortName, gitCommit.getFormatFullMessage());
            this.getPageCache().put(shortName + CACHE_PATH_PREFIX, SerializationUtils.toJsonString((Object)changedFilePaths));
        }
    }

    private boolean isContainsCurrentFileNumber(List<String> changedFilePaths, String number) {
        boolean flag = false;
        for (String path : changedFilePaths) {
            String[] split = path.split("/");
            String formNumber = split[split.length - 1];
            String removeSuffix = formNumber.split("\\.")[0];
            if (!removeSuffix.equals(number)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public void entryRowClick(RowClickEvent evt) {
        Control control = (Control)evt.getSource();
        if (evt.getRow() < 0) {
            return;
        }
        if (LOG_ENTRY.equals(control.getKey())) {
            String shortName = (String)this.getModel().getValue(TXT_NAME, evt.getRow());
            String detail = this.getPageCache().get(shortName);
            this.getModel().setValue(M_TXT_DETAIL, (Object)detail);
            String changedFilePathStr = this.getPageCache().get(shortName + CACHE_PATH_PREFIX);
            List changedFilePaths = SerializationUtils.fromJsonStringToList((String)changedFilePathStr, String.class);
            this.getModel().deleteEntryData(FILE_PATH_ENTRY);
            if (changedFilePaths != null) {
                for (String changedFilePath : changedFilePaths) {
                    int row = this.getModel().createNewEntryRow(FILE_PATH_ENTRY);
                    this.getModel().setValue(TXT_PATH, (Object)changedFilePath, row);
                }
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if (TXT_PATH.equals(fieldName)) {
            EntryGrid logGrid = (EntryGrid)this.getView().getControl(LOG_ENTRY);
            int[] logGridSelectRows = logGrid.getSelectRows();
            if (logGridSelectRows.length < 1) {
                return;
            }
            FormShowParameter parameter = this.getView().getFormShowParameter();
            String personalGitRepository = (String)parameter.getCustomParam(PERSONALGITREPOSITORY);
            int rowIndex = evt.getRowIndex();
            String sha1 = (String)this.getModel().getValue(TXT_NAME, logGridSelectRows[0]);
            String filePath = (String)this.getModel().getValue(TXT_PATH, rowIndex);
            GitDiffEntry commitDiffEntry = GitOperationUtils.getCommitDiffEntry((String)personalGitRepository, (String)filePath, (String)sha1);
            boolean showMerge = this.isShowMerge(filePath);
            if (showMerge && StringUtils.isNotBlank((CharSequence)commitDiffEntry.getOldContent()) && StringUtils.isNotBlank((CharSequence)commitDiffEntry.getNewContent()) && !commitDiffEntry.getNewContent().contains("PrintMetadata")) {
                this.showMerge(commitDiffEntry, filePath, "false");
            } else {
                this.showMerge(commitDiffEntry, filePath, "true");
            }
        }
    }

    private void showMerge(GitDiffEntry commitDiffEntry, String fileName, String isNotShowTree) {
        String oldContent = commitDiffEntry.getOldContent();
        String newContent = commitDiffEntry.getNewContent();
        String oldCommitId = commitDiffEntry.getOldCommitId();
        String newCommitId = commitDiffEntry.getNewCommitId();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(BOS_DEVP_METAMERGE);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.setCustomParam(fileName, parameter);
        parameter.setCustomParam("newCommitId", (Object)newCommitId);
        parameter.setCustomParam("oldCommitId", (Object)oldCommitId);
        parameter.setCustomParam("isNotShowTree", (Object)isNotShowTree);
        parameter.setCustomParam(LAST_DYM, (Object)oldContent);
        parameter.setCustomParam(BASE_DYM, (Object)newContent);
        parameter.setCustomParam("filePath", (Object)fileName);
        this.getView().showForm(parameter);
    }

    private boolean isShowMerge(String fileName) {
        return fileName.endsWith(".dym") || fileName.endsWith(".dymx") || fileName.endsWith(".app") || fileName.endsWith(".appx");
    }

    private void setCustomParam(String fileName, FormShowParameter parameter) {
        if (fileName.endsWith(".dym") || fileName.endsWith(".dymx")) {
            parameter.setCustomParam("metaType", (Object)PAGE);
        } else if (fileName.endsWith(".app") || fileName.endsWith(".appx")) {
            parameter.setCustomParam("metaType", (Object)"app");
        }
        String[] split = fileName.split("/");
        String fileNumber = split[split.length - 1];
        if (fileName.endsWith(".dymx") || fileName.endsWith(".appx")) {
            parameter.setCustomParam("multiLang", (Object)"true");
            String[] split1 = fileNumber.split("\\.");
            parameter.setCustomParam("localeId", (Object)split1[1]);
        }
        parameter.setCustomParam("number", (Object)fileNumber);
    }
}

