/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.git.pluginnew;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.devportal.business.hosting.GitOperationUtil;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.EntryGridColAllCheckedEvent;
import kd.bos.form.control.events.EntryGridColAllCheckedListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class GitChooseFilePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
RowClickEventListener,
EntryGridColAllCheckedListener {
    private final Log log = LogFactory.getLog(GitChooseFilePlugin.class);
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String COMMIT_PUSH = "commitandpush";
    private static final String COMMIT = "btnok";
    private static final String ADDRESS = "address";
    private static final String BRANCH = "branch";
    private static final String ROOT_PATH = "gitRootPath";
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String COMPARE = "compare";
    private static final String PAGE = "page";
    private static final String KS = "ks";
    private static final String BIZAPPID = "bizappid";
    private static final String ID = "id";
    private static final String UNIT_ID = "unitid";
    private static final String UNIT_NAME = "unitname";
    private static final String STATUS = "status";
    private static final String SELECT_PAGE = "selectPage";
    private static final String SELECT_KS = "selectKs";
    private static final String CURRENT_ID = "currentId";
    private static final String SELECT = "select";
    private static final String EXPAND = "expand";
    private static final String PICTURE_STATUS = "pictureStatus";
    private static final String PICTURE_EXPAND = "0";
    private static final String PICTURE_COLLAPSE = "1";
    private static final String IMAGEAP = "imagepanel";
    private static final String CHECK_APP = "checkinapp";
    private static final String GIT_GITBRANCH = "gitbranch";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{COMMIT, COMMIT_PUSH, EXPAND});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String bizAppId = (String)parameter.getCustomParam(BIZAPPID);
        this.getPageCache().put(CURRENT_ID, bizAppId);
        this.getPageCache().put(PICTURE_STATUS, PICTURE_EXPAND);
        List<MetaType> metaTypes = this.getNodeList(bizAppId);
        this.removeNoChangeFile(metaTypes);
        this.initEntryEntity(metaTypes);
        String address = (String)parameter.getCustomParam(ADDRESS);
        String branch = (String)parameter.getCustomParam(GIT_GITBRANCH);
        Label addressLabel = (Label)this.getView().getControl(ADDRESS);
        Label branchLabel = (Label)this.getView().getControl(BRANCH);
        addressLabel.setText(address);
        branchLabel.setText(branch);
    }

    private List<MetaType> getNodeList(String bizAppID) {
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppID, (boolean)false);
        List functionElements = appMeta.getAppFunctionPackets();
        HashMap<String, String> bizUnit = new HashMap<String, String>(functionElements.size());
        for (AppFunctionPacketElement functionElement : functionElements) {
            bizUnit.put(functionElement.getId(), (String)functionElement.getName().getDefaultItem());
        }
        List<MetaType> app = this.getApp(bizAppID);
        List<MetaType> pages = this.getPage(bizAppID, bizUnit);
        List<MetaType> ks = this.getKs(bizAppID, bizUnit);
        app.addAll(pages);
        app.addAll(ks);
        this.exportAppFile(bizAppID, pages, ks);
        this.getPageCache().put(bizAppID, SerializationUtils.toJsonString(app));
        return app;
    }

    private void initEntryEntity(List<MetaType> metaTypes) {
        if (metaTypes.isEmpty()) {
            return;
        }
        List pages = null;
        List ks = null;
        ArrayList selectPageAndKs = new ArrayList(10);
        String selectPage = this.getPageCache().get(SELECT_PAGE);
        String selectKs = this.getPageCache().get(SELECT_KS);
        if (selectPage != null) {
            pages = SerializationUtils.fromJsonStringToList((String)selectPage, String.class);
            selectPageAndKs.addAll(pages);
        }
        if (selectKs != null) {
            ks = SerializationUtils.fromJsonStringToList((String)selectKs, String.class);
            selectPageAndKs.addAll(ks);
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, metaTypes.size());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(metaTypes.size());
        for (int i = 0; i < metaTypes.size(); ++i) {
            MetaType metaType = metaTypes.get(i);
            DynamicObject row = (DynamicObject)entryEntity.get(i);
            row.set(NAME, (Object)metaType.getName());
            row.set(NUMBER, (Object)metaType.getNumber());
            row.set(TYPE, (Object)metaType.getType());
            row.set(ID, (Object)metaType.getId());
            if (selectPageAndKs.contains(metaType.getId())) {
                row.set(SELECT, (Object)true);
            }
            row.set(UNIT_ID, (Object)metaType.getUnitId());
            row.set(UNIT_NAME, (Object)metaType.getUnitName());
            CellStyle cellStyle = new CellStyle();
            String status = metaType.getStatus();
            if (StringUtils.equals((CharSequence)"Added", (CharSequence)status)) {
                cellStyle.setForeColor("#40bd6e");
            } else if (StringUtils.equals((CharSequence)"Modified", (CharSequence)status)) {
                cellStyle.setForeColor("#ff991c");
            } else if (StringUtils.equals((CharSequence)"Missing", (CharSequence)status)) {
                cellStyle.setForeColor("#fb2323");
            }
            cellStyle.setFieldKey(STATUS);
            cellStyle.setRow(i);
            cellStyles.add(cellStyle);
            row.set(STATUS, (Object)metaType.getStatus());
        }
        entryGrid.setCellStyle(cellStyles);
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void removeNoChangeFile(List<MetaType> metaTypes) {
        String repositoryPath;
        File file;
        String separator;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String repository = (String)parameter.getCustomParam(ADDRESS);
        String gitRootPath = (String)parameter.getCustomParam(ROOT_PATH);
        String path = gitRootPath.replaceAll(separator = Matcher.quoteReplacement(File.separator), "/");
        if (path.startsWith("/") || path.startsWith("\\")) {
            path = path.substring(1);
        }
        if (!(file = new File(repositoryPath = repository + File.separator + ".git")).exists()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u5730\u4ed3\u5e93\u4e0d\u5b58\u5728\u3002", (String)"GitChooseFilePlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        try (Git git = Git.open((File)file);){
            List diffEntries = git.diff().setPathFilter((TreeFilter)PathFilter.create((String)path)).call();
            HashSet<String> added = new HashSet<String>();
            HashSet<String> modified = new HashSet<String>();
            HashSet<String> missing = new HashSet<String>();
            for (DiffEntry diffEntry : diffEntries) {
                String newPath;
                if (DiffEntry.ChangeType.DELETE.equals((Object)diffEntry.getChangeType())) {
                    String oldPath = diffEntry.getOldPath();
                    missing.add(oldPath);
                    continue;
                }
                if (DiffEntry.ChangeType.ADD.equals((Object)diffEntry.getChangeType())) {
                    newPath = diffEntry.getNewPath();
                    added.add(newPath);
                    continue;
                }
                newPath = diffEntry.getNewPath();
                modified.add(newPath);
            }
            HashSet<String> afterAdd = new HashSet<String>(added.size());
            HashSet<String> afterModified = new HashSet<String>(added.size());
            HashSet<String> afterMissing = new HashSet<String>(added.size());
            this.handleFileName(added, afterAdd);
            this.handleFileName(modified, afterModified);
            this.handleFileName(missing, afterMissing);
            this.handleMetaType(metaTypes, afterAdd, afterModified, afterMissing);
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
        }
    }

    private void handleFileName(Set<String> beforeSet, Set<String> afterSet) {
        for (String s : beforeSet) {
            String[] split = s.split("/");
            String name = split[split.length - 1];
            afterSet.add(name);
        }
    }

    private void handleMetaType(List<MetaType> metaTypes, Set<String> added, Set<String> modified, Set<String> removed) {
        Iterator<MetaType> iterator = metaTypes.iterator();
        while (iterator.hasNext()) {
            MetaType metaType = iterator.next();
            String name = this.getName(metaType);
            if (added.contains(name)) {
                metaType.setStatus("Added");
                continue;
            }
            if (modified.contains(name)) {
                metaType.setStatus("Modified");
                continue;
            }
            if (removed.contains(name)) {
                metaType.setStatus("Missing");
                continue;
            }
            iterator.remove();
        }
    }

    private String getName(MetaType metaType) {
        String type = metaType.getType();
        String name = null;
        if (PAGE.equals(type)) {
            name = metaType.getNumber() + ".dym";
        } else if (KS.equals(type)) {
            name = metaType.getNumber() + ".ks";
        } else if ("app".equals(type)) {
            name = metaType.getNumber() + ".app";
        }
        return name;
    }

    private List<MetaType> getPage(String bizAppId, Map<String, String> unit) {
        QFilter qFilter = new QFilter("bizapp", "=", (Object)bizAppId);
        QFilter[] filters = new QFilter[]{qFilter};
        String unitFormFields = "bizapp,bizunit,form";
        String formFields = "id,number,name,type,parentid";
        ArrayList<MetaType> metaTypes = new ArrayList<MetaType>(10);
        try (DataSet unitFormDataSet = QueryServiceHelper.queryDataSet((String)"bos_devportal_unitrelform", (String)"bos_devportal_unitrelform", (String)unitFormFields, (QFilter[])filters, (String)"form asc");
             DataSet formDataSet = QueryServiceHelper.queryDataSet((String)"bos_formmeta", (String)"bos_formmeta", (String)formFields, null, (String)"number asc");
             DataSet result = unitFormDataSet.join(formDataSet, JoinType.INNER).on("form", ID).select(new String[]{"bizunit", "form"}, new String[]{ID, NUMBER, NAME, TYPE, "parentid"}).finish();){
            for (Row row : result) {
                MetaType metaType = new MetaType();
                metaType.setId(row.getString(ID));
                metaType.setName(row.getString(NAME));
                metaType.setNumber(row.getString(NUMBER));
                metaType.setType(PAGE);
                String unitId = row.getString("bizunit");
                String unitName = unit.get(unitId);
                metaType.setUnitId(unitId);
                metaType.setUnitName(unitName);
                metaTypes.add(metaType);
            }
        }
        return metaTypes;
    }

    private List<MetaType> getKs(String bizAppId, Map<String, String> unit) {
        String scriptFields = "id, txt_scriptnumber, txt_scriptname, bizunitid";
        QFilter scriptFilter_1 = new QFilter(BIZAPPID, "=", (Object)bizAppId);
        QFilter[] scriptFilters = new QFilter[]{scriptFilter_1};
        String scriptOrderBy = "txt_scriptnumber";
        ArrayList<MetaType> metaTypes = new ArrayList<MetaType>(10);
        DynamicObjectCollection scriptInfo = QueryServiceHelper.query((String)"ide_pluginscript", (String)scriptFields, (QFilter[])scriptFilters, (String)scriptOrderBy);
        for (DynamicObject obj : scriptInfo) {
            MetaType metaType = new MetaType();
            metaType.setId(obj.getString(ID));
            metaType.setName(obj.getString("txt_scriptname"));
            metaType.setNumber(obj.getString("txt_scriptnumber"));
            String unitId = obj.getString("bizunitid");
            String unitName = unit.get(unitId);
            metaType.setUnitId(unitId);
            metaType.setUnitName(unitName);
            metaType.setType(KS);
            metaTypes.add(metaType);
        }
        return metaTypes;
    }

    private List<MetaType> getApp(String bizAppId) {
        String sql = "select a.fnumber, b.fname from t_meta_bizapp a join t_meta_bizapp_l b on a.fid = b.fid and a.fid = ? and b.flocaleid = 'zh_CN'";
        Object[] params = new SqlParameter[]{new SqlParameter(":fid", 12, (Object)bizAppId)};
        ResultSetHandler action = rs -> {
            ArrayList<MetaType> metaTypes = new ArrayList<MetaType>(1);
            if (rs.next()) {
                MetaType metaType = new MetaType();
                metaType.setId(bizAppId);
                metaType.setName(rs.getString("fname"));
                metaType.setNumber(rs.getString("fnumber"));
                metaType.setType("app");
                metaType.setUnitId("");
                metaType.setUnitName("");
                metaTypes.add(metaType);
                return metaTypes;
            }
            return null;
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    private void exportAppFile(String bizAppId, List<MetaType> formMeta, List<MetaType> scriptMeta) {
        try {
            List deployFile = MetadataDao.getAppDeployFile((String)bizAppId);
            this.saveFileToLocalRepository(deployFile);
            this.exportPageFile(formMeta, bizAppId);
            this.exportScriptFile(scriptMeta);
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
        }
    }

    private void exportPageFile(List<MetaType> metaTypes, String bizAppId) {
        ArrayList<DeployFile> fileList = new ArrayList<DeployFile>(metaTypes.size());
        for (MetaType metaType : metaTypes) {
            List file = null;
            try {
                file = MetadataDao.getFormDeployFile((String)metaType.getId(), (String)bizAppId, (String)metaType.getUnitId());
            }
            catch (Exception e) {
                this.log.error(metaType.getId(), (Throwable)e);
            }
            if (file == null) continue;
            fileList.addAll(file);
        }
        this.saveFileToLocalRepository(fileList);
    }

    private void exportScriptFile(List<MetaType> metaTypes) {
        try {
            ArrayList scriptIds = new ArrayList(metaTypes.size());
            metaTypes.forEach(metaType -> scriptIds.add(metaType.getId()));
            List scriptDeployFile = MetadataDao.getScriptDeployFile((String[])scriptIds.toArray(new String[0]));
            this.saveFileToLocalRepository(scriptDeployFile);
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
        }
    }

    private void saveFileToLocalRepository(List<DeployFile> deployFileList) {
        String repositoryPath = this.getRepositoryPath();
        for (DeployFile file : deployFileList) {
            GitOperationUtil.saveFile((String)file.getFileName(), (String)file.getFileContent(), (String)repositoryPath);
        }
    }

    private String getRepositoryPath() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String address = (String)parameter.getCustomParam(ADDRESS);
        String rootPath = (String)parameter.getCustomParam(ROOT_PATH);
        return address + rootPath;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (SELECT.equals(name)) {
            ChangeData changeData = e.getChangeSet()[0];
            boolean isSelect = (Boolean)changeData.getNewValue();
            String type = changeData.getDataEntity().getString(TYPE);
            String id = changeData.getDataEntity().getString(ID);
            if (PAGE.equals(type)) {
                this.handleSelectPage(isSelect, id);
            } else if (KS.equals(type)) {
                this.handleSelectKs(isSelect, id);
            }
        }
    }

    private void handleSelectPage(boolean isSelect, String id) {
        String pageCache = this.getPageCache().get(SELECT_PAGE);
        ArrayList<String> pages = null;
        if (isSelect) {
            if (pageCache != null) {
                pages = SerializationUtils.fromJsonStringToList((String)pageCache, String.class);
                if (!pages.contains(id)) {
                    pages.add(id);
                }
            } else {
                pages = new ArrayList<String>(1);
                pages.add(id);
            }
            this.getPageCache().put(SELECT_PAGE, SerializationUtils.toJsonString(pages));
            return;
        }
        if (pageCache != null) {
            pages = SerializationUtils.fromJsonStringToList((String)pageCache, String.class);
            pages.remove(id);
        }
        if (pages != null) {
            this.getPageCache().put(SELECT_PAGE, SerializationUtils.toJsonString(pages));
        }
    }

    private void handleSelectKs(boolean isSelect, String id) {
        String ksCache = this.getPageCache().get(SELECT_KS);
        ArrayList<String> ks = null;
        if (isSelect) {
            if (ksCache != null) {
                ks = SerializationUtils.fromJsonStringToList((String)ksCache, String.class);
                if (!ks.contains(id)) {
                    ks.add(id);
                }
            } else {
                ks = new ArrayList<String>(1);
                ks.add(id);
            }
            this.getPageCache().put(SELECT_KS, SerializationUtils.toJsonString(ks));
            return;
        }
        if (ksCache != null) {
            ks = SerializationUtils.fromJsonStringToList((String)ksCache, String.class);
            ks.remove(id);
        }
        if (ks != null) {
            this.getPageCache().put(SELECT_KS, SerializationUtils.toJsonString(ks));
        }
    }

    public void entryGridColAllChecked(EntryGridColAllCheckedEvent e) {
        String colKey = e.getColKey();
        if (SELECT.equals(colKey)) {
            boolean checked = e.isChecked();
            this.handleColAllChecked(checked);
        }
    }

    private void handleColAllChecked(boolean isChecked) {
        String nodeId = this.getPageCache().get(CURRENT_ID);
        String pageAndKs = this.getPageCache().get(nodeId);
        if (pageAndKs == null) {
            return;
        }
        List metaTypes = SerializationUtils.fromJsonStringToList((String)pageAndKs, MetaType.class);
        ArrayList<String> page = new ArrayList<String>(10);
        ArrayList<String> ks = new ArrayList<String>(10);
        for (MetaType metaType : metaTypes) {
            if (PAGE.equals(metaType.getType())) {
                page.add(metaType.getId());
                continue;
            }
            if (!KS.equals(metaType.getType())) continue;
            ks.add(metaType.getId());
        }
        String pageCache = this.getPageCache().get(SELECT_PAGE);
        String ksCache = this.getPageCache().get(SELECT_KS);
        List selectPage = null;
        List selectKs = null;
        if (pageCache != null) {
            selectPage = SerializationUtils.fromJsonStringToList((String)pageCache, String.class);
        }
        if (ksCache != null) {
            selectKs = SerializationUtils.fromJsonStringToList((String)ksCache, String.class);
        }
        if (isChecked) {
            List collect;
            if (selectPage != null) {
                selectPage.addAll(page);
                collect = selectPage.stream().distinct().collect(Collectors.toList());
                this.getPageCache().put(SELECT_PAGE, SerializationUtils.toJsonString(collect));
            } else if (!page.isEmpty()) {
                this.getPageCache().put(SELECT_PAGE, SerializationUtils.toJsonString(page));
            }
            if (selectKs != null) {
                selectKs.addAll(ks);
                collect = selectKs.stream().distinct().collect(Collectors.toList());
                this.getPageCache().put(SELECT_PAGE, SerializationUtils.toJsonString(collect));
            } else if (!ks.isEmpty()) {
                this.getPageCache().put(SELECT_PAGE, SerializationUtils.toJsonString(ks));
            }
        } else {
            if (selectPage != null) {
                selectPage.removeAll(page);
            }
            if (selectKs != null) {
                selectKs.removeAll(ks);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Donothing operate;
        String operateKey;
        if (args.getSource() instanceof Donothing && COMPARE.equals(operateKey = (operate = (Donothing)args.getSource()).getOperateKey())) {
            int index = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            String type = (String)this.getModel().getValue(TYPE, index);
            String fileName = null;
            String content = null;
            if (PAGE.equals(type)) {
                fileName = this.getModel().getValue(NUMBER, index) + ".dym";
                content = ((DeployFile)MetadataDao.getFormDeployFile((String)((String)this.getModel().getValue(ID, index))).get(0)).getFileContent();
            } else if (KS.equals(type)) {
                fileName = this.getModel().getValue(NUMBER, index) + ".ks";
                content = ((DeployFile)MetadataDao.getScriptDeployFile((String[])new String[]{(String)this.getModel().getValue(ID, index)}).get(0)).getFileContent();
            }
            String repositoryPath = (String)this.getView().getFormShowParameter().getCustomParam("gitrepository");
            Object baseFileContent = null;
            FormShowParameter parameter = new FormShowParameter();
            if (PAGE.equals(type) && baseFileContent != null) {
                parameter.setFormId("bos_devp_metamerge_new");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCustomParam("lastDym", baseFileContent);
                parameter.setCustomParam("baseDym", (Object)content);
            } else {
                parameter.setFormId("bos_devp_gitdiff");
                parameter.setPageId(UUID.randomUUID().toString());
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                String projectUrl = formShowParameter.getCustomParam("gitrepository") + ".git";
                parameter.setCustomParam("projecturl", (Object)projectUrl);
                parameter.setCustomParam("gitrepository", formShowParameter.getCustomParam("gitrepository"));
                parameter.setCustomParam("personalgitrepository", formShowParameter.getCustomParam("gitrepository"));
                String metaType = PAGE.equals(type) ? PAGE : "scrpt";
                parameter.setCustomParam("filepath", (Object)fileName);
                parameter.setCustomParam(TYPE, (Object)metaType);
                parameter.setCaption(ResManager.loadKDString((String)"\u6587\u4ef6\u6bd4\u8f83", (String)"GITPushPlugin_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                OpenStyle style = new OpenStyle();
                StyleCss cssStyle = new StyleCss();
                cssStyle.setHeight("760");
                cssStyle.setWidth("1200");
                style.setInlineStyleCss(cssStyle);
                style.setShowType(ShowType.Modal);
                parameter.setOpenStyle(style);
            }
            this.getView().showForm(parameter);
        }
    }

    public void click(EventObject e) {
        String key;
        switch (key = ((Control)e.getSource()).getKey()) {
            case "expand": {
                this.expandAndCollapse();
                break;
            }
            case "btnok": {
                this.commit();
                break;
            }
        }
    }

    private void expandAndCollapse() {
        String status = this.getPageCache().get(PICTURE_STATUS);
        if (PICTURE_EXPAND.equals(status)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{IMAGEAP});
            this.getPageCache().put(PICTURE_STATUS, PICTURE_COLLAPSE);
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{IMAGEAP});
            this.getPageCache().put(PICTURE_STATUS, PICTURE_EXPAND);
        }
    }

    private void commit() {
        String pageCache = this.getPageCache().get(SELECT_PAGE);
        boolean containAppResource = (Boolean)this.getModel().getValue(CHECK_APP);
        List pages = new ArrayList(1);
        if (pageCache != null) {
            pages = SerializationUtils.fromJsonStringToList((String)pageCache, String.class);
        }
        String ksCache = this.getPageCache().get(SELECT_KS);
        List ks = new ArrayList(1);
        if (ksCache != null) {
            ks = SerializationUtils.fromJsonStringToList((String)ksCache, String.class);
        }
        if (pages.isEmpty() && ks.isEmpty() && !containAppResource) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u63d0\u4ea4\u7684\u6587\u4ef6\u3002", (String)"GitChooseFilePlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String bizAppId = (String)parameter.getCustomParam(BIZAPPID);
        JSONObject msg = new JSONObject();
        msg.put("gitoperatekey", (Object)"commit");
        msg.put(BIZAPPID, (Object)bizAppId);
        msg.put(TYPE, (Object)"app");
        msg.put("pageids", (Object)SerializationUtils.toJsonString(pages));
        msg.put("scriptids", (Object)SerializationUtils.toJsonString(ks));
        msg.put("checkinappflag", (Object)containAppResource);
        msg.put("gitmsg", parameter.getCustomParam("gitmsg"));
        this.getView().returnDataToParent((Object)msg.toJSONString());
        this.getView().close();
    }

    static class MetaType
    implements Serializable {
        private static final long serialVersionUID = -4899288175276899799L;
        private String id;
        private String name;
        private String number;
        private String type;
        private String unitId;
        private String unitName;
        private String status;

        public MetaType() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getUnitId() {
            return this.unitId;
        }

        public void setUnitId(String unitId) {
            this.unitId = unitId;
        }

        public String getUnitName() {
            return this.unitName;
        }

        public void setUnitName(String unitName) {
            this.unitName = unitName;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public MetaType(String id, String name, String number, String type, String unitId, String unitName) {
            this.id = id;
            this.name = name;
            this.number = number;
            this.type = type;
            this.unitId = unitId;
            this.unitName = unitName;
        }
    }
}

