/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.git.pluginnew;

import com.alibaba.fastjson.JSONArray;
import java.io.File;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.datamodel.metadata.dao.PDMEntityMetaBuilder;
import kd.bos.datamodel.metadata.pdm.PDMEntityMetadata;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.devportal.business.git.GitContext;
import kd.bos.devportal.business.git.GitDiffContext;
import kd.bos.devportal.business.git.GitOperateHandler;
import kd.bos.devportal.business.git.GitOperationUtils;
import kd.bos.devportal.business.git.GitSaveFileHandler;
import kd.bos.devportal.business.hosting.GITCodeHostingServiceImpl;
import kd.bos.devportal.business.hosting.GitOperationUtil;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.git.GitUtil;
import kd.bos.devportal.git.proxy.GitAppPluginProxy;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.EntryGridColAllCheckedListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.util.SAXReaderUtil;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class GitCommitPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
EntryGridColAllCheckedListener,
EntryGridBindDataListener,
TreeNodeClickListener {
    private static final Log log = LogFactory.getLog(GitCommitPlugin.class);
    private static final String KEY_GITURL = "giturl";
    private static final String KEY_GITBRANCH = "gitbranch";
    private static final String KEY_ANNOTATION = "annotation";
    private static final String KEY_GITREPOSITORY = "gitrepository";
    private static final String KEY_GITROOTPATH = "gitrootpath";
    private static final String KEY_PAGEIDS = "pageids";
    private static final String COMMIT = "commit";
    private static final String COMMIT_PUSH = "commitpush";
    private static final String PULL = "pull";
    private static final String TOOL_BARAP = "toolbarap";
    private static final String IMAGEAP = "imagepanel";
    private static final String EXPAND = "expand";
    private static final String PICTURE_STATUS = "pictureStatus";
    private static final String PICTURE_EXPAND = "0";
    private static final String PICTURE_COLLAPSE = "1";
    private static final String FILE_STATUS = "filestatus";
    private static final String OPERATE = "operate";
    public static final String GITBRANCH = "gitbranch";
    public static final String PERSONALGITREPOSITORY = "personalgitrepository";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String META_ENTRY_ENTITY = "metaentryentity";
    private static final String COMMIT_PANEL = "commitfilepanel";
    private static final String COMMIT_MESSAGE_PANEL = "commitmessagepanel";
    private static final String CHOOSE_FILE_PANEL = "choosepanel";
    private static final String LAST_STEP = "laststep";
    private static final String NEXT_STEP = "nextstop";
    private static final String BIZAPPID = "bizappid";
    private static final String SELECT = "select";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String MODIFY_DATE = "modifydate";
    private static final String ID = "id";
    private static final String UNIT_ID = "unitid";
    private static final String UNIT_NAME = "unitname";
    private static final String CHOOSE_FILE_STATUS = "choosefilestatus";
    private static final String FILE_NAME = "filename";
    private static final String TYPE = "type";
    private static final String PAGE = "page";
    private static final String KS = "ks";
    private static final String LAST = "last";
    private static final String CURRENT = "current";
    private static final String CONTENT = "content";
    private static final String TXT_SCRIPTNUMBER = "txt_scriptnumber";
    private static final String KEY_NUMBER = "number";
    private static final String CLOUD = "cloud";
    private static final String APP = "app";
    private static final String IS_SAVE = "issave";
    private static final String COMMIT_ID = "commitId";
    private static final String CURRENT_COMMIT_ID = "currentCommitId";
    private static final String ADDRESS = "address";
    private static final String BRANCH = "branch";
    private static final String TREEVIEWAP = "treeviewap";
    private static final String SELECT_PAGE = "selectPage";
    private static final String SELECT_SCRIPT = "selectScript";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String PATH = "path";
    private static final String DATA_MODEL = "dataModel";
    private static final String BOS_DM_SQLCONTENT = "bos_dm_sqlcontent";

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entryGrid.addPackageDataListener(this::packageData);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{EXPAND, COMMIT, COMMIT_PUSH, NEXT_STEP, LAST_STEP, PULL});
        this.addItemClickListeners(new String[]{TOOL_BARAP});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEWAP);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put(PICTURE_STATUS, PICTURE_EXPAND);
        this.hideSelectOrderAndFilter();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String gitContext = (String)formShowParameter.getCustomParam("gitContext");
        GitContext context = (GitContext)SerializationUtils.fromJsonString((String)gitContext, GitContext.class);
        this.switchViewVisible();
        String gitRepository = context.getPersonalGitRepository();
        String rootPath = GitUtil.getMetadataRootPath(context.getGitRootPath());
        String gitBranch = context.getGitBranch();
        Label addressLabel = (Label)this.getView().getControl(ADDRESS);
        Label branchLabel = (Label)this.getView().getControl(BRANCH);
        addressLabel.setText(gitRepository);
        branchLabel.setText(gitBranch);
        String type = context.getType();
        String id = context.getId();
        if (PAGE.equals(type)) {
            List<DeployFile> list = MetadataDao.getFormDeployFile((String)id);
            list = list.stream().filter(f -> !GitOperationUtil.isIgnoreFile((String)f.getFileName())).collect(Collectors.toList());
            this.addToEntryRow(list, 0);
        } else if ("script".equals(type)) {
            List deployFileList = MetadataDao.getScriptDeployFile((String[])new String[]{id});
            DeployFile df = (DeployFile)deployFileList.get(0);
            String fileName = df.getFileName();
            this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, 1);
            this.getModel().setValue(FILE_NAME, (Object)fileName, 0);
            this.getModel().setValue("status", (Object)ResManager.loadKDString((String)"\u5f85\u63d0\u4ea4", (String)"GITCommitPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), 0);
            this.getModel().setValue(FILE_STATUS, (Object)ResManager.loadKDString((String)"\u672a\u5408\u5e76", (String)"GitCommitPlugin_10", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), 0);
            this.getModel().setValue(OPERATE, (Object)ResManager.loadKDString((String)"\u6bd4\u8f83", (String)"GitCommitPlugin_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), 0);
            this.getModel().setValue(CONTENT, (Object)df.getFileContent(), 0);
        } else {
            if (APP.equals(type)) {
                this.renderMenuTree(context.getBizAppId());
                this.fillEntryEntity(context.getBizAppId());
                this.switchViewVisible(false);
                this.initImageVisible();
                return;
            }
            if (CLOUD.equals(type)) {
                List<DeployFile> list = MetadataDao.getCloudDeployFile((String)id);
                list = list.stream().filter(f -> !GitOperationUtil.isIgnoreFile((String)f.getFileName())).collect(Collectors.toList());
                this.addToEntryRow(list, 0);
            } else if ("botp_cr".equals(type) || "botp_wb".equals(type) || "botp_bur".equals(type)) {
                JSONArray ruleIds = (JSONArray)JSONArray.parse((String)formShowParameter.getCustomParam("ruleIds").toString());
                List<DeployFile> convertRuleDeployFiles = GitOperationUtil.getBotpDeployFiles((String)type, (JSONArray)ruleIds);
                convertRuleDeployFiles = convertRuleDeployFiles.stream().filter(f -> !GitOperationUtil.isIgnoreFile((String)f.getFileName())).collect(Collectors.toList());
                this.addToEntryRow(convertRuleDeployFiles, 0);
            } else if (DATA_MODEL.equals(type)) {
                String modelId = (String)formShowParameter.getCustomParam("modelId");
                if (StringUtils.isBlank((CharSequence)modelId)) {
                    this.initImageVisible();
                    return;
                }
                String gitRootPath = context.getGitRootPath();
                AppInfo appInfo = AppMetadataCache.getAppInfo((String)context.getBizAppId());
                String number = appInfo.getNumber();
                String dbRoute = appInfo.getDbRoute();
                String pdmPath = gitRootPath.split("main")[0] + "pdm/" + number;
                String personalGitRepository = context.getPersonalGitRepository();
                List<DeployFile> dataModelDeployFile = this.getDataModelDeployFile(modelId);
                if (dataModelDeployFile != null) {
                    DataModelLog dataModelLog;
                    String lastPdm = GitOperationUtils.getLastCommitFile((String)personalGitRepository, (String)pdmPath, (String)dataModelDeployFile.get(0).getFileName());
                    String currPdm = dataModelDeployFile.get(0).getFileContent();
                    List<DataModelType> sqlList = this.getSql(currPdm, lastPdm, gitRootPath);
                    DataModelType xml = null;
                    if (sqlList != null) {
                        ArrayList<String> fileNames = new ArrayList<String>(sqlList.size());
                        sqlList.forEach(sql -> fileNames.add(sql.getFileName()));
                        xml = this.getXml(gitRootPath, personalGitRepository, dbRoute, fileNames);
                    }
                    List<DataModelType> dataModelType = this.getDataModelType(dataModelDeployFile, pdmPath);
                    if (sqlList != null && !sqlList.isEmpty()) {
                        dataModelType.addAll(sqlList);
                    }
                    if (xml != null) {
                        dataModelType.add(xml);
                    }
                    if ((dataModelLog = this.getDataModelLog(modelId)) != null) {
                        String content = dataModelLog.getContent();
                        String commit = ResManager.loadKDString((String)"\u3010\u63d0\u4ea4\u4eba\u3011", (String)"GitCommitPlugin_19", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
                        String commitName = dataModelLog.getCommitName() == null ? "" : dataModelLog.getCommitName();
                        String submit = commit + commitName;
                        this.getModel().setValue(KEY_ANNOTATION, (Object)(content + "\r\n" + submit));
                    }
                    this.initDataModelEntry(dataModelType);
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{PATH});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{FILE_STATUS});
                }
            }
        }
        this.compareContent();
        this.initImageVisible();
    }

    private void initImageVisible() {
        if (Lang.zh_CN != Lang.get()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{IMAGEAP, EXPAND});
        }
    }

    private List<DataModelType> getDataModelType(List<DeployFile> dataModelDeployFile, String path) {
        DataModelType dataModelType = new DataModelType();
        dataModelType.setFileName(dataModelDeployFile.get(0).getFileName());
        dataModelType.setFileContent(dataModelDeployFile.get(0).getFileContent());
        dataModelType.setFilePath(path);
        dataModelType.setOperate(ResManager.loadKDString((String)"\u6bd4\u8f83", (String)"GitCommitPlugin_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        ArrayList<DataModelType> dataModelTypes = new ArrayList<DataModelType>(1);
        dataModelTypes.add(dataModelType);
        return dataModelTypes;
    }

    private DataModelType getXml(String rootPath, String repositoryPath, String dbRoute, List<String> fileNames) {
        if (fileNames.isEmpty()) {
            return null;
        }
        try {
            String path = rootPath.replaceAll("/metadata", "");
            String[] split = path.split("/");
            String xmlName = split[split.length - 1];
            String xmlPath = path + File.separator + xmlName + ".xml";
            File file = new File(repositoryPath + File.separator + xmlPath);
            if (!file.exists()) {
                log.info("xml not exits");
                return null;
            }
            SAXReader reader = SAXReaderUtil.getSAXReader();
            reader.setEncoding("utf-8");
            Document document = reader.read(file);
            Element root = document.getRootElement();
            List lists = root.elements();
            for (String fileName : fileNames) {
                Element element = DocumentHelper.createElement((String)"SqlScript");
                element.addAttribute("Type", "KSQL");
                element.addAttribute("Separator", ";");
                element.addAttribute("dbkey", dbRoute);
                element.setText("dbschema/" + fileName);
                lists.add(element);
            }
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setIndentSize(4);
            StringWriter stringWriter = new StringWriter();
            XMLWriter writer = new XMLWriter((Writer)stringWriter, format);
            writer.write(document);
            DataModelType dataModelType = new DataModelType();
            dataModelType.setFileName(xmlName + ".xml");
            dataModelType.setFileContent(stringWriter.toString());
            dataModelType.setFilePath(path);
            dataModelType.setOperate(ResManager.loadKDString((String)"\u6bd4\u8f83", (String)"GitCommitPlugin_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return dataModelType;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return null;
        }
    }

    private List<DataModelType> getSql(String currPdm, String lastPdm, String rootPath) {
        try {
            String path = rootPath.replaceAll("metadata", "");
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            String sqlPath = path + "dbschema";
            PDMEntityMetadata currMeta = PDMEntityMetaBuilder.buildPDMEntityMetadata((String)currPdm);
            PDMEntityMetadata lastMeta = PDMEntityMetaBuilder.buildPDMEntityMetadata((String)lastPdm);
            Class<?> pdmCompare = Class.forName("kd.bos.designer.plugin.PDMModelCompare");
            Object instance = pdmCompare.newInstance();
            Method method = pdmCompare.getMethod("comparePDModel", PDMEntityMetadata.class, PDMEntityMetadata.class);
            Map res = (Map)method.invoke(instance, lastMeta, currMeta);
            ArrayList<DataModelType> dataModelTypes = new ArrayList<DataModelType>(res.size());
            for (Map.Entry entry : res.entrySet()) {
                Map sqlMap = (Map)entry.getValue();
                for (Map.Entry sql : sqlMap.entrySet()) {
                    DataModelType dataModelType = new DataModelType();
                    dataModelType.setFileName((String)sql.getKey());
                    dataModelType.setFileContent((String)sql.getValue());
                    dataModelType.setFilePath(sqlPath);
                    dataModelType.setOperate(ResManager.loadKDString((String)"\u67e5\u770b", (String)"GitCommitPlugin_18", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                    dataModelTypes.add(dataModelType);
                }
            }
            return dataModelTypes;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return null;
        }
    }

    private DataModelLog getDataModelLog(String modelId) {
        String sql = "SELECT TOP 1 FSUBMIT,FDESCRIPTION FROM T_DM_PDMMODELVERSION WHERE FMODELID = ? AND FOPERATOR = ? ORDER BY FOPERATETIME DESC";
        Object[] parameters = new SqlParameter[]{new SqlParameter(":FMODELID", 12, (Object)modelId), new SqlParameter(":FOPERATOR", -5, (Object)RequestContext.get().getCurrUserId())};
        return (DataModelLog)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])parameters, resultSet -> {
            if (resultSet.next()) {
                String submit = resultSet.getString("FSUBMIT");
                String description = resultSet.getString("FDESCRIPTION");
                return new DataModelLog(submit, description);
            }
            return null;
        });
    }

    private void initDataModelEntry(List<DataModelType> dataModelTypes) {
        int[] rows;
        for (int rowIndex : rows = this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, dataModelTypes.size())) {
            DataModelType dataModelType = dataModelTypes.get(rowIndex);
            this.addEntryRow(dataModelType, rowIndex);
        }
    }

    private void addEntryRow(DataModelType dataModelType, int index) {
        this.getModel().setValue(FILE_NAME, (Object)dataModelType.getFileName(), index);
        this.getModel().setValue("status", (Object)ResManager.loadKDString((String)"\u5f85\u63d0\u4ea4", (String)"GITCommitPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), index);
        this.getModel().setValue(FILE_STATUS, (Object)ResManager.loadKDString((String)"\u672a\u5408\u5e76", (String)"GitCommitPlugin_10", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), index);
        this.getModel().setValue(OPERATE, (Object)dataModelType.getOperate(), index);
        this.getModel().setValue(CONTENT, (Object)dataModelType.getFileContent(), index);
        this.getModel().setValue(PATH, (Object)dataModelType.getFilePath(), index);
    }

    private List<DeployFile> getDataModelDeployFile(String modelId) {
        try {
            Class<?> dataModel = Class.forName("kd.bos.datamodel.metadata.pdm.DeployPDMMetadataDao");
            Method method = dataModel.getDeclaredMethod("getDataModelDeployFile", String.class);
            return (List)method.invoke(dataModel, modelId);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return null;
        }
    }

    private void hideSelectOrderAndFilter() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        grid.setColumnProperty(OPERATE, "filter", (Object)false);
    }

    private void packageData(PackageDataEvent event) {
        boolean isBase = (Boolean)event.getRowData().get("iscompare");
        if (isBase) {
            event.getNoLinkKey().add(OPERATE);
        }
    }

    private void switchViewVisible() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{CHOOSE_FILE_PANEL, LAST_STEP, NEXT_STEP, PATH});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{COMMIT_PANEL, COMMIT_MESSAGE_PANEL});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{CONTENT, IS_SAVE, "iscompare", "status"});
    }

    private void switchViewVisible(boolean isNext) {
        if (isNext) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{NEXT_STEP, CHOOSE_FILE_PANEL});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{COMMIT_PANEL, COMMIT_MESSAGE_PANEL, COMMIT, COMMIT_PUSH, LAST_STEP, PULL});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{LAST_STEP, COMMIT, COMMIT_PUSH, COMMIT_PANEL, COMMIT_MESSAGE_PANEL, PULL});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{CHOOSE_FILE_PANEL, NEXT_STEP});
        }
    }

    private void fillEntryEntity(String nodeId) {
        List<MetaType> metaTypes = this.getMetaTypeCache(nodeId);
        if (metaTypes.isEmpty()) {
            this.getModel().deleteEntryData(META_ENTRY_ENTITY);
            return;
        }
        String selectPage = this.getPageCache().get(SELECT_PAGE);
        String selectScript = this.getPageCache().get(SELECT_SCRIPT);
        List selectPageIds = new ArrayList(10);
        List selectScriptIds = new ArrayList(10);
        if (selectPage != null) {
            selectPageIds = SerializationUtils.fromJsonStringToList((String)selectPage, String.class);
        }
        if (selectScript != null) {
            selectScriptIds = SerializationUtils.fromJsonStringToList((String)selectScript, String.class);
        }
        this.getModel().deleteEntryData(META_ENTRY_ENTITY);
        this.getModel().batchCreateNewEntryRow(META_ENTRY_ENTITY, metaTypes.size());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(META_ENTRY_ENTITY);
        for (int i = 0; i < metaTypes.size(); ++i) {
            MetaType metaType = metaTypes.get(i);
            DynamicObject row = (DynamicObject)entryEntity.get(i);
            if (!KS.equals(metaType.getType()) && selectPageIds.contains(metaType.getId())) {
                row.set(SELECT, (Object)true);
            }
            if (KS.equals(metaType.getType()) && selectScriptIds.contains(metaType.getId())) {
                row.set(SELECT, (Object)true);
            }
            row.set(NAME, (Object)metaType.getName());
            row.set("number", (Object)metaType.getNumber());
            row.set(MODIFY_DATE, (Object)metaType.getModifyDate());
            row.set(TYPE, (Object)metaType.getType());
            row.set(ID, (Object)metaType.getId());
            row.set(UNIT_ID, (Object)metaType.getUnitId());
        }
        this.getView().updateView(META_ENTRY_ENTITY);
    }

    private void renderMenuTree(String bizAppId) {
        this.getPageCache().put("bizAppId", bizAppId);
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        Map<String, TreeNode> nodeList = this.getTreeNode(bizAppId, appMetadata);
        TreeNode root = this.renderRoot(bizAppId, appMetadata);
        this.buildNode(root, nodeList);
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEWAP);
        tree.addNode(root);
        tree.focusNode(root);
    }

    private TreeNode renderRoot(String bizAppId, AppMetadata appMetadata) {
        String name = appMetadata.getName().getLocaleValue();
        TreeNode root = new TreeNode();
        root.setText(name);
        root.setId(bizAppId);
        root.setIsOpened(true);
        root.setParentid("");
        return root;
    }

    private Map<String, TreeNode> getTreeNode(String bizAppId, AppMetadata appMeta) {
        List functionElements = appMeta.getAppFunctionPackets();
        LinkedHashMap<String, TreeNode> funcNode = new LinkedHashMap<String, TreeNode>(functionElements.size());
        for (AppFunctionPacketElement function : functionElements) {
            String nodeId = function.getId();
            String text = (String)function.getName().getDefaultItem();
            String number = function.getNumber();
            String parentId = function.getParentId() == null ? bizAppId : function.getParentId();
            TreeNode func = new TreeNode();
            func.setText(text);
            func.setId(nodeId);
            func.setParentid(parentId);
            func.setData((Object)number);
            funcNode.put(nodeId, func);
        }
        return funcNode;
    }

    private void buildNode(TreeNode root, Map<String, TreeNode> childNode) {
        for (TreeNode node : childNode.values()) {
            TreeNode parentNode = childNode.get(node.getParentid());
            if (parentNode != null) {
                parentNode.addChild(node);
                continue;
            }
            root.addChild(node);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        if (nodeId == null) {
            return;
        }
        this.fillEntryEntity(nodeId);
    }

    private List<MetaType> getMetaTypeCache(String nodeId) {
        String bizAppId = this.getPageCache().get("bizAppId");
        String metaCache = this.getPageCache().get(nodeId);
        if (metaCache != null) {
            return SerializationUtils.fromJsonStringToList((String)metaCache, MetaType.class);
        }
        if (nodeId.equals(bizAppId)) {
            List<MetaType> pageInfo = this.getPageInfo(bizAppId);
            List<MetaType> scriptInfo = this.getScriptInfo(bizAppId);
            pageInfo.addAll(scriptInfo);
            pageInfo.sort((o1, o2) -> {
                Date d1 = o1.getModifyDate();
                Date d2 = o2.getModifyDate();
                if (d1 != null && d2 != null) {
                    return d2.compareTo(d1);
                }
                return 0;
            });
            this.getPageCache().put(nodeId, SerializationUtils.toJsonString(pageInfo));
            return pageInfo;
        }
        List<MetaType> pageInfo = this.getPageInfo(bizAppId, nodeId);
        List<MetaType> scriptInfo = this.getScriptInfo(bizAppId, nodeId);
        pageInfo.addAll(scriptInfo);
        pageInfo.sort((o1, o2) -> {
            Date d1 = o1.getModifyDate();
            Date d2 = o2.getModifyDate();
            if (d1 != null && d2 != null) {
                return d2.compareTo(d1);
            }
            return 0;
        });
        this.getPageCache().put(nodeId, SerializationUtils.toJsonString(pageInfo));
        return pageInfo;
    }

    private List<MetaType> getPageInfo(String bizAppId) {
        return this.getPageInfo(bizAppId, null);
    }

    private List<MetaType> getPageInfo(String bizAppId, String bizUnitId) {
        QFilter qFilter = new QFilter("bizapp", "=", (Object)bizAppId);
        if (StringUtils.isNotBlank((CharSequence)bizUnitId)) {
            QFilter unitFilter = new QFilter("bizunit", "=", (Object)bizUnitId);
            qFilter.and(unitFilter);
        }
        QFilter[] filters = new QFilter[]{qFilter};
        String unitFormFields = "bizapp,bizunit,form";
        String formFields = "id,number,name,type,parentid,modifydate,modeltype";
        ArrayList<MetaType> metaTypes = new ArrayList<MetaType>(10);
        try (DataSet unitFormDataSet = QueryServiceHelper.queryDataSet((String)"bos_devportal_unitrelform", (String)"bos_devportal_unitrelform", (String)unitFormFields, (QFilter[])filters, (String)"form asc");
             DataSet formDataSet = QueryServiceHelper.queryDataSet((String)"bos_formmeta", (String)"bos_formmeta", (String)formFields, null, (String)"modifydate desc");
             DataSet result = unitFormDataSet.join(formDataSet, JoinType.INNER).on("form", ID).select(new String[]{"bizunit", "form"}, new String[]{ID, "number", NAME, TYPE, "parentid", MODIFY_DATE, "modeltype"}).finish().orderBy(new String[]{"modifydate desc"});){
            for (Row row : result) {
                MetaType metaType = new MetaType();
                metaType.setId(row.getString(ID));
                metaType.setName(row.getString(NAME));
                metaType.setNumber(row.getString("number"));
                metaType.setType(row.getString("modeltype"));
                String unitId = row.getString("bizunit");
                metaType.setUnitId(unitId);
                metaType.setModifyDate(row.getDate(MODIFY_DATE));
                metaTypes.add(metaType);
            }
        }
        return metaTypes;
    }

    private List<MetaType> getScriptInfo(String bizAppId) {
        return this.getScriptInfo(bizAppId, null);
    }

    private List<MetaType> getScriptInfo(String bizAppId, String bizUnitId) {
        String scriptFields = "id, txt_scriptnumber, txt_scriptname, bizunitid,modifydate";
        QFilter scriptFilter_1 = new QFilter(BIZAPPID, "=", (Object)bizAppId);
        if (StringUtils.isNotBlank((CharSequence)bizUnitId)) {
            QFilter unitFilter = new QFilter("bizunitid", "=", (Object)bizUnitId);
            scriptFilter_1.and(unitFilter);
        }
        QFilter[] scriptFilters = new QFilter[]{scriptFilter_1};
        String scriptOrderBy = "modifydate desc";
        ArrayList<MetaType> metaTypes = new ArrayList<MetaType>(10);
        DynamicObjectCollection scriptInfo = QueryServiceHelper.query((String)"ide_pluginscript", (String)scriptFields, (QFilter[])scriptFilters, (String)scriptOrderBy);
        for (DynamicObject obj : scriptInfo) {
            MetaType metaType = new MetaType();
            metaType.setId(obj.getString(ID));
            metaType.setName(obj.getString("txt_scriptname"));
            metaType.setNumber(obj.getString(TXT_SCRIPTNUMBER));
            String unitId = obj.getString("bizunitid");
            metaType.setUnitId(unitId);
            metaType.setModifyDate(obj.getDate(MODIFY_DATE));
            metaType.setType(KS);
            metaTypes.add(metaType);
        }
        return metaTypes;
    }

    private void fillEntryEntity() {
        String bizAppId = this.getPageCache().get("bizAppId");
        String ids = this.getPageCache().get("scriptids");
        List scriptIds = null;
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            scriptIds = (List)SerializationUtils.fromJsonString((String)ids, List.class);
        }
        String formIds = this.getPageCache().get(KEY_PAGEIDS);
        List pageIds = null;
        if (StringUtils.isNotBlank((CharSequence)formIds)) {
            pageIds = (List)SerializationUtils.fromJsonString((String)formIds, List.class);
        }
        String containAppMenu = this.getPageCache().get("checkinappflag");
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        int startIndex = 0;
        if (scriptIds != null && !scriptIds.isEmpty()) {
            List scriptDeployFile = MetadataDao.getScriptDeployFile((String[])scriptIds.toArray(new String[0]));
            this.addToEntryRow(scriptDeployFile, startIndex);
            startIndex += scriptDeployFile.size();
        }
        if (pageIds != null && !pageIds.isEmpty()) {
            for (String pageId : pageIds) {
                List<DeployFile> formDeployFile = MetadataDao.getFormDeployFile((String)pageId);
                formDeployFile = formDeployFile.stream().filter(f -> !GitOperationUtil.isIgnoreFile((String)f.getFileName())).collect(Collectors.toList());
                this.addToEntryRow(formDeployFile, startIndex);
                startIndex += formDeployFile.size();
            }
        }
        if (StringUtils.equals((CharSequence)"true", (CharSequence)containAppMenu)) {
            List<DeployFile> appMenus = AppMetaServiceHelper.getAppDeployFile((String)bizAppId);
            appMenus = appMenus.stream().filter(f -> !GitOperationUtil.isIgnoreFile((String)f.getFileName())).collect(Collectors.toList());
            this.addToEntryRow(appMenus, startIndex);
        }
        this.compareContent();
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void addToEntryRow(List<DeployFile> fileList, int startIndex) {
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, fileList.size());
        for (int i = 0; i < fileList.size(); ++i) {
            this.getModel().setValue(FILE_NAME, (Object)fileList.get(i).getFileName(), startIndex + i);
            this.getModel().setValue("status", (Object)ResManager.loadKDString((String)"\u5f85\u63d0\u4ea4", (String)"GITCommitPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), startIndex + i);
            this.getModel().setValue(FILE_STATUS, (Object)ResManager.loadKDString((String)"\u672a\u5408\u5e76", (String)"GitCommitPlugin_10", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), startIndex + i);
            this.getModel().setValue(OPERATE, (Object)ResManager.loadKDString((String)"\u6bd4\u8f83", (String)"GitCommitPlugin_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), startIndex + i);
            this.getModel().setValue(CONTENT, (Object)fileList.get(i).getFileContent(), startIndex + i);
        }
    }

    private void compareContent() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject object = (DynamicObject)entryEntity.get(i);
            String currentContent = object.getString(CONTENT);
            String lastContent = this.getLastCommitFileContent(i);
            if (!StringUtils.isNotBlank((CharSequence)currentContent)) continue;
            String string = lastContent = lastContent == null ? null : lastContent.trim();
            if (!currentContent.trim().equals(lastContent)) continue;
            this.getModel().setValue("iscompare", (Object)true, i);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (COMMIT.equals(key) || COMMIT_PUSH.equals(key)) {
            this.commit(key);
        }
    }

    public void click(EventObject e) {
        String key;
        Control control = (Control)e.getSource();
        switch (key = control.getKey()) {
            case "expand": {
                this.expandAndCollapse();
                break;
            }
            case "commit": 
            case "commitpush": {
                this.commit(key);
                break;
            }
            case "nextstop": {
                this.nextStep();
                break;
            }
            case "laststep": {
                this.lastStep();
                break;
            }
            case "pull": {
                this.pull();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (SELECT.equals(name)) {
            boolean isSelect = (Boolean)e.getChangeSet()[0].getNewValue();
            DynamicObject dataEntity = e.getChangeSet()[0].getDataEntity();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(META_ENTRY_ENTITY);
            boolean isAllSelect = true;
            for (DynamicObject object : entryEntity) {
                boolean select = object.getBoolean(SELECT);
                if (select) continue;
                this.setGridColAllValue(name, false);
                isAllSelect = false;
                break;
            }
            if (isAllSelect) {
                this.setGridColAllValue(name, true);
            }
            this.handleSelectMetaInfo(isSelect, dataEntity);
        }
    }

    private void handleSelectMetaInfo(boolean isSelect, DynamicObject dataEntity) {
        String type = dataEntity.getString(TYPE);
        String id = dataEntity.getString(ID);
        if (!KS.equals(type)) {
            this.handleSelectMetaInfo(SELECT_PAGE, id, isSelect);
        } else {
            this.handleSelectMetaInfo(SELECT_SCRIPT, id, isSelect);
        }
    }

    private void handleSelectMetaInfo(String type, String id, boolean isSelect) {
        String selectIds = this.getPageCache().get(type);
        if (selectIds != null) {
            List pageIds = SerializationUtils.fromJsonStringToList((String)selectIds, String.class);
            if (isSelect && !pageIds.contains(id)) {
                pageIds.add(id);
            }
            if (!isSelect) {
                pageIds.remove(id);
            }
            this.getPageCache().put(type, SerializationUtils.toJsonString((Object)pageIds));
        } else if (isSelect) {
            ArrayList<String> pageIds = new ArrayList<String>(1);
            pageIds.add(id);
            this.getPageCache().put(type, SerializationUtils.toJsonString(pageIds));
        }
    }

    private void setGridColAllValue(String colKey, boolean checked) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> ret = new HashMap<String, Object>(2);
        ret.put("c", colKey);
        ret.put("v", checked);
        clientViewProxy.invokeControlMethod(META_ENTRY_ENTITY, "setGridColAllValue", new Object[]{ret});
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if (OPERATE.equals(fieldName)) {
            int rowIndex = evt.getRowIndex();
            this.getPageCache().put("index", String.valueOf(rowIndex));
            String fileName = (String)this.getModel().getValue(FILE_NAME, rowIndex);
            String currentContent = (String)this.getModel().getValue(CONTENT, rowIndex);
            if (fileName.endsWith(".sql")) {
                this.showViewSql(currentContent);
                return;
            }
            String content = this.getLastCommitFileContent(rowIndex);
            if (StringUtils.equals((CharSequence)content, (CharSequence)currentContent)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5143\u6570\u636e\u6ca1\u6709\u5dee\u5f02\uff0c\u65e0\u9700\u6bd4\u8f83\u3002", (String)"GitCommitPlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            if ((fileName.endsWith(".dym") || fileName.endsWith(".dymx") || fileName.endsWith(".app") || fileName.endsWith(".appx")) && StringUtils.isNotBlank((CharSequence)content) && !content.contains("PrintMetadata")) {
                if (fileName.endsWith(".dymx") || fileName.endsWith(".appx")) {
                    String[] split = fileName.trim().split("\\.");
                    parameter.setCustomParam("localeId", (Object)split[1]);
                    parameter.setCustomParam("multiLang", (Object)"true");
                }
                if (fileName.endsWith(".dym") || fileName.endsWith(".dymx")) {
                    parameter.setCustomParam("metaType", (Object)PAGE);
                } else {
                    parameter.setCustomParam("metaType", (Object)APP);
                }
                parameter.setCustomParam("number", (Object)fileName);
                this.showMerge(rowIndex, content, parameter);
            } else {
                this.showDiff(rowIndex, content, parameter);
                if (StringUtils.isBlank((CharSequence)content) && !fileName.endsWith(".ks")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5143\u6570\u636e\u53ef\u80fd\u5904\u4e8e\u65b0\u589e\u72b6\u6001\uff0c\u65e0\u5dee\u5f02\u9879\u3002", (String)"GitCommitPlugin_16", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                }
            }
        }
    }

    private void showViewSql(String value) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(BOS_DM_SQLCONTENT);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("sqlContent", (Object)value);
        this.getView().showForm(parameter);
    }

    private void nextStep() {
        String selectPage = this.getPageCache().get(SELECT_PAGE);
        String selectScript = this.getPageCache().get(SELECT_SCRIPT);
        List pages = new ArrayList(10);
        List scripts = new ArrayList(10);
        if (selectPage != null) {
            pages = SerializationUtils.fromJsonStringToList((String)selectPage, String.class);
        }
        if (selectScript != null) {
            scripts = SerializationUtils.fromJsonStringToList((String)selectScript, String.class);
        }
        boolean isContainApp = (Boolean)this.getModel().getValue("checkinapp");
        if (pages.isEmpty() && scripts.isEmpty() && !isContainApp) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u63d0\u4ea4\u7684\u6587\u4ef6\u3002", (String)"GitChooseFilePlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put("checkinappflag", String.valueOf(isContainApp));
        this.getPageCache().put(KEY_PAGEIDS, SerializationUtils.toJsonString(pages));
        this.getPageCache().put("scriptids", SerializationUtils.toJsonString(scripts));
        this.switchViewVisible(true);
        this.fillEntryEntity();
        this.hideSelectOrderAndFilter();
    }

    private void lastStep() {
        this.switchViewVisible(false);
    }

    private void pull() {
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u62c9\u53d6...", (String)"GitCommitPlugin_17", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0])));
        GitContext context = this.getGitContext();
        GitOperateHandler handler = new GitOperateHandler();
        handler.pull(context, (AbstractFormPlugin)this, false);
        this.getView().hideLoading();
    }

    private void showDiff(int row, String lastContent, FormShowParameter parameter) {
        GitDiffContext diffContext = new GitDiffContext();
        GitContext context = this.getGitContext();
        diffContext.setGitRootPath(context.getGitRootPath());
        diffContext.setPersonalGitRepository(context.getPersonalGitRepository());
        String fileName = (String)this.getModel().getValue(FILE_NAME, row);
        diffContext.setFileName(fileName);
        diffContext.setFilePath(fileName);
        String personalRepository = context.getPersonalGitRepository();
        String oldCommitId = GitOperationUtils.getCommitId((String)personalRepository);
        String newCommitId = "YourVersion";
        String newContent = (String)this.getModel().getValue(CONTENT, row);
        diffContext.setOldCommit(oldCommitId);
        diffContext.setNewCommit(newCommitId);
        diffContext.setNewContent(newContent);
        diffContext.setOldContent(lastContent);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "diffCloseCallBack"));
        GitUtil.showDiff(diffContext, parameter);
        this.getView().showForm(parameter);
    }

    private void showMerge(int row, String content, FormShowParameter parameter) {
        parameter.setFormId("bos_devp_metamerge_new");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("lastDym", (Object)content);
        String currentContent = (String)this.getModel().getValue(CONTENT, row);
        parameter.setCustomParam("baseDym", (Object)currentContent);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "gitMergeCallBack"));
        this.getView().showForm(parameter);
    }

    private String getLastCommitFileContent(int row) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String gitContext = (String)formShowParameter.getCustomParam("gitContext");
        GitContext context = (GitContext)SerializationUtils.fromJsonString((String)gitContext, GitContext.class);
        String name = (String)this.getModel().getValue(FILE_NAME, row);
        String personalRepository = context.getPersonalGitRepository();
        if (DATA_MODEL.equals(context.getType())) {
            String path = (String)this.getModel().getValue(PATH, row);
            return GitOperationUtils.getLastCommitFile((String)personalRepository, (String)path, (String)name);
        }
        String rootPath = context.getGitRootPath();
        String metadataRootPath = this.getMetadataRootPath(rootPath);
        return GitOperationUtils.getLastCommitFile((String)personalRepository, (String)metadataRootPath, (String)name);
    }

    private void handleGitPullUpdateMetaCallBack(ClosedCallBackEvent e) {
        String gitContext = (String)e.getReturnData();
        GitContext context = (GitContext)SerializationUtils.fromJsonString((String)gitContext, GitContext.class);
        if (context.getPullUpdate()) {
            GitOperationUtils.updateMetadata((GitContext)context, (AbstractFormPlugin)this);
        }
        if (context.isExportToLocal()) {
            GitSaveFileHandler saveFileHandler = new GitSaveFileHandler();
            saveFileHandler.handler(context, (AbstractFormPlugin)this);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() != null && "diffCloseCallBack".equals(e.getActionId())) {
            boolean isSave = Boolean.parseBoolean(e.getReturnData().toString());
            String index = this.getPageCache().get("index");
            if (isSave) {
                this.getModel().setValue(IS_SAVE, (Object)Boolean.TRUE, Integer.parseInt(index));
                String fileName = (String)this.getModel().getValue(FILE_NAME, Integer.parseInt(index));
                String localContent = this.getLocalContent(fileName);
                this.getModel().setValue(CONTENT, (Object)localContent, Integer.parseInt(index));
                this.getModel().setValue(FILE_STATUS, (Object)ResManager.loadKDString((String)"\u5df2\u5408\u5e76", (String)"GitCommitPlugin_11", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            }
        } else if (e.getReturnData() != null && "gitMergeCallBack".equals(e.getActionId())) {
            String content = (String)e.getReturnData();
            GitContext context = this.getGitContext();
            String index = this.getPageCache().get("index");
            String fileName = (String)this.getModel().getValue(FILE_NAME, Integer.parseInt(index));
            String personalGitRepository = context.getPersonalGitRepository();
            String gitRootPath = context.getGitRootPath();
            String metadataRootPath = this.getMetadataRootPath(gitRootPath);
            String metaDataGitRepository = personalGitRepository + metadataRootPath;
            GitOperationUtil.saveFile((String)fileName, (String)content, (String)metaDataGitRepository);
            this.getModel().setValue(CONTENT, (Object)content, Integer.parseInt(index));
            this.getModel().setValue(IS_SAVE, (Object)Boolean.TRUE, Integer.parseInt(index));
            this.getModel().setValue(FILE_STATUS, (Object)ResManager.loadKDString((String)"\u5df2\u5408\u5e76", (String)"GitCommitPlugin_11", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (e.getReturnData() != null && "gitPullConflictCallBack".equals(e.getActionId())) {
            GitAppPluginProxy.getProxy(this).invoke("gitPullConflictCallBack", e);
        } else if (e.getReturnData() != null && "gitPullUpdateMetaCallBack".equals(e.getActionId())) {
            this.handleGitPullUpdateMetaCallBack(e);
        }
    }

    private void expandAndCollapse() {
        String status = this.getPageCache().get(PICTURE_STATUS);
        if (PICTURE_EXPAND.equals(status)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{IMAGEAP});
            this.getPageCache().put(PICTURE_STATUS, PICTURE_COLLAPSE);
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{IMAGEAP});
            this.getPageCache().put(PICTURE_STATUS, PICTURE_EXPAND);
        }
    }

    private void commit(String type) {
        String annotation = (String)this.getModel().getValue(KEY_ANNOTATION);
        if (StringUtils.isBlank((CharSequence)annotation)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u63d0\u4ea4\u8bf4\u660e\u3002", (String)"GitCommitPlugin_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String result = this.commitChooseFile(annotation);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("result", result);
        res.put(TYPE, COMMIT);
        if (COMMIT_PUSH.equals(type)) {
            String gitContext = (String)this.getView().getFormShowParameter().getCustomParam("gitContext");
            res.put("gitContext", gitContext);
            res.put(TYPE, "commitAndPush");
        }
        this.addOperateLog((String)res.get(TYPE));
        this.getView().returnDataToParent(res);
        this.getView().close();
    }

    private void addOperateLog(String type) {
        MultiLangEnumBridge opDescription;
        MultiLangEnumBridge opName;
        if (StringUtils.equals((CharSequence)COMMIT, (CharSequence)type)) {
            opName = new MultiLangEnumBridge("\u63d0\u4ea4", "GitCommitPlugin_12", BOS_DEVPORTAL_PLUGIN);
            opDescription = new MultiLangEnumBridge("Git\u63d0\u4ea4\u5143\u6570\u636e", "GitCommitPlugin_14", BOS_DEVPORTAL_PLUGIN);
        } else {
            opName = new MultiLangEnumBridge("\u63d0\u4ea4\u5e76\u63a8\u9001", "GitCommitPlugin_13", BOS_DEVPORTAL_PLUGIN);
            opDescription = new MultiLangEnumBridge("Git\u63d0\u4ea4\u5e76\u63a8\u9001\u5143\u6570\u636e", "GitCommitPlugin_15", BOS_DEVPORTAL_PLUGIN);
        }
        AppUtils.addOpLog((String)"bos_devp_gitcommit_new", (String)type, (String)"bos_devp_gitcommit_new", (String)PICTURE_COLLAPSE, (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[0]);
    }

    private String commitChooseFile(String annotation) {
        annotation = annotation.trim();
        GitContext context = this.getGitContext();
        if (DATA_MODEL.equals(context.getType())) {
            return this.commitDataModelFile(annotation, context);
        }
        String userName = context.getUserName();
        String personalGitRepository = context.getPersonalGitRepository();
        String id = context.getId();
        String gitRootPath = context.getGitRootPath();
        String metadataRootPath = this.getMetadataRootPath(gitRootPath);
        String metadataPath = personalGitRepository + metadataRootPath;
        ArrayList<String> fileNames = new ArrayList<String>();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (DynamicObject object : entryEntity) {
            boolean isSave = object.getBoolean(IS_SAVE);
            String fileName = object.getString(FILE_NAME);
            String content = object.getString(CONTENT);
            if (!isSave) {
                this.saveFileToLocal(fileName, content, metadataPath);
            }
            fileNames.add(fileName);
        }
        return GITCodeHostingServiceImpl.commit((String)personalGitRepository, (String)annotation, fileNames, (String)userName);
    }

    private String commitDataModelFile(String annotation, GitContext context) {
        annotation = annotation.trim();
        String userName = context.getUserName();
        String personalGitRepository = context.getPersonalGitRepository();
        ArrayList<String> fileNames = new ArrayList<String>();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (DynamicObject object : entryEntity) {
            String fileName = object.getString(FILE_NAME);
            String content = object.getString(CONTENT);
            String path = object.getString(PATH);
            if (StringUtils.isBlank((CharSequence)path)) continue;
            path = path.replace("/", File.separator).replace("\\", File.separator);
            String metadataPath = personalGitRepository + File.separator + path;
            this.saveFileToLocal(fileName, content, metadataPath);
            fileNames.add(fileName);
        }
        return GITCodeHostingServiceImpl.commit((String)personalGitRepository, (String)annotation, fileNames, (String)userName);
    }

    private String getLocalContent(String fileName) {
        try {
            GitContext context = this.getGitContext();
            String personalGitRepository = context.getPersonalGitRepository();
            String gitRootPath = context.getGitRootPath();
            String metadataRootPath = this.getMetadataRootPath(gitRootPath);
            String metadataPath = personalGitRepository + metadataRootPath;
            return GITCodeHostingServiceImpl.readFromRepository((String)metadataPath, (String)fileName);
        }
        catch (Exception e) {
            log.error("get local content error " + e);
            return null;
        }
    }

    private void saveFileToLocal(String fileName, String content, String metaDataGitRepository) {
        GitOperationUtil.saveFile((String)fileName, (String)content, (String)metaDataGitRepository);
    }

    private GitContext getGitContext() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String gitContext = (String)formShowParameter.getCustomParam("gitContext");
        return (GitContext)SerializationUtils.fromJsonString((String)gitContext, GitContext.class);
    }

    private String getMetadataRootPath(String gitRootpath) {
        String result = "";
        String separator = Matcher.quoteReplacement(File.separator);
        if (!StringUtils.isBlank((CharSequence)gitRootpath)) {
            result = !(gitRootpath = gitRootpath.replaceAll("\\\\", separator).replaceAll("/", separator)).startsWith(File.separator) ? File.separator + gitRootpath : gitRootpath;
        }
        return result;
    }

    static class DataModelLog {
        private String commitName;
        private String content;

        public DataModelLog() {
        }

        public DataModelLog(String commitName, String content) {
            this.commitName = commitName;
            this.content = content;
        }

        public String getCommitName() {
            return this.commitName;
        }

        public void setCommitName(String commitName) {
            this.commitName = commitName;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }
    }

    static class MetaType
    implements Serializable {
        private static final long serialVersionUID = -4899288175276899799L;
        private String id;
        private String name;
        private String number;
        private String type;
        private String unitId;
        private String unitName;
        private String status;
        private Date modifyDate;

        public Date getModifyDate() {
            return this.modifyDate;
        }

        public void setModifyDate(Date modifyDate) {
            this.modifyDate = modifyDate;
        }

        public MetaType() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getUnitId() {
            return this.unitId;
        }

        public void setUnitId(String unitId) {
            this.unitId = unitId;
        }

        public String getUnitName() {
            return this.unitName;
        }

        public void setUnitName(String unitName) {
            this.unitName = unitName;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public MetaType(String id, String name, String number, String type, String unitId, String unitName) {
            this.id = id;
            this.name = name;
            this.number = number;
            this.type = type;
            this.unitId = unitId;
            this.unitName = unitName;
        }
    }

    static class DataModelType {
        private String fileName;
        private String fileContent;
        private String filePath;
        private String operate;

        DataModelType() {
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getFileContent() {
            return this.fileContent;
        }

        public void setFileContent(String fileContent) {
            this.fileContent = fileContent;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        public String getOperate() {
            return this.operate;
        }

        public void setOperate(String operate) {
            this.operate = operate;
        }
    }
}

