/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.git.pluginnew;

import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.devportal.git.GitUtil;
import kd.bos.entity.IFrameMessage;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.IFrame;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.session.SessionKeys;

public class GitDiffPlugin
extends AbstractFormPlugin {
    private static final String ISSAVE = "issave";
    private static final String KEY_UPDATETOLOCALE = "updatetolocale";
    private static final String IFRAME_AP = "iframeap";
    private static final String ID = "id";
    private static final String LAST = "last";
    private static final String CURRENT = "current";
    private static final String UPDATE_LOCAL_CALL_BACK = "updateToLocaleCallBack";
    private static final String COMMIT_ID = "commitId";
    private static final String CURRENT_COMMIT_ID = "currentCommitId";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_UPDATETOLOCALE});
    }

    public void afterCreateNewData(EventObject e) {
        String urlParams = this.getUrlParams();
        urlParams = this.getKdcdUrl(urlParams);
        IFrame iframe = (IFrame)this.getView().getControl(IFRAME_AP);
        iframe.setSrc("devtools/built-compare/gitResolve.html?" + urlParams);
        this.getPageCache().put(ISSAVE, "false");
        String noUpdate = (String)this.getView().getFormShowParameter().getCustomParam("noUpdate");
        if ("true".equals(noUpdate)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_UPDATETOLOCALE});
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (KEY_UPDATETOLOCALE.equals(key)) {
            this.updateToLocale();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.getView().returnDataToParent((Object)this.getPageCache().get(ISSAVE));
        this.getPageCache().remove(ISSAVE);
    }

    private void updateToLocale() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5c06\u53f3\u4fa7\u5185\u5bb9\u66f4\u65b0\u5230\u672c\u5730\u5417?", (String)"GitDiff_0", (String)"bos-devportal-plugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(UPDATE_LOCAL_CALL_BACK));
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        String callBackId;
        if (MessageBoxResult.Yes.equals((Object)mbce.getResult()) && UPDATE_LOCAL_CALL_BACK.equals(callBackId = mbce.getCallBackId())) {
            this.postMessageToIframe();
        }
    }

    private void postMessageToIframe() {
        IFrame iframe = (IFrame)this.getView().getControl(IFRAME_AP);
        IFrameMessage msg = new IFrameMessage();
        msg.setContent((Object)"");
        String urlParams = this.getUrlParams();
        urlParams = this.getKdcdUrl(urlParams);
        msg.setOrigin(RequestContext.get().getClientFullContextPath() + "devtools/built-compare/gitResolve.html?" + urlParams);
        msg.setType(KEY_UPDATETOLOCALE);
        iframe.postMessage(msg);
        this.getPageCache().put(ISSAVE, "true");
    }

    private String getUrlParams() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String uuid = Uuid8.generateShortUuid();
        String commitId = (String)parameter.getCustomParam(COMMIT_ID);
        String currentCommitId = (String)parameter.getCustomParam(CURRENT_COMMIT_ID);
        String projectURL = (String)parameter.getCustomParam(LAST);
        if (projectURL == null) {
            projectURL = "";
        }
        String gitRepository = (String)parameter.getCustomParam(CURRENT);
        String personalGitRepository = (String)parameter.getCustomParam("personalgitrepository");
        String gitRootPath = (String)parameter.getCustomParam("gitrootpath");
        gitRootPath = GitUtil.getMetadataRootPath(gitRootPath);
        personalGitRepository = personalGitRepository + gitRootPath;
        String filePath = (String)parameter.getCustomParam("filepath");
        filePath = filePath + "$$" + commitId + "$$" + currentCommitId;
        String type = (String)parameter.getCustomParam("type");
        String id = (String)parameter.getCustomParam(ID);
        String bizAppId = (String)parameter.getCustomParam("filepath");
        if (bizAppId.contains("/")) {
            String[] split = bizAppId.split("/");
            bizAppId = split[split.length - 1];
        }
        String pageId = this.getView().getPageId();
        Boolean isSave = (Boolean)this.getView().getFormShowParameter().getCustomParam(ISSAVE);
        return "uuid#" + uuid + "&pageid#" + pageId + "&projecturl#" + projectURL + "&gitrepository#" + gitRepository + "&personalgitrepository#" + personalGitRepository + "&filepath#" + filePath + "&id#" + id + "&bizappid#" + bizAppId + "&type#" + type + "&issave#" + isSave;
    }

    private String getKdcdUrl(String path) {
        return SessionKeys.isAccountSession((String)RequestContext.get().getTenantId()) ? path + "&kdcdc#" + RequestContext.get().getAccountId() : path;
    }
}

