/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.git.pluginnew;

import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.business.git.GitRevFilter;
import kd.bos.devportal.git.pluginnew.GitBaseLogPlugin;
import kd.bos.form.control.Control;

public class GitLogPlugin
extends GitBaseLogPlugin {
    public static final String BTN_SEARCH = "search";
    public static final String DATE_RANGE_FIELD_START_DATE = "daterangefield_startdate";
    public static final String DATE_RANGE_FIELD_END_DATE = "daterangefield_enddate";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_SEARCH});
    }

    public void afterCreateNewData(EventObject e) {
        this.showLog();
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if (BTN_SEARCH.equals(control.getKey())) {
            String searchauthor;
            Date startDate = (Date)this.getModel().getValue(DATE_RANGE_FIELD_START_DATE);
            Date endDate = (Date)this.getModel().getValue(DATE_RANGE_FIELD_END_DATE);
            GitRevFilter betweenFilter = null;
            GitRevFilter authorMatchFilter = null;
            if (startDate != null && endDate != null) {
                betweenFilter = GitRevFilter.commitTimebetween((Date)startDate, (Date)endDate);
            }
            if (StringUtils.isNotBlank((CharSequence)(searchauthor = (String)this.getModel().getValue("searchauthor")))) {
                authorMatchFilter = GitRevFilter.authorMatch((String)searchauthor);
            }
            if (betweenFilter != null && authorMatchFilter != null) {
                this.showLog(GitRevFilter.and((GitRevFilter[])new GitRevFilter[]{betweenFilter, authorMatchFilter}));
            } else if (betweenFilter != null) {
                this.showLog(betweenFilter);
            } else if (authorMatchFilter != null) {
                this.showLog(authorMatchFilter);
            }
        }
    }
}

