/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.git.pluginnew;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.business.git.UserCacheInfo;
import kd.bos.devportal.business.hosting.GITCodeHostingServiceImpl;
import kd.bos.devportal.business.hosting.GitOperationUtil;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import org.eclipse.jgit.api.errors.GitAPIException;

public class GitLoginPlugin
extends AbstractFormPlugin {
    private static final String KEY_BIZAPPID = "bizappid";
    private static final String KEY_GITURL = "giturl";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String GIT_BRANCH = "gitbranch";
    private static final String USERNAME = "username";
    private static final String HIDEITEM = "password";
    private static final String GITMSG = "gitmsg";
    public static final Log logger = LogFactory.getLog(GitLoginPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String bizAppId = (String)formShowParameter.getCustomParam(KEY_BIZAPPID);
        if (StringUtils.isBlank((CharSequence)bizAppId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e94\u7528ID\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"GITLoginPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if ("btnok".equals(key)) {
            this.btnOk();
        }
    }

    private String buildErrorInfo(String userName) {
        return String.format(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5f53\u524d\u8d26\u53f7\uff1a%s\u662f\u5426\u6b63\u786e\uff0c\u6216\u8005\u68c0\u67e5\u8d26\u53f7\u662f\u5426\u5177\u6709\u76f8\u5e94\u7684\u6743\u9650\u3002", (String)"GITManagePlugin_19", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), userName);
    }

    private void btnOk() {
        String passWord;
        String userName = (String)this.getModel().getValue(USERNAME);
        if (this.checkAccount(userName, passWord = (String)this.getModel().getValue(HIDEITEM))) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            userName = userName.trim();
        }
        if (StringUtils.isNotBlank((CharSequence)passWord)) {
            passWord = passWord.trim();
        }
        String encryptPassWord = Encrypters.encode((String)passWord);
        String sessionId = Encrypters.encode((String)userName);
        boolean isChecked = (Boolean)this.getModel().getValue("ischecked");
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String bizAppId = (String)parameter.getCustomParam(KEY_BIZAPPID);
        String gitUrl = (String)parameter.getCustomParam(KEY_GITURL);
        String gitBranch = (String)parameter.getCustomParam(GIT_BRANCH);
        try {
            this.getView().showLoading(new LocaleString(""));
            GITCodeHostingServiceImpl.checkRemoteAccount((String)gitUrl, (String)userName, (String)passWord);
            List branchs = GitOperationUtil.getBranchs((String)gitUrl, (String)userName, (String)passWord);
            String branch = gitBranch == null ? "" : gitBranch;
            boolean existBranch = branchs.stream().anyMatch(b -> b.equals(branch));
            if (!existBranch) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"Git\u8fdc\u7a0b\u5206\u652f\u4e0d\u5b58\u5728\u6216\u6ca1\u6709\u6743\u9650\u67e5\u770b\u3002", (String)"GITManagePlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                this.getView().hideLoading();
                return;
            }
            this.saveGitLoginInfo(sessionId, encryptPassWord, isChecked);
        }
        catch (GitAPIException e) {
            this.getView().hideLoading();
            if (e.getMessage().contains("not authorized")) {
                this.getView().showTipNotification(this.buildErrorInfo(userName));
            } else {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u8fdc\u7a0b\u4ed3\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u65e0\u6cd5\u8fde\u63a5\u201c%s\u201d\u3002", (String)"GITLoginPlugin_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), e.getMessage()));
            }
            logger.error((Throwable)e);
            this.getModel().setValue(HIDEITEM, (Object)"");
            return;
        }
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u786e\u5b9a", "GITManagePlugin_16", BOS_DEVPORTAL_PLUGIN);
        MultiLangEnumBridge opDescription = new MultiLangEnumBridge("Git\u8ba4\u8bc1", "GitLoginPlugin_10", BOS_DEVPORTAL_PLUGIN);
        AppUtils.addOpLog((String)"bos_devp_gitinfo", (String)"save", (String)"bos_devp_gitinfo", (String)"1", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[0]);
        JSONObject msg = new JSONObject();
        msg.put(KEY_GITURL, (Object)gitUrl);
        msg.put(USERNAME, (Object)userName);
        msg.put(HIDEITEM, (Object)encryptPassWord);
        msg.put("ischecked", (Object)isChecked);
        msg.put("gitoperatekey", parameter.getCustomParam("gitoperatekey"));
        msg.put("gitoperateid", parameter.getCustomParam("gitoperateid"));
        msg.put("gitoperatetype", parameter.getCustomParam("gitoperatetype"));
        msg.put(GITMSG, (Object)sessionId);
        msg.put(GIT_BRANCH, (Object)gitBranch);
        msg.put(KEY_BIZAPPID, (Object)bizAppId);
        msg.put("checkResult", (Object)"success");
        msg.put("type", parameter.getCustomParam("type"));
        msg.put("operateKey", parameter.getCustomParam("operateKey"));
        msg.put("bizAppId", parameter.getCustomParam(KEY_BIZAPPID));
        msg.put("id", parameter.getCustomParam("id"));
        this.getView().returnDataToParent((Object)msg.toJSONString());
        this.getView().close();
    }

    private boolean checkAccount(String userName, String passWord) {
        if (StringUtils.isBlank((CharSequence)userName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GITLoginPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return true;
        }
        if (StringUtils.isBlank((CharSequence)passWord)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GITLoginPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void saveGitLoginInfo(String sessionId, String passWord, boolean isChecked) {
        UserCacheInfo userCacheInfo = new UserCacheInfo(sessionId, passWord);
        if (isChecked) {
            if (Instance.isLightWeightDeploy()) {
                userCacheInfo.saveUserInfo(sessionId, 28800);
            } else {
                userCacheInfo.saveUserInfo(sessionId, 2592000);
            }
        } else {
            userCacheInfo.saveUserInfo(sessionId);
        }
        JSONObject userInfo = new JSONObject();
        userInfo.put(HIDEITEM, (Object)passWord);
        userInfo.put("sessionid", (Object)sessionId);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("SAVE_SVN_MSG", (Object)userInfo);
        JSONObject sessionObj = new JSONObject();
        sessionObj.put("svnmsg", (Object)sessionId);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("SAVE_JSESSION_ID", (Object)sessionObj);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).setClientLocalStorage(GITMSG, sessionId);
        SessionManager.getCurrent().put(GitOperationUtil.getSessionByRequestContext() + "gitusername", sessionId);
        SessionManager.getCurrent().put(GitOperationUtil.getSessionByRequestContext() + "gitpassword", passWord);
    }
}

