/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.git.pluginnew;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class GitPathPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String NAME = "name";
    private static final String PATH = "path";
    private static final String PARENT_PATH = "parentpath";
    private static final String LAST_PATH = "lastpath";
    private static final String CURRENT_PATH = "currentpath";
    private static final String LAST = "last";
    private static final String BTN_OK = "btnok";
    private static final String ROOT_FILE = "rootfile";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final Log log = LogFactory.getLog(GitPathPlugin.class);

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{LAST, BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        this.initFile();
        this.initRootFile();
        this.getView().setEnable(Boolean.valueOf(false), new String[]{CURRENT_PATH});
    }

    private void initFile() {
        try {
            List<FilePath> filePath = this.getFilePath(null);
            this.fillEntryEntity(filePath);
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
    }

    private void initRootFile() {
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(ROOT_FILE);
        try {
            List<FilePath> filePath = this.getFilePath(null);
            if (filePath == null) {
                return;
            }
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(filePath.size());
            for (FilePath path : filePath) {
                ComboItem item = new ComboItem();
                LocaleString name = new LocaleString();
                if (StringUtils.isBlank((CharSequence)path.getName())) {
                    name.setLocaleValue(path.getPath());
                } else {
                    name.setLocaleValue(path.getName());
                }
                item.setCaption(name);
                item.setValue(path.getPath());
                items.add(item);
            }
            comboEdit.setComboItems(items);
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
    }

    private void fillEntryEntity(List<FilePath> filePaths) {
        if (filePaths == null) {
            return;
        }
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        if (filePaths.isEmpty()) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, filePaths.size());
        for (int i = 0; i < filePaths.size(); ++i) {
            FilePath filePath = filePaths.get(i);
            this.getModel().setValue(NAME, (Object)filePath.getName(), i);
            this.getModel().setValue(PATH, (Object)filePath.getPath(), i);
            this.getModel().setValue(PARENT_PATH, (Object)filePath.getParentPath(), i);
            this.getModel().setValue(LAST_PATH, (Object)filePath.getLastPath(), i);
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        int row = evt.getRow();
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, row);
        String path = rowEntity.getString(PATH);
        String lastPath = rowEntity.getString(LAST_PATH);
        if (StringUtils.isNotBlank((CharSequence)path)) {
            this.getPageCache().put("currentPath", path);
            this.getPageCache().put("currentLastPath", lastPath);
            this.setCurrentPath();
        }
        File file = new File(path);
        this.fillComboEdit(file.getPath(), true);
        try {
            List<FilePath> filePath = this.getFilePath(file);
            this.fillEntryEntity(filePath);
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
    }

    private void fillComboEdit(String path, boolean isContainsItself) {
        if (StringUtils.isBlank((CharSequence)path)) {
            this.initRootFile();
            return;
        }
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        if (isContainsItself) {
            this.recursionFile(file, comboItems);
        } else {
            File parentFile = file.getParentFile();
            if (parentFile == null) {
                this.initRootFile();
                return;
            }
            this.recursionFile(parentFile, comboItems);
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(ROOT_FILE);
        comboEdit.setComboItems(comboItems);
        this.getModel().beginInit();
        this.getModel().setValue(ROOT_FILE, (Object)((ComboItem)comboItems.get(comboItems.size() - 1)).getValue());
        this.getModel().endInit();
        this.getView().updateView(ROOT_FILE);
    }

    private void recursionFile(File file, List<ComboItem> comboItems) {
        if (file.getParentFile() != null) {
            this.recursionFile(file.getParentFile(), comboItems);
        }
        ComboItem item = new ComboItem();
        item.setCaption(new LocaleString(file.getPath()));
        item.setValue(file.getPath());
        comboItems.add(item);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (LAST.equals(key)) {
            String lastPath = this.getPageCache().get("currentPath");
            if (StringUtils.isNotBlank((CharSequence)lastPath)) {
                this.fillParentFile(lastPath);
                this.fillComboEdit(lastPath, false);
            }
        } else if (BTN_OK.equals(key)) {
            this.returnFilePath();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (ROOT_FILE.equals(name)) {
            ChangeData changeData = e.getChangeSet()[0];
            String newValue = (String)changeData.getNewValue();
            try {
                if (StringUtils.isBlank((CharSequence)newValue)) {
                    this.fillEntryEntity(this.getFilePath(null));
                } else {
                    this.fillEntryEntity(this.getFilePath(new File(newValue)));
                }
                this.getPageCache().put("currentPath", newValue);
                this.setCurrentPath();
                this.fillComboEdit(newValue, true);
            }
            catch (IOException exception) {
                log.error((Throwable)exception);
            }
        }
    }

    private void returnFilePath() {
        String path = (String)this.getModel().getValue(CURRENT_PATH);
        if (StringUtils.isBlank((CharSequence)path)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GitPathPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        this.getView().returnDataToParent((Object)path);
        this.getView().close();
    }

    private void fillParentFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        File parentFile = file.getParentFile();
        try {
            if (parentFile == null) {
                this.fillEntryEntity(this.getFilePath(null));
                this.getPageCache().put("currentPath", "");
                this.setCurrentPath();
                return;
            }
            this.fillEntryEntity(this.getFilePath(parentFile));
            this.getPageCache().put("currentPath", parentFile.getCanonicalPath());
            this.setCurrentPath();
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
    }

    private void setCurrentPath() {
        String currentPath = this.getPageCache().get("currentPath");
        if (currentPath != null) {
            this.getModel().setValue(CURRENT_PATH, (Object)currentPath);
        }
    }

    private List<FilePath> getFilePath(File f) throws IOException {
        File[] files;
        boolean isRoot = false;
        if (f == null) {
            files = File.listRoots();
            isRoot = true;
        } else {
            files = f.listFiles();
        }
        if (files == null) {
            return null;
        }
        ArrayList<FilePath> filePaths = new ArrayList<FilePath>(files.length);
        for (File file : files) {
            if (!file.isDirectory() || !isRoot && file.isHidden()) continue;
            FilePath filePath = new FilePath();
            if (StringUtils.isBlank((CharSequence)file.getName())) {
                filePath.setName(file.getCanonicalPath());
            } else {
                filePath.setName(file.getName());
            }
            if (StringUtils.isNotBlank((Object)file.getParentFile())) {
                filePath.setParentPath(file.getParentFile().getCanonicalPath());
                if (StringUtils.isNotBlank((Object)file.getParentFile().getParentFile())) {
                    filePath.setLastPath(file.getParentFile().getParentFile().getCanonicalPath());
                }
            }
            filePath.setPath(file.getCanonicalPath());
            filePaths.add(filePath);
        }
        return filePaths;
    }

    static class FilePath {
        private String path;
        private String parentPath;
        private String lastPath;
        private String name;

        FilePath() {
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getParentPath() {
            return this.parentPath;
        }

        public void setParentPath(String parentPath) {
            this.parentPath = parentPath;
        }

        public String getLastPath() {
            return this.lastPath;
        }

        public void setLastPath(String lastPath) {
            this.lastPath = lastPath;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

