/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.git.pluginnew;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Set;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.business.git.GitContext;
import kd.bos.devportal.business.git.GitOperationUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoFilepatternException;

public class GitPullConflictPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final Log log = LogFactory.getLog(GitPullConflictPlugin.class);
    private static final String BTN_OK = "btnok";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String FILE_NAME = "filename";
    private static final String PICTURE_STATUS = "pictureStatus";
    private static final String EXPAND = "expand";
    private static final String IMAGEAP = "imagepanel";
    private static final String PICTURE_EXPAND = "0";
    private static final String PICTURE_COLLAPSE = "1";
    private static final String OPERATE = "operate";
    private static final String KEY_GITROOTPATH = "gitrootpath";
    public static final String GITBRANCH = "gitbranch";
    public static final String PERSONALGITREPOSITORY = "personalgitrepository";
    private static final String LAST = "last";
    private static final String CURRENT = "current";
    private static final String TXT_SCRIPTNUMBER = "txt_scriptnumber";
    private static final String KEY_NUMBER = "number";
    private static final String CLOUD = "cloud";
    private static final String APP = "app";
    private static final String COMMIT_ID = "commitId";
    private static final String CURRENT_COMMIT_ID = "currentCommitId";
    private static final String ISSAVE = "issave";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{BTN_OK, EXPAND});
    }

    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put(PICTURE_STATUS, PICTURE_EXPAND);
        this.viewConflict();
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (EXPAND.equals(key)) {
            this.expandAndCollapse();
        } else if (BTN_OK.equals(key)) {
            this.conflictResolution();
        }
    }

    private void expandAndCollapse() {
        String status = this.getPageCache().get(PICTURE_STATUS);
        if (PICTURE_EXPAND.equals(status)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{IMAGEAP});
            this.getPageCache().put(PICTURE_STATUS, PICTURE_COLLAPSE);
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{IMAGEAP});
            this.getPageCache().put(PICTURE_STATUS, PICTURE_EXPAND);
        }
    }

    private void conflictResolution() {
        if (!this.isResolutionConflict()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u89e3\u51b3\u6240\u6709\u51b2\u7a81\u6587\u4ef6\uff0c\u518d\u70b9\u51fb\u63d0\u4ea4\u3002", (String)"GitPullConflictPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String gitContext = (String)parameter.getCustomParam("gitContext");
        GitContext context = (GitContext)SerializationUtils.fromJsonString((String)gitContext, GitContext.class);
        String personalGitRepository = context.getPersonalGitRepository();
        String path = personalGitRepository + File.separator + ".git";
        boolean isCommit = false;
        try (Git git = Git.open((File)new File(path));){
            AddCommand addCommand = git.add();
            for (DynamicObject object : entryEntity) {
                boolean res = object.getBoolean(ISSAVE);
                if (!res) continue;
                String fileName = object.getString(FILE_NAME);
                addCommand.addFilepattern(fileName);
                isCommit = true;
            }
            if (isCommit) {
                addCommand.call();
                git.commit().setMessage("conflict resolution").setAuthor(context.getUserName(), context.getUserName() + "@kingdee.com").call();
            }
            this.getView().returnDataToParent((Object)"success");
            this.getView().close();
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
        catch (NoFilepatternException e) {
            log.error("file not find " + (Object)((Object)e));
        }
        catch (GitAPIException e) {
            log.error("git error" + (Object)((Object)e));
        }
    }

    private boolean isResolutionConflict() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (DynamicObject object : entryEntity) {
            boolean isSave = object.getBoolean(ISSAVE);
            if (isSave) continue;
            return false;
        }
        return true;
    }

    private void viewConflict() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String file = (String)parameter.getCustomParam("fileList");
        Set fileList = (Set)SerializationUtils.fromJsonString((String)file, Set.class);
        ArrayList list = new ArrayList(fileList);
        if (fileList.isEmpty()) {
            return;
        }
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, fileList.size());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (int i = 0; i < fileList.size(); ++i) {
            DynamicObject object = (DynamicObject)entryEntity.get(i);
            object.set(FILE_NAME, list.get(i));
            object.set(OPERATE, (Object)ResManager.loadKDString((String)"\u6bd4\u8f83", (String)"GitPullConflictPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if (OPERATE.equals(fieldName)) {
            int rowIndex = evt.getRowIndex();
            this.getPageCache().put("index", String.valueOf(rowIndex));
            String metaPath = (String)this.getModel().getValue(FILE_NAME, rowIndex);
            this.showDiff(rowIndex, metaPath);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String res;
        if ("diffCloseCallBack".equals(event.getActionId()) && event.getReturnData() != null && "true".equals(res = (String)event.getReturnData())) {
            String index = this.getPageCache().get("index");
            this.getModel().setValue(ISSAVE, (Object)Boolean.TRUE, Integer.parseInt(index));
        }
    }

    private void showDiff(int row, String metaPath) {
        QFilter qFilter;
        GitContext context = this.getGitContext();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_gitdifference");
        parameter.setPageId(UUID.randomUUID().toString());
        String rootPath = context.getGitRootPath();
        String personalRepository = context.getPersonalGitRepository();
        String commitId = GitOperationUtils.getCommitId((String)personalRepository);
        parameter.setCustomParam(COMMIT_ID, (Object)"Remote\uff3fVersion");
        parameter.setCustomParam(CURRENT_COMMIT_ID, (Object)commitId);
        String lastContent = this.getConflictContent(metaPath);
        parameter.setCustomParam(LAST, (Object)Encrypters.encode((String)lastContent));
        String currentContent = this.getRemoteContent(metaPath);
        parameter.setCustomParam(CURRENT, (Object)Encrypters.encode((String)currentContent));
        parameter.setCustomParam(PERSONALGITREPOSITORY, (Object)personalRepository);
        parameter.setCustomParam(KEY_GITROOTPATH, (Object)rootPath);
        String fileName = (String)this.getModel().getValue(FILE_NAME, row);
        String[] split = fileName.trim().split("\\.");
        boolean isCloud = split[split.length - 1].contains("cld");
        boolean isApp = split[split.length - 1].contains(APP);
        String type = null;
        DynamicObject dym = null;
        if (fileName.endsWith("ks")) {
            String scriptName = fileName.split("\\.")[0];
            qFilter = new QFilter(TXT_SCRIPTNUMBER, "=", (Object)scriptName);
            dym = BusinessDataServiceHelper.loadSingle((String)"ide_pluginscript", (String)"ID,bizappid", (QFilter[])new QFilter[]{qFilter});
            type = "script";
        } else if (fileName.contains("dym")) {
            String pageName = fileName.split("\\.")[0];
            qFilter = new QFilter(KEY_NUMBER, "=", (Object)pageName);
            dym = BusinessDataServiceHelper.loadSingle((String)"bos_formmeta", (String)"ID,bizappid", (QFilter[])new QFilter[]{qFilter});
            type = "page";
        } else if (isCloud) {
            type = CLOUD;
        } else if (isApp) {
            String appNumber = fileName.split("\\.")[0];
            qFilter = new QFilter(KEY_NUMBER, "=", (Object)appNumber);
            dym = BusinessDataServiceHelper.loadSingle((String)"bos_devportal_bizapp", (String)"ID,bizappid", (QFilter[])new QFilter[]{qFilter});
            type = APP;
        }
        if (dym != null) {
            String id = dym.getString("ID");
            String bizAppId = null;
            bizAppId = StringUtils.equals((CharSequence)APP, (CharSequence)type) ? dym.getString("id") : dym.getString("bizappid");
            parameter.setCustomParam("id", (Object)id);
            parameter.setCustomParam("bizappid", (Object)bizAppId);
        }
        parameter.setCustomParam("filepath", this.getModel().getValue(FILE_NAME, row));
        parameter.setCustomParam("type", (Object)type);
        parameter.setCaption(ResManager.loadKDString((String)"\u6587\u4ef6\u6bd4\u8f83", (String)"GITPushPlugin_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        OpenStyle style = new OpenStyle();
        StyleCss cssStyle = new StyleCss();
        cssStyle.setHeight("760");
        cssStyle.setWidth("1200");
        style.setInlineStyleCss(cssStyle);
        style.setShowType(ShowType.Modal);
        parameter.setOpenStyle(style);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "diffCloseCallBack"));
        this.getView().showForm(parameter);
    }

    private GitContext getGitContext() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String gitContext = (String)formShowParameter.getCustomParam("gitContext");
        return (GitContext)SerializationUtils.fromJsonString((String)gitContext, GitContext.class);
    }

    private String getRemoteContent(String metaPath) {
        GitContext context = this.getGitContext();
        String personalGitRepository = context.getPersonalGitRepository();
        String path = personalGitRepository + File.separator + metaPath;
        return this.getContent(path);
    }

    private String getConflictContent(String metaPath) {
        GitContext context = this.getGitContext();
        String personalGitRepository = context.getPersonalGitRepository();
        String remoteBranch = "remotes/origin/" + context.getGitBranch();
        return GitOperationUtils.getRemoteLastCommitFile((String)personalGitRepository, (String)metaPath, (String)remoteBranch);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getContent(String filePath) {
        byte[] filecontent = null;
        File file = new File(filePath);
        try (FileInputStream in = new FileInputStream(file);){
            long filelength = file.length();
            filecontent = new byte[(int)filelength];
            int count = 0;
            String formRepository = "";
            while ((count = in.read(filecontent)) > 0) {
                formRepository = new String(filecontent, StandardCharsets.UTF_8);
            }
            String string = formRepository;
            return string;
        }
        catch (Exception e) {
            return null;
        }
    }
}

