/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.git.pluginnew;

import java.util.EventObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.business.git.GitContext;
import kd.bos.devportal.business.git.GitSaveFileHandler;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class GitPullPlugin
extends AbstractFormPlugin {
    private static final String DETAIL = "detail";
    private static final String BTN_OK = "btnok";
    private static final String UPDATE_META = "updatemeta";
    private static final String EXPORT_TO_LOCAL = "exporttolocal";
    private static final String UPDATE_METADATA_TO_DB = "updateMetadataToDb";
    public static final String GITURL = "giturl";
    public static final String GITREPOSITORY = "gitrepository";
    public static final String GITBRANCH = "gitbranch";
    public static final String GITROOTPATH = "gitrootpath";
    public static final String PERSONALGITREPOSITORY = "personalgitrepository";
    public static final String USERNAME = "username";
    public static final String METADATA = "metadata";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{DETAIL, BTN_OK});
    }

    public void afterBindData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String gitContext = (String)parameter.getCustomParam("gitContext");
        GitContext context = (GitContext)SerializationUtils.fromJsonString((String)gitContext, GitContext.class);
        if (!StringUtils.equals((CharSequence)"app", (CharSequence)context.getType())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{EXPORT_TO_LOCAL});
        }
    }

    public void click(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "detail": {
                this.expandDetail();
                break;
            }
            case "btnok": {
                this.updateMetadata();
                break;
            }
        }
    }

    private void expandDetail() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String detail = (String)parameter.getCustomParam(DETAIL);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_devp_pull_detail");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam(DETAIL, (Object)detail);
        this.getView().showForm(showParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        if (UPDATE_METADATA_TO_DB.equals(callBackId) && MessageBoxResult.Cancel.equals((Object)event.getResult())) {
            this.getModel().setValue(UPDATE_META, (Object)false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        boolean isSelect;
        String name = e.getProperty().getName();
        if (UPDATE_META.equals(name) && (isSelect = ((Boolean)e.getChangeSet()[0].getNewValue()).booleanValue())) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u5143\u6570\u636e\uff08\u6570\u636e\u6a21\u578b\uff09\u8fd8\u539f\u81f3\u6570\u636e\u5e93\uff0c\u53ef\u80fd\u4f1a\u5bfc\u81f4\u5176\u4ed6\u7528\u6237\u6570\u636e\u88ab\u8986\u76d6\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u8fdb\u884c\u8fd8\u539f\u64cd\u4f5c\uff1f", (String)"GitPullPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(UPDATE_METADATA_TO_DB, (IFormPlugin)this));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String isClickOk = this.getPageCache().get("isClickOk");
        if (StringUtils.isBlank((CharSequence)isClickOk)) {
            boolean exportToLocal = (Boolean)this.getModel().getValue(EXPORT_TO_LOCAL);
            FormShowParameter parameter = this.getView().getFormShowParameter();
            String gitContext = (String)parameter.getCustomParam("gitContext");
            GitContext context = (GitContext)SerializationUtils.fromJsonString((String)gitContext, GitContext.class);
            if (exportToLocal) {
                GitSaveFileHandler saveFileHandler = new GitSaveFileHandler();
                saveFileHandler.handler(context, (AbstractFormPlugin)this);
            }
        }
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u62c9\u53d6", "GitPullPlugin_0", BOS_DEVPORTAL_PLUGIN);
        MultiLangEnumBridge opDescription = new MultiLangEnumBridge("Git\u62c9\u53d6\u5143\u6570\u636e", "GitPullPlugin_1", BOS_DEVPORTAL_PLUGIN);
        AppUtils.addOpLog((String)"bos_devp_gitmessage", (String)"pull", (String)"bos_devp_gitmessage", (String)"1", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[0]);
    }

    private void updateMetadata() {
        this.getView().showLoading(new LocaleString(""));
        boolean updateMeta = (Boolean)this.getModel().getValue(UPDATE_META);
        boolean exportToLocal = (Boolean)this.getModel().getValue(EXPORT_TO_LOCAL);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String gitContext = (String)parameter.getCustomParam("gitContext");
        GitContext context = (GitContext)SerializationUtils.fromJsonString((String)gitContext, GitContext.class);
        context.setPullUpdate(updateMeta);
        context.setExportToLocal(exportToLocal);
        gitContext = SerializationUtils.toJsonString((Object)context);
        this.getPageCache().put("isClickOk", "true");
        this.getView().returnDataToParent((Object)gitContext);
        this.getView().close();
    }
}

