/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.git.pluginnew;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.business.git.GitRepositoryHelper;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.git.pluginnew.GitBaseLogPlugin;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public class GitPushPlugin
extends GitBaseLogPlugin {
    private static final Log logger = LogFactory.getLog(GitPushPlugin.class);
    private static final String PICTURE_STATUS = "pictureStatus";
    private static final String PICTURE_EXPAND = "0";
    private static final String PICTURE_COLLAPSE = "1";
    private static final String IMAGEAP = "imagepanel";
    private static final String EXPAND = "expand";
    private static final String BTN_OK = "btnok";
    private static final String LOG_ENTRY = "logentry";
    private static final String LBL_ADDRESS = "address";
    private static final String LBL_BRANCH = "branch";
    private static final String USERNAME = "username";
    private static final String PSD = "password";
    private static final String GITURL = "giturl";
    private static final String GITBRANCH = "gitbranch";
    private static final String PERSONALGITREPOSITORY = "personalgitrepository";
    private static final String ORIGIN = "origin";
    private static final String BRANCH = "branch";
    private static final String REMOTE = "remote";
    private static final String REMOTES = "remotes/";
    private static final String HEAD = "HEAD";
    private static final String RESULT = "result";
    private static final String SUCCESS = "success";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, EXPAND});
    }

    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put(PICTURE_STATUS, PICTURE_EXPAND);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String personalGitRepository = (String)parameter.getCustomParam(PERSONALGITREPOSITORY);
        String gitUrl = (String)parameter.getCustomParam(GITURL);
        String gitBranch = (String)parameter.getCustomParam(GITBRANCH);
        String gitRemote = ORIGIN;
        try (Repository repository = GitRepositoryHelper.openRepository((String)personalGitRepository);){
            RemoteConfig cfg;
            if (StringUtils.isNotBlank((CharSequence)repository.getBranch())) {
                gitBranch = repository.getBranch();
                String remoteCfg = repository.getConfig().getString("branch", gitBranch, REMOTE);
                if (StringUtils.isNotBlank((CharSequence)remoteCfg)) {
                    gitRemote = remoteCfg;
                }
            }
            if ((cfg = new RemoteConfig((Config)repository.getConfig(), gitRemote)).getURIs().isEmpty() && cfg.getPushURIs().isEmpty()) {
                URIish urIish = new URIish(gitRemote);
                gitUrl = urIish.toASCIIString();
            }
            StringBuilder sb = new StringBuilder();
            List uris = cfg.getPushURIs();
            if (uris.isEmpty()) {
                uris = cfg.getURIs();
            }
            for (URIish urIish : uris) {
                sb.append(urIish.toASCIIString()).append("\r\n");
            }
            gitUrl = sb.toString();
        }
        catch (Exception ex) {
            logger.error("\u83b7\u53d6\u63a8\u9001url\u5931\u8d25:" + ex.getMessage());
        }
        Label address = (Label)this.getControl(LBL_ADDRESS);
        address.setText(gitUrl);
        Label branch = (Label)this.getControl("branch");
        branch.setText(gitBranch);
        this.showLog(REMOTES + gitRemote + "/" + gitBranch, HEAD);
        this.getView().getPageCache().put("gitRemote", gitRemote);
        if (Lang.zh_CN != Lang.get()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{IMAGEAP, EXPAND});
        }
    }

    public void click(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "expand": {
                this.expandAndCollapse();
                break;
            }
            case "btnok": {
                this.push();
                break;
            }
        }
    }

    private void expandAndCollapse() {
        String status = this.getPageCache().get(PICTURE_STATUS);
        if (PICTURE_EXPAND.equals(status)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{IMAGEAP});
            this.getPageCache().put(PICTURE_STATUS, PICTURE_COLLAPSE);
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{IMAGEAP});
            this.getPageCache().put(PICTURE_STATUS, PICTURE_EXPAND);
        }
    }

    private void push() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(LOG_ENTRY);
        if (entryEntity.size() == 0) {
            return;
        }
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String userName = (String)parameter.getCustomParam(USERNAME);
        String password = (String)parameter.getCustomParam(PSD);
        String personalGitRepository = (String)parameter.getCustomParam(PERSONALGITREPOSITORY);
        HashMap<String, String> response = new HashMap<String, String>();
        try (Repository repository = GitRepositoryHelper.openRepository((String)personalGitRepository);
             Git git = new Git(repository);){
            PushCommand push = git.push();
            String remote = this.getView().getPageCache().get("gitRemote");
            if (StringUtils.isNotBlank((CharSequence)remote)) {
                push.setRemote(remote);
            }
            StringWriter writer = new StringWriter();
            TextProgressMonitor progressMonitor = new TextProgressMonitor((Writer)writer);
            push.setProgressMonitor((ProgressMonitor)progressMonitor);
            push.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(userName, password));
            Iterable pushResults = push.call();
            for (PushResult pushResult : pushResults) {
                Collection remoteUpdates = pushResult.getRemoteUpdates();
                if (remoteUpdates.size() <= 0) continue;
                RemoteRefUpdate refUpdate = (RemoteRefUpdate)remoteUpdates.iterator().next();
                RemoteRefUpdate.Status status = refUpdate.getStatus();
                if (status == RemoteRefUpdate.Status.OK) {
                    response.put(RESULT, SUCCESS);
                    break;
                }
                if (status == RemoteRefUpdate.Status.REJECTED_OTHER_REASON) {
                    response.put(RESULT, refUpdate.getMessage());
                    break;
                }
                response.put(RESULT, status.name());
                break;
            }
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u63a8\u9001", "GITPushPlugin_9", BOS_DEVPORTAL_PLUGIN);
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge("Git\u63a8\u9001\u5143\u6570\u636e", "GITPushPlugin_10", BOS_DEVPORTAL_PLUGIN);
            AppUtils.addOpLog((String)"bos_devp_gitpush_new", (String)"push", (String)"bos_devp_gitpush_new", (String)PICTURE_COLLAPSE, (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[0]);
        }
        catch (GitAPIException e) {
            response.put(RESULT, e.getMessage());
            logger.error("\u63a8\u9001\u5931\u8d25:" + e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u63a8\u9001\u5931\u8d25:" + e.getMessage());
        }
        this.getView().returnDataToParent(response);
        this.getView().close();
    }
}

