/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.git.pluginnew;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.devportal.business.git.GitContext;
import kd.bos.devportal.business.git.GitDiffEntry;
import kd.bos.devportal.business.git.GitOperationUtils;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.git.pluginnew.GitBaseLogPlugin;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetaLogType;
import kd.bos.metadata.dao.MetaType;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.metadata.deploy.DeployMetadata;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataLogService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class GitRestorePlugin
extends GitBaseLogPlugin {
    private static final Log log = LogFactory.getLog(GitRestorePlugin.class);
    private static final String MASTERID = "masterid";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String LOG_ENTRY = "logentry";
    private static final String FILE_PATH_ENTRY = "filepathentry";
    private static final String BTN_OK = "btnok";
    private static final String PICTURE_STATUS = "pictureStatus";
    private static final String EXPAND = "expand";
    private static final String IMAGEAP = "imagepanel";
    private static final String PICTURE_EXPAND = "0";
    private static final String PICTURE_COLLAPSE = "1";
    private static final String ADDRESS = "address";
    private static final String BRANCH = "branch";
    private static final String GITURL = "giturl";
    private static final String GITBRANCH = "gitbranch";
    private static final String GITROOTPATH = "gitrootpath";
    private static final String PERSONALGITREPOSITORY = "personalgitrepository";
    private static final String UPDATE_METADATA_TO_DB = "updateMetadataToDb";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, EXPAND});
    }

    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put(PICTURE_STATUS, PICTURE_EXPAND);
        this.expandAndCollapse();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String gitUrl = (String)parameter.getCustomParam(GITURL);
        String gitBranch = (String)parameter.getCustomParam(GITBRANCH);
        Label address = (Label)this.getControl(ADDRESS);
        address.setText(gitUrl);
        Label branch = (Label)this.getControl(BRANCH);
        branch.setText(gitBranch);
        this.showLog();
        if (Lang.zh_CN != Lang.get()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{IMAGEAP, EXPAND});
        }
    }

    @Override
    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        Control control = (Control)evt.getSource();
        if (evt.getRow() < 0) {
            return;
        }
        if (LOG_ENTRY.equals(control.getKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(FILE_PATH_ENTRY);
            int[] selectRows = this.getSelectRows();
            if (selectRows != null) {
                entryGrid.selectRows(selectRows, selectRows[0]);
            }
        }
    }

    private int[] getSelectRows() {
        GitContext context = this.getGitContext();
        String type = context.getType();
        String id = context.getId();
        String number = null;
        if ("page".equals(type)) {
            number = MetadataDao.getNumberById((String)id);
        } else if ("script".equals(type)) {
            List scriptDeployFile = MetadataDao.getScriptDeployFile((String[])new String[]{id});
            number = ((DeployFile)scriptDeployFile.get(0)).getFileName().split("\\.")[0];
        }
        if (number == null) {
            return null;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(FILE_PATH_ENTRY);
        ArrayList<Integer> index = new ArrayList<Integer>(2);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject object = (DynamicObject)entryEntity.get(i);
            String txtPath = (String)object.get("txtpath");
            String[] split = txtPath.split("/");
            String fileNumber = split[split.length - 1];
            String removeSuffixNumber = fileNumber.split("\\.")[0];
            if (!removeSuffixNumber.equals(number)) continue;
            index.add(i);
        }
        return index.size() == 0 ? null : index.stream().mapToInt(x -> x).toArray();
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        if (UPDATE_METADATA_TO_DB.equals(callBackId) && MessageBoxResult.Yes.equals((Object)event.getResult())) {
            this.restoreMetadata();
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_OK.equals(key)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u6240\u9009\u5143\u6570\u636e\u8fd8\u539f\u81f3\u6570\u636e\u5e93\uff0c\u53ef\u80fd\u4f1a\u5bfc\u81f4\u5176\u4ed6\u7528\u6237\u6570\u636e\u88ab\u8986\u76d6\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u8fdb\u884c\u8fd8\u539f\u64cd\u4f5c\uff1f", (String)"GitRestorePlugin_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(UPDATE_METADATA_TO_DB, (IFormPlugin)this));
        } else if (EXPAND.equals(key)) {
            this.expandAndCollapse();
        }
    }

    private void expandAndCollapse() {
        String status = this.getPageCache().get(PICTURE_STATUS);
        if (PICTURE_EXPAND.equals(status)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{IMAGEAP});
            this.getPageCache().put(PICTURE_STATUS, PICTURE_COLLAPSE);
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{IMAGEAP});
            this.getPageCache().put(PICTURE_STATUS, PICTURE_EXPAND);
        }
    }

    private void restoreMetadata() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(FILE_PATH_ENTRY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u8fd8\u539f\u7684\u5143\u6570\u636e\u3002", (String)"GitRestorePlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        EntryGrid logGrid = (EntryGrid)this.getView().getControl(LOG_ENTRY);
        int[] logGridSelectRows = logGrid.getSelectRows();
        if (logGridSelectRows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u63d0\u4ea4\u8bb0\u5f55\u3002", (String)"GitRestorePlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String personalGitRepository = (String)parameter.getCustomParam(PERSONALGITREPOSITORY);
        String sha1 = (String)this.getModel().getValue("txtname", logGridSelectRows[0]);
        String metaNumber = null;
        for (int i = 0; i < selectRows.length; ++i) {
            String metaPath = (String)this.getModel().getValue("txtpath", selectRows[i]);
            String[] split = metaPath.split("/");
            metaNumber = split[split.length - 1];
            GitDiffEntry commitDiffEntry = GitOperationUtils.getCommitDiffEntry((String)personalGitRepository, (String)metaPath, (String)sha1);
            String fileContent = commitDiffEntry.getChangeType() == GitDiffEntry.ChangeType.DELETE ? commitDiffEntry.getOldContent() : commitDiffEntry.getNewContent();
            if (StringUtils.isBlank((CharSequence)fileContent)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8fd8\u539f\u5931\u8d25\uff1a %s\u3002", (String)"GitRestorePlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"\u8fd8\u539f\u5185\u5bb9\u4e3a\u7a7a", (String)"GitRestorePlugin_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0])));
                return;
            }
            try {
                this.deployMetadata(metaPath, fileContent);
            }
            catch (Exception e) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8fd8\u539f\u5931\u8d25\uff1a %s\u3002", (String)"GitRestorePlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), e.getMessage()));
                return;
            }
            this.writeLog(metaNumber);
        }
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u8fd8\u539f", "GitRestorePlugin_4", BOS_DEVPORTAL_PLUGIN);
        MultiLangEnumBridge opDescription = new MultiLangEnumBridge("Git\u8fd8\u539f%1$s\u5230\u6307\u5b9a\u7248\u672c%2$s", "GitRestorePlugin_5", BOS_DEVPORTAL_PLUGIN);
        AppUtils.addOpLog((String)"bos_devp_gitrestore", (String)"revert", (String)"bos_devp_gitrestore", (String)PICTURE_COLLAPSE, (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[]{metaNumber, sha1});
        this.getView().returnDataToParent((Object)"success");
        this.getView().close();
    }

    private void writeLog(String formNumber) {
        try {
            long fid = DB.genGlobalLongId();
            MetadataLogService logService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
            if (formNumber.endsWith(".dym")) {
                formNumber = formNumber.trim().split("\\.")[0];
                String formId = MetadataDao.getIdByNumber((String)formNumber, (MetaCategory)MetaCategory.Form);
                logService.addMetaLog(formId, formNumber, (int)MetaLogType.Deploy.getValue(), fid, (int)MetaType.Form.getValue());
            } else if (formNumber.endsWith(".app")) {
                formNumber = formNumber.trim().split("\\.")[0];
                String appId = BizAppServiceHelp.getAppIdByAppNumber((String)formNumber);
                logService.addAppMetaLog(appId, (int)MetaLogType.Deploy.getValue(), fid, (int)MetaType.App.getValue());
            }
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u5143\u6570\u636e\u65e5\u5fd7\u5931\u8d25\uff0cerr\uff1a" + e);
        }
    }

    private void deployMetadata(String fileName, String fileContent) throws Exception {
        if (fileName.endsWith(".dym") || fileName.endsWith(".zh_CN.dymx")) {
            this.deployFormMetadata(fileName, fileContent);
        } else if (fileName.endsWith(".app") || fileName.endsWith(".zh_CN.appx")) {
            this.deployAppMetadata(fileContent);
        } else if (fileName.endsWith(".cr") || fileName.endsWith(".zh_CN.crx")) {
            this.deployBotpMetadata(fileContent);
        } else if (fileName.endsWith(".wb") || fileName.endsWith(".zh_CN.wbx")) {
            this.deployBotpMetadata(fileContent);
        } else if (fileName.endsWith(".bur") || fileName.endsWith(".zh_CN.burx")) {
            this.deployBotpMetadata(fileContent);
        } else if (fileName.endsWith(".ks")) {
            this.deployKsMetadata(fileContent);
        } else if (fileName.endsWith(".cld") || fileName.endsWith(".cldx")) {
            this.deployCloudMetadata(fileContent);
        } else if (fileName.endsWith(".kpdm")) {
            this.deployDataModel(fileContent);
        }
    }

    private void deployDataModel(String content) {
        MetadataDao.deployMetadata((String)content, null, null);
    }

    private void deployFormMetadata(String fileName, String fileContent) throws Exception {
        DynamicObject loadSingle;
        String[] split;
        String[] split1;
        String number;
        GitContext context = this.getGitContext();
        String id = null;
        if (StringUtils.equals((CharSequence)"app", (CharSequence)context.getType()) && (id = MetadataDao.getIdByNumber((String)(number = (split1 = (split = fileName.split("/"))[split.length - 1].trim().split("\\."))[0]), (MetaCategory)MetaCategory.Form)) == null) {
            List metadata = MetadataDao.deployMetadata((String)fileContent);
            MetadataDao.rebuildRuntimeMetaById((String)((String)metadata.get(0)));
            return;
        }
        if (id == null) {
            id = context.getId();
        }
        String masterId = StringUtils.isBlank((CharSequence)(loadSingle = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bos_formmeta", (String)MASTERID)).getString(MASTERID)) ? id : loadSingle.getString(MASTERID);
        String bizAppId = context.getBizAppId();
        String bizUnitId = context.getBizUnitId();
        MetadataDao.deployMetadata((String)fileContent, (String)bizUnitId, (String)bizAppId);
        MetadataDao.rebuildRuntimeMetaById((String)masterId);
    }

    private void deployKsMetadata(String fileContent) throws Exception {
        GitContext context = this.getGitContext();
        String bizAppId = context.getBizAppId();
        String bizUnitId = context.getBizUnitId();
        MetadataDao.deployScript((String)fileContent, (String)bizUnitId, (String)bizAppId);
    }

    private void deployCloudMetadata(String fileContent) {
        MetadataDao.deployCloud((String)fileContent);
    }

    private void deployAppMetadata(String fileContent) throws Exception {
        GitContext context = this.getGitContext();
        String bizAppId = context.getBizAppId();
        MetadataDao.deployAppMetadata((String)fileContent);
        MetadataDao.rebuildRuntimeAppMetaById((String)bizAppId);
    }

    private void deployBotpMetadata(String fileContent) throws Exception {
        DcxmlSerializer serializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        DeployMetadata deployNew = (DeployMetadata)serializer.deserializeFromString(fileContent, null);
        MetadataDao.deployMetadata((DeployMetadata)deployNew, null, null);
    }

    private GitContext getGitContext() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String gitContext = (String)parameter.getCustomParam("gitContext");
        return (GitContext)SerializationUtils.fromJsonString((String)gitContext, GitContext.class);
    }
}

