/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.git.pluginnew;

import java.util.EventObject;
import java.util.LinkedHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.business.git.GitRepositoryHelper;
import kd.bos.devportal.business.git.UserCacheInfo;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;

public class GitSettingPlugin
extends AbstractFormPlugin {
    private static final String CLEAN = "clean";
    private static final String BTN_OK = "btnok";
    private static final String URL = "url";
    private static final String PUSH_URL = "pushurl";
    private static final String DISABLE_SSL = "disablessl";
    private static final String LOGIN_PANEL = "loginpanel";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final Log log = LogFactory.getLog(GitSettingPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{CLEAN, BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        this.fillUrl();
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_OK.equals(key)) {
            this.setRepositoryConfig();
        } else if (CLEAN.equals(key)) {
            this.cleanLoginInfo();
        }
    }

    private void fillUrl() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{LOGIN_PANEL});
        String personalRepository = (String)this.getView().getFormShowParameter().getCustomParam("personalRepository");
        try (Repository repository = GitRepositoryHelper.openRepository((String)personalRepository);){
            StoredConfig config = repository.getConfig();
            String remotePullUrl = config.getString("remote", "origin", URL);
            String remotePushUrl = config.getString("remote", "origin", PUSH_URL);
            if (remotePullUrl != null) {
                this.getModel().setValue(URL, (Object)remotePullUrl);
            }
            if (remotePushUrl != null) {
                this.getModel().setValue(PUSH_URL, (Object)remotePushUrl);
            }
            boolean ssl = config.getBoolean("http", "sslVerify", true);
            this.getModel().setValue(DISABLE_SSL, (Object)ssl);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    private void cleanLoginInfo() {
        String sessionId = (String)this.getView().getFormShowParameter().getCustomParam("sessionId");
        UserCacheInfo userCacheInfo = new UserCacheInfo();
        userCacheInfo.removeUserInfo(sessionId);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6e05\u9664\u6210\u529f\u3002", (String)"GitSettingPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
    }

    private void setRepositoryConfig() {
        String url = (String)this.getModel().getValue(URL);
        String pushUrl = (String)this.getModel().getValue(PUSH_URL);
        String personalRepository = (String)this.getView().getFormShowParameter().getCustomParam("personalRepository");
        try (Repository repository = GitRepositoryHelper.openRepository((String)personalRepository);){
            StoredConfig config = repository.getConfig();
            LinkedHashMap<String, String> res = new LinkedHashMap<String, String>(2);
            String remotePushUrl = config.getString("remote", "origin", PUSH_URL);
            if (StringUtils.isNotBlank((CharSequence)url)) {
                res.put(URL, url);
            }
            if (pushUrl != null && !pushUrl.equals(remotePushUrl)) {
                config.setString("remote", "origin", PUSH_URL, pushUrl);
                res.put("pushUrl", pushUrl);
            }
            boolean ssl = config.getBoolean("http", "sslVerify", true);
            boolean disableSSL = (Boolean)this.getModel().getValue(DISABLE_SSL);
            if (disableSSL != ssl) {
                config.setBoolean("http", null, "sslVerify", disableSSL);
                res.put("sslVerify", String.valueOf(disableSSL));
            }
            config.save();
            res.put("result", "success");
            this.getView().returnDataToParent(res);
            this.getView().close();
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
        }
    }
}

