/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.git.proxy;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.devportal.business.git.GitContext;
import kd.bos.devportal.business.git.GitOperateHandler;
import kd.bos.devportal.business.git.GitSettingDao;
import kd.bos.devportal.business.hosting.GitOperationUtil;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;

public class GitAppPluginProxy {
    private static final String GIT_OPERATE = "gitOperate";
    private static final String GITOPERATEKEY = "gitoperatekey";
    private static final String GIT_COMMIT_NEW_CALLBACK = "gitCommitNewCallBack";
    private static final String COMMIT = "commit";
    private static final String REVERT = "revert";
    private static final String PUSH = "push";
    private static final String LOG = "log";
    private static final String BRANCH_COMPARE = "branchcompare";
    private static final String GITMSG = "gitmsg";
    private static final String BIZAPPID = "bizappid";
    private static final String BIZAPPNUMBER = "bizappnumber";
    private static final String GITOPERATEID = "gitoperateid";
    private static final String GITOPERATETYPE = "gitoperatetype";
    private static final String GIT_OPERATE_CALL_BACK = "gitOperateCallBack";
    private static final String GIT_COMMIT_PUSH_CONFIRM_BACK = "gitCommitAndPushConfirmBack";
    private static final String GIT_RESTORE_CALL_BACK = "gitRestoreCallBack";
    private static final String GIT_PUSH_NEW_CALLBACK = "gitPushNewCallBack";
    private static final String GIT_PULL_CONFLICT_CALLBACK = "gitPullConflictCallBack";
    private static final String GITMANAGECLOSECALLBACK = "gitmanageclosecallback";
    private static final String GIT_MANAGER_NEW = "gitManagerNew";
    private static final String GIT_LOGIN_INFO_CALLBACK = "gitLoginInfoCallBack";
    public static final String SCRIPT = "script";
    public static final String BOTP = "botp";
    public static final String BIZUNITID = "bizunitid";
    public static final String GITURL = "giturl";
    public static final String GITBRANCH = "gitbranch";
    public static final String GITROOTPATH = "gitrootpath";
    private static final String GITREPOSITORY = "gitrepository";
    private static final String USERNAME = "username";
    public static final String PSD = "password";
    public static final String GIT_USERNAME = "gitusername";
    public static final String GIT_PSD = "gitpassword";
    private static final String BIZ_APP_NUMBER = "bos_devportal_bizapp";
    private static final String UNIT_REF_FORM_NUMBER = "bos_devportal_unitrelform";
    private static final String BIZ_UNIT = "bizunit";
    private static final String BIZAPP = "bizapp";
    private static final String FILENAME = "filename";
    private static final String SUCCESS = "success";
    private static final String TXT_SCRIPT_NUMBER = "txt_scriptnumber";
    private static final String SCRIPT_SUFFIX = ".ks";
    public static final String IDE_PLUGINSCRIPT = "ide_pluginscript";
    private static final String BOS_DEVPORTAL_BUSINESS = "bos-devportal-business";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private AbstractFormPlugin plugin;

    private GitAppPluginProxy(AbstractFormPlugin plugin) {
        this.plugin = plugin;
    }

    public static GitAppPluginProxy getProxy(AbstractFormPlugin plugin) {
        return new GitAppPluginProxy(plugin);
    }

    private IPageCache getPageCache() {
        return this.plugin.getPageCache();
    }

    private IFormView getView() {
        return this.plugin.getView();
    }

    public void invoke(String methodName, Object ... args) {
        switch (methodName) {
            case "gitOperate": {
                this.gitOperate((JSONObject)args[0]);
                break;
            }
            case "gitOperateCallBack": {
                this.handleGitOperateConfirmCallBack();
                break;
            }
            case "gitCommitNewCallBack": {
                this.handleGitCommitNewCallBack((ClosedCallBackEvent)args[0]);
                break;
            }
            case "gitCommitAndPushConfirmBack": {
                this.handleGitCommitAndPushConfirmBack();
                break;
            }
            case "gitRestoreCallBack": {
                this.handleGitRestoreCallBack((ClosedCallBackEvent)args[0]);
                break;
            }
            case "gitPushNewCallBack": {
                this.handleGitPushNewCallBack((ClosedCallBackEvent)args[0]);
                break;
            }
            case "gitPullConflictCallBack": {
                this.handleGitPullConflictCallBack((ClosedCallBackEvent)args[0]);
                break;
            }
            case "gitManagerNew": {
                this.handleGitManagerNew((JSONObject)args[0]);
                break;
            }
            case "gitLoginInfoCallBack": {
                this.handleGitLoginInfoCallBack((String)args[0]);
                break;
            }
        }
    }

    private void gitOperate(JSONObject arg) {
        String cloudId;
        String operateKey = arg.getString(GITOPERATEKEY);
        String bizAppId = arg.getString(BIZAPPID);
        String sessionId = arg.getString(GITMSG);
        String type = arg.getString("type");
        if ("cloud".equals(type) && StringUtils.isNotBlank((CharSequence)(cloudId = this.getCloudId(bizAppId)))) {
            bizAppId = cloudId;
        }
        GitSettingDao dao = new GitSettingDao();
        switch (operateKey) {
            case "commit": 
            case "revert": 
            case "push": 
            case "log": 
            case "branchcompare": {
                if (!dao.isNewGitOperate()) break;
                GitAppPluginProxy.beforeGitOperate(operateKey, bizAppId, type, sessionId, this.plugin);
                return;
            }
        }
        GitAppPluginProxy.gitConfirmOperate(bizAppId, type, operateKey, sessionId, this.plugin);
    }

    private String getCloudId(String bizAppId) {
        String sql = "select fbizcloudid from t_meta_bizapp where fid = ?";
        Object[] parameters = new SqlParameter[]{new SqlParameter(":fbizcloudid", 12, (Object)bizAppId)};
        ResultSetHandler action = rs -> {
            if (rs.next()) {
                return rs.getString("fbizcloudid");
            }
            return null;
        };
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])parameters, (ResultSetHandler)action);
    }

    public static void gitConfirmOperate(String id, String type, String operateKey, String sessionId, AbstractFormPlugin plugin) {
        JSONObject gitInfo = new JSONObject();
        gitInfo.put(GITOPERATEID, (Object)id);
        gitInfo.put(GITOPERATETYPE, (Object)type);
        gitInfo.put(GITOPERATEKEY, (Object)operateKey);
        gitInfo.put("gitoperatesessionid", (Object)sessionId);
        plugin.getPageCache().put("gitinfo", gitInfo.toJSONString());
        String resourceMsg = null;
        if (SCRIPT.equalsIgnoreCase(type)) {
            resourceMsg = ResManager.loadKDString((String)"\u811a\u672c", (String)"GitOperationUtil_0", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
        } else if ("page".equalsIgnoreCase(type)) {
            resourceMsg = ResManager.loadKDString((String)"\u9875\u9762", (String)"GitOperationUtil_1", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
        } else if ("app".equalsIgnoreCase(type)) {
            resourceMsg = ResManager.loadKDString((String)"\u5e94\u7528", (String)"GitOperationUtil_38", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
        } else if ("cloud".equalsIgnoreCase(type)) {
            resourceMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91", (String)"GitOperationUtil_42", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
        } else if (type.startsWith(BOTP)) {
            resourceMsg = ResManager.loadKDString((String)"\u5355\u636e\u8f6c\u6362", (String)"GitOperationUtil_39", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
        }
        String showMsg = null;
        if (COMMIT.equals(operateKey)) {
            showMsg = String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5c06%s\u63d0\u4ea4\u5230\u672c\u5730\u4ed3\u5e93\u5417?", (String)"GitOperationUtil_43", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), resourceMsg);
        } else if (PUSH.equals(operateKey)) {
            showMsg = String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5c06\u672c\u5730\u4ed3\u5e93\u91cc\u7684%s\u63a8\u9001\u5230\u8fdc\u7a0b\u4ed3\u5417?", (String)"GitOperationUtil_44", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), resourceMsg);
        } else if (REVERT.equals(operateKey)) {
            showMsg = String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5c06%s\u8fd8\u539f\u81f3\u672c\u5730\u4ed3\u5e93\u7248\u672c\u5417?", (String)"GitOperationUtil_45", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), resourceMsg);
        } else if ("pull".equals(operateKey)) {
            showMsg = ResManager.loadKDString((String)"\u786e\u5b9a\u62c9\u53d6\u8fdc\u7a0b\u4ed3\u5e93\u5e76\u66f4\u65b0\u672c\u5730\u4ed3\u5e93\u5417?", (String)"GitOperationUtil_6", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
        }
        plugin.getView().showConfirm(showMsg, MessageBoxOptions.YesNo, new ConfirmCallBackListener(GIT_OPERATE_CALL_BACK));
    }

    private void handleGitOperateConfirmCallBack() {
        JSONObject gitInfo = JSONObject.parseObject((String)this.getPageCache().get("gitinfo"));
        String id = gitInfo.getString(GITOPERATEID);
        String type = gitInfo.getString(GITOPERATETYPE);
        String operateKey = gitInfo.getString(GITOPERATEKEY);
        String sessionId = gitInfo.getString("gitoperatesessionid");
        this.getPageCache().remove("gitinfo");
        GitAppPluginProxy.beforeGitOperate(operateKey, id, type, sessionId, this.plugin);
    }

    private void handleGitCommitAndPushConfirmBack() {
        String gitContext = this.getPageCache().get("gitContext");
        GitContext context = (GitContext)SerializationUtils.fromJsonString((String)gitContext, GitContext.class);
        context.setOperateKey(PUSH);
        GitOperateHandler handler = new GitOperateHandler();
        handler.handler(context, this.plugin);
    }

    private void handleGitRestoreCallBack(ClosedCallBackEvent e) {
        String msg = (String)e.getReturnData();
        if (SUCCESS.equals(msg)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u5c06\u9009\u62e9\u5143\u6570\u636e\u4ece\u672c\u5730\u4ed3\u5e93\u8fd8\u539f\u81f3\u6570\u636e\u5e93\u3002", (String)"GitAppPluginProxy_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void handleGitCommitNewCallBack(ClosedCallBackEvent e) {
        Map res = (Map)e.getReturnData();
        String gitType = (String)res.get("type");
        String result = (String)res.get("result");
        if ("nochange".equals(result) || "nochange_commitandpush".equals(result)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5185\u5bb9\u6ca1\u6709\u53d8\u5316,\u65e0\u9700\u63d0\u4ea4\u3002", (String)"BizPageListPlugin_17", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (COMMIT.equals(gitType)) {
            if (SUCCESS.equals(result)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"BizPageListPlugin_18", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff1a%s", (String)"GitAppPluginProxy_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), result));
            }
            return;
        }
        if (SUCCESS.equals(result)) {
            String context = (String)res.get("gitContext");
            this.getPageCache().put("gitContext", context);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u6240\u6709\u6587\u4ef6\u5c06\u63a8\u9001\u81f3\u8fdc\u7a0b\u4ed3\u5e93\uff0c\u662f\u5426\u7ee7\u7eed\u63a8\u9001\uff1f", (String)"GitAppPluginProxy_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(GIT_COMMIT_PUSH_CONFIRM_BACK));
        } else {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff1a%s", (String)"GitAppPluginProxy_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), result));
        }
    }

    private void handleGitPushNewCallBack(ClosedCallBackEvent e) {
        Map res = (Map)e.getReturnData();
        String result = (String)res.get("result");
        if (SUCCESS.equals(result)) {
            this.plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63a8\u9001\u6210\u529f\u3002", (String)"GITPushPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else {
            this.plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u63a8\u9001\u5931\u8d25\uff1a%s", (String)"GitAppPluginProxy_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), result));
        }
    }

    private void handleGitPullConflictCallBack(ClosedCallBackEvent e) {
        String res = (String)e.getReturnData();
        if (SUCCESS.equals(res)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u5c06\u51b2\u7a81\u6587\u4ef6\u8fdb\u884c\u63d0\u4ea4\u3002", (String)"GitAppPluginProxy_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void handleGitManagerNew(JSONObject arg) {
        FormShowParameter parameter = new FormShowParameter();
        String bizAppId = arg.getString(BIZAPPID);
        String gitMsg = arg.getString(GITMSG);
        if (StringUtils.isBlank((CharSequence)gitMsg)) {
            gitMsg = arg.getString("svnmsg");
        }
        String bizAppNumber = arg.getString(BIZAPPNUMBER);
        parameter.setFormId("bos_devp_gitmanager_new");
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam(GITMSG, (Object)gitMsg);
        parameter.setCustomParam(BIZAPPNUMBER, (Object)bizAppNumber);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.plugin, GITMANAGECLOSECALLBACK));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    private void handleGitLoginInfoCallBack(String args) {
        JSONObject arg = JSONObject.parseObject((String)args);
        String operateKey = arg.getString("operateKey");
        String bizAppId = arg.getString("bizAppId");
        arg.put(GITOPERATEKEY, (Object)operateKey);
        arg.put(BIZAPPID, (Object)bizAppId);
        this.gitOperate(arg);
    }

    private static void beforeGitOperate(String operateKey, String id, String type, String sessionId, AbstractFormPlugin plugin) {
        DynamicObject gitSetting;
        JSONObject result = GitAppPluginProxy.getBizAppIdAndFileNameByType(type, id);
        String bizAppId = result.getString(BIZAPPID);
        String bizUnitId = result.getString(BIZUNITID);
        GitSettingDao settingDao = new GitSettingDao();
        if (settingDao.isNewGitOperate()) {
            GitOperateHandler handler = new GitOperateHandler();
            GitContext context = new GitContext();
            context.setBizAppId(bizAppId);
            context.setBizUnitId(bizUnitId);
            context.setOperateKey(operateKey);
            context.setId(id);
            context.setType(type);
            context.setSessionId(sessionId);
            handler.handler(context, plugin);
            return;
        }
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            GitAppPluginProxy.showGitLoginPage(operateKey, id, type, plugin, bizAppId, bizUnitId);
            return;
        }
        String userName = plugin.getPageCache().get(USERNAME);
        String passWord = plugin.getPageCache().get(PSD);
        if (StringUtils.isBlank((CharSequence)userName) || StringUtils.isBlank((CharSequence)passWord)) {
            JSONObject cachedLoginInfo = GitAppPluginProxy.getCachedLoginInfo(bizAppId, bizUnitId, sessionId);
            if (cachedLoginInfo == null || StringUtils.isBlank((CharSequence)cachedLoginInfo.getString(USERNAME)) || StringUtils.isBlank((CharSequence)cachedLoginInfo.getString(PSD))) {
                GitAppPluginProxy.showGitLoginPage(operateKey, id, type, plugin, bizAppId, bizUnitId);
                return;
            }
            userName = cachedLoginInfo.getString(USERNAME);
            passWord = cachedLoginInfo.getString(PSD);
        }
        if ((gitSetting = GitOperationUtil.getGitSetting((String)bizAppId, (String)bizUnitId, (String)userName)) == null) {
            String appNumber = MetadataDao.getAppNumberByAppId((String)bizAppId);
            plugin.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528[%s]\u6ca1\u6709\u914dgit\u5730\u5740\uff0c\u8bf7\u5148\u5230\u5e94\u7528\u5361\u7247\u4e0a\u914d\u7f6e\u3002", (String)"GitOperationUtil_7", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), appNumber));
            return;
        }
        String gitUrl = gitSetting.getString(GITURL);
        if (StringUtils.isBlank((CharSequence)gitUrl)) {
            plugin.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528git\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5230\u5e94\u7528\u5361\u7247\u4e0a\u914d\u7f6e\u3002", (String)"GitOperationUtil_8", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            return;
        }
        String gitRepository = gitSetting.getString(GITREPOSITORY);
        if (StringUtils.isBlank((CharSequence)gitRepository)) {
            plugin.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u4ed3\u5e93\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5230\u5e94\u7528\u5361\u7247\u4e0a\u914d\u7f6e\u3002", (String)"GitOperationUtil_9", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            return;
        }
        String gitBranch = gitSetting.getString(GITBRANCH);
        if (StringUtils.isBlank((CharSequence)gitBranch)) {
            plugin.getView().showMessage(ResManager.loadKDString((String)"Git\u8fdc\u7a0b\u5206\u652f\u672a\u914d\u7f6e\u3002", (String)"GitOperationUtil_41", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            return;
        }
        String gitRootpath = gitSetting.getString(GITROOTPATH);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getUserId(), (String)"bos_user", (String)"phone");
        String phoneNumber = dynamicObject.getString("phone");
        String personalGitRepository = gitRepository + File.separator + phoneNumber + File.separator + RequestContext.get().getAccountId() + File.separator + userName;
        GitOperationUtil.gitOperate((String)bizAppId, (String)gitUrl, (String)gitRepository, (String)gitBranch, (String)gitRootpath, (String)personalGitRepository, (String)userName, (String)passWord, (String)operateKey, (String)id, (String)type, (AbstractFormPlugin)plugin);
    }

    private static void showGitLoginPage(String operateKey, String id, String type, AbstractFormPlugin plugin, String bizAppId, String bizUnitId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devp_gitlogin");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "gitlogincallback"));
        parameter.setCustomParam(GITOPERATEKEY, (Object)operateKey);
        parameter.setCustomParam(GITOPERATEID, (Object)id);
        parameter.setCustomParam(GITOPERATETYPE, (Object)type);
        parameter.setCustomParam(GITMSG, (Object)UUID.randomUUID().toString());
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam(BIZUNITID, (Object)bizUnitId);
        plugin.getView().showForm(parameter);
    }

    private static JSONObject getCachedLoginInfo(String sessionId, String bizAppId, String bizUnitId) {
        String sessionKey;
        SessionDAO sessionDao;
        String attribute;
        if (StringUtils.isNotBlank((CharSequence)sessionId) && StringUtils.isNotBlank((CharSequence)(attribute = (sessionDao = SessionDAOFactory.getSessionDAO((String)sessionId)).getAttribute(sessionKey = GitOperationUtil.getSessionKeyByApp((String)bizAppId, (String)bizUnitId, (String)sessionId))))) {
            return JSONObject.parseObject((String)attribute);
        }
        String username = SessionManager.getCurrent().get(GitOperationUtil.getSessionByRequestContext() + GIT_USERNAME);
        String password = SessionManager.getCurrent().get(GitOperationUtil.getSessionByRequestContext() + GIT_PSD);
        JSONObject r = new JSONObject();
        r.put(USERNAME, (Object)username);
        r.put(PSD, (Object)password);
        return r;
    }

    private static JSONObject getBizAppIdAndFileNameByType(String type, String id) {
        JSONObject result = new JSONObject();
        String bizAppId = null;
        String fileNumber = null;
        String bizUnitId = null;
        if (SCRIPT.equalsIgnoreCase(type)) {
            DynamicObject scriptObject = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)IDE_PLUGINSCRIPT, (String)"txt_scriptnumber,bizappid");
            bizAppId = scriptObject.getString(BIZAPPID);
            fileNumber = scriptObject.getString(TXT_SCRIPT_NUMBER) + SCRIPT_SUFFIX;
        } else if ("page".equalsIgnoreCase(type)) {
            fileNumber = MetadataDao.getNumberById((String)id) + ".dym";
            bizAppId = MetadataDao.getAppIdByFormId((String)id);
            bizUnitId = MetadataDao.getUnitIdFromUnitrel((String)id);
            if (StringUtils.isEmpty((CharSequence)bizAppId)) {
                QFilter qFormId = new QFilter("form", "=", (Object)id);
                DynamicObject pageRelInfo = QueryServiceHelper.queryOne((String)UNIT_REF_FORM_NUMBER, (String)"bizapp,bizunit", (QFilter[])new QFilter[]{qFormId});
                bizAppId = pageRelInfo.getString(BIZAPP);
                bizUnitId = pageRelInfo.getString(BIZ_UNIT);
            }
        } else if ("app".equalsIgnoreCase(type)) {
            bizAppId = id;
            fileNumber = BusinessDataServiceHelper.loadSingle((Object)bizAppId, (String)BIZ_APP_NUMBER, (String)"number").getString("number") + ".app";
        } else if ("cloud".equalsIgnoreCase(type)) {
            DynamicObject cloudObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bos_devportal_bizcloud", (String)"baseapp");
            bizAppId = cloudObject.getString("baseapp_id");
        } else if (type.startsWith(BOTP)) {
            bizAppId = id;
        } else if ("dataModel".equals(type)) {
            bizAppId = id;
        }
        result.put(BIZAPPID, (Object)bizAppId);
        result.put(FILENAME, (Object)fileNumber);
        result.put(BIZUNITID, (Object)bizUnitId);
        return result;
    }
}

