/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.git.proxy;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.business.git.GitContext;
import kd.bos.devportal.business.git.GitOperateHandler;
import kd.bos.devportal.business.git.GitOperationUtils;
import kd.bos.devportal.business.git.GitSaveFileHandler;
import kd.bos.devportal.business.git.GitSettingDao;
import kd.bos.devportal.business.hosting.GitOperationUtil;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;

public class GitPagePluginProxy {
    private static final String PROJECTURL = "projecturl";
    private static final String KEY_GITURL = "giturl";
    private static final String GITREPOSITORY = "gitrepository";
    private static final String PERSONALGITREPOSITORY = "personalgitrepository";
    private static final String USERNAME = "username";
    private static final String P = "password";
    private static final String GITOPERATEKEY = "gitoperatekey";
    private static final String GITOPERATEID = "gitoperateid";
    private static final String GITOPERATETYPE = "gitoperatetype";
    private static final String KEY_SUCCESS = "success";
    private static final String GITMSG = "gitmsg";
    private static final String ISCHECKED = "ischecked";
    public static final String BOTP = "botp";
    public static final String BOTP_ConvertRule = "botp_cr";
    public static final String BOTP_WriteBackRule = "botp_wb";
    public static final String BOTP_BalanceUpdateRule = "botp_bur";
    public static final String BIZAPPID = "bizappid";
    public static final String BIZUNITID = "bizunitid";
    public static final String GITURL = "giturl";
    public static final String GITBRANCH = "gitbranch";
    public static final String GITROOTPATH = "gitrootpath";
    public static final String PSD = "password";
    public static final String IDE_PLUGINSCRIPT = "ide_pluginscript";
    private static final String BIZAPPNUMBER = "bizappnumber";
    public static final String GIT_USERNAME = "gitusername";
    public static final String GIT_PSD = "gitpassword";
    private static final String BIZ_APP_NUMBER = "bos_devportal_bizapp";
    private static final String UNIT_REF_FORM_NUMBER = "bos_devportal_unitrelform";
    private static final String BIZ_UNIT = "bizunit";
    private static final String BIZAPP = "bizapp";
    private static final String FILENAME = "filename";
    private static final String GIT_OPERATE = "gitOperate";
    private static final String GIT_OPERATE_CONFIRM_CALLBACK = "gitOperateConfirmCallBack";
    private static final String GIT_CONFLICT_CONFIRM_CALLBACK = "gitConflictConfirmCallBack";
    private static final String GIT_LOGIN_CALLBACK = "gitLoginCallback";
    private static final String GIT_COMMIT_CALLBACK = "gitCommitCallback";
    private static final String GIT_UPDATE_CALLBACK = "gitUpdateCallback";
    private static final String GIT_DELETE = "gitDelete";
    private static final String GIT_COMMIT_NEW_CALLBACK = "gitCommitNewCallBack";
    private static final String GIT_PUSH_NEW_CALLBACK = "gitPushNewCallBack";
    private static final String GIT_COMMIT_PUSH_CONFIRM_BACK = "gitCommitAndPushConfirmBack";
    private static final String GIT_PULL_UPDATEMETA_CALL_BACK = "gitPullUpdateMetaCallBack";
    private static final String GIT_RESTORE_CALL_BACK = "gitRestoreCallBack";
    private static final String GIT_PULL_CONFLICT_CALLBACK = "gitPullConflictCallBack";
    private static final String GIT_LOGIN_INFO_CALLBACK = "gitLoginInfoCallBack";
    private static final String GIT_MANAGER_NEW = "gitManagerNew";
    private static final String COMMIT = "commit";
    private static final String REVERT = "revert";
    private static final String PUSH = "push";
    private static final String LOG = "log";
    private static final String SUCCESS = "success";
    private static final String BOS_DEVPORTAL_BUSINESS = "bos-devportal-business";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private AbstractFormPlugin plugin;

    private GitPagePluginProxy(AbstractFormPlugin plugin) {
        this.plugin = plugin;
    }

    public static GitPagePluginProxy getProxy(AbstractFormPlugin plugin) {
        return new GitPagePluginProxy(plugin);
    }

    private IPageCache getPageCache() {
        return this.plugin.getPageCache();
    }

    private IFormView getView() {
        return this.plugin.getView();
    }

    public void invoke(String methodName, Object ... args) {
        switch (methodName) {
            case "gitOperate": {
                this.gitOperate((JSONObject)args[0]);
                break;
            }
            case "gitManagerNew": {
                this.handleGitManagerNew((JSONObject)args[0]);
                break;
            }
            case "gitOperateConfirmCallBack": {
                this.gitOperateConfirmCallBack();
                break;
            }
            case "gitConflictConfirmCallBack": {
                this.gitConflictConfirmCallBack((MessageBoxClosedEvent)args[0]);
                break;
            }
            case "gitLoginCallback": {
                this.gitLoginCallback((ClosedCallBackEvent)args[0]);
                break;
            }
            case "gitCommitCallback": {
                this.gitCommitCallback((ClosedCallBackEvent)args[0]);
                break;
            }
            case "gitUpdateCallback": {
                this.gitUpdateCallback((ClosedCallBackEvent)args[0]);
                break;
            }
            case "gitDelete": {
                this.gitDelete((String)args[0], (String)args[1]);
                break;
            }
            case "gitCommitNewCallBack": {
                this.handleGitCommitNewCallBack((ClosedCallBackEvent)args[0]);
                break;
            }
            case "gitPullUpdateMetaCallBack": {
                this.handleGitPullUpdateMetaCallBack((ClosedCallBackEvent)args[0]);
                break;
            }
            case "gitCommitAndPushConfirmBack": {
                this.handleGitCommitAndPushConfirmBack();
                break;
            }
            case "gitRestoreCallBack": {
                this.handleGitRestoreCallBack((ClosedCallBackEvent)args[0]);
                break;
            }
            case "gitPushNewCallBack": {
                this.handleGitPushNewCallBack((ClosedCallBackEvent)args[0]);
                break;
            }
            case "gitPullConflictCallBack": {
                this.handleGitPullConflictCallBack((ClosedCallBackEvent)args[0]);
                break;
            }
            case "gitLoginInfoCallBack": {
                this.handlerGitLoginInfoCallBack((String)args[0]);
                break;
            }
        }
    }

    private void gitOperate(JSONObject arg) {
        GitSettingDao dao;
        String sessionId = arg.getString(GITMSG);
        String type = arg.getString("type");
        String id = arg.getString("id");
        String operateKey = arg.getString(GITOPERATEKEY);
        if ((REVERT.equals(operateKey) || PUSH.equals(operateKey) || LOG.equals(operateKey) || COMMIT.equals(operateKey)) && (dao = new GitSettingDao()).isNewGitOperate()) {
            GitOperateHandler handler = new GitOperateHandler();
            GitContext context = new GitContext();
            context.setId(id);
            context.setType(type);
            context.setOperateKey(operateKey);
            context.setSessionId(sessionId);
            BizAppServiceHelp.getBizAppByFormID((String)id);
            handler.handler(context, this.plugin);
            return;
        }
        GitPagePluginProxy.gitConfirmOperate(id, type, operateKey, sessionId, this.plugin);
    }

    private void handleGitManagerNew(JSONObject arg) {
        FormShowParameter parameter = new FormShowParameter();
        String bizAppId = arg.getString(BIZAPPID);
        String bizAppNumber = AppMetadataCache.getAppNumberById((String)bizAppId);
        String gitMsg = arg.getString(GITMSG);
        String bizUnitId = arg.getString(BIZUNITID);
        if (StringUtils.isBlank((CharSequence)gitMsg)) {
            gitMsg = arg.getString("svnmsg");
        }
        parameter.setFormId("bos_devp_gitmanager_new");
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam(GITMSG, (Object)gitMsg);
        parameter.setCustomParam(BIZUNITID, (Object)bizUnitId);
        parameter.setCustomParam(BIZAPPNUMBER, (Object)bizAppNumber);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    private void handleGitCommitAndPushConfirmBack() {
        String gitContext = this.getPageCache().get("gitContext");
        GitContext context = (GitContext)SerializationUtils.fromJsonString((String)gitContext, GitContext.class);
        context.setOperateKey(PUSH);
        GitOperateHandler handler = new GitOperateHandler();
        handler.handler(context, this.plugin);
    }

    private void handleGitRestoreCallBack(ClosedCallBackEvent e) {
        String msg = (String)e.getReturnData();
        if ("success".equals(msg)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u5c06\u9009\u62e9\u5143\u6570\u636e\u4ece\u672c\u5730\u4ed3\u5e93\u8fd8\u539f\u81f3\u6570\u636e\u5e93\u3002", (String)"GitAppPluginProxy_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    static void gitConfirmOperate(String id, String type, String operateKey, String sessionId, AbstractFormPlugin plugin) {
        JSONObject gitInfo = new JSONObject();
        gitInfo.put(GITOPERATEID, (Object)id);
        gitInfo.put(GITOPERATETYPE, (Object)type);
        gitInfo.put(GITOPERATEKEY, (Object)operateKey);
        gitInfo.put("gitoperatesessionid", (Object)sessionId);
        plugin.getPageCache().put("gitinfo", gitInfo.toJSONString());
        String resourceMsg = null;
        if (COMMIT.equalsIgnoreCase(type)) {
            resourceMsg = ResManager.loadKDString((String)"\u811a\u672c", (String)"GitOperationUtil_0", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
        } else if ("page".equalsIgnoreCase(type)) {
            resourceMsg = ResManager.loadKDString((String)"\u9875\u9762", (String)"GitOperationUtil_1", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
        } else if ("app".equalsIgnoreCase(type)) {
            resourceMsg = ResManager.loadKDString((String)"\u5e94\u7528", (String)"GitOperationUtil_38", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
        } else if ("cloud".equalsIgnoreCase(type)) {
            resourceMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91", (String)"GitOperationUtil_42", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
        } else if (type.startsWith(BOTP)) {
            resourceMsg = ResManager.loadKDString((String)"\u5355\u636e\u8f6c\u6362", (String)"GitOperationUtil_39", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
        }
        String showMsg = null;
        if (COMMIT.equals(operateKey)) {
            showMsg = String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5c06%s\u63d0\u4ea4\u5230\u672c\u5730\u4ed3\u5e93\u5417?", (String)"GitOperationUtil_43", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), resourceMsg);
        } else if (PUSH.equals(operateKey)) {
            showMsg = String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5c06\u672c\u5730\u4ed3\u5e93\u91cc\u7684%s\u63a8\u9001\u5230\u8fdc\u7a0b\u4ed3\u5417?", (String)"GitOperationUtil_44", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), resourceMsg);
        } else if (REVERT.equals(operateKey)) {
            showMsg = String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5c06%s\u8fd8\u539f\u81f3\u672c\u5730\u4ed3\u5e93\u7248\u672c\u5417?", (String)"GitOperationUtil_45", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), resourceMsg);
        } else if ("pull".equals(operateKey)) {
            showMsg = ResManager.loadKDString((String)"\u786e\u5b9a\u62c9\u53d6\u8fdc\u7a0b\u4ed3\u5e93\u5e76\u66f4\u65b0\u672c\u5730\u4ed3\u5e93\u5417?", (String)"GitOperationUtil_6", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]);
        }
        plugin.getView().showConfirm(showMsg, MessageBoxOptions.YesNo, new ConfirmCallBackListener("gitOperateCallBack"));
    }

    private void gitOperateConfirmCallBack() {
        JSONObject gitInfo = JSONObject.parseObject((String)this.getPageCache().get("gitinfo"));
        String id = gitInfo.getString(GITOPERATEID);
        String type = gitInfo.getString(GITOPERATETYPE);
        String operateKey = gitInfo.getString(GITOPERATEKEY);
        String sessionId = gitInfo.getString("gitoperatesessionid");
        this.getPageCache().remove("gitinfo");
        GitSettingDao settingDao = new GitSettingDao();
        if (settingDao.isNewGitOperate()) {
            GitOperateHandler handler = new GitOperateHandler();
            GitContext context = new GitContext();
            context.setId(id);
            context.setType(type);
            context.setOperateKey(operateKey);
            context.setSessionId(sessionId);
            BizAppServiceHelp.getBizAppByFormID((String)id);
            handler.handler(context, this.plugin);
            return;
        }
        GitPagePluginProxy.beforeGitOperate(operateKey, id, type, sessionId, this.plugin);
    }

    private void gitConflictConfirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            String projectURL = this.getPageCache().get(PROJECTURL);
            String gitUrl = this.getPageCache().get("giturl");
            String gitRepository = this.getPageCache().get(GITREPOSITORY);
            String gitbranch = this.getPageCache().get(GITBRANCH);
            String gitrootpath = this.getPageCache().get(GITROOTPATH);
            String bizAppId = this.getPageCache().get(BIZAPPID);
            String personalGitRepository = this.getPageCache().get(PERSONALGITREPOSITORY);
            String arr = this.getPageCache().get("arr");
            String userName = this.getPageCache().get(USERNAME);
            String passWord = this.getPageCache().get("password");
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("bos_devp_gitresolve");
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.plugin, "gitpushcallback"));
            parameter.setCustomParam("giturl", (Object)gitUrl);
            parameter.setCustomParam(GITREPOSITORY, (Object)gitRepository);
            parameter.setCustomParam(GITBRANCH, (Object)gitbranch);
            parameter.setCustomParam(GITROOTPATH, (Object)gitrootpath);
            parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
            parameter.setCustomParam(PERSONALGITREPOSITORY, (Object)personalGitRepository);
            parameter.setCustomParam(PROJECTURL, (Object)projectURL);
            parameter.setCustomParam("filearr", (Object)arr);
            parameter.setCustomParam(USERNAME, (Object)userName);
            parameter.setCustomParam("password", (Object)passWord);
            this.getView().showForm(parameter);
            this.getPageCache().remove(PROJECTURL);
            this.getPageCache().remove("giturl");
            this.getPageCache().remove(GITREPOSITORY);
            this.getPageCache().remove(PERSONALGITREPOSITORY);
            this.getPageCache().remove("arr");
            this.getPageCache().remove(USERNAME);
            this.getPageCache().remove("password");
        } else {
            String operateKey;
            String errorMsg = null;
            switch (operateKey = this.getPageCache().get(GITOPERATEKEY)) {
                case "commit": {
                    errorMsg = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25", (String)"BizPageListPlugin_71", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
                    break;
                }
                case "push": {
                    errorMsg = ResManager.loadKDString((String)"\u63a8\u9001\u5931\u8d25", (String)"BizPageListPlugin_72", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
                    break;
                }
                case "update": {
                    errorMsg = ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25", (String)"BizPageListPlugin_73", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
                    break;
                }
                case "revert": {
                    errorMsg = "";
                    break;
                }
            }
            errorMsg = errorMsg + ResManager.loadKDString((String)"\u4ed3\u5e93\u5b58\u5728\u51b2\u7a81\u3002", (String)"BizPageListPlugin_74", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
        }
    }

    private void gitLoginCallback(ClosedCallBackEvent event) {
        JSONObject sourceMsg = JSONObject.parseObject((String)((String)event.getReturnData()));
        String userName = sourceMsg.getString(USERNAME);
        String passWord = sourceMsg.getString("password");
        String sessionId = sourceMsg.getString(GITMSG);
        String gitUrl = sourceMsg.getString("giturl");
        String gitOperateKey = sourceMsg.getString(GITOPERATEKEY);
        String gitOperateId = sourceMsg.getString(GITOPERATEID);
        String gitOperateType = sourceMsg.getString(GITOPERATETYPE);
        String gitRepository = sourceMsg.getString(GITREPOSITORY);
        String gitBranch = sourceMsg.getString(GITBRANCH);
        String gitRootpath = sourceMsg.getString(GITROOTPATH);
        String bizAppId = sourceMsg.getString(BIZAPPID);
        String personalGitRepository = sourceMsg.getString(PERSONALGITREPOSITORY);
        GitOperationUtil.gitOperate((String)bizAppId, (String)gitUrl, (String)gitRepository, (String)gitBranch, (String)gitRootpath, (String)personalGitRepository, (String)userName, (String)passWord, (String)gitOperateKey, (String)gitOperateId, (String)gitOperateType, (AbstractFormPlugin)this.plugin);
        Boolean isChecked = sourceMsg.getBoolean(ISCHECKED);
        if (isChecked.booleanValue()) {
            JSONObject saveGitMsg = new JSONObject();
            saveGitMsg.put("sessionid", (Object)sessionId);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("SAVE_GIT_SESSIONID", (Object)saveGitMsg);
        }
    }

    private void gitCommitCallback(ClosedCallBackEvent event) {
        JSONObject returnResult = JSONObject.parseObject((String)event.getReturnData().toString());
        String result = returnResult.getString("result");
        if ("nochange".equals(result) || "nochange_commitandpush".equals(result)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5185\u5bb9\u6ca1\u6709\u53d8\u5316,\u65e0\u9700\u63d0\u4ea4\u3002", (String)"BizPageListPlugin_17", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if ("success".equals(result)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"BizPageListPlugin_18", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if ("success_commitandpush".equals(result)) {
            JSONArray fileArray = new JSONArray();
            String gitUrl = returnResult.getString("giturl");
            String personalGitRepository = returnResult.getString(PERSONALGITREPOSITORY);
            String id = returnResult.getString("id");
            String type = returnResult.getString("type");
            String userName = returnResult.getString(USERNAME);
            String passWord = returnResult.getString("password");
            String gitBranch = returnResult.getString(GITBRANCH);
            String gitRootpath = returnResult.getString(GITROOTPATH);
            String bizAppId = returnResult.getString(BIZAPPID);
            Boolean flag = GitOperationUtil.beforePush((JSONArray)fileArray, (String)gitUrl, (String)personalGitRepository, (String)gitBranch, (String)gitRootpath, (String)id, (String)type, (AbstractFormPlugin)this.plugin, (String)userName, (String)passWord);
            if (flag.booleanValue()) {
                String gitRepository = returnResult.getString(GITREPOSITORY);
                String projectURL = returnResult.getString(PROJECTURL);
                GitOperationUtil.push((String)bizAppId, (String)gitUrl, (String)gitRepository, (String)personalGitRepository, (String)gitBranch, (String)gitRootpath, (String)projectURL, (String)userName, (String)passWord, (String)type, (AbstractFormPlugin)this.plugin, (JSONArray)fileArray);
            }
        } else {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff1a%s", (String)"GitAppPluginProxy_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), result));
        }
    }

    private void gitUpdateCallback(ClosedCallBackEvent event) {
        JSONObject result = (JSONObject)event.getReturnData();
        String gitOperateKey = result.getString(GITOPERATEKEY);
        String gitOperateId = result.getString(GITOPERATEID);
        String gitOperateType = result.getString(GITOPERATETYPE);
        String gitmsg = result.getString(GITMSG);
        GitPagePluginProxy.beforeGitOperate(gitOperateKey, gitOperateId, gitOperateType, gitmsg, this.plugin);
    }

    private void gitDelete(String formId, String jsessionid) {
        GitOperationUtil.delete((String)"delete", (String)formId, (String)"page", (AbstractFormPlugin)this.plugin, (String)jsessionid);
    }

    private void handleGitCommitNewCallBack(ClosedCallBackEvent e) {
        Map res = (Map)e.getReturnData();
        String gitType = (String)res.get("type");
        String result = (String)res.get("result");
        if ("nochange".equals(result) || "nochange_commitandpush".equals(result)) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u5185\u5bb9\u6ca1\u6709\u53d8\u5316,\u65e0\u9700\u63d0\u4ea4\u3002", (String)"BizPageListPlugin_17", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (COMMIT.equals(gitType)) {
            if ("success".equals(result)) {
                this.plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"BizPageListPlugin_18", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            } else {
                this.plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff1a%s", (String)"GitAppPluginProxy_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), result));
            }
            return;
        }
        if ("success".equals(result)) {
            String context = (String)res.get("gitContext");
            this.plugin.getPageCache().put("gitContext", context);
            this.plugin.getView().showConfirm(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u6240\u6709\u6587\u4ef6\u5c06\u63a8\u9001\u81f3\u8fdc\u7a0b\u4ed3\u5e93\uff0c\u662f\u5426\u7ee7\u7eed\u63a8\u9001\uff1f", (String)"GitAppPluginProxy_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(GIT_COMMIT_PUSH_CONFIRM_BACK));
        } else {
            this.plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff1a%s", (String)"GitAppPluginProxy_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), result));
        }
    }

    private void handleGitPushNewCallBack(ClosedCallBackEvent e) {
        Map res = (Map)e.getReturnData();
        String result = (String)res.get("result");
        if ("success".equals(result)) {
            this.plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63a8\u9001\u6210\u529f\u3002", (String)"GITPushPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else {
            this.plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u63a8\u9001\u5931\u8d25\uff1a%s", (String)"GitAppPluginProxy_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), result));
        }
    }

    private void handleGitPullConflictCallBack(ClosedCallBackEvent e) {
        String res = (String)e.getReturnData();
        if ("success".equals(res)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u5c06\u51b2\u7a81\u6587\u4ef6\u8fdb\u884c\u63d0\u4ea4\u3002", (String)"GitAppPluginProxy_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void handlerGitLoginInfoCallBack(String args) {
        JSONObject arg = JSONObject.parseObject((String)args);
        String operateKey = arg.getString("operateKey");
        arg.put(GITOPERATEKEY, (Object)operateKey);
        this.gitOperate(arg);
    }

    private void handleGitPullUpdateMetaCallBack(ClosedCallBackEvent e) {
        String gitContext = (String)e.getReturnData();
        GitContext context = (GitContext)SerializationUtils.fromJsonString((String)gitContext, GitContext.class);
        if (context.getPullUpdate()) {
            GitOperationUtils.updateMetadata((GitContext)context, (AbstractFormPlugin)this.plugin);
        }
        if (context.isExportToLocal()) {
            GitSaveFileHandler saveFileHandler = new GitSaveFileHandler();
            saveFileHandler.handler(context, this.plugin);
        }
    }

    private static void beforeGitOperate(String operateKey, String id, String type, String sessionId, AbstractFormPlugin plugin) {
        DynamicObject gitSetting;
        JSONObject result = GitPagePluginProxy.getBizAppIdAndFileNameByType(type, id);
        String bizAppId = result.getString(BIZAPPID);
        String bizUnitId = result.getString(BIZUNITID);
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            GitPagePluginProxy.showGitLoginPage(operateKey, id, type, plugin, bizAppId, bizUnitId);
            return;
        }
        String userName = plugin.getPageCache().get(USERNAME);
        String passWord = plugin.getPageCache().get("password");
        if (StringUtils.isBlank((CharSequence)userName) || StringUtils.isBlank((CharSequence)passWord)) {
            JSONObject cachedLoginInfo = GitPagePluginProxy.getCachedLoginInfo(bizAppId, bizUnitId, sessionId);
            if (cachedLoginInfo == null || StringUtils.isBlank((CharSequence)cachedLoginInfo.getString(USERNAME)) || StringUtils.isBlank((CharSequence)cachedLoginInfo.getString("password"))) {
                GitPagePluginProxy.showGitLoginPage(operateKey, id, type, plugin, bizAppId, bizUnitId);
                return;
            }
            userName = cachedLoginInfo.getString(USERNAME);
            passWord = cachedLoginInfo.getString("password");
        }
        if ((gitSetting = GitOperationUtil.getGitSetting((String)bizAppId, (String)bizUnitId, (String)userName)) == null) {
            String appNumber = MetadataDao.getAppNumberByAppId((String)bizAppId);
            plugin.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528[%s]\u6ca1\u6709\u914dgit\u5730\u5740\uff0c\u8bf7\u5148\u5230\u5e94\u7528\u5361\u7247\u4e0a\u914d\u7f6e\u3002", (String)"GitOperationUtil_7", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]), appNumber));
            return;
        }
        String gitUrl = gitSetting.getString("giturl");
        if (StringUtils.isBlank((CharSequence)gitUrl)) {
            plugin.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528git\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5230\u5e94\u7528\u5361\u7247\u4e0a\u914d\u7f6e\u3002", (String)"GitOperationUtil_8", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            return;
        }
        String gitRepository = gitSetting.getString(GITREPOSITORY);
        if (StringUtils.isBlank((CharSequence)gitRepository)) {
            plugin.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u4ed3\u5e93\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5230\u5e94\u7528\u5361\u7247\u4e0a\u914d\u7f6e\u3002", (String)"GitOperationUtil_9", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            return;
        }
        String gitBranch = gitSetting.getString(GITBRANCH);
        if (StringUtils.isBlank((CharSequence)gitBranch)) {
            plugin.getView().showMessage(ResManager.loadKDString((String)"Git\u8fdc\u7a0b\u5206\u652f\u672a\u914d\u7f6e\u3002", (String)"GitOperationUtil_41", (String)BOS_DEVPORTAL_BUSINESS, (Object[])new Object[0]));
            return;
        }
        String gitRootpath = gitSetting.getString(GITROOTPATH);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getUserId(), (String)"bos_user", (String)"phone");
        String phoneNumber = dynamicObject.getString("phone");
        String personalGitRepository = gitRepository + File.separator + phoneNumber + File.separator + RequestContext.get().getAccountId() + File.separator + userName;
        GitOperationUtil.gitOperate((String)bizAppId, (String)gitUrl, (String)gitRepository, (String)gitBranch, (String)gitRootpath, (String)personalGitRepository, (String)userName, (String)passWord, (String)operateKey, (String)id, (String)type, (AbstractFormPlugin)plugin);
    }

    static JSONObject getBizAppIdAndFileNameByType(String type, String id) {
        JSONObject result = new JSONObject();
        String bizAppId = null;
        String fileNumber = null;
        String bizUnitId = null;
        if ("page".equalsIgnoreCase(type)) {
            fileNumber = MetadataDao.getNumberById((String)id) + ".dym";
            bizAppId = MetadataDao.getAppIdByFormId((String)id);
            bizUnitId = MetadataDao.getUnitIdFromUnitrel((String)id);
            if (StringUtils.isEmpty((CharSequence)bizAppId)) {
                QFilter qFormId = new QFilter("form", "=", (Object)id);
                DynamicObject pageRelInfo = QueryServiceHelper.queryOne((String)UNIT_REF_FORM_NUMBER, (String)"bizapp,bizunit", (QFilter[])new QFilter[]{qFormId});
                bizAppId = pageRelInfo.getString(BIZAPP);
                bizUnitId = pageRelInfo.getString(BIZ_UNIT);
            }
        } else if ("app".equalsIgnoreCase(type)) {
            bizAppId = id;
            fileNumber = BusinessDataServiceHelper.loadSingle((Object)bizAppId, (String)BIZ_APP_NUMBER, (String)"number").getString("number") + ".app";
        }
        result.put(BIZAPPID, (Object)bizAppId);
        result.put(FILENAME, (Object)fileNumber);
        result.put(BIZUNITID, (Object)bizUnitId);
        return result;
    }

    private static void showGitLoginPage(String operateKey, String id, String type, AbstractFormPlugin plugin, String bizAppId, String bizUnitId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devp_gitlogin");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "gitlogincallback"));
        parameter.setCustomParam(GITOPERATEKEY, (Object)operateKey);
        parameter.setCustomParam(GITOPERATEID, (Object)id);
        parameter.setCustomParam(GITOPERATETYPE, (Object)type);
        parameter.setCustomParam(GITMSG, (Object)UUID.randomUUID().toString());
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam(BIZUNITID, (Object)bizUnitId);
        plugin.getView().showForm(parameter);
    }

    private static JSONObject getCachedLoginInfo(String sessionId, String bizAppId, String bizUnitId) {
        String sessionKey;
        SessionDAO sessionDao;
        String attribute;
        if (StringUtils.isNotBlank((CharSequence)sessionId) && StringUtils.isNotBlank((CharSequence)(attribute = (sessionDao = SessionDAOFactory.getSessionDAO((String)sessionId)).getAttribute(sessionKey = GitOperationUtil.getSessionKeyByApp((String)bizAppId, (String)bizUnitId, (String)sessionId))))) {
            return JSONObject.parseObject((String)attribute);
        }
        String username = SessionManager.getCurrent().get(GitOperationUtil.getSessionByRequestContext() + GIT_USERNAME);
        String password = SessionManager.getCurrent().get(GitOperationUtil.getSessionByRequestContext() + GIT_PSD);
        JSONObject r = new JSONObject();
        r.put(USERNAME, (Object)username);
        r.put("password", (Object)password);
        return r;
    }
}

