/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.metamerge;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.metamerge.CheckItem;
import kd.bos.devportal.metamerge.MergeCheck;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.metadata.devportal.AppMetadata;

public class AppMetadataCheck
implements MergeCheck {
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";

    @Override
    public List<CheckItem> check(AppMetadata appMetadata, AppMetadata oldAppMetadata) {
        ArrayList<CheckItem> checkItems = new ArrayList<CheckItem>(1);
        CheckItem item = new CheckItem();
        item.setName(ResManager.loadKDString((String)"\u7236\u5b50\u5173\u7cfb\u5b8c\u6574\u6027", (String)"DefaultCheck_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        item.setDescription(ResManager.loadKDString((String)"\u7236\u5b50\u5173\u7cfb\u5b8c\u6574\u6027\u68c0\u67e5\uff0c\u5982\u7236\u7ea7\u83dc\u5355\u88ab\u5220\u9664\uff0c\u5b50\u7ea7\u83dc\u5355\u8fd8\u5b58\u5728", (String)"AppMetadataCheck_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        this.checkMenu(item, appMetadata, oldAppMetadata);
        this.checkFunction(item, appMetadata, oldAppMetadata);
        checkItems.add(item);
        return checkItems;
    }

    private void checkMenu(CheckItem item, AppMetadata appMetadata, AppMetadata oldAppMetadata) {
        List appMenus = appMetadata.getAppMenus();
        Map mapMenus = appMetadata.getMapMenus();
        for (AppMenuElement element : appMenus) {
            String id;
            String parentId;
            AppMenuElement parentMenu;
            if (!StringUtils.isNotBlank((CharSequence)element.getParentId()) || (parentMenu = (AppMenuElement)mapMenus.get(parentId = element.getParentId())) != null || (id = appMetadata.getAppElement().getId()) == null || id.equals(parentId) || this.checkParentMenu(parentId, oldAppMetadata)) continue;
            String name = element.getName().getLocaleValue();
            item.setStatus(false);
            String info = String.format(ResManager.loadKDString((String)"\u83dc\u5355\u201c%1$s\u201d\uff08%2$s\uff09\u7684\u7236\u7ea7\u83dc\u5355\u4e0d\u5b58\u5728%3$s\u3002", (String)"AppMetadataCheck_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), name, element.getNumber(), "\r\n");
            String detail = item.getDetail();
            detail = StringUtils.isNotBlank((CharSequence)detail) ? detail + info : info;
            item.setDetail(detail);
        }
    }

    private void checkFunction(CheckItem item, AppMetadata appMetadata, AppMetadata oldAppMetadata) {
        List functionPackets = appMetadata.getAppFunctionPackets();
        Map mapFunctions = appMetadata.getMapFuncs();
        for (AppFunctionPacketElement element : functionPackets) {
            String id;
            String parentId;
            AppFunctionPacketElement parentFunc;
            if (!StringUtils.isNotBlank((CharSequence)element.getParentId()) || (parentFunc = (AppFunctionPacketElement)mapFunctions.get(parentId = element.getParentId())) != null || (id = appMetadata.getAppElement().getId()) == null || id.equals(parentId) || this.checkParentFunc(parentId, oldAppMetadata)) continue;
            String name = element.getName().getLocaleValue();
            item.setStatus(false);
            String info = String.format(ResManager.loadKDString((String)"\u5206\u7ec4\u201c%1$s\u201d\uff08%2$s\uff09\u7684\u7236\u7ea7\u5206\u7ec4\u4e0d\u5b58\u5728%3$s\u3002", (String)"AppMetadataCheck_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), name, element.getNumber(), "\r\n");
            String detail = item.getDetail();
            detail = StringUtils.isNotBlank((CharSequence)detail) ? detail + info : info;
            item.setDetail(detail);
        }
    }

    private boolean checkParentMenu(String parentId, AppMetadata oldAppMetadata) {
        if (oldAppMetadata == null) {
            return false;
        }
        Map mapMenus = oldAppMetadata.getMapMenus();
        AppMenuElement element = (AppMenuElement)mapMenus.get(parentId);
        if (element != null) {
            return true;
        }
        String id = oldAppMetadata.getAppElement().getId();
        return id != null && id.equals(parentId);
    }

    private boolean checkParentFunc(String parentId, AppMetadata oldAppMetadata) {
        if (oldAppMetadata == null) {
            return false;
        }
        Map mapFunctions = oldAppMetadata.getMapFuncs();
        AppFunctionPacketElement element = (AppFunctionPacketElement)mapFunctions.get(parentId);
        if (element != null) {
            return true;
        }
        String id = oldAppMetadata.getAppElement().getId();
        return id != null && id.equals(parentId);
    }
}

