/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.metamerge;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.metamerge.CheckItem;
import kd.bos.devportal.metamerge.DefaultCheck;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.businessfield.ItemClassField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.businessfield.QtyField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.ExchangeRateGroupCheckUtil;

public class DependFieldCheck
extends DefaultCheck {
    @Override
    public List<CheckItem> check(FormMetadata formMetadata, EntityMetadata entityMetadata, FormMetadata oldFormMetadata, EntityMetadata oldEntityMetadata) {
        super.check(formMetadata, entityMetadata, oldFormMetadata, oldEntityMetadata);
        return this.checkDependField(formMetadata, entityMetadata);
    }

    private List<CheckItem> checkDependField(FormMetadata formMetadata, EntityMetadata entityMetadata) {
        ArrayList<CheckItem> checkItems = new ArrayList<CheckItem>(10);
        int qtyCount = 0;
        int itemClassCount = 0;
        int exchangeCount = 0;
        int baseDataCount = 0;
        int baseDataPropCount = 0;
        int mulBaseDataCount = 0;
        boolean qtyRes = true;
        boolean itemClassRes = true;
        boolean exchangeRes = true;
        boolean baseDataRes = true;
        boolean baseDataPropRes = true;
        boolean mulBaseDataRes = true;
        if (entityMetadata == null) {
            return checkItems;
        }
        formMetadata.createIndex();
        entityMetadata.createIndex();
        formMetadata.bindEntityMetadata(entityMetadata);
        List items = entityMetadata.getItems();
        for (EntityItem item : items) {
            CheckItem checkItem;
            if (item instanceof QtyField) {
                checkItem = this.checkQtyField((QtyField)item);
                if (checkItem.isStatus() && qtyCount == 0) {
                    checkItems.add(checkItem);
                    ++qtyCount;
                    continue;
                }
                if (checkItem.isStatus() || !qtyRes) continue;
                checkItems.add(checkItem);
                qtyRes = false;
                ++qtyCount;
                continue;
            }
            if (item instanceof ItemClassField) {
                checkItem = this.checkItemClassField((ItemClassField)item);
                if (checkItem.isStatus() && itemClassCount == 0) {
                    checkItems.add(checkItem);
                    ++itemClassCount;
                    continue;
                }
                if (checkItem.isStatus() || !itemClassRes) continue;
                checkItems.add(checkItem);
                itemClassRes = false;
                ++itemClassCount;
                continue;
            }
            if (item instanceof BasedataPropField) {
                checkItem = this.checkBaseDataPropField((BasedataPropField)item);
                if (checkItem.isStatus() && baseDataPropCount == 0) {
                    checkItems.add(checkItem);
                    ++baseDataPropCount;
                    continue;
                }
                if (checkItem.isStatus() || !baseDataPropRes) continue;
                checkItems.add(checkItem);
                baseDataPropRes = false;
                ++baseDataPropCount;
                continue;
            }
            if (item.getClass().equals(BasedataField.class)) {
                checkItem = this.checkBaseDataField((BasedataField)item);
                if (checkItem.isStatus() && baseDataCount == 0) {
                    checkItems.add(checkItem);
                    ++baseDataCount;
                    continue;
                }
                if (checkItem.isStatus() || !baseDataRes) continue;
                checkItems.add(checkItem);
                baseDataRes = false;
                ++baseDataCount;
                continue;
            }
            if (item instanceof MulBasedataField) {
                checkItem = this.checkMulBaseDataField((MulBasedataField)item);
                if (checkItem.isStatus() && mulBaseDataCount == 0) {
                    checkItems.add(checkItem);
                    ++mulBaseDataCount;
                    continue;
                }
                if (checkItem.isStatus() || !mulBaseDataRes) continue;
                checkItems.add(checkItem);
                mulBaseDataRes = false;
                ++mulBaseDataCount;
                continue;
            }
            checkItem = new CheckItem();
            checkItem.setName(ResManager.loadKDString((String)"\u4f9d\u8d56\u5b57\u6bb5\u5b8c\u6574\u6027", (String)"DefaultCheck_2", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            checkItem.setDescription(ResManager.loadKDString((String)"\u6c47\u7387\u63a7\u4ef6\u5b8c\u6574\u6027\u68c0\u67e5", (String)"DefaultCheck_5", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            this.checkExchangeRateGroupField(formMetadata, entityMetadata, checkItem);
            if (checkItem.isStatus() && exchangeCount == 0) {
                checkItems.add(checkItem);
                ++exchangeCount;
                continue;
            }
            if (checkItem.isStatus() || !exchangeRes) continue;
            checkItems.add(checkItem);
            exchangeRes = false;
            ++exchangeCount;
        }
        this.checkCount(checkItems, qtyRes, itemClassRes, exchangeRes);
        return checkItems;
    }

    private CheckItem checkBaseDataField(BasedataField field) {
        CheckItem checkItem = new CheckItem();
        checkItem.setName(ResManager.loadKDString((String)"\u4f9d\u8d56\u5b57\u6bb5\u5b8c\u6574\u6027", (String)"DefaultCheck_2", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        checkItem.setDescription(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u9700\u8981\u5173\u8054\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u3002", (String)"DependFieldCheck_0", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        String baseEntityId = field.getBaseEntityId();
        if (StringUtils.isBlank((CharSequence)baseEntityId)) {
            String detail = checkItem.getDetail();
            checkItem.setStatus(false);
            String errorInfo = String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u201c%s\u201d\u7684\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u672a\u8bbe\u7f6e\u3002\r\n", (String)"DependFieldCheck_1", (String)"bos-devportal-plugin", (Object[])new Object[0]), field.getName());
            errorInfo = detail == null ? errorInfo : checkItem.getDetail() + errorInfo;
            checkItem.setDetail(errorInfo);
        }
        return checkItem;
    }

    private CheckItem checkBaseDataPropField(BasedataPropField field) {
        CheckItem checkItem = new CheckItem();
        checkItem.setName(ResManager.loadKDString((String)"\u4f9d\u8d56\u5b57\u6bb5\u5b8c\u6574\u6027", (String)"DefaultCheck_2", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        checkItem.setDescription(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5c5e\u6027\u5b57\u6bb5\u9700\u8981\u5173\u8054\u57fa\u7840\u8d44\u6599\u7c7b\u578b", (String)"DependFieldCheck_2", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        String refBaseFieldId = field.getRefBaseFieldId();
        if (StringUtils.isBlank((CharSequence)refBaseFieldId)) {
            String detail = checkItem.getDetail();
            checkItem.setStatus(false);
            String errorInfo = String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5c5e\u6027\u201c%s\u201d\u7684\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u672a\u8bbe\u7f6e\u3002\r\n", (String)"DependFieldCheck_3", (String)"bos-devportal-plugin", (Object[])new Object[0]), field.getName());
            errorInfo = detail == null ? errorInfo : checkItem.getDetail() + errorInfo;
            checkItem.setDetail(errorInfo);
        }
        return checkItem;
    }

    private CheckItem checkMulBaseDataField(MulBasedataField field) {
        CheckItem checkItem = new CheckItem();
        checkItem.setName(ResManager.loadKDString((String)"\u4f9d\u8d56\u5b57\u6bb5\u5b8c\u6574\u6027", (String)"DefaultCheck_2", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        checkItem.setDescription(ResManager.loadKDString((String)"\u591a\u9009\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u9700\u8981\u5173\u8054\u57fa\u7840\u8d44\u6599\u7c7b\u578b", (String)"DependFieldCheck_4", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        String refBaseFieldId = field.getBaseEntityId();
        if (StringUtils.isBlank((CharSequence)refBaseFieldId)) {
            String detail = checkItem.getDetail();
            checkItem.setStatus(false);
            String errorInfo = String.format(ResManager.loadKDString((String)"\u591a\u9009\u57fa\u7840\u8d44\u6599\u201c%s\u201d\u7684\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u672a\u8bbe\u7f6e\u3002\r\n", (String)"DependFieldCheck_5", (String)"bos-devportal-plugin", (Object[])new Object[0]), field.getName());
            errorInfo = detail == null ? errorInfo : checkItem.getDetail() + errorInfo;
            checkItem.setDetail(errorInfo);
        }
        return checkItem;
    }

    private void checkCount(List<CheckItem> checkItems, boolean qtyRes, boolean itemClassRes, boolean exchangeRes) {
        String qty = ResManager.loadKDString((String)"\u6570\u91cf\u5b57\u6bb5\u9700\u8981\u5173\u8054\u8ba1\u91cf\u5355\u4f4d\u3002", (String)"DefaultCheck_3", (String)"bos-devportal-plugin", (Object[])new Object[0]);
        String itemClass = ResManager.loadKDString((String)"\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u9700\u8981\u5173\u8054\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u3002", (String)"DefaultCheck_4", (String)"bos-devportal-plugin", (Object[])new Object[0]);
        String exchange = ResManager.loadKDString((String)"\u6c47\u7387\u63a7\u4ef6\u5b8c\u6574\u6027\u68c0\u67e5", (String)"DefaultCheck_5", (String)"bos-devportal-plugin", (Object[])new Object[0]);
        Iterator<CheckItem> iterator = checkItems.iterator();
        while (iterator.hasNext()) {
            CheckItem item = iterator.next();
            if (!qtyRes && qty.equals(item.getDescription()) && item.isStatus()) {
                iterator.remove();
            }
            if (!itemClassRes && itemClass.equals(item.getDescription()) && item.isStatus()) {
                iterator.remove();
            }
            if (exchangeRes || !exchange.equals(item.getDescription()) || !item.isStatus()) continue;
            iterator.remove();
        }
    }

    private CheckItem checkQtyField(QtyField field) {
        CheckItem checkItem = new CheckItem();
        checkItem.setName(ResManager.loadKDString((String)"\u4f9d\u8d56\u5b57\u6bb5\u5b8c\u6574\u6027", (String)"DefaultCheck_2", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        checkItem.setDescription(ResManager.loadKDString((String)"\u6570\u91cf\u5b57\u6bb5\u9700\u8981\u5173\u8054\u8ba1\u91cf\u5355\u4f4d\u3002", (String)"DefaultCheck_3", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        String unitFieldId = field.getUnitFieldId();
        String parentId = field.getParentId();
        String name = field.getName() == null ? field.getKey() : field.getName().getLocaleValue();
        String detail = checkItem.getDetail();
        if (StringUtils.isBlank((CharSequence)unitFieldId)) {
            checkItem.setStatus(false);
            EntryEntity entryById = this.getEntryById(parentId);
            if (entryById != null) {
                LocaleString entryLocaleName = entryById.getName();
                String entryName = entryLocaleName == null ? "" : entryLocaleName.getLocaleValue();
                String errorInfo = String.format(ResManager.loadKDString((String)"%1$s\u4e2d\u7684\u201c%2$s\u201d\u9700\u8981\u5173\u8054\u201c\u8ba1\u91cf\u5355\u4f4d\u201d\u3002\r\n", (String)"DefaultCheck_10", (String)"bos-devportal-plugin", (Object[])new Object[0]), entryName, name);
                errorInfo = detail == null ? errorInfo : checkItem.getDetail() + errorInfo;
                checkItem.setDetail(errorInfo);
            } else {
                String errorInfo = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u9700\u8981\u5173\u8054\u201c\u8ba1\u91cf\u5355\u4f4d\u201d\u3002\r\n", (String)"DefaultCheck_11", (String)"bos-devportal-plugin", (Object[])new Object[0]), name);
                errorInfo = detail == null ? errorInfo : checkItem.getDetail() + errorInfo;
                checkItem.setDetail(errorInfo);
            }
            return checkItem;
        }
        Field<?> fld = this.getFieldById(unitFieldId);
        if (fld == null) {
            checkItem.setStatus(false);
            EntryEntity entryEntity = this.getEntryById(parentId);
            if (entryEntity != null) {
                LocaleString entryLocaleName = entryEntity.getName();
                String entryName = entryLocaleName == null ? "" : entryLocaleName.getLocaleValue();
                String errorInfo = String.format(ResManager.loadKDString((String)"%1$s\u4e2d\u7684\u201c%2$s\u201d\u5173\u8054\u7684\u201c\u8ba1\u91cf\u5355\u4f4d\u201d\u5b57\u6bb5\u4e0d\u5b58\u5728\u3002\r\n", (String)"DefaultCheck_12", (String)"bos-devportal-plugin", (Object[])new Object[0]), entryName, name);
                errorInfo = detail == null ? errorInfo : checkItem.getDetail() + errorInfo;
                checkItem.setDetail(errorInfo);
            } else {
                String errorInfo = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5173\u8054\u7684\u201c\u8ba1\u91cf\u5355\u4f4d\u201d\u5b57\u6bb5\u4e0d\u5b58\u5728\u3002\r\n", (String)"DefaultCheck_13", (String)"bos-devportal-plugin", (Object[])new Object[0]), name);
                errorInfo = detail == null ? errorInfo : checkItem.getDetail() + errorInfo;
                checkItem.setDetail(errorInfo);
            }
        }
        return checkItem;
    }

    private CheckItem checkItemClassField(ItemClassField field) {
        CheckItem checkItem = new CheckItem();
        checkItem.setName(ResManager.loadKDString((String)"\u4f9d\u8d56\u5b57\u6bb5\u5b8c\u6574\u6027", (String)"DefaultCheck_2", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        checkItem.setDescription(ResManager.loadKDString((String)"\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u9700\u8981\u5173\u8054\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u3002", (String)"DefaultCheck_4", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        String typeFieldId = field.getTypeFieldId();
        Field<?> fld = this.getFieldById(typeFieldId);
        String errorInfo = null;
        String detail = checkItem.getDetail();
        if (fld == null) {
            checkItem.setStatus(false);
            errorInfo = String.format(ResManager.loadKDString((String)"\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\u201c%s\u201d\u7684\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u672a\u8bbe\u7f6e\u3002\r\n", (String)"DefaultCheck_14", (String)"bos-devportal-plugin", (Object[])new Object[0]), field.getName());
            errorInfo = detail == null ? errorInfo : checkItem.getDetail() + errorInfo;
            checkItem.setDetail(errorInfo);
        }
        return checkItem;
    }

    private void checkExchangeRateGroupField(FormMetadata formMetadata, EntityMetadata entityMetadata, CheckItem checkItem) {
        FormMetadata mobMeta;
        String errorInfo = null;
        entityMetadata.getBuildErrors().clear();
        ExchangeRateGroupCheckUtil.checkExchangeRateGroupField((FormMetadata)formMetadata, (EntityMetadata)entityMetadata);
        FormAp rootAp = formMetadata.getRootAp();
        if (rootAp instanceof BillFormAp && (mobMeta = ((BillFormAp)rootAp).getMobMeta()) != null) {
            ExchangeRateGroupCheckUtil.checkExchangeRateGroupField((FormMetadata)mobMeta, (EntityMetadata)entityMetadata);
        }
        List buildErrors = entityMetadata.getBuildErrors();
        for (ErrorInfo error : buildErrors) {
            checkItem.setStatus(false);
            errorInfo = error.getError() + "\r\n";
            String detail = checkItem.getDetail();
            errorInfo = detail == null ? errorInfo : checkItem.getDetail() + errorInfo;
            checkItem.setDetail(errorInfo);
        }
        entityMetadata.getBuildErrors().clear();
    }
}

