/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.metamerge;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.devportal.metamerge.CheckItem;
import kd.bos.devportal.metamerge.MergeCheck;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.FormMetadata;

public class MetadataMergeCheck {
    private static final Map<String, String> checkMap = new LinkedHashMap<String, String>(3);
    private static final Map<String, String> appCheckMap = new LinkedHashMap<String, String>(1);
    private FormMetadata formMetadata;
    private EntityMetadata entityMetadata;
    private FormMetadata oldFormMetadata;
    private EntityMetadata oldEntityMetadata;
    private AppMetadata appMetadata;
    private AppMetadata oldAppMetadata;

    public MetadataMergeCheck() {
    }

    public MetadataMergeCheck(AppMetadata appMetadata, AppMetadata oldAppMetadata) {
        this.appMetadata = appMetadata;
        this.oldAppMetadata = oldAppMetadata;
    }

    public MetadataMergeCheck(FormMetadata formMetadata, EntityMetadata entityMetadata, FormMetadata oldFormMetadata, EntityMetadata oldEntityMetadata) {
        this.formMetadata = formMetadata;
        this.entityMetadata = entityMetadata;
        this.oldFormMetadata = oldFormMetadata;
        this.oldEntityMetadata = oldEntityMetadata;
    }

    public FormMetadata getFormMetadata() {
        return this.formMetadata;
    }

    public void setFormMetadata(FormMetadata formMetadata) {
        this.formMetadata = formMetadata;
    }

    public EntityMetadata getEntityMetadata() {
        return this.entityMetadata;
    }

    public void setEntityMetadata(EntityMetadata entityMetadata) {
        this.entityMetadata = entityMetadata;
    }

    public FormMetadata getOldFormMetadata() {
        return this.oldFormMetadata;
    }

    public void setOldFormMetadata(FormMetadata oldFormMetadata) {
        this.oldFormMetadata = oldFormMetadata;
    }

    public EntityMetadata getOldEntityMetadata() {
        return this.oldEntityMetadata;
    }

    public void setOldEntityMetadata(EntityMetadata oldEntityMetadata) {
        this.oldEntityMetadata = oldEntityMetadata;
    }

    public AppMetadata getAppMetadata() {
        return this.appMetadata;
    }

    public void setAppMetadata(AppMetadata appMetadata) {
        this.appMetadata = appMetadata;
    }

    public AppMetadata getOldAppMetadata() {
        return this.oldAppMetadata;
    }

    public void setOldAppMetadata(AppMetadata oldAppMetadata) {
        this.oldAppMetadata = oldAppMetadata;
    }

    public List<CheckItem> checkMetadata() {
        ArrayList<CheckItem> itemList = new ArrayList<CheckItem>(10);
        for (Map.Entry<String, String> entry : checkMap.entrySet()) {
            String className = entry.getValue();
            MergeCheck mergeCheck = (MergeCheck)TypesContainer.createInstance((String)className);
            List<CheckItem> checkItems = mergeCheck.check(this.formMetadata, this.entityMetadata, this.oldFormMetadata, this.oldEntityMetadata);
            itemList.addAll(checkItems);
        }
        return itemList;
    }

    public List<CheckItem> checkMetadata(MergeCheck mergeCheck) {
        return mergeCheck.check(this.formMetadata, this.entityMetadata, this.oldFormMetadata, this.oldEntityMetadata);
    }

    public List<CheckItem> checkAppMetadata() {
        ArrayList<CheckItem> itemList = new ArrayList<CheckItem>(10);
        for (Map.Entry<String, String> entry : appCheckMap.entrySet()) {
            String className = entry.getValue();
            MergeCheck mergeCheck = (MergeCheck)TypesContainer.createInstance((String)className);
            List<CheckItem> checkItems = mergeCheck.check(this.appMetadata, this.oldAppMetadata);
            itemList.addAll(checkItems);
        }
        return itemList;
    }

    static {
        checkMap.put("LayoutCheck", "kd.bos.devportal.metamerge.LayoutCheck");
        checkMap.put("HierarchicalRelationCheck", "kd.bos.devportal.metamerge.HierarchicalRelationCheck");
        checkMap.put("DependFieldCheck", "kd.bos.devportal.metamerge.DependFieldCheck");
        appCheckMap.put("AppMetadataCheck", "kd.bos.devportal.metamerge.AppMetadataCheck");
    }
}

