/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.page.plugin;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IFormDesignService;

public class BizPageNewBlankLayoutPlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener {
    private static final String BTNOK = "btnok";
    private static final String BTNLAST = "btnlast";
    private static final String BIZ_ENTITY = "bizentity";
    private static final String ENTITYID = "entityId";
    private static final String DENTITYID = "dentityid";
    private static final String QUERY_ENTITY = "queryentity";
    private static final String LAYOUTMOBILE = "layoutmobile";
    private static final List<String> ENTITY_MODEL_HIDDEN = Arrays.asList("PrintModel", "QueryListModel", "layoutmobile");
    private static final String KEY_MODELTYPE1 = "modeltype";
    private static final String KEY_MODELTYPE2 = "modelType";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static IFormDesignService formDesignService;

    public void registerListener(EventObject e) {
        BasedataEdit ftargetbill = (BasedataEdit)this.getView().getControl(BIZ_ENTITY);
        if (ftargetbill != null) {
            ftargetbill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{BTNLAST, BTNOK});
    }

    public void afterCreateNewData(EventObject e) {
        Map configInfo = this.getView().getFormShowParameter().getCustomParams();
        String bizAppId = configInfo.get("bizappid").toString();
        Map objName = (Map)configInfo.get("name");
        LocaleString name = new LocaleString();
        if (objName != null) {
            name = LocaleString.fromMap((Map)objName);
        }
        String number = (String)configInfo.get("number");
        String bizentity = (String)configInfo.get(BIZ_ENTITY);
        String modelType = (String)configInfo.get(KEY_MODELTYPE1);
        Object isPrintTemplate = configInfo.get("isprinttemplate");
        if ("PrintModel".equals(modelType)) {
            number = bizentity;
            if (!StringUtils.isEmpty((CharSequence)bizentity)) {
                number = this.CreateNewNumber(number);
            }
        }
        this.getModel().setValue("name", (Object)name);
        this.getModel().setValue("number", (Object)number);
        this.getModel().setValue(BIZ_ENTITY, (Object)bizentity);
        if (!ObjectUtils.isEmpty(isPrintTemplate)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTNLAST});
        } else if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTNOK});
        }
        if (LAYOUTMOBILE.equals(modelType)) {
            this.getModel().setValue("pagetype", (Object)"Empty");
            this.getView().setEnable(Boolean.FALSE, new String[]{"pagetype"});
        }
    }

    public void afterBindData(EventObject e) {
        Map configInfo = this.getView().getFormShowParameter().getCustomParams();
        String modelType = (String)configInfo.get(KEY_MODELTYPE1);
        if (ENTITY_MODEL_HIDDEN.indexOf(modelType) != -1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"pagetype"});
        }
        if ("QueryListModel".equals(modelType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BIZ_ENTITY});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{QUERY_ENTITY});
        }
    }

    public String CreateNewNumber(String number) {
        String accountIsv = ISVService.getISVInfo().getId();
        if ("kingdee".equals(accountIsv)) {
            if (number.endsWith("_prt")) {
                number = number + "_s";
            } else if (!number.endsWith("_s") && !number.endsWith("_prt")) {
                number = number + "_prt_s";
            }
        } else {
            number = number.endsWith("_s") ? number.substring(0, number.length() - 2) : number + "_prt";
        }
        return number;
    }

    public void click(EventObject evt) {
        String key;
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "btnlast": {
                this.lastStep();
                break;
            }
            case "btnok": {
                this.finish();
                break;
            }
        }
    }

    private void lastStep() {
        ILocaleString name = (ILocaleString)this.getModel().getValue("name");
        String number = (String)this.getModel().getValue("number");
        String bizEntityId = (String)this.getModel().getValue("bizentity_id");
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        returnData.put("name", name);
        returnData.put("number", number);
        returnData.put(BIZ_ENTITY, bizEntityId);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private void finish() {
        Map configInfo = this.getView().getFormShowParameter().getCustomParams();
        String bizAppId = (String)configInfo.get("bizappid");
        String bizUnitId = (String)configInfo.get("bizunitid");
        String modelType = (String)configInfo.get(KEY_MODELTYPE1);
        ILocaleString name = (ILocaleString)this.getModel().getValue("name");
        String number = (String)this.getModel().getValue("number");
        if (StringUtils.isBlank((Object)name) && StringUtils.isBlank((CharSequence)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u3001\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizPageNewBlankLayoutPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((Object)name)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizPageNewBlankLayoutPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizPageNewBlankLayoutPlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String entity = modelType.equals("QueryListModel") ? QUERY_ENTITY : BIZ_ENTITY;
        ValidateResult result = this.validate(modelType, entity);
        if (!result.success) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", number);
        map.put("name", name);
        map.put("bizappid", bizAppId);
        map.put("bizunitid", bizUnitId);
        Map<Object, Object> message = new HashMap();
        switch (modelType) {
            case "layoutpc": {
                message = this.resolvePcLayout(result.getEntity(), map);
                break;
            }
            case "layoutmobile": {
                message = this.resolveMobLayout(result.getEntity(), map);
                break;
            }
            case "PrintModel": {
                message = this.resolvePrintTemplate(result.getEntity(), map);
                break;
            }
            case "QueryListModel": {
                message = this.resolveQueryModel(result.getEntity(), map);
                break;
            }
        }
        if (StringUtils.isBlank(message.get("isvcheckresult"))) {
            this.getView().returnDataToParent(message);
            this.getView().close();
        }
    }

    private ValidateResult validate(String modelType, String entity) {
        boolean isValidate = true;
        DynamicObject dataEntity = null;
        switch (entity) {
            case "bizentity": {
                dataEntity = (DynamicObject)this.getModel().getValue(BIZ_ENTITY);
                if (dataEntity == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u5b9e\u4f53\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizPageNewBlankLayoutPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                    isValidate = false;
                    return new ValidateResult(isValidate, dataEntity);
                }
                String layoutEntityType = (String)dataEntity.get(KEY_MODELTYPE2);
                if (!StringUtils.isNotBlank((CharSequence)modelType) || !"layoutpc".equalsIgnoreCase(modelType) || !"ReportFormModel".equals(layoutEntityType)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u7c7b\u578b\u7684\u5b9e\u4f53\u4e0d\u5141\u8bb8\u751f\u6210\u5e03\u5c40\u3002", (String)"BizPageNewBlankLayoutPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                isValidate = false;
                break;
            }
            case "queryentity": {
                dataEntity = (DynamicObject)this.getModel().getValue(QUERY_ENTITY);
                if (dataEntity != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u67e5\u8be2\u5b9e\u4f53\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizPageNewBlankLayoutPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                isValidate = false;
                break;
            }
        }
        return new ValidateResult(isValidate, dataEntity);
    }

    private Map<String, Object> resolvePcLayout(DynamicObject dataEntity, Map<String, Object> params) {
        params.put("islayout", Boolean.TRUE);
        params.put("isRuntime", Boolean.TRUE);
        params.put("pagetype", this.getModel().getValue("pagetype"));
        params.put(ENTITYID, dataEntity.get(DENTITYID));
        params.put(KEY_MODELTYPE2, dataEntity.get(KEY_MODELTYPE2));
        params.put("isRuntime", Boolean.TRUE);
        return DevportalUtil.buildNewLayout(params, (String)params.get("bizappid"), (String)params.get("bizunitid"), this.getView(), false);
    }

    private Map<String, Object> resolveMobLayout(DynamicObject dataEntity, Map<String, Object> params) {
        params.put("islayout", Boolean.TRUE);
        params.put("pagetype", this.getModel().getValue("pagetype"));
        params.put(KEY_MODELTYPE2, "MobileBillFormModel");
        params.put(ENTITYID, (String)dataEntity.get(DENTITYID));
        return DevportalUtil.buildNewLayout(params, (String)params.get("bizappid"), (String)params.get("bizunitid"), this.getView(), false);
    }

    private Map<String, Object> resolvePrintTemplate(DynamicObject dataEntity, Map<String, Object> params) {
        params.put(KEY_MODELTYPE2, "PrintModel");
        params.put(ENTITYID, (String)dataEntity.get(DENTITYID));
        Map<String, Object> result = DevportalUtil.buildNewLayout(params, (String)params.get("bizappid"), (String)params.get("bizunitid"), this.getView(), true);
        this.getOrCreateDesignService().afterCreateTpl(result);
        return result;
    }

    private Map<String, Object> resolveQueryModel(DynamicObject dataEntity, Map<String, Object> params) {
        params.put(ENTITYID, dataEntity.get(DENTITYID));
        params.put("entityName", dataEntity.get("number"));
        params.put(KEY_MODELTYPE2, "QueryListModel");
        return DevportalUtil.buildNewQueryModel(params, (String)params.get("bizappid"), (String)params.get("bizunitid"), this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        Map configInfo = this.getView().getFormShowParameter().getCustomParams();
        String modelType = (String)configInfo.get(KEY_MODELTYPE1);
        if (BIZ_ENTITY.equals(property) && "PrintModel".equals(modelType)) {
            DynamicObject bizentity = (DynamicObject)this.getModel().getValue(BIZ_ENTITY);
            String number = (String)bizentity.get("number");
            if (!ObjectUtils.isEmpty((Object)bizentity)) {
                number = this.CreateNewNumber(number);
                this.getModel().setValue("number", (Object)number);
            }
        }
        if ("number".equals(property)) {
            String number = (String)e.getChangeSet()[0].getNewValue();
            number = DevportalUtil.autoIsvNumber(number);
            this.getModel().beginInit();
            this.getModel().setValue("number", (Object)number);
            this.getModel().endInit();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent paramBeforeF7SelectEvent) {
        Map configInfo = this.getView().getFormShowParameter().getCustomParams();
        if ("PrintModel".equals(configInfo.get(KEY_MODELTYPE1))) {
            ListShowParameter paramter = (ListShowParameter)paramBeforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParam = paramter.getListFilterParameter();
            List qfilters = filterParam.getQFilters();
            QFilter qfilter = new QFilter(KEY_MODELTYPE1, "in", Arrays.asList("QueryListModel", "DynamicFormModel"));
            if (!qfilters.isEmpty()) {
                ((QFilter)qfilters.get(0)).or(qfilter);
            } else {
                qfilters.add(qfilter);
            }
        }
    }

    private IFormDesignService getOrCreateDesignService() {
        if (formDesignService == null) {
            formDesignService = (IFormDesignService)TypesContainer.createInstance((String)"kd.bos.designer.PrintDesignerService");
        }
        return formDesignService;
    }

    private static class ValidateResult {
        private boolean success;
        private DynamicObject entity;

        public ValidateResult(boolean success, DynamicObject entity) {
            this.success = success;
            this.entity = entity;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public DynamicObject getEntity() {
            return this.entity;
        }

        public void setEntity(DynamicObject entity) {
            this.entity = entity;
        }
    }
}

