/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.page.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.bos.param.ParameterReader;

public class BizPageNewDefaultPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String KEY_BTNOK = "btnok";
    private static final String KEY_BIZAPPID = "bizappid";
    private static final String PARATYPE = "paratype";
    private static final String NUMBER = "number";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnlast", KEY_BTNOK});
    }

    public void afterCreateNewData(EventObject e) {
        Map configInfo = this.getView().getFormShowParameter().getCustomParams();
        if (configInfo != null) {
            String bizAppId = (String)configInfo.get(KEY_BIZAPPID);
            Map objName = (Map)configInfo.get("name");
            LocaleString name = new LocaleString();
            if (objName != null) {
                name = LocaleString.fromMap((Map)objName);
            }
            String number = (String)configInfo.get(NUMBER);
            String modeltype = (String)configInfo.get("modeltype");
            String paratype = (String)configInfo.get(PARATYPE);
            if ("ParameterFormModel".equals(modeltype)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{PARATYPE});
                if (StringUtils.isNotBlank((CharSequence)paratype)) {
                    this.getModel().setValue(PARATYPE, (Object)paratype);
                }
            }
            this.getModel().setValue("name", (Object)name);
            this.getModel().setValue(NUMBER, (Object)number);
            if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTNOK});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        if (NUMBER.equals(property)) {
            String number = (String)e.getChangeSet()[0].getNewValue();
            number = DevportalUtil.autoIsvNumber(number);
            this.getModel().beginInit();
            this.getModel().setValue(NUMBER, (Object)number);
            this.getModel().endInit();
        }
    }

    public void click(EventObject evt) {
        String key;
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "btnlast": {
                this.lastStep();
                break;
            }
            case "btnok": {
                this.finish();
                break;
            }
        }
    }

    private void lastStep() {
        ILocaleString name = (ILocaleString)this.getModel().getValue("name");
        String number = (String)this.getModel().getValue(NUMBER);
        String paratype = (String)this.getModel().getValue(PARATYPE);
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        returnData.put("name", name);
        returnData.put(NUMBER, number);
        returnData.put(PARATYPE, paratype);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private void finish() {
        if (EnvTypeHelper.isDeploying()) {
            String msg = ResManager.loadKDString((String)"\u5e73\u53f0\u6b63\u5728\u8fdb\u884c\u7cfb\u7edf\u5347\u7ea7\uff0c\u6682\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"MainPlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        Map configinfo = this.getView().getFormShowParameter().getCustomParams();
        if (configinfo != null) {
            String bizAppId = (String)configinfo.get(KEY_BIZAPPID);
            String bizUnitId = (String)configinfo.get("bizunitid");
            ILocaleString name = (ILocaleString)this.getModel().getValue("name");
            String number = (String)this.getModel().getValue(NUMBER);
            String modelType = (String)configinfo.get("modeltype");
            if ("ParameterFormModel".equals(modelType) && "ParameterFormModel_public".equals(modelType = (String)this.getModel().getValue(PARATYPE)) && ParameterReader.getPublicParameter() != null) {
                String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u53c2\u6570\u4e2d\u5df2\u7ecf\u5b58\u5728\u516c\u5171\u53c2\u6570\uff0c\u8bf7\u52ff\u91cd\u590d\u65b0\u589e\u591a\u4f59\u516c\u5171\u53c2\u6570\u3002", (String)"BizPageNewDefaultPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                return;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("modelType", modelType);
            map.put("id", number);
            map.put("name", name);
            map.put(KEY_BIZAPPID, bizAppId);
            map.put("bizunitid", bizUnitId);
            Map<String, Object> message = DevportalUtil.buildNewPage(map, bizAppId, bizUnitId, this.getView(), false);
            if (StringUtils.isBlank((Object)message.get("isvcheckresult"))) {
                this.getView().returnDataToParent(message);
                this.getView().close();
            }
        }
    }
}

