/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.page.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class BizPageNewInheritPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String BTNOK = "btnok";
    private static final String BIZAPPID = "bizappid";
    private static final String PARENTENTITYID = "parententityid";
    private static final String NUMBER = "number";
    private static final String REFPARENTENTITY = "refparententity";
    private static final String PARENTENTITY = "parententity";
    private static final String MODELTYPE = "modeltype";
    private static final String PARATYPE = "paratype";
    private static final String PARAMETERFORMMODEL = "ParameterFormModel";
    private static final String REFAPPID = "refappid";
    private static final String BOS_FORMMETA = "bos_formmeta";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnlast", BTNOK, PARENTENTITY, REFPARENTENTITY});
    }

    public void afterCreateNewData(EventObject e) {
        Map configInfo = this.getView().getFormShowParameter().getCustomParams();
        if (configInfo != null) {
            String bizAppId = (String)configInfo.get(BIZAPPID);
            Map objName = (Map)configInfo.get("name");
            LocaleString name = new LocaleString();
            if (objName != null) {
                name = LocaleString.fromMap((Map)objName);
            }
            String number = (String)configInfo.get(NUMBER);
            String parentEntity = (String)configInfo.get(PARENTENTITY);
            String parentEntityId = (String)configInfo.get(PARENTENTITYID);
            String modeltype = (String)configInfo.get(MODELTYPE);
            String paratype = (String)configInfo.get(PARATYPE);
            if (PARAMETERFORMMODEL.equals(modeltype)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{PARATYPE});
                if (StringUtils.isNotBlank((CharSequence)paratype)) {
                    this.getModel().setValue(PARATYPE, (Object)paratype);
                }
            }
            this.getModel().setValue("name", (Object)name);
            this.getModel().setValue(NUMBER, (Object)number);
            this.getModel().setValue(PARENTENTITY, (Object)parentEntity);
            if (this.getControl(REFPARENTENTITY) != null) {
                this.getModel().setValue(REFPARENTENTITY, (Object)parentEntity);
            }
            this.getModel().setValue(PARENTENTITYID, (Object)parentEntityId);
            if (configInfo.get(REFAPPID) != null) {
                this.getView().setVisible(Boolean.TRUE, new String[]{REFPARENTENTITY});
                this.getView().setVisible(Boolean.FALSE, new String[]{PARENTENTITY});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{REFPARENTENTITY});
                this.getView().setVisible(Boolean.TRUE, new String[]{PARENTENTITY});
            }
            if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{BTNOK});
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "btnlast": {
                this.lastStep();
                break;
            }
            case "btnok": {
                this.finish();
                break;
            }
            case "parententity": 
            case "refparententity": {
                this.openParentEntities();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        ListSelectedRowCollection rt;
        if ("selectParent".equals(e.getActionId()) && (rt = (ListSelectedRowCollection)e.getReturnData()) != null && rt.size() > 0) {
            this.getModel().setValue(PARENTENTITY, (Object)rt.get(0).getName());
            this.getModel().setValue(PARENTENTITYID, rt.get(0).getPrimaryKeyValue());
            if (this.getControl(REFPARENTENTITY) != null) {
                this.getModel().setValue(REFPARENTENTITY, (Object)rt.get(0).getName());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        if (NUMBER.equals(property)) {
            String number = (String)e.getChangeSet()[0].getNewValue();
            number = DevportalUtil.autoIsvNumber(number);
            this.getModel().beginInit();
            this.getModel().setValue(NUMBER, (Object)number);
            this.getModel().endInit();
        }
    }

    private void lastStep() {
        ILocaleString name = (ILocaleString)this.getModel().getValue("name");
        String number = (String)this.getModel().getValue(NUMBER);
        String parentEntity = (String)this.getModel().getValue(PARENTENTITY);
        String parentEntityId = (String)this.getModel().getValue(PARENTENTITYID);
        String paratype = (String)this.getModel().getValue(PARATYPE);
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        returnData.put("name", name);
        returnData.put(NUMBER, number);
        returnData.put(PARENTENTITY, parentEntity);
        returnData.put(PARENTENTITYID, parentEntityId);
        returnData.put(PARATYPE, paratype);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private void finish() {
        if (EnvTypeHelper.isDeploying()) {
            String msg = ResManager.loadKDString((String)"\u5e73\u53f0\u6b63\u5728\u8fdb\u884c\u7cfb\u7edf\u5347\u7ea7\uff0c\u6682\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"MainPlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        Map configInfo = this.getView().getFormShowParameter().getCustomParams();
        if (configInfo != null) {
            String bizAppId = (String)configInfo.get(BIZAPPID);
            String bizUnitId = (String)configInfo.get("bizunitid");
            ILocaleString name = (ILocaleString)this.getModel().getValue("name");
            String number = (String)this.getModel().getValue(NUMBER);
            String modelType = (String)configInfo.get(MODELTYPE);
            if (PARAMETERFORMMODEL.equals(modelType)) {
                modelType = (String)this.getModel().getValue(PARATYPE);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            String parentId = this.getModel().getValue(PARENTENTITYID).toString();
            if (StringUtils.isNotBlank((CharSequence)parentId)) {
                DynamicObject formInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)parentId, (String)BOS_FORMMETA);
                String devType = formInfo.get("type").toString();
                if ("2".equals(devType)) {
                    map.put("devType", "2");
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ee7\u627f\u7684\u8868\u5355\u3002", (String)"BizPageNewInheritPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            map.put("modelType", modelType);
            map.put("parentId", parentId);
            map.put("id", number);
            map.put("name", name);
            if (configInfo.get(REFAPPID) != null) {
                String count = DevportalUtil.getParallelExtCountByIsv(parentId, BOS_FORMMETA, "parentid");
                if ("0".equals(count)) {
                    map.put("devType", "2");
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u9875\u9762\u4ec5\u53ef\u6269\u5c551\u6b21\u3002", (String)"BizPageNewInheritPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                    return;
                }
            }
            map.put(BIZAPPID, bizAppId);
            map.put("bizunitid", bizUnitId);
            Map<String, Object> message = DevportalUtil.buildNewPage(map, bizAppId, bizUnitId, this.getView(), false);
            if (StringUtils.isBlank((Object)message.get("isvcheckresult"))) {
                this.getView().returnDataToParent(message);
                this.getView().close();
            }
        }
    }

    private void openParentEntities() {
        ListShowParameter listShowParameter;
        Map configInfo = this.getView().getFormShowParameter().getCustomParams();
        String modelType = (String)configInfo.get(MODELTYPE);
        if (PARAMETERFORMMODEL.equals(modelType)) {
            modelType = (String)this.getModel().getValue(PARATYPE);
        }
        if (StringUtils.isBlank((CharSequence)modelType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53c2\u6570\u7c7b\u578b\u3002", (String)"BizPageNewInheritPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String bizAppId = (String)configInfo.get(BIZAPPID);
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String inheritPath = metadata.getInheritPath();
        String appType = metadata.getDevType();
        String refAppId = metadata.getAppElement().getRefAppId();
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isBlank(configInfo.get(REFAPPID))) {
            list.add(bizAppId);
        }
        if ((listShowParameter = ShowFormHelper.createShowListForm((String)BOS_FORMMETA, (boolean)false)) != null) {
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u8868\u5355\u9009\u62e9\u9875\u9762", (String)"BizPageNewInheritPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            listShowParameter.setFormId("bos_devp_formtreelistf7");
            if (StringUtils.isNotBlank((CharSequence)refAppId)) {
                list.add(refAppId);
            }
            if ("2".equals(appType)) {
                if (inheritPath.contains(",")) {
                    String[] inheritPaths;
                    for (String inherit : inheritPaths = inheritPath.split(",")) {
                        list.add(inherit);
                    }
                } else {
                    list.add(inheritPath);
                }
            }
            listShowParameter.setCustomParam("bizappids", list);
            listShowParameter.setCustomParam("runtime", (Object)Boolean.FALSE);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            QFilter filter = new QFilter(MODELTYPE, "=", (Object)modelType);
            QFilter q = new QFilter("type", "!=", (Object)"2");
            filter.and(q);
            QFilter q1 = new QFilter("isinherit", "=", (Object)"1");
            filter.and(q1);
            QFilter q2 = new QFilter("id", "=", (Object)"basedatafield.id", true);
            filter.and(q2);
            if ("2".equals(metadata.getDevType())) {
                this.getPageCache().put("apptype", "2");
            }
            qFilters.add(filter);
            ListFilterParameter listFilterParameter = new ListFilterParameter(qFilters, null);
            listShowParameter.setListFilterParameter(listFilterParameter);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectParent"));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }
}

