/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.page.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.checking.plugin.CheckingPlugin;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.formtemplate.FormTemplateUtil;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.servicehelper.util.DevportalCommonUtil;
import kd.bos.url.UrlService;

public class BizPageNewTempMobPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final Log logger = LogFactory.getLog(CheckingPlugin.class);
    private static final String KEY_BTNLAST1 = "btnlast1";
    private static final String KEY_BTNOK = "btnok";
    private static final String KEY_BTNLAST = "btnlast";
    private static final String KEY_BTNNEXT = "btnnext";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String TEMPLATENUMBER = "templatenumber";
    private static final String BOS_DEVP_TPLMOBBILL = "bos_devp_tplmobbill";
    private static final String CONFIG = "config";
    private static final String CONFIGINFO = "configinfo";
    private static final String CACHEMAP = "cachemap";
    private static final String CONFIGPAGEID = "configpageid";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_METADATAID = "metadataid";
    private static final String KEY_METADATA = "metadata";
    private static final String KEY_BILLFIELDID = "billfieldid";
    private static final String KEY_ENTRY = "entry";
    private static final String KEY_ENTRYFIELDID = "entryfieldid";
    private static final String CONFIGCONTAINER = "configcontainer";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_BTNNEXT, KEY_BTNLAST, KEY_BTNLAST1, KEY_BTNOK});
    }

    public void afterCreateNewData(EventObject e) {
        Map configInfo = this.getView().getFormShowParameter().getCustomParams();
        String bizAppId = (String)configInfo.get("bizappid");
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTNOK});
        }
        int pageNum = 1;
        this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, pageNum);
        this.getModel().setValue("picture", (Object)(UrlService.getDomainContextUrl() + "/images/pc/other/ydxd_document.png"), 0);
        this.getModel().setValue("temptype", (Object)ResManager.loadKDString((String)"\u6a21\u677f\u7c7b\u578b\u4e00", (String)"BizPageNewTempMobPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), 0);
        this.getModel().setValue(TEMPLATENUMBER, (Object)BOS_DEVP_TPLMOBBILL, 0);
        String row = (String)configInfo.get("row");
        if (StringUtils.isNotBlank((CharSequence)row)) {
            int r = Integer.parseInt(row);
            AbstractGrid grid = (AbstractGrid)this.getControl(KEY_ENTRYENTITY);
            grid.selectRows(r);
        }
        JSONObject cacheJson = this.getCacheJson();
        cacheJson.put(CONFIGINFO, configInfo.get(CONFIG) == null ? new JSONObject() : configInfo.get(CONFIG));
        this.getPageCache().put(CACHEMAP, cacheJson.toJSONString());
    }

    public void afterBindData(EventObject e) {
        ((AbstractGrid)this.getControl(KEY_ENTRYENTITY)).selectRows(0);
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase()) {
            case "btnnext": {
                this.nextStep();
                break;
            }
            case "imageap": {
                this.getModel().setValue("radiogroupfield", (Object)BOS_DEVP_TPLMOBBILL);
                break;
            }
            case "btnlast": {
                this.lastStep();
                break;
            }
            case "btnlast1": {
                this.lastStep1();
                break;
            }
            case "btnok": {
                this.finish();
                break;
            }
        }
    }

    private void lastStep1() {
        AbstractGrid entry = (AbstractGrid)this.getControl(KEY_ENTRYENTITY);
        int rowIndex = entry.getEntryState().getFocusRow();
        HashMap<String, Integer> returnData = new HashMap<String, Integer>();
        returnData.put("row", rowIndex);
        returnData.put(CONFIG, (Integer)this.getCacheJson().getJSONObject(CONFIGINFO));
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private void lastStep() {
        String templateNumber = (String)this.getModel().getValue(TEMPLATENUMBER);
        JSONObject cacheJson = this.getCacheJson();
        if (StringUtils.isNotBlank((Object)cacheJson.get((Object)CONFIGPAGEID))) {
            IFormView congfigPageView = this.getView().getView(cacheJson.get((Object)CONFIGPAGEID).toString());
            JSONObject object = new JSONObject();
            if (BOS_DEVP_TPLMOBBILL.equals(templateNumber)) {
                object.put("name", congfigPageView.getModel().getValue("name"));
                object.put(KEY_NUMBER, congfigPageView.getModel().getValue(KEY_NUMBER));
                object.put("metadatanumber", congfigPageView.getModel().getValue("metadatanumber"));
                object.put(KEY_METADATAID, congfigPageView.getModel().getValue(KEY_METADATAID));
                object.put(KEY_METADATA, congfigPageView.getModel().getValue(KEY_METADATA));
                object.put("bill", congfigPageView.getModel().getValue("bill"));
                object.put(KEY_BILLFIELDID, congfigPageView.getModel().getValue(KEY_BILLFIELDID));
                object.put(KEY_ENTRY, congfigPageView.getModel().getValue(KEY_ENTRY));
                object.put(KEY_ENTRYFIELDID, congfigPageView.getModel().getValue(KEY_ENTRYFIELDID));
            }
            cacheJson.put(CONFIGINFO, (Object)object);
            this.getPageCache().put(CACHEMAP, cacheJson.toJSONString());
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{CONFIGCONTAINER});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTNLAST});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTNOK});
        this.getView().setVisible(Boolean.TRUE, new String[]{"tempcontainer"});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BTNNEXT});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BTNLAST1});
    }

    private void nextStep() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(KEY_ENTRYENTITY);
        int index = grid.getEntryState().getFocusRow();
        if (index == -1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u7c7b\u578b\u3002", (String)"BizPageNewTempMobPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String templateNumber = (String)this.getModel().getValue(TEMPLATENUMBER);
        if (StringUtils.isNotBlank((CharSequence)templateNumber)) {
            try {
                JSONObject cacheJson = this.getCacheJson();
                FormTemplateUtil templateUtil = FormTemplateUtil.getTemplateUtil(templateNumber);
                String configFormId = templateUtil.getConfigPage();
                FormShowParameter parameter = new FormShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.InContainer);
                parameter.getOpenStyle().setTargetKey(CONFIGCONTAINER);
                parameter.setFormId(configFormId);
                String pageId = UUID.randomUUID().toString();
                cacheJson.put(CONFIGPAGEID, (Object)pageId);
                this.getPageCache().put(CACHEMAP, cacheJson.toJSONString());
                parameter.setPageId(pageId);
                parameter.setCustomParam(CONFIGINFO, (Object)cacheJson.getJSONObject(CONFIGINFO).toJSONString());
                this.getView().showForm(parameter);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error(e.getMessage());
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u7c7b\u578b\u3002", (String)"BizPageNewTempMobPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{CONFIGCONTAINER});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BTNLAST});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BTNOK});
        this.getView().setVisible(Boolean.FALSE, new String[]{"tempcontainer"});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTNNEXT});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTNLAST1});
    }

    private void finish() {
        IFormView congfigPageView;
        if (EnvTypeHelper.isDeploying()) {
            String msg = ResManager.loadKDString((String)"\u5e73\u53f0\u6b63\u5728\u8fdb\u884c\u7cfb\u7edf\u5347\u7ea7\uff0c\u6682\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"MainPlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        Map configInfo = this.getView().getFormShowParameter().getCustomParams();
        String bizAppId = (String)configInfo.get("bizappid");
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            this.getView().showTipNotification(DevportalUtil.getNoPermissionTip());
            return;
        }
        JSONObject cacheJson = this.getCacheJson();
        if (StringUtils.isNotBlank((Object)cacheJson.get((Object)CONFIGPAGEID)) && (congfigPageView = this.getView().getView(cacheJson.get((Object)CONFIGPAGEID).toString())) != null) {
            String templateNumber = (String)this.getModel().getValue("radiogroupfield");
            try {
                FormMetadata formMetadata;
                String entryFields;
                FormTemplateUtil templateUtil = FormTemplateUtil.getTemplateUtil(templateNumber);
                HashMap<String, Object> metaInfo = new HashMap<String, Object>();
                metaInfo.put("formTemplateId", templateUtil.getTemplateId());
                ILocaleString name = (ILocaleString)congfigPageView.getModel().getValue("name");
                String number = (String)congfigPageView.getModel().getValue(KEY_NUMBER);
                String metadataId = (String)congfigPageView.getModel().getValue(KEY_METADATAID);
                StringBuilder errorMsg = DevportalUtil.validateNameNumberAndEntity(number, name, metadataId);
                if (StringUtils.isNotBlank((CharSequence)errorMsg.toString())) {
                    this.getView().showTipNotification(errorMsg.toString());
                    return;
                }
                metaInfo.put("name", name);
                metaInfo.put(KEY_NUMBER, number);
                metaInfo.put("pagemetaid", metadataId);
                EntityMetadata meta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)metadataId, (MetaCategory)MetaCategory.Entity);
                String billFields = (String)congfigPageView.getModel().getValue(KEY_BILLFIELDID);
                if (StringUtils.isNotBlank((CharSequence)billFields)) {
                    JSONArray billFieldIds = (JSONArray)JSONArray.parse((String)billFields);
                    JSONArray billArray = new JSONArray();
                    for (Object billfieldid : billFieldIds) {
                        String id = (String)billfieldid;
                        Field billField = meta.getFieldById(id);
                        JSONObject billObject = new JSONObject();
                        if (billField == null) continue;
                        billObject.put("Field", (Object)billField);
                        billArray.add((Object)billObject);
                    }
                    metaInfo.put("billfield", billArray);
                }
                if (StringUtils.isNotBlank((CharSequence)(entryFields = (String)congfigPageView.getModel().getValue(KEY_ENTRYFIELDID)))) {
                    JSONArray entryFieldIds = (JSONArray)JSONArray.parse((String)entryFields);
                    JSONArray entryArray = new JSONArray();
                    for (Object entryfieldid : entryFieldIds) {
                        String id = (String)entryfieldid;
                        Field entryField = meta.getFieldById(id);
                        JSONObject entryObject = new JSONObject();
                        if (entryField == null) continue;
                        entryObject.put("Field", (Object)entryField);
                        entryArray.add((Object)entryObject);
                    }
                    metaInfo.put("entryfield", entryArray);
                }
                String entryentityId = (String)congfigPageView.getModel().getValue("entryentityid");
                metaInfo.put("entryentityid", entryentityId);
                HashMap<String, Object> params = new HashMap<String, Object>();
                String bizUnitId = (String)configInfo.get("bizunitid");
                params.put("bizapp", bizAppId);
                params.put("bizunit", bizUnitId);
                AbstractMetadata metadata = templateUtil.builderMetadata(metaInfo);
                metadata.setBizappId(bizAppId);
                metadata.setEnvRegion(DevportalCommonUtil.genEnvRegion());
                if (metadata instanceof FormMetadata && (formMetadata = (FormMetadata)metadata).getItems().size() > 0 && formMetadata.getItems().get(0) instanceof FormAp) {
                    FormAp rootAp = (FormAp)formMetadata.getItems().get(0);
                    rootAp.initializeJsPlugin();
                }
                templateUtil.saveMetadata(metadata, params);
                HashMap<String, Object> message = new HashMap<String, Object>();
                message.put("formid", metadata.getId());
                message.put("success", Boolean.TRUE);
                message.put("message", ResManager.loadKDString((String)"\u521b\u5efa\u6210\u529f\u3002", (String)"BizPageNewTempMobPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                this.getView().returnDataToParent(message);
                this.getView().close();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error(e.getMessage());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        IFormView congfigPageView;
        JSONObject cacheJson = this.getCacheJson();
        if (StringUtils.isNotBlank((Object)cacheJson.get((Object)CONFIGPAGEID)) && (congfigPageView = this.getView().getView(cacheJson.get((Object)CONFIGPAGEID).toString())) != null && KEY_METADATA.equals(name = e.getProperty().getName())) {
            congfigPageView.getModel().setValue("bill", (Object)"");
            congfigPageView.getModel().setValue(KEY_ENTRY, (Object)"");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.getPageCache().remove(CACHEMAP);
    }

    public JSONObject getCacheJson() {
        JSONObject cacheJson = null;
        String cache = this.getPageCache().get(CACHEMAP);
        cacheJson = cache == null ? new JSONObject() : JSON.parseObject((String)cache);
        return cacheJson;
    }
}

