/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.page.plugin;

import java.security.SecureRandom;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;

public class PageImportPlanPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String PROGRESSBARAP = "progressbarap";
    private static final String BTN_CANCEL = "btncancel";
    private static final String CACHEKEY_ISSTART = "isstart";
    private static final String CUSTPARAM_ENTITYNAME = "entityname";
    private static final String URLARR = "urlarr";
    private static final String BIZAPPID = "bizappid";
    private static final String BIZUNITID = "bizunitid";
    private static final String PARENTPAGEID = "parentpageid";
    private static final String CACHEKEY_ISFINISHED = "isfinished";
    private static final String CACHEKEY_JOBFORMINFO = "page_import_jobforminfo";
    private static final String CACHEKEY_TASKID = "page_import_taskid";
    private static final String PAGE_IMPORT_IS_CANCEL = "PAGE_IMPORT_IS_CANCEL";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private boolean canClose = false;
    private static final Log LOG = LogFactory.getLog(PageImportPlanPlugin.class);

    public void registerListener(EventObject e) {
        ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESSBARAP);
        progressbar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{BTN_CANCEL});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
        bar.start();
        String taskId = this.getTaskId();
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 99;
            }
            bar.setPercent(progress);
        }
    }

    public void onProgress(ProgressEvent e) {
        try {
            String taskId = this.getTaskId();
            boolean isStart = this.isStart();
            this.setStart();
            if (!isStart && StringUtils.isBlank((CharSequence)taskId)) {
                this.dispatchTask();
                double n = new SecureRandom().nextDouble();
                e.setProgress((int)(50.0 * n));
                return;
            }
            if (StringUtils.isBlank((CharSequence)taskId)) {
                return;
            }
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            if (taskInfo.isTaskEnd()) {
                boolean isFinished = this.isFinished();
                this.setFinished();
                if (!isFinished) {
                    e.setProgress(99);
                    return;
                }
                IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
                String taskInfoData = taskInfo.getData();
                if (taskInfoData != null) {
                    Map data = (Map)SerializationUtils.fromJsonString((String)taskInfoData, Map.class);
                    if (StringUtils.equalsIgnoreCase((CharSequence)"FAILED", (CharSequence)taskInfo.getStatus())) {
                        this.getView().showErrMessage(taskInfo.getFailureReason(), "");
                        this.stopBar();
                        return;
                    }
                    if (Boolean.parseBoolean((String)data.get("success"))) {
                        this.getView().returnDataToParent((Object)data);
                        e.setProgress(100);
                    } else {
                        parentView.showErrMessage("" + data.get("error"), "");
                        this.getView().sendFormAction(parentView);
                    }
                }
                this.stopBar();
                this.closeForm();
                this.getCurrentAppCache().remove(CACHEKEY_TASKID);
            } else {
                int progress = taskInfo.getProgress();
                if (progress >= 100) {
                    progress = 99;
                }
                e.setProgress(progress);
            }
        }
        catch (Exception exception) {
            this.stopBar();
            IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            parentView.showErrMessage(String.format(ResManager.loadKDString((String)"\u62a5\u9519\u4fe1\u606f: %s", (String)"PageImportPlanPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), exception.getMessage()), "");
            LOG.error((Throwable)exception);
            this.getView().sendFormAction(parentView);
            this.closeForm();
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if (BTN_CANCEL.equals(c.getKey())) {
            this.getCurrentAppCache().put(PAGE_IMPORT_IS_CANCEL, (Object)"true");
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String isStop = (String)this.getCurrentAppCache().get(PAGE_IMPORT_IS_CANCEL, String.class);
        if (!this.isStart()) {
            if (Boolean.parseBoolean(isStop)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u5b9a\u8981\u7ec8\u6b62\u9875\u9762\u5bfc\u5165\uff1f", (String)"PageImportPlanPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("CLOSE_UNSTART", (IFormPlugin)this));
                e.setCancel(true);
                return;
            }
            e.setCancel(true);
            return;
        }
        if (this.canClose || this.isFinished()) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getTaskId())) {
            if (Boolean.parseBoolean(isStop)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u5b9a\u8981\u7ec8\u6b62\u9875\u9762\u5bfc\u5165\uff1f", (String)"PageImportPlanPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("CLOSE_START", (IFormPlugin)this));
                this.stopBar();
                e.setCancel(true);
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u5c06\u9875\u9762\u5bfc\u51fa\u8f6c\u4e3a\u540e\u53f0\u6267\u884c\uff1f", (String)"PageImportPlanPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("CLOSE_CONFIRMED", (IFormPlugin)this));
            this.stopBar();
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageboxclosedevent) {
        super.confirmCallBack(messageboxclosedevent);
        if ("CLOSE_START".equals(messageboxclosedevent.getCallBackId())) {
            if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
                ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
                bar.stop();
                this.closeForm();
            } else {
                ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
                bar.start();
            }
        } else if ("CLOSE_UNSTART".equals(messageboxclosedevent.getCallBackId())) {
            if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
                ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
                bar.stop();
                this.closeForm();
            } else {
                this.dispatchTask();
            }
        } else if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
            this.toBackground();
        } else {
            ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
            bar.start();
        }
        this.getCurrentAppCache().remove(PAGE_IMPORT_IS_CANCEL);
    }

    private String getTaskId() {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey(CACHEKEY_TASKID)) {
            return (String)this.getView().getFormShowParameter().getCustomParam(CACHEKEY_TASKID);
        }
        return this.getPageCache().get(CACHEKEY_TASKID);
    }

    private boolean isStart() {
        String start = this.getPageCache().get(CACHEKEY_ISSTART);
        if (StringUtils.isBlank((CharSequence)start)) {
            return false;
        }
        return Boolean.parseBoolean(start);
    }

    private void setStart() {
        this.getPageCache().put(CACHEKEY_ISSTART, String.valueOf(true));
    }

    private void dispatchTask() {
        JobFormInfo jobFormInfo = this.buildJobFormInfo();
        String isStop = (String)this.getCurrentAppCache().get(PAGE_IMPORT_IS_CANCEL, String.class);
        if (Boolean.parseBoolean(isStop)) {
            this.getCurrentAppCache().remove(PAGE_IMPORT_IS_CANCEL);
            return;
        }
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        this.putTaskId(taskId);
        this.putJobFormInfo(jobFormInfo);
    }

    private JobFormInfo buildJobFormInfo() {
        JobInfo jobInfo = new JobInfo();
        FormShowParameter fs = this.getView().getFormShowParameter();
        jobInfo.setName(ResManager.loadKDString((String)"\u5f00\u53d1\u5e73\u53f0\u5bfc\u5165\u9875\u9762", (String)"PageImportPlanPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId(fs.getServiceAppId());
        jobInfo.setTaskClassname("kd.bos.devportal.page.plugin.PageImportTask");
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        params.put(PARENTPAGEID, fs.getParentPageId());
        params.put(BIZAPPID, fs.getCustomParam(BIZAPPID));
        params.put(BIZUNITID, fs.getCustomParam(BIZUNITID));
        params.put(URLARR, fs.getCustomParam(URLARR));
        jobInfo.setParams(params);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setParentPageId(fs.getParentPageId());
        jobFormInfo.setRootPageId(fs.getRootPageId());
        jobFormInfo.setTimeout(this.getImportTimeout());
        jobFormInfo.getParams().putAll(fs.getCustomParams());
        return jobFormInfo;
    }

    private String getEntityName() {
        String name = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_ENTITYNAME);
        if (name == null) {
            name = "";
        }
        return name;
    }

    private int getImportTimeout() {
        return 1800;
    }

    private IAppCache getCurrentAppCache() {
        return AppCache.get((String)this.getView().getFormShowParameter().getFormConfig().getAppId());
    }

    private void putTaskId(String taskId) {
        this.getPageCache().put(CACHEKEY_TASKID, taskId);
    }

    private void putJobFormInfo(JobFormInfo jobFormInfo) {
        if (jobFormInfo == null) {
            this.getPageCache().remove(CACHEKEY_JOBFORMINFO);
        } else {
            String str = SerializationUtils.toJsonString((Object)jobFormInfo);
            this.getPageCache().put(CACHEKEY_JOBFORMINFO, str);
        }
    }

    private boolean isFinished() {
        String finished = this.getPageCache().get(CACHEKEY_ISFINISHED);
        if (StringUtils.isBlank((CharSequence)finished)) {
            return false;
        }
        return Boolean.parseBoolean(finished);
    }

    private void setFinished() {
        this.getPageCache().put(CACHEKEY_ISFINISHED, String.valueOf(true));
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
        bar.stop();
    }

    private void closeForm() {
        this.canClose = true;
        TaskClientProxy.setProgressPageId((String)this.getTaskId(), (String)"");
        this.getView().close();
    }

    private void toBackground() {
        this.closeForm();
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (!TaskClientProxy.isExistTask((String)taskId)) {
            JobFormInfo jobFormInfo = this.getJobFormInfo();
            if (jobFormInfo != null) {
                TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)jobFormInfo, (TaskInfo)taskInfo);
            }
            BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
            ThreadPools.executeOnce((String)"task-background-monitor", (Runnable)subscriber);
        }
    }

    private JobFormInfo getJobFormInfo() {
        String str = null;
        str = this.getView().getFormShowParameter().getCustomParams().containsKey(CACHEKEY_JOBFORMINFO) ? (String)this.getView().getFormShowParameter().getCustomParam(CACHEKEY_JOBFORMINFO) : this.getPageCache().get(CACHEKEY_JOBFORMINFO);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return (JobFormInfo)SerializationUtils.fromJsonString((String)str, JobFormInfo.class);
    }
}

