/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.page.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.dao.MetaLogType;
import kd.bos.metadata.dao.MetaType;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataLogService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;

public class PageImportTask
extends AbstractTask {
    private final long LIMITSIZ = 0x1400000L;
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String URLARR = "urlarr";
    private static final String BIZAPPID = "bizappid";
    private static final String BIZUNITID = "bizunitid";
    private static final Log logger = LogFactory.getLog(PageImportTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDBizException {
        this.feedbackProgress(50, ResManager.loadKDString((String)"\u9875\u9762\u5bfc\u5165\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\u3002", (String)"PageImportTask_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), null);
        JSONObject installMsg = new JSONObject();
        try {
            List<JSONObject> message = this.install(map);
            installMsg.put("installMsg", message);
        }
        catch (Exception e) {
            HashMap<String, String> result = new HashMap<String, String>(2);
            result.putAll((Map<String, String>)installMsg);
            result.put("success", "false");
            result.put("error", e.getMessage());
            this.feedbackCustomdata(result);
        }
        HashMap<String, String> result = new HashMap<String, String>(2);
        result.put("success", "true");
        result.putAll((Map<String, String>)installMsg);
        this.feedbackCustomdata(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<JSONObject> install(Map<String, Object> map) {
        JSONArray urlArr = JSONArray.parseArray((String)((String)map.get(URLARR)));
        ArrayList<JSONObject> messageList = new ArrayList<JSONObject>(10);
        String bizunitId = (String)map.get(BIZUNITID);
        String bizAppId = (String)map.get(BIZAPPID);
        String number = "";
        long logId = DB.genGlobalLongId();
        if (urlArr != null && urlArr.size() > 0) {
            for (int i = 0; i < urlArr.size(); ++i) {
                JSONObject urlObj = (JSONObject)urlArr.get(i);
                for (String urlName : urlObj.keySet()) {
                    String retInfo;
                    TempFileCache cache;
                    String url;
                    JSONObject message;
                    block97: {
                        message = new JSONObject();
                        message.put(BIZAPPID, (Object)bizAppId);
                        message.put(BIZUNITID, (Object)bizunitId);
                        url = urlObj.getString(urlName);
                        logger.debug("url=" + url);
                        cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                        logger.debug("cache=" + cache);
                        try {
                            InputStream inputStream = cache.getInputStream(url);
                            Throwable throwable = null;
                            try {
                                ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                                Throwable throwable2 = null;
                                try {
                                    ZipEntry zEntry = zipInputStream.getNextEntry();
                                    if (zEntry == null) {
                                        logger.debug("ERROR", (Object)String.format("zipName\uff1a%1$s\uff1burlArr\uff1a%2$s", urlName, urlArr));
                                        message.put("ERROR", (Object)String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u5bfc\u5165\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"PageImportTask_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), urlName));
                                        messageList.add(message);
                                        continue;
                                    }
                                    String metaName = zEntry.getName();
                                    if ("kdpkgs.xml".equals(metaName) || "appInfo.xml".equals(metaName)) {
                                        message.put("ERROR", (Object)String.format(ResManager.loadKDString((String)"\u8bf7\u52ff\u5b89\u88c5\u5e94\u7528\u3010%s\u3011\u3002", (String)"PageImportTask_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), urlName));
                                        messageList.add(message);
                                        continue;
                                    }
                                    if (metaName.endsWith(".zip") && metaName.startsWith("dm")) {
                                        message.put("ERROR", (Object)String.format(ResManager.loadKDString((String)"\u8bf7\u52ff\u5b89\u88c5\u5e94\u7528\u3010%s\u3011\u3002", (String)"PageImportTask_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), urlName));
                                        messageList.add(message);
                                        continue;
                                    }
                                    break block97;
                                }
                                catch (Throwable zEntry) {
                                    throwable2 = zEntry;
                                    throw zEntry;
                                }
                                finally {
                                    if (zipInputStream == null) continue;
                                    if (throwable2 != null) {
                                        try {
                                            zipInputStream.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable2.addSuppressed(throwable3);
                                        }
                                        continue;
                                    }
                                    zipInputStream.close();
                                }
                            }
                            catch (Throwable zipInputStream) {
                                throwable = zipInputStream;
                                throw zipInputStream;
                            }
                            finally {
                                if (inputStream == null) continue;
                                if (throwable != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                inputStream.close();
                            }
                        }
                        catch (IOException redisException) {
                            logger.warn("ERROR", (Object)("redisException\uff1a" + redisException.getMessage()));
                            message.put("ERROR", (Object)String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u5bfc\u5165\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"PageImportTask_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), urlName));
                            messageList.add(message);
                        }
                        catch (Exception e) {
                            message.put("ERROR", (Object)String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u5bfc\u5165\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"PageImportTask_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), urlName));
                            messageList.add(message);
                        }
                        continue;
                    }
                    String formId = null;
                    String oldUnitId = null;
                    String curRebuildFormId = "";
                    String pageNum = "";
                    try (TXHandle tx = TX.required((String)"mdl_BizImportPagePlugin_asynInstall");
                         InputStream inStream = cache.getInputStream(url);
                         ZipInputStream zipIn = new ZipInputStream(inStream);){
                        ZipEntry zipEntry;
                        while ((zipEntry = zipIn.getNextEntry()) != null) {
                            int readLength;
                            if (zipEntry.isDirectory()) continue;
                            String metaName = zipEntry.getName();
                            metaName = metaName.replace(File.separator, "/");
                            logger.debug("metaName=" + metaName);
                            int len = 0;
                            byte[] buf = new byte[0x1400000];
                            if (metaName.endsWith("dym") || metaName.endsWith("dymx")) {
                                while ((readLength = zipIn.read()) != -1) {
                                    buf[len] = (byte)readLength;
                                    ++len;
                                }
                                String content = new String(buf, 0, len, StandardCharsets.UTF_8);
                                if (metaName.endsWith("dym")) {
                                    String masterId;
                                    String metaType;
                                    DcxmlSerializer serializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
                                    serializer.setColloctionIgnorePKValue(true);
                                    DeployMetadata deployNew = (DeployMetadata)serializer.deserializeFromString(content, null);
                                    DesignMeta meta = (DesignMeta)deployNew.getDesignMetas().get(0);
                                    String metaISV = meta.getIsv();
                                    pageNum = meta.getNumber();
                                    String pageIsExistMsg = DevportalUtil.checkPageIsExist(meta.getInheritPath(), pageNum);
                                    if (pageIsExistMsg != null) {
                                        throw new KDException(new ErrorCode("page_notExist", pageIsExistMsg), new Object[0]);
                                    }
                                    formId = deployNew.getId();
                                    QFilter qFilter = new QFilter("form", "=", (Object)formId);
                                    if (QueryServiceHelper.exists((String)"bos_devportal_unitrelform", (QFilter[])new QFilter[]{qFilter})) {
                                        oldUnitId = Objects.requireNonNull(BusinessDataServiceHelper.loadSingle((String)"bos_devportal_unitrelform", (String)"bizunit", (QFilter[])new QFilter[]{qFilter})).getString("bizUnit");
                                    }
                                    curRebuildFormId = "2".equals(metaType = meta.getDevType()) ? (masterId = deployNew.getMasterId()) : formId;
                                    if (StringUtils.isBlank((CharSequence)metaISV)) {
                                        throw new KDException(new ErrorCode("devp_isv", String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5bfc\u5165\u9875\u9762\"%s\"\u7684\u5f00\u53d1\u5546\u6807\u8bc6\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PageImportTask_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), pageNum)), new Object[0]);
                                    }
                                    String appIsv = AppUtils.getIsvByAppId((String)bizAppId);
                                    if (!appIsv.equals(metaISV)) {
                                        throw new KDException(new ErrorCode("devp_isv", String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5bfc\u5165\u9875\u9762\"%1$s\"\u7684\u5f00\u53d1\u5546\u6807\u8bc6\u4e3a\"%2$s\"\uff0c\u4e0e\u5f53\u524d\u5e94\u7528\u7684\u5f00\u53d1\u5546\u6807\u8bc6\"%3$s\"\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"PageImportTask_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), pageNum, metaISV, appIsv)), new Object[]{ResManager.loadKDString((String)"\u90e8\u7f72\u9875\u9762\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5f00\u53d1\u5546\u3002", (String)"BizImportPagePlugin_10", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0])});
                                    }
                                }
                                MetadataDao.deployMetadata((String)content, (String)bizunitId, (String)bizAppId);
                                this.writeLog(formId, pageNum, content, logId);
                                continue;
                            }
                            if (!metaName.endsWith("ks")) continue;
                            while ((readLength = zipIn.read()) != -1) {
                                buf[len] = (byte)readLength;
                                ++len;
                            }
                            String scriptContent = new String(buf, 0, len, StandardCharsets.UTF_8);
                            MetadataDao.deployScript((String)scriptContent, null, null);
                        }
                    }
                    try {
                        ArrayList<String> formIdList = new ArrayList<String>();
                        formIdList.add(curRebuildFormId);
                        MetadataDao.clearSubRuntimeMeta(formIdList);
                        number = MetadataDao.getNumberById((String)curRebuildFormId);
                        MetadataDao.rebuildRuntimeMetaById((String)curRebuildFormId);
                        if (StringUtils.isBlank((CharSequence)message.getString("ERROR"))) {
                            message.put("SUCCESS", (Object)ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"BizImportPagePlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                        }
                    }
                    catch (Exception runtimeException) {
                        retInfo = "";
                        retInfo = StringUtils.isNotBlank((CharSequence)number) ? String.format(ResManager.loadKDString((String)"\u8868\u5355\"%1$s\"\uff0c\u6784\u5efa\u8fd0\u884c\u671f\u5143\u6570\u636e\u5931\u8d25\uff1a%2$s", (String)"PageImportTask_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), number, runtimeException.getMessage()) : String.format(ResManager.loadKDString((String)"\u8868\u5355\"%1$s\"\uff0c\u6784\u5efa\u8fd0\u884c\u671f\u5143\u6570\u636e\u5931\u8d25\uff1a%2$s", (String)"PageImportTask_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), curRebuildFormId, runtimeException.getMessage());
                        message.put("RUNTIMEERROR", (Object)retInfo);
                    }
                    message.put(BIZAPPID, (Object)bizAppId);
                    message.put(BIZUNITID, (Object)bizunitId);
                    message.put("bizpageid", formId);
                    message.put("bizpagenumber", (Object)number);
                    message.put("oldunitid", oldUnitId);
                    messageList.add(message);
                }
            }
        }
        return messageList;
    }

    private void writeLog(String formId, String formNumber, String content, long logId) {
        try {
            MetadataLogService logService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
            logService.addMetaLog(formId, formNumber, content, (int)MetaLogType.PageImport.getValue(), logId, (int)MetaType.Form.getValue());
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u5143\u6570\u636e\u65e5\u5fd7\u5931\u8d25\uff0cerr\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }
}

