/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;

public class AppListPlugin
extends AbstractListPlugin {
    public void afterCreateNewData(EventObject e) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        List qFilters = listShowParameter.getListFilterParameter().getQFilters();
        if (qFilters.isEmpty()) {
            return;
        }
        List<String> appIds = new ArrayList<String>(16);
        for (QFilter qFilter : qFilters) {
            if (!"id".equalsIgnoreCase(qFilter.getProperty()) || !"in".equalsIgnoreCase(qFilter.getCP())) continue;
            appIds = (List)qFilter.getValue();
        }
        if (!appIds.isEmpty()) {
            Map<String, Map<String, Object>> dict = AppListPlugin.getDictionaries(appIds);
            this.getPageCache().put("dictionaries", SerializationUtils.toJsonString(dict));
        }
    }

    public static Map<String, Map<String, Object>> getDictionaries(List<String> appIds) {
        String sql = "select b.fid, d.fname, d.fdescription from t_meta_bizapp b left join t_meta_appruntime_l d on b.fnumber = d.fappid where b.fid in (%s) and d.flocaleid = '%s'";
        sql = String.format(sql, AppListPlugin.changeSetToSqlStr(appIds), Lang.get().toString());
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)new ResultSetHandler<Map<String, Map<String, Object>>>(){

            public Map<String, Map<String, Object>> handle(ResultSet resultSet) throws Exception {
                HashMap<String, Map<String, Object>> rs = new HashMap<String, Map<String, Object>>(16);
                while (resultSet.next()) {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    String id = resultSet.getString(1);
                    map.put("name", resultSet.getString(2));
                    map.put("description", resultSet.getString(3));
                    rs.put(id, map);
                }
                return rs;
            }
        });
    }

    private static String changeSetToSqlStr(List<String> set) {
        if (set == null || set.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String item : set) {
            if (item == null) continue;
            String val = null;
            if (item instanceof String) {
                val = item.toString();
            } else if (item instanceof Map.Entry) {
                Object tVal = ((Map.Entry)((Object)item)).getValue();
                String string = val = tVal == null ? null : tVal.toString();
            }
            if (!StringUtils.isNotEmpty((CharSequence)val)) continue;
            sb.append('\'').append(val).append("',");
        }
        String str = sb.toString();
        if (str.length() > 0) {
            return str.substring(0, str.length() - 1);
        }
        return null;
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        String dict = this.getPageCache().get("dictionaries");
        if (StringUtils.isBlank((CharSequence)dict)) {
            return;
        }
        Map dictMap = new HashMap(16);
        if (StringUtils.isNotBlank((CharSequence)dict)) {
            dictMap = (Map)SerializationUtils.fromJsonString((String)dict, Map.class);
        }
        DynamicObjectCollection pageData = e.getPageData();
        for (DynamicObject data : pageData) {
            for (Map.Entry map : dictMap.entrySet()) {
                if (!data.getString("id").equals(map.getKey())) continue;
                data.set("name", ((Map)map.getValue()).get("name"));
                data.set("description", ((Map)map.getValue()).get("description"));
            }
        }
    }
}

