/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.plugin.AppListPlugin;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class AppTreeListPlugin
extends StandardTreeListPlugin {
    private static final Log log = LogFactory.getLog(AppTreeListPlugin.class);

    public void initializeTree(EventObject e) {
        QFilter[] filters;
        DynamicObject[] bizApps;
        String[] bizCloudIds = null;
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        List cloudListFromParameter = new ArrayList();
        Object customParam = listShowParameter.getCustomParam("bizcloudids");
        if (customParam != null) {
            cloudListFromParameter = (List)listShowParameter.getCustomParam("bizcloudids");
        }
        ArrayList<String> cloudListFromDesigner = new ArrayList<String>();
        List qFilters = listShowParameter.getListFilterParameter().getQFilters();
        if (!qFilters.isEmpty() && (bizApps = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"bizcloud_id", (QFilter[])(filters = new QFilter[]{(QFilter)qFilters.get(0)}))) != null && bizApps.length > 0) {
            for (DynamicObject bizApp : bizApps) {
                cloudListFromDesigner.add(bizApp.get("bizcloud_id").toString());
            }
        }
        if (!cloudListFromParameter.isEmpty()) {
            String[] tempList = cloudListFromParameter.toArray(new String[0]);
            if (!cloudListFromDesigner.isEmpty()) {
                cloudListFromParameter.retainAll(cloudListFromDesigner);
                if (cloudListFromParameter.isEmpty()) {
                    String notification = ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u7ed3\u679c\uff0c\u8bf7\u68c0\u67e5\u8fc7\u6ee4\u6761\u4ef6\u8bbe\u7f6e\u3002", (String)"AppTreeListPlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]);
                    this.getView().getParentView().showTipNotification(notification);
                    this.getView().close();
                } else {
                    bizCloudIds = cloudListFromParameter.toArray(new String[0]);
                }
            } else {
                bizCloudIds = tempList;
            }
        } else if (!cloudListFromDesigner.isEmpty()) {
            bizCloudIds = cloudListFromDesigner.toArray(new String[0]);
        }
        String industryId = (String)listShowParameter.getCustomParam("industryid");
        TreeNode root = AppUtils.getCloudSubsysTree((String[])bizCloudIds, (String)industryId);
        if (root != null) {
            this.getTreeModel().setRoot(root);
            String rootId = root.getId();
            this.getTreeModel().setCurrentNodeId((Object)rootId);
            log.debug("\u5b50\u7cfb\u7edf\u6811\u6839\u8282\u70b9ID\u4e3a\uff1a" + rootId);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.focusInitOrgTreeNode();
        ArrayList<String> appIds = new ArrayList<String>(10);
        DynamicObjectCollection allBizApps = BizAppServiceHelp.getAllBizApps();
        for (DynamicObject app : allBizApps) {
            appIds.add(app.getString("id"));
        }
        Map<String, Map<String, Object>> dictionaries = AppListPlugin.getDictionaries(appIds);
        this.getPageCache().put("dictionaries", SerializationUtils.toJsonString(dictionaries));
    }

    private void focusInitOrgTreeNode() {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String cloudId = (String)listShowParameter.getCustomParam("focusCloudId");
        TreeNode treeNode = null;
        if (StringUtils.isNotEmpty((CharSequence)cloudId)) {
            List treeNodes = this.getTreeModel().getRoot().getChildren();
            if (CollectionUtils.isEmpty((Collection)treeNodes)) {
                return;
            }
            TreeNode currentTreeNode = treeNodes.stream().filter(a -> a.getId().equals(cloudId)).findFirst().orElse(null);
            if (currentTreeNode != null) {
                treeNode = currentTreeNode;
            }
        }
        if (treeNode == null) {
            treeNode = this.getTreeModel().getRoot().getChildren() == null ? this.getTreeModel().getRoot() : (TreeNode)this.getTreeModel().getRoot().getChildren().get(0);
        }
        TreeView treeView = this.treeListView.getTreeView();
        treeView.focusNode(treeNode);
        this.getTreeModel().setCurrentNodeId((Object)treeNode.getId());
    }

    public void setFilter(SetFilterEvent e) {
        List cloudNodeList = this.getTreeModel().getRoot().getChildren();
        ArrayList<String> bizCloudIds = new ArrayList<String>(cloudNodeList.size());
        for (TreeNode treeNode : cloudNodeList) {
            bizCloudIds.add(treeNode.getId());
        }
        QFilter q = new QFilter("bizcloud", "in", bizCloudIds);
        e.addCustomQFilter(q);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String nodeId = e.getNodeId().toString();
        e.setCancel(true);
        ArrayList<String> cloudList = new ArrayList<String>(1);
        if ("rootNode".equals(nodeId)) {
            nodeId = ((TreeNode)this.getTreeModel().getRoot().getChildren().get(0)).getId();
        }
        cloudList.add(nodeId);
        QFilter qFilter = new QFilter("bizcloud", "in", cloudList);
        e.addQFilter(qFilter);
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        String dict = this.getPageCache().get("dictionaries");
        if (StringUtils.isBlank((CharSequence)dict)) {
            return;
        }
        Map dictMap = new HashMap(16);
        if (StringUtils.isNotBlank((CharSequence)dict)) {
            dictMap = (Map)SerializationUtils.fromJsonString((String)dict, Map.class);
        }
        DynamicObjectCollection pageData = e.getPageData();
        for (DynamicObject data : pageData) {
            for (Map.Entry map : dictMap.entrySet()) {
                if (!data.getString("id").equals(map.getKey())) continue;
                data.set("name", ((Map)map.getValue()).get("name"));
                if (!data.containsProperty("description")) continue;
                data.set("description", ((Map)map.getValue()).get("description"));
            }
        }
    }
}

