/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public abstract class BaseBizAppTreePlugin
extends AbstractFormPlugin
implements ClickListener,
TreeNodeClickListener,
ItemClickListener {
    private static final String TREEVIEWAP = "treeviewap";
    private static final String BIZAPPID = "bizappid";
    private static final String APP_TYPE = "APP_TYPE";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String KEY_SCRIPT = "_script";
    private static final String KEY_PAGE = "_page";
    public Map<String, String> pageUnits = new LinkedHashMap<String, String>(16);
    public Map<String, String> scriptUnits = new LinkedHashMap<String, String>(16);

    public void registerListener(EventObject e) {
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEWAP);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        if (!this.setPath(bizAppId)) {
            return;
        }
        TreeNode root = this.renderMenuTree(bizAppId);
        this.getPageCache().put("root", SerializationUtils.toJsonString((Object)root));
        String bizId = (String)this.getView().getFormShowParameter().getCustomParam("bizid");
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEWAP);
        if (StringUtils.isNotBlank((CharSequence)bizId)) {
            TreeNode node = root.getTreeNode(bizId, 6);
            tree.setMulti(false);
            tree.showNode(node.getId());
            tree.focusNode(node);
        } else {
            TreeNode node = root.getTreeNode(bizAppId, 5);
            tree.setMulti(true);
            tree.showNode(node.getId());
        }
    }

    protected abstract boolean setPath(String var1);

    protected TreeNode renderMenuTree(String bizAppID) {
        TreeNode root = this.renderRoot();
        List<TreeNode> nodeList = this.getNodeList(bizAppID);
        this.buildNode(root, nodeList);
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEWAP);
        tree.addNode(root);
        tree.treeNodeClick("", root.getId());
        return root;
    }

    private TreeNode renderRoot() {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        String name = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false).getName().getLocaleValue();
        TreeNode root = new TreeNode();
        root.setText(name);
        root.setId(bizAppId);
        root.setIsOpened(true);
        root.setParentid("");
        return root;
    }

    private List<TreeNode> getNodeList(String bizAppID) {
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppID, (boolean)false);
        List functionElements = appMeta.getAppFunctionPackets();
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        ArrayList<TreeNode> entryParent = new ArrayList<TreeNode>(functionElements.size());
        for (AppFunctionPacketElement functionElement : functionElements) {
            String nodeID = functionElement.getId();
            String text = (String)functionElement.getName().getDefaultItem();
            String number = functionElement.getNumber();
            TreeNode func = new TreeNode();
            func.setText(text);
            func.setId(nodeID);
            func.setParentid(bizAppID);
            func.setData((Object)number);
            if (APP_TYPE.equals(type)) {
                func.setIsOpened(false);
            } else {
                func.setIsOpened(true);
            }
            entryParent.add(func);
            if (!APP_TYPE.equals(type)) continue;
            TreeNode formNode = new TreeNode();
            formNode.setText(ResManager.loadKDString((String)"\u9875\u9762", (String)"BizAppTreePlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            formNode.setId(nodeID + KEY_PAGE);
            formNode.setParentid(nodeID);
            formNode.setIsOpened(false);
            func.addChild(formNode);
            QFilter unitFilter = new QFilter("bizunit", "=", (Object)nodeID);
            QFilter unitFilter_1 = new QFilter("bizapp", "=", (Object)bizAppID);
            QFilter[] unitFilters = new QFilter[]{unitFilter, unitFilter_1};
            String unitrelformFields = "bizapp,bizunit,form";
            String formFields = "id,number,name,type,parentid";
            try (DataSet unitFormDataSet = QueryServiceHelper.queryDataSet((String)"bos_devportal_unitrelform", (String)"bos_devportal_unitrelform", (String)unitrelformFields, (QFilter[])unitFilters, (String)"form asc");
                 DataSet formDataSet = QueryServiceHelper.queryDataSet((String)"bos_formmeta", (String)"bos_formmeta", (String)formFields, null, (String)"number asc");
                 DataSet result = unitFormDataSet.join(formDataSet, JoinType.INNER).on("form", "id").select(new String[]{"bizunit", "form"}, new String[]{"id", "number", "name", "type", "parentid"}).finish();){
                for (Row row : result) {
                    TreeNode formsNode = new TreeNode();
                    formsNode.setParentid(nodeID + KEY_PAGE);
                    formsNode.setId(row.getString("id"));
                    formsNode.setText(row.getString("name"));
                    formsNode.setData((Object)row.getString("number"));
                    formsNode.setIsOpened(false);
                    formNode.addChild(formsNode);
                    this.pageUnits.put(formsNode.getId(), nodeID);
                }
            }
            TreeNode scriptNode = new TreeNode();
            scriptNode.setText(ResManager.loadKDString((String)"\u811a\u672c", (String)"BizAppTreePlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            scriptNode.setId(nodeID + KEY_SCRIPT);
            scriptNode.setParentid(nodeID);
            scriptNode.setIsOpened(false);
            func.addChild(scriptNode);
            String scriptFields = "id, txt_scriptnumber, txt_scriptname";
            QFilter scriptFilter_1 = new QFilter(BIZAPPID, "=", (Object)bizAppID);
            QFilter scriptFilter_2 = new QFilter("bizunitid", "=", (Object)nodeID);
            QFilter[] scriptFilters = new QFilter[]{scriptFilter_1, scriptFilter_2};
            String scriptOrderBy = "txt_scriptnumber";
            DynamicObjectCollection scriptInfo = QueryServiceHelper.query((String)"ide_pluginscript", (String)scriptFields, (QFilter[])scriptFilters, (String)scriptOrderBy);
            for (DynamicObject obj : scriptInfo) {
                TreeNode scriptsNode = new TreeNode();
                scriptsNode.setParentid(nodeID + KEY_SCRIPT);
                scriptsNode.setId(obj.getString("id"));
                scriptsNode.setText(obj.getString("txt_scriptname"));
                scriptsNode.setData((Object)obj.getString("txt_scriptnumber"));
                scriptsNode.setIsOpened(false);
                scriptNode.addChild(scriptsNode);
                this.scriptUnits.put(scriptsNode.getId(), nodeID);
            }
        }
        this.getView().getPageCache().put("pageUnits", SerializationUtils.toJsonString(this.pageUnits));
        this.getView().getPageCache().put("scriptUnits", SerializationUtils.toJsonString(this.scriptUnits));
        return entryParent;
    }

    private TreeNode buildNode(TreeNode pnode, List<TreeNode> childNode) {
        HashMap<String, TreeNode> leafNodeMap = new HashMap<String, TreeNode>();
        this.getLeafNodes(leafNodeMap, pnode);
        for (int i = 0; i < childNode.size(); ++i) {
            TreeNode cnode = childNode.get(i);
            String parentID = cnode.getParentid();
            TreeNode parNode = (TreeNode)leafNodeMap.get(parentID);
            if (parNode == null) continue;
            int seq = 0;
            if (parNode.getChildren() != null) {
                seq = parNode.getChildren().size();
            }
            parNode.addChild(seq, cnode);
        }
        return pnode;
    }

    private void getLeafNodes(Map<String, TreeNode> map, TreeNode node) {
        if (node.getChildren() != null) {
            for (TreeNode childNode : node.getChildren()) {
                this.getLeafNodes(map, childNode);
            }
        } else {
            map.put(node.getId(), node);
            return;
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "btnok": {
                this.btnok();
                break;
            }
        }
    }

    private void btnok() {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            this.getView().showTipNotification(DevportalUtil.getNoPermissionTip());
            return;
        }
        JSONObject msg = new JSONObject();
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEWAP);
        List selectNodes = tree.getTreeState().getSelectedNodes();
        ArrayList<String> pageIds = new ArrayList<String>();
        ArrayList<String> scriptIds = new ArrayList<String>();
        ArrayList<String> unitTestIds = new ArrayList<String>();
        boolean checkinappFlag = (Boolean)this.getModel().getValue("checkinapp");
        if (!checkinappFlag && APP_TYPE.equals(type) && selectNodes.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u5143\u6570\u636e\u3002", (String)"BizAppTreePlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        for (Map selectNode : selectNodes) {
            String parentid = (String)selectNode.get("parentid");
            String bizId = (String)selectNode.get("id");
            if (parentid.endsWith(KEY_PAGE)) {
                pageIds.add(bizId);
                continue;
            }
            if (parentid.endsWith(KEY_SCRIPT)) {
                scriptIds.add(bizId);
                continue;
            }
            if (!parentid.endsWith("_unittest")) continue;
            unitTestIds.add(bizId);
        }
        String annotation = (String)this.getModel().getValue("annotation");
        msg.put("annotation", (Object)annotation);
        msg.put("pageids", (Object)SerializationUtils.toJsonString(pageIds));
        msg.put("scriptids", (Object)SerializationUtils.toJsonString(scriptIds));
        msg.put("unittestids", (Object)SerializationUtils.toJsonString(unitTestIds));
        msg.put("checkinappflag", (Object)checkinappFlag);
        msg.put("pageUnits", (Object)this.getView().getPageCache().get("pageUnits"));
        msg.put("scriptUnits", (Object)this.getView().getPageCache().get("scriptUnits"));
        this.getView().returnDataToParent((Object)msg.toJSONString());
        this.getView().close();
    }
}

