/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class BizAPPHierarchyPlugin
extends AbstractFormPlugin
implements ClickListener,
TreeNodeClickListener {
    private static final String TREEVIEWAP = "treeviewap";
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String PARENTID = "parentid";
    private static final String ENTITY_NUMBER_BIZAPP = "bos_devportal_bizapp";

    public void registerListener(EventObject e) {
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEWAP);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"confirm"});
    }

    public void afterCreateNewData(EventObject evt) {
        String bizappId = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
        TreeNode root = new TreeNode();
        TreeNode node = this.getTopPageInfo(bizappId, root);
        this.getAllChildrenPages(node);
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEWAP);
        tree.addNode(root);
        tree.focusNode(node);
        tree.treeNodeClick("", node.getId());
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "confirm": {
                TreeView tree = (TreeView)this.getView().getControl(TREEVIEWAP);
                List selectNodeIds = tree.getTreeState().getSelectedNodeId();
                String selectedNodeId = (String)selectNodeIds.get(0);
                this.gotoSelectedPage(selectedNodeId);
                break;
            }
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
        String selectedNodeId = evt.getNodeId().toString();
        this.gotoSelectedPage(selectedNodeId);
    }

    private void gotoSelectedPage(String selectedNodeId) {
        JSONObject positionMsg = new JSONObject();
        positionMsg.put("bizpageid", (Object)selectedNodeId);
        QFilter q = new QFilter(ID, "=", (Object)selectedNodeId);
        QFilter[] filters = new QFilter[]{q};
        boolean exists = QueryServiceHelper.exists((String)ENTITY_NUMBER_BIZAPP, (QFilter[])filters);
        if (!exists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9875\u9762\u4e0d\u5728\u5f00\u53d1\u8005\u95e8\u6237\u4e2d\u3002", (String)"BizAPPHierarchyPlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        } else {
            AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)selectedNodeId, (boolean)false);
            positionMsg.put("bizcloudid", (Object)appMetadata.getBizCloudID());
            positionMsg.put("bizappid", (Object)selectedNodeId);
        }
        this.getView().returnDataToParent((Object)positionMsg);
        this.getView().close();
    }

    private void getAllChildrenPages(TreeNode node) {
        String bizappId = node.getId();
        QFilter filter = new QFilter(PARENTID, "=", (Object)bizappId);
        DynamicObject[] appObjs = BusinessDataServiceHelper.load((String)ENTITY_NUMBER_BIZAPP, (String)"id,number,name,parentid", (QFilter[])new QFilter[]{filter});
        if (appObjs != null && appObjs.length > 0) {
            for (DynamicObject app : appObjs) {
                TreeNode childNode = new TreeNode();
                childNode.setId((String)app.getPkValue());
                String appName = "";
                Object name = app.get(NAME);
                appName = name instanceof OrmLocaleValue ? ((OrmLocaleValue)name).toString() : (String)name;
                childNode.setText(appName + "(" + app.getString(NUMBER) + ")");
                childNode.setParentid(bizappId);
                childNode.setData((Object)app.getString(NUMBER));
                childNode.setIsOpened(true);
                this.getAllChildrenPages(childNode);
                node.addChild(childNode);
            }
        }
    }

    private TreeNode getTopPageInfo(String bizappId, TreeNode root) {
        TreeNode node = new TreeNode();
        List<String> selectProps = Arrays.asList(ID, NUMBER, NAME, PARENTID);
        DynamicObjectType dt = EntityMetadataCache.getSubDataEntityType((String)ENTITY_NUMBER_BIZAPP, selectProps);
        DynamicObject[] appObjs = BusinessDataServiceHelper.load((Object[])new Object[]{bizappId}, (DynamicObjectType)dt);
        if (appObjs != null && appObjs.length != 0) {
            for (DynamicObject app : appObjs) {
                node.setId((String)app.getPkValue());
                String appName = "";
                Object name = app.get(NAME);
                appName = name instanceof OrmLocaleValue ? ((OrmLocaleValue)name).toString() : (String)name;
                node.setText(appName + "(" + app.getString(NUMBER) + ")");
                node.setData((Object)app.getString(NUMBER));
                node.setIsOpened(true);
                String formParentId = app.getString(PARENTID);
                if (formParentId == null || formParentId.trim().length() == 0) {
                    node.setParentid("");
                    root.setId(node.getId());
                    root.setParentid(node.getParentid());
                    root.setText(node.getText());
                    root.setData(node.getData());
                    root.setIsOpened(node.getIsOpened());
                    return root;
                }
                node.setParentid(formParentId);
                TreeNode parentRoot = this.getTopPageInfo(formParentId, root);
                parentRoot.addChild(node);
            }
        }
        return node;
    }
}

