/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.devportal.AppElement;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class BizAppDetailsPlugin
extends AbstractFormPlugin
implements ClickListener,
TabSelectListener {
    private static final String EXTENDCOUNT = "extendcount";
    private static final String APPID = "appid";
    private static final String UNITCOUNT = "unitcount";
    private static final String SCRIPTCOUNT = "scriptcount";
    private static final String PAGECOUNT = "pagecount";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String BIZAPPDETAILCACHE = "bizappdetailcache";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{UNITCOUNT, PAGECOUNT, "cardcount", SCRIPTCOUNT, EXTENDCOUNT});
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String bizAppId = (String)parameter.getCustomParam(APPID);
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        AppElement appElement = appMetadata.getAppElement();
        this.getModel().setValue("name", (Object)appElement.getName().getLocaleValue());
        this.getModel().setValue("number", (Object)appMetadata.getNumber());
        this.getModel().setValue("simplenumber", (Object)appElement.getSimpleNumber());
        this.getModel().setValue("bizcloud", (Object)appMetadata.getBizCloudID());
        List appFunctionPackets = appMetadata.getAppFunctionPackets();
        JSONArray functionPacketIDs = new JSONArray();
        for (AppFunctionPacketElement functionPacket : appFunctionPackets) {
            if ("2".equals(appMetadata.getDevType())) {
                String type = functionPacket.getType();
                if (!"2".equals(type) && !"3".equals(type)) continue;
                functionPacketIDs.add((Object)functionPacket.getId());
                continue;
            }
            functionPacketIDs.add((Object)functionPacket.getId());
        }
        Label unitcount = (Label)this.getControl(UNITCOUNT);
        unitcount.setText(String.valueOf(functionPacketIDs.size()));
        DynamicObject[] pages = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)"id", (QFilter[])new QFilter[]{new QFilter("bizappid", "=", (Object)bizAppId)});
        Label pagecount = (Label)this.getControl(PAGECOUNT);
        pagecount.setText(String.valueOf(pages.length));
        DynamicObject[] scripts = BusinessDataServiceHelper.load((String)"ide_pluginscript", (String)"id", (QFilter[])new QFilter[]{new QFilter("bizappid", "=", (Object)bizAppId)});
        Label scriptcount = (Label)this.getControl(SCRIPTCOUNT);
        scriptcount.setText(String.valueOf(scripts.length));
        if ("2".equals(appMetadata.getDevType())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"extendappcountpanel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"blank"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"extendappcountpanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"blank"});
            String countNumber = DevportalUtil.getSysExtendedCount(bizAppId, "bos_devportal_bizapp", "masterid");
            Label extendcount = (Label)this.getControl(EXTENDCOUNT);
            if (StringUtils.isBlank((CharSequence)countNumber)) {
                countNumber = "0";
            }
            extendcount.setText(countNumber);
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase()) {
            case "unitcount": {
                this.openTabPage(ResManager.loadKDString((String)"\u529f\u80fd\u5206\u7ec4\u5217\u8868", (String)"BizAppDetailsPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), "detail_unitlist", "unitcountpagedetails");
                break;
            }
            case "pagecount": {
                this.openTabPage(ResManager.loadKDString((String)"\u9875\u9762\u5217\u8868", (String)"BizAppDetailsPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), "detail_pagelist", "pagecountpagedetails");
                break;
            }
            case "cardcount": {
                this.openTabPage(ResManager.loadKDString((String)"\u5361\u7247\u5217\u8868", (String)"BizAppDetailsPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), "detail_cardlist", "cardcountpagedetails");
                break;
            }
            case "scriptcount": {
                this.openTabPage(ResManager.loadKDString((String)"\u811a\u672c\u5217\u8868", (String)"BizAppDetailsPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), "detail_scriptlist", "scriptcountpagedetails");
                break;
            }
            case "extendcount": {
                this.openTabPage(ResManager.loadKDString((String)"\u6269\u5c55\u5e94\u7528\u5217\u8868", (String)"BizAppDetailsPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), "detail_extendapplist", "extendappcountpagedetails");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        IPageCache pageCache = this.getPageCache();
        String detailCache = pageCache.get(BIZAPPDETAILCACHE);
        if (detailCache != null) {
            JSONObject bizAppDetailCache = JSONObject.parseObject((String)detailCache);
            bizAppDetailCache.remove((Object)e.getActionId());
            pageCache.put(BIZAPPDETAILCACHE, bizAppDetailCache.toJSONString());
        }
    }

    private void openTabPage(String tabTitle, String formId, String closeCallBackActionAndCacheId) {
        IPageCache pageCache = this.getPageCache();
        String detailCache = pageCache.get(BIZAPPDETAILCACHE);
        if (detailCache == null) {
            String pageId = this.showFormPage(tabTitle, formId, closeCallBackActionAndCacheId);
            JSONObject bizAppDetailCache = new JSONObject();
            bizAppDetailCache.put(closeCallBackActionAndCacheId, (Object)pageId);
            pageCache.put(BIZAPPDETAILCACHE, bizAppDetailCache.toJSONString());
        } else {
            JSONObject bizAppDetailCache = JSONObject.parseObject((String)detailCache);
            if (!bizAppDetailCache.containsKey((Object)closeCallBackActionAndCacheId)) {
                String pageId = this.showFormPage(tabTitle, formId, closeCallBackActionAndCacheId);
                bizAppDetailCache.put(closeCallBackActionAndCacheId, (Object)pageId);
                pageCache.put(BIZAPPDETAILCACHE, bizAppDetailCache.toJSONString());
            } else {
                String pageId = bizAppDetailCache.getString(closeCallBackActionAndCacheId);
                this.getView().getView(pageId).activate();
                this.getView().sendFormAction(this.getView().getView(pageId));
            }
        }
    }

    private String showFormPage(String tabTitle, String formId, String closeCallBackActionId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        parameter.getOpenStyle().setTargetKey("tabap");
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(APPID);
        parameter.setCustomParam(APPID, (Object)bizAppId);
        parameter.setCaption(tabTitle);
        parameter.setFormId(formId);
        String pageId = UUID.randomUUID().toString();
        parameter.setPageId(pageId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeCallBackActionId));
        this.getView().showForm(parameter);
        return pageId;
    }

    public void tabSelected(TabSelectEvent arg0) {
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.getPageCache().remove(BIZAPPDETAILCACHE);
    }
}

