/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBType;
import kd.bos.devportal.upgrade.factory.ConfDeployServiceFactory;
import kd.bos.devportal.upgrade.service.ConfDeployService;
import kd.bos.devportal.util.AppPackageUtil;
import kd.bos.entity.ISVInfo;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.MessageTypes;
import kd.bos.form.container.Tab;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class BizAppFullDeployTplPlugin
extends AbstractFormPlugin {
    static final String TABPANEL = "tabpanel";
    protected static final String KEY_ADDAPPMETA = "addappmeta";
    protected static final String KEY_ADDAPPLABEL = "addapplabel";
    protected static final String TREEVIEW_AP = "treeviewap";
    protected static final String BTN_ADDNODE = "btn_addnode";
    protected static final String BTN_DELNODE = "btn_delnode";
    protected static final String KEY_APPSEQBUTTON = "appseqbutton";
    protected static final String KEY_APPSEQINFO = "appseqinfo";
    protected static final String TREEVIEW_SELECT = "treeviewselect";
    protected static final String NEXT_STEP = "nextstep";
    protected static final String KEY_METACONFIRM = "metaconfirm";
    protected static final String KEY_CONF_LEFTTREE = "conftree";
    protected static final String KEY_CONFBTN_ADDNODE = "confbtn_addnode";
    protected static final String KEY_CONFBTN_DELNODE = "confbtn_delnode";
    protected static final String KEY_CONF_ISOVERRIDE = "isoverride";
    protected static final String KEY_CONF_RIGHTTREE = "conftreeselect";
    protected static final String KEY_BRFORECONF = "beforeconf";
    protected static final String KEY_NEXTCONF = "nextconf";
    protected static final String KEY_CONFCONFIRM = "confconfirm";
    protected static final String SQLENTRYENTITY = "sqlentryentity";
    protected static final String KEY_SQLENTRY_SQLNAME = "sqlname";
    protected static final String KEY_SQLENTRY_SQLAPP = "sqlapp";
    protected static final String KEY_SQLENTRY_SQLFILETYPE = "sqlfiletype";
    protected static final String KEY_SQLENTRY_DBTYPE = "dbtype";
    protected static final String KEY_SQLENTRY_URLPATH = "urlpath";
    protected static final String BEFORE_STEP = "beforestep";
    protected static final String NEXT_SOURCE = "nextsource";
    protected static final String KEY_ATTACONFIRM = "attachmentconfirm";
    protected static final String KEY_ENTRY_RESOURCE = "sourceentryentity";
    protected static final String UPLOADSOURCE = "uploadsource";
    protected static final String KEY_RESOURCEENTRY_NAME = "sourcename";
    protected static final String KEY_RESOURCEENTRY_APPID = "resourceappid";
    protected static final String KEY_RESOURCEENTRY_TYPE = "resourcetype";
    protected static final String KEY_RESOURCEENTRY_URL = "sourceurl";
    protected static final String BEFORE_SQL = "beforesql";
    protected static final String NEXT_INFO = "nextinfo";
    protected static final String KEY_SOURCECONFIRM = "sourceconfirm";
    protected static final String KEY_RESOURCETYPE_JAR = "jar";
    protected static final String KEY_RESOURCETYPE_STATIC = "static";
    protected static final String PATCHCHECKED = "patchchecked";
    protected static final String PKVERSION = "pkversion";
    protected static final String KEY_PKGDESC = "pacckdescription";
    protected static final String BEFORE_SOURCE = "beforesource";
    protected static final String KEY_INFOCONFIRM = "infoconfirm";
    protected static final String LEFTAPPIDS = "leftappids";
    protected static final String APPIDSVALUE = "appidsvalue";
    protected static final String SELECTAPPIDS = "selectappids";
    protected static final String LEFTROOT = "leftroot";
    protected static final String KEY_CACHE_CONFSELECTAPPIDS = "confselectappids";
    protected static final String KEY_CACHE_CONFLEFTROOTNODE = "confleftroot";
    protected static final String KEY_CACHE_CONFRIGHTROOTNODE = "confrightroot";
    protected static final String KEY_CACHE_CONFROOTNODEID = "confrootnode";
    protected static final String KEY_CACHE_CONFLEFTTREESELECTNODES = "conflefttreeselectnodes";
    protected static final String SELECT_APP_PATH = "selectapppath";
    protected static final String DETAILERRORINFO = "detailerrorinfo";
    protected static final String DATAMODEL = "datamodel";
    protected static final String MAIN = "main";
    protected static final String METADATA = "metadata";
    protected static final String DBSCHEMA = "dbschema";
    protected static final String PREINSDATA = "preinsdata";
    protected static final List<String> EXPORTEDENTITYDATAUNDERAPP = Arrays.asList("portal_scheme", "bos_coderule", "perm_permitem", "sch_schedule", "bos_billtype");
    protected static final List<String> EXPORTEDENTITYDATA = Collections.singletonList("portal_scheme_group");
    protected static final String BIZAPPID = "bizappid";

    public void afterBindData(EventObject e) {
        ComboEdit dataBaseCombo = (ComboEdit)this.getView().getControl(KEY_SQLENTRY_DBTYPE);
        DBType[] dbTypeArr = DBType.values();
        ArrayList<ComboItem> dataBaseComboList = new ArrayList<ComboItem>(dbTypeArr.length + 1);
        dataBaseComboList.add(new ComboItem(new LocaleString("KSQL"), "KSQL"));
        for (DBType dbType : dbTypeArr) {
            String dbName = dbType.name();
            dataBaseComboList.add(new ComboItem(new LocaleString(dbName.toUpperCase()), dbName.toUpperCase()));
        }
        dataBaseCombo.setComboItems(dataBaseComboList);
    }

    protected List<TreeNode> createConfLeftTreeNodes(List<String> appIds) {
        StringBuilder detailErrorMsg = new StringBuilder();
        StringBuilder errItemBuilder = new StringBuilder();
        StringBuilder detailErrorLogInfo = new StringBuilder();
        ArrayList<TreeNode> confLeftTreeNodeList = new ArrayList<TreeNode>(appIds.size());
        for (String bizAppId : appIds) {
            List subTreeNodes;
            Map<String, Object> billTypeRetMap;
            Map<String, Object> scheduleRetMap;
            Map<String, Object> permItemRetMap;
            Map<String, Object> codeRuleRetMap;
            AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
            TreeNode bizAppNode = this.generateAppNode(appMeta);
            ConfDeployService service = ConfDeployServiceFactory.getService("PortalSchemaDataDeployService");
            Map<String, Object> portalSchemaRetMap = service.createTreeNodes(bizAppId, EXPORTEDENTITYDATAUNDERAPP.get(0), bizAppNode);
            if (!Boolean.parseBoolean(portalSchemaRetMap.get("success").toString())) {
                errItemBuilder.append(ResManager.loadKDString((String)"\u5e94\u7528\u5de5\u4f5c\u53f0", (String)"BizAppFullDeployTplPlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0])).append(", ");
                detailErrorLogInfo.append(portalSchemaRetMap.get("message")).append(System.lineSeparator());
            }
            if (!Boolean.parseBoolean((codeRuleRetMap = (service = ConfDeployServiceFactory.getService("CodeRuleDataDeployService")).createTreeNodes(bizAppId, EXPORTEDENTITYDATAUNDERAPP.get(1), bizAppNode)).get("success").toString())) {
                errItemBuilder.append(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219", (String)"BizAppFullDeployTplPlugin_1", (String)"bos-devportal-plugin", (Object[])new Object[0])).append(", ");
                detailErrorLogInfo.append(codeRuleRetMap.get("message")).append(System.lineSeparator());
            }
            if (!Boolean.parseBoolean((permItemRetMap = (service = ConfDeployServiceFactory.getService("PermItemDataDeployService")).createTreeNodes(bizAppId, EXPORTEDENTITYDATAUNDERAPP.get(2), bizAppNode)).get("success").toString())) {
                errItemBuilder.append(ResManager.loadKDString((String)"\u6743\u9650\u9879", (String)"BizAppFullDeployTplPlugin_2", (String)"bos-devportal-plugin", (Object[])new Object[0])).append(", ");
                detailErrorLogInfo.append(permItemRetMap.get("message")).append(System.lineSeparator());
            }
            if (!Boolean.parseBoolean((scheduleRetMap = (service = ConfDeployServiceFactory.getService("ScheduleDataDeployService")).createTreeNodes(bizAppId, EXPORTEDENTITYDATAUNDERAPP.get(3), bizAppNode)).get("success").toString())) {
                errItemBuilder.append(ResManager.loadKDString((String)"\u540e\u53f0\u8c03\u5ea6\u4efb\u52a1", (String)"BizAppFullDeployTplPlugin_3", (String)"bos-devportal-plugin", (Object[])new Object[0])).append(", ");
                detailErrorLogInfo.append(scheduleRetMap.get("message")).append(System.lineSeparator());
            }
            if (!Boolean.parseBoolean((billTypeRetMap = (service = ConfDeployServiceFactory.getService("BillTypeDataDeployService")).createTreeNodes(bizAppId, EXPORTEDENTITYDATAUNDERAPP.get(4), bizAppNode)).get("success").toString())) {
                errItemBuilder.append(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b", (String)"BizAppFullDeployTplPlugin_4", (String)"bos-devportal-plugin", (Object[])new Object[0])).append(", ");
                detailErrorLogInfo.append(billTypeRetMap.get("message")).append(System.lineSeparator());
            }
            if ((subTreeNodes = bizAppNode.getChildren()) != null && !subTreeNodes.isEmpty()) {
                confLeftTreeNodeList.add(bizAppNode);
            }
            if (!StringUtils.isNotBlank((CharSequence)errItemBuilder)) continue;
            errItemBuilder.deleteCharAt(errItemBuilder.lastIndexOf(","));
            detailErrorMsg.append(String.format(ResManager.loadKDString((String)"%1$s \u52a0\u8f7d\u3010%2$s\u3011\u65f6\u51fa\u73b0\u9519\u8bef\uff0c\u8be6\u60c5\u8bf7\u67e5\u9605\u65e5\u5fd7\u3002", (String)"BizAppFullDeployTplPlugin_5", (String)"bos-devportal-plugin", (Object[])new Object[0]), bizAppNode.getText(), errItemBuilder)).append(System.lineSeparator());
        }
        ArrayList<TreeNode> funcAppNodeList = new ArrayList<TreeNode>();
        QFilter itemFilter = new QFilter("number", "in", new ArrayList());
        DynamicObjectCollection entityColl = ORM.create().query("bos_entitymeta", "id, number, name, bizapp", itemFilter.toArray());
        for (DynamicObject entity : entityColl) {
            ISVInfo isvInfo = ISVServiceHelper.getISVInfo();
            QFilter filter = new QFilter("number", "like", (Object)(isvInfo.getId() + "%"));
            DynamicObjectCollection dataColl = ORM.create().query(entity.getString("number"), null);
            String appId = entity.getString("bizapp");
            if (dataColl == null || dataColl.isEmpty()) continue;
            boolean newFuncAppNode = true;
            TreeNode appNode = new TreeNode();
            for (TreeNode funcNode : funcAppNodeList) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)appId, (CharSequence)funcNode.getId())) continue;
                appNode = funcNode;
                newFuncAppNode = false;
                break;
            }
            if (newFuncAppNode) {
                AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)false);
                appNode = new TreeNode(KEY_CACHE_CONFROOTNODEID, appId, appMetadata.getName().getLocaleValue());
                funcAppNodeList.add(appNode);
            }
            TreeNode funcNode = this.geneConfNode(appId, entity.getString("number"), entity.getLocaleString("name").getLocaleValue());
            appNode.addChild(funcNode);
            AppPackageUtil.createDataNode(dataColl, funcNode);
        }
        if (!funcAppNodeList.isEmpty()) {
            confLeftTreeNodeList.addAll(funcAppNodeList);
        }
        if (StringUtils.isNotBlank((CharSequence)detailErrorLogInfo)) {
            this.addValToPageCache(DETAILERRORINFO, detailErrorLogInfo.toString());
        }
        if (StringUtils.isNotBlank((CharSequence)detailErrorMsg)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5e94\u7528\u5143\u6570\u636e\u4e0d\u5b8c\u6574\u3002", (String)"BizAppFullDeployTplPlugin_6", (String)"bos-devportal-plugin", (Object[])new Object[0]), detailErrorMsg.toString(), MessageTypes.Default);
        }
        return confLeftTreeNodeList;
    }

    private TreeNode generateAppNode(AppMetadata appMeta) {
        long bizappIndustryId;
        DynamicObject industryObject;
        String industryName = "";
        if (StringUtils.isNotBlank((Object)appMeta.getIndustryId()) && StringUtils.isNotBlank((Object)(industryObject = BusinessDataServiceHelper.loadSingleFromCache((Object)(bizappIndustryId = appMeta.getIndustryId().longValue()), (String)"bos_devp_industry", (String)"name")))) {
            industryName = BusinessDataServiceHelper.loadSingleFromCache((Object)bizappIndustryId, (String)"bos_devp_industry").getLocaleString("name").getLocaleValue();
        }
        String appNodeText = String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u529f\u80fd\u914d\u7f6e", (String)"BizAppFullDeployTplPlugin_7", (String)"bos-devportal-plugin", (Object[])new Object[0]), appMeta.getName().getLocaleValue());
        if (StringUtils.isNotBlank((CharSequence)industryName)) {
            appNodeText = String.format(ResManager.loadKDString((String)"\u3010%1$s\uff08%2$s\uff09\u529f\u80fd\u914d\u7f6e\u3011", (String)"BizAppFullDeployTplPlugin_8", (String)"bos-devportal-plugin", (Object[])new Object[0]), appMeta.getName().getLocaleValue(), industryName);
        }
        TreeNode bizAppNode = new TreeNode(KEY_CACHE_CONFROOTNODEID, appMeta.getId(), appNodeText);
        return bizAppNode;
    }

    private TreeNode geneConfNode(String parentId, String dataId, String nodeText) {
        String nodeId = String.format("%1$s#%2$s", parentId, dataId);
        return new TreeNode(parentId, nodeId, nodeText);
    }

    protected void beforeStep(String key) {
        Tab tab = (Tab)this.getView().getControl(TABPANEL);
        if (KEY_BRFORECONF.equals(key)) {
            tab.activeTab("metatab");
        } else if (BEFORE_STEP.equals(key)) {
            tab.activeTab("config");
        } else if (BEFORE_SQL.equals(key)) {
            tab.activeTab("uploadtab");
        } else if (BEFORE_SOURCE.equals(key)) {
            tab.activeTab("sourceupload");
        }
    }

    protected void nextStep(String key) {
        Tab tab = (Tab)this.getView().getControl(TABPANEL);
        if (NEXT_STEP.equals(key)) {
            tab.activeTab("config");
        } else if (KEY_NEXTCONF.equals(key)) {
            tab.activeTab("uploadtab");
        } else if (NEXT_SOURCE.equals(key)) {
            tab.activeTab("sourceupload");
        } else if (NEXT_INFO.equals(key)) {
            tab.activeTab("packageinfo");
        }
    }

    protected List<String> getSelectAppIds(String cacheKey) {
        List selectAppList = null;
        String selectAppIds = this.getPageCache().get(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)selectAppIds)) {
            selectAppList = (List)SerializationUtils.fromJsonString((String)selectAppIds, List.class);
        }
        return selectAppList;
    }

    protected void changeToConfirm() {
        Tab tab = (Tab)this.getView().getControl(TABPANEL);
        tab.activeTab("packageinfo");
    }

    protected Object addValToPageCache(String cacheKey, Object value) {
        Object newVal = null;
        String content = this.getPageCache().get(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)content)) {
            switch (cacheKey) {
                case "detailerrorinfo": {
                    content = StringUtils.join((Object[])new String[]{content, value.toString(), System.lineSeparator()});
                    newVal = content;
                    break;
                }
                case "conflefttreeselectnodes": {
                    List confLeftTreeSelectNodeList = (List)SerializationUtils.fromJsonString((String)content, List.class);
                    List confSelectNodes = (List)value;
                    for (Map selectNodeMap : confSelectNodes) {
                        if (confLeftTreeSelectNodeList.contains(selectNodeMap)) continue;
                        confLeftTreeSelectNodeList.add(selectNodeMap);
                    }
                    content = SerializationUtils.toJsonString((Object)confLeftTreeSelectNodeList);
                    newVal = confLeftTreeSelectNodeList;
                    break;
                }
            }
        } else {
            switch (cacheKey) {
                case "detailerrorinfo": {
                    content = StringUtils.join((Object[])new String[]{value.toString(), System.lineSeparator()});
                    break;
                }
                case "conflefttreeselectnodes": {
                    content = SerializationUtils.toJsonString((Object)value);
                    break;
                }
            }
            newVal = value;
        }
        this.getPageCache().put(cacheKey, content);
        return newVal;
    }

    protected Object delValInPageCache(String cacheKey, Object value) {
        List newVal = null;
        String content = this.getPageCache().get(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)content)) {
            switch (cacheKey) {
                case "conflefttreeselectnodes": {
                    List confLeftTreeSelectNodeList = (List)SerializationUtils.fromJsonString((String)content, List.class);
                    List confSelectNodes = (List)value;
                    for (Map selectNodeMap : confSelectNodes) {
                        confLeftTreeSelectNodeList.remove(selectNodeMap);
                    }
                    content = SerializationUtils.toJsonString((Object)confLeftTreeSelectNodeList);
                    newVal = confLeftTreeSelectNodeList;
                }
            }
        }
        this.getPageCache().put(cacheKey, content);
        return newVal;
    }

    protected void clearValInPageCache(String ... cacheKeys) {
        for (String cacheKey : cacheKeys) {
            this.getPageCache().remove(cacheKey);
        }
    }
}

