/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.plugin.BizAppFullDeployTplPlugin;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BizAppFullDeployTreePlugin
extends BizAppFullDeployTplPlugin
implements TreeNodeClickListener,
ClickListener {
    private static Log logger = LogFactory.getLog(BizAppFullDeployTreePlugin.class);

    public void registerListener(EventObject e) {
        TreeView confLeftTreeView = (TreeView)this.getView().getControl("conftree");
        confLeftTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeView confRightTreeView = (TreeView)this.getView().getControl("conftreeselect");
        confRightTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"confbtn_addnode", "confbtn_delnode", "beforeconf", "nextconf", "confconfirm"});
    }

    public void afterCreateNewData(EventObject e) {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
        this.confTreesBindData(bizAppId);
        super.afterCreateNewData(e);
    }

    private void confTreesBindData(String appId) {
        ArrayList<String> appIdList = new ArrayList<String>();
        appIdList.add(appId);
        TreeNode confLeftRootNode = this.renderNewConfTreeRoot("left", "confrootnode");
        long start = new Date().getTime();
        confLeftRootNode.addChildren(this.createConfLeftTreeNodes(appIdList));
        long end = new Date().getTime();
        logger.debug(String.format("\u3010\u914d\u7f6e\u4fe1\u606f\u3011\u9875\u7b7e\u5de6\u6811\u6784\u9020\u6240\u6709\u5b50\u7ea7\u8282\u70b9\u5171\u82b1\u8d39\u65f6\u95f4\uff1a%s ms", end - start));
        this.getPageCache().put("confleftroot", SerializationUtils.toJsonString((Object)confLeftRootNode));
        TreeView confLeftTreeView = (TreeView)this.getView().getControl("conftree");
        confLeftTreeView.setMulti(true);
        confLeftTreeView.setRootVisible(true);
        confLeftTreeView.addNode(confLeftRootNode);
        TreeNode confRightRootNode = this.renderNewConfTreeRoot("right", "confrootnode");
        this.getPageCache().put("confrightroot", SerializationUtils.toJsonString((Object)confRightRootNode));
        TreeView confRightTreeView = (TreeView)this.getView().getControl("conftreeselect");
        confRightTreeView.setMulti(true);
        confRightTreeView.setRootVisible(true);
        confRightTreeView.addNode(confRightRootNode);
    }

    private TreeNode renderNewConfTreeRoot(String position, String nodeId) {
        String nodeText = ResManager.loadKDString((String)"\u529f\u80fd\u914d\u7f6e", (String)"BizAppFullDeployTreePlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]);
        if (StringUtils.equalsIgnoreCase((CharSequence)position, (CharSequence)"right")) {
            nodeText = String.format(ResManager.loadKDString((String)"\u5df2\u9009%s", (String)"BizAppFullDeployTreePlugin_1", (String)"bos-devportal-plugin", (Object[])new Object[0]), nodeText);
        }
        TreeNode root = new TreeNode("", nodeId, nodeText);
        root.setIsOpened(true);
        return root;
    }

    public void click(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "confbtn_addnode": {
                this.confRightTreeAddNodes();
                break;
            }
            case "confbtn_delnode": {
                this.confRightTreeDelNodes();
                break;
            }
            case "beforeconf": {
                this.beforeStep(key);
                break;
            }
            case "nextconf": {
                this.nextStep(key);
                break;
            }
            case "confconfirm": {
                this.changeToConfirm();
                break;
            }
        }
        super.click(evt);
    }

    private void confRightTreeAddNodes() {
        TreeView confLeftTreeView = (TreeView)this.getView().getControl("conftree");
        TreeView confRightTreeView = (TreeView)this.getView().getControl("conftreeselect");
        List<Map<String, Object>> confLeftTreeSelectNodes = confLeftTreeView.getTreeState().getSelectedNodes();
        if (confLeftTreeSelectNodes.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u9700\u8981\u5236\u4f5c\u8865\u4e01\u7684\u529f\u80fd\u914d\u7f6e\u3002", (String)"BizAppFullDeployTreePlugin_2", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            return;
        }
        TreeNode confRightTreeRootNode = this.createConfRightTreeNodes(confLeftTreeSelectNodes = this.updateCacheConfLeftSelectNodes(confLeftTreeSelectNodes, "add"));
        if (confRightTreeRootNode != null) {
            confRightTreeView.addNode(confRightTreeRootNode);
            confRightTreeView.updateNode(confRightTreeRootNode);
        }
    }

    private List<Map<String, Object>> updateCacheConfLeftSelectNodes(List<Map<String, Object>> confSelectNodes, String type) {
        List confLeftTreeSelectNodeList = null;
        switch (type) {
            case "add": {
                confLeftTreeSelectNodeList = (List)this.addValToPageCache("conflefttreeselectnodes", confSelectNodes);
                break;
            }
            case "del": {
                confLeftTreeSelectNodeList = (List)this.delValInPageCache("conflefttreeselectnodes", confSelectNodes);
                break;
            }
        }
        return confLeftTreeSelectNodeList;
    }

    private TreeNode createConfRightTreeNodes(List<Map<String, Object>> confLeftTreeSelectedNodeList) {
        TreeNode confRightTreeRootNode = null;
        HashSet<String> confSelectAppIds = new HashSet<String>();
        HashMap<String, String> confRightTreeNodeMap = new HashMap<String, String>();
        TreeNode confLeftRootNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("confleftroot"), TreeNode.class);
        Map<String, TreeNode> confLeftTreeAllNodeMap = this.getAllTreeNode(confLeftRootNode);
        for (Map<String, Object> selectNodeMap : confLeftTreeSelectedNodeList) {
            String text;
            String nodeId;
            boolean isParent = Boolean.parseBoolean(selectNodeMap.get("isParent").toString());
            if (isParent) continue;
            Object parentNodeId = selectNodeMap.get("parentid");
            String parentId = StringUtils.isBlank((Object)parentNodeId) ? "" : parentNodeId.toString();
            TreeNode confRightLeafNode = new TreeNode(parentId, nodeId = selectNodeMap.get("id").toString(), text = selectNodeMap.get("text").toString());
            confRightTreeRootNode = this.createConfRightTreeNodes(confLeftTreeAllNodeMap, confRightLeafNode);
            if (null == confRightTreeRootNode) {
                return confRightTreeRootNode;
            }
            String[] confTreeNodeIdArr = this.getConfTreeNodeIds(nodeId, confLeftRootNode, 0);
            String confSelectAppId = confTreeNodeIdArr[0];
            confSelectAppIds.add(confSelectAppId);
            TreeNode confRightAppNode = confRightTreeRootNode.getTreeNode(confSelectAppId);
            confRightTreeNodeMap.put(String.format("conf#%s", confSelectAppId), SerializationUtils.toJsonString((Object)confRightAppNode));
        }
        this.getPageCache().put("confselectappids", SerializationUtils.toJsonString(confSelectAppIds));
        if (!confRightTreeNodeMap.isEmpty()) {
            this.getPageCache().put(confRightTreeNodeMap);
        }
        return confRightTreeRootNode;
    }

    private Map<String, TreeNode> getAllTreeNode(TreeNode treeNode) {
        HashMap<String, TreeNode> allNodeMap = new HashMap<String, TreeNode>();
        TreeNode tmpTreeNode = null;
        String parentNodeId = treeNode.getParentid();
        if (StringUtils.isNotBlank((CharSequence)parentNodeId)) {
            tmpTreeNode = new TreeNode(parentNodeId, treeNode.getId(), treeNode.getText());
        } else {
            String confRightRootNodeStr = this.getPageCache().get("confrightroot");
            if (StringUtils.isNotBlank((CharSequence)confRightRootNodeStr)) {
                tmpTreeNode = (TreeNode)SerializationUtils.fromJsonString((String)confRightRootNodeStr, TreeNode.class);
            }
        }
        allNodeMap.put(treeNode.getId(), tmpTreeNode);
        List children = treeNode.getChildren();
        if (children != null && !children.isEmpty()) {
            for (TreeNode child : children) {
                allNodeMap.put(child.getId(), new TreeNode(child.getParentid(), child.getId(), child.getText()));
                allNodeMap.putAll(this.getAllTreeNode(child));
            }
        }
        return allNodeMap;
    }

    private TreeNode createConfRightTreeNodes(Map<String, TreeNode> allTreeNodeMap, TreeNode treeNode) {
        TreeNode parentNode = null;
        String parentNodeId = treeNode.getParentid();
        if (StringUtils.isNotBlank((CharSequence)parentNodeId)) {
            Collection<TreeNode> allTreeNodes = allTreeNodeMap.values();
            for (TreeNode tmpNode : allTreeNodes) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)parentNodeId, (CharSequence)tmpNode.getId())) continue;
                if (!this.isContain(tmpNode, treeNode)) {
                    tmpNode.addChild(treeNode);
                }
                parentNode = this.createConfRightTreeNodes(allTreeNodeMap, tmpNode);
                break;
            }
        } else {
            parentNode = treeNode;
        }
        return parentNode;
    }

    private boolean isContain(TreeNode parentNode, TreeNode childNode) {
        boolean isContainFlag = false;
        List children = parentNode.getChildren();
        if (children != null && !children.isEmpty()) {
            for (TreeNode tmpNode : children) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)tmpNode.getId(), (CharSequence)childNode.getId())) continue;
                isContainFlag = true;
                break;
            }
        }
        return isContainFlag;
    }

    private void confRightTreeDelNodes() {
        TreeView confLeftTreeView = (TreeView)this.getView().getControl("conftree");
        TreeView confRightTreeView = (TreeView)this.getView().getControl("conftreeselect");
        List<Map<String, Object>> confRightTreeSelectNodes = confRightTreeView.getTreeState().getSelectedNodes();
        List ids = confRightTreeView.getTreeState().getCheckedNodeIds();
        if (ids.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u9700\u8981\u79fb\u9664\u7684\u529f\u80fd\u914d\u7f6e\u3002", (String)"BizAppFullDeployTreePlugin_3", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            return;
        }
        confRightTreeSelectNodes = this.updateCacheConfLeftSelectNodes(confRightTreeSelectNodes, "del");
        HashSet<String> confSelectAppIds = new HashSet<String>();
        TreeNode confLeftRootNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("confleftroot"), TreeNode.class);
        for (Map<String, Object> leftSelectNodeMap : confRightTreeSelectNodes) {
            String nodeId = leftSelectNodeMap.get("id").toString();
            boolean isParent = Boolean.parseBoolean(leftSelectNodeMap.get("isParent").toString());
            if (isParent) continue;
            String[] confTreeNodeIdArr = this.getConfTreeNodeIds(nodeId, confLeftRootNode, 0);
            String confSelectAppId = confTreeNodeIdArr[0];
            confSelectAppIds.add(confSelectAppId);
        }
        this.getPageCache().put("confselectappids", SerializationUtils.toJsonString(confSelectAppIds));
        ids.remove("confrootnode");
        confRightTreeView.deleteNodes(ids);
        confRightTreeView.uncheckNode("confrootnode");
        confLeftTreeView.uncheckNodes(ids);
    }

    String[] getConfTreeNodeIds(String nodeId, TreeNode rootNode, int startLevel) {
        String regex = "#";
        ArrayList allEntityNums = new ArrayList();
        allEntityNums.addAll(EXPORTEDENTITYDATAUNDERAPP);
        allEntityNums.addAll(EXPORTEDENTITYDATA);
        for (String entityNum : allEntityNums) {
            if (!nodeId.contains(entityNum)) continue;
            regex = String.format("%1$s%2$s", regex, entityNum);
        }
        int nodeLevel = rootNode.getNodeLevel(nodeId, startLevel);
        if (nodeLevel > 2) {
            regex = String.format("%s#", regex);
        }
        return nodeId.split(regex);
    }
}

